/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.program.internal.ds;

import com.ti.backplane.bind.AbstractStatus;
import com.ti.binding.program.internal.ICancelable;
import com.ti.binding.program.internal.IDebugFilter;
import com.ti.binding.program.internal.IRequestCompletedCallback;
import com.ti.binding.program.internal.ProgramModelPlugin;
import com.ti.binding.program.internal.ds.DSArithmeticExpressionData;
import com.ti.binding.program.internal.ds.DSCancellabeWrapper;
import com.ti.binding.program.internal.ds.DSExpressionData;
import com.ti.binding.program.internal.ds.DSTask;
import com.ti.binding.program.internal.ds.GlobalExpressionData;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.IStringReader;
import com.ti.debug.engine.events.data.IExpressionEvaluationData;
import com.ti.debug.engine.events.data.IStringReaderEventData;
import com.ti.debug.engine.events.types.IObjectEventListener;

class GlobalStringData
extends GlobalExpressionData {
    final String READ_REQUEST_FAILED = "Read Target String failed! Error:";

    public GlobalStringData(DSTask owner, String expression, int length, IDspValue addressDspValue, DSArithmeticExpressionData dsArithmeticData, boolean isArray) {
        super(owner, expression, length, addressDspValue, dsArithmeticData, isArray);
    }

    @Override
    ICancelable reguestGet(final IRequestCompletedCallback callback, final DSTask.ICancelState cancelState) {
        try {
            final int currentLength = this.length != -1 ? this.length : 32;
            final IStringReader stringReader = this.owner.task.getStringReader();
            com.ti.debug.engine.ICancelable dsc = null;
            if (this.isArray) {
                StringReadCompelteWrapper scw = new StringReadCompelteWrapper(callback, cancelState);
                dsc = stringReader.requestStringRead(this.addressDspValue, (int)this.memPage, currentLength, 0, (IObjectEventListener)scw);
            } else {
                String pointerExpression = "*(" + this.expression + ")";
                dsc = this.owner.eval.requestEvaluation(pointerExpression, (IObjectEventListener)new IObjectEventListener<IExpressionEvaluationData>(){

                    public void onEvent(IExpressionEvaluationData dataElement) {
                        try {
                            DSExpressionData pointedExpression = new DSExpressionData(dataElement, true, false);
                            StringReadCompelteWrapper scw = new StringReadCompelteWrapper(callback, cancelState);
                            stringReader.requestStringRead(pointedExpression.addressDspValue, (int)GlobalStringData.this.memPage, currentLength, 0, (IObjectEventListener)scw);
                        }
                        catch (Exception e) {
                            callback.done(null, AbstractStatus.createErrorStatus((String)("Read Target String failed! Error:" + e.getMessage())));
                        }
                    }
                });
            }
            DSCancellabeWrapper dscw = new DSCancellabeWrapper(this.expression, dsc);
            return dscw;
        }
        catch (Exception e) {
            callback.done(null, AbstractStatus.createErrorStatus((String)e.getMessage()));
            return null;
        }
    }

    @Override
    ICancelable reguestSet(Object value, IRequestCompletedCallback callback, DSTask.ICancelState cancelState) {
        callback.done(null, AbstractStatus.createErrorStatus((String)"Strings cannot be written to "));
        return null;
    }

    class StringReadCompelteWrapper
    implements IObjectEventListener<IStringReaderEventData> {
        IRequestCompletedCallback callback;
        DSTask.ICancelState cancelState;

        StringReadCompelteWrapper(IRequestCompletedCallback callback, DSTask.ICancelState cancelState) {
            this.callback = callback;
            this.cancelState = cancelState;
        }

        public void onEvent(IStringReaderEventData data) {
            try {
                if (ProgramModelPlugin.DEBUG && DSTask.isExressionLogged(GlobalStringData.this.expression)) {
                    ProgramModelPlugin.debug("DS.IMemoryAccessEvent.onEvent()", IDebugFilter.DS_READ);
                }
                DSTask.Statistics.addReadCount(GlobalStringData.this.expression);
                if (this.cancelState.isCanceled()) {
                    this.callback.done(null, null);
                    return;
                }
                if (data == null) {
                    this.callback.done(null, AbstractStatus.createErrorStatus((String)"Read Target String failed! Error:null returned."));
                    return;
                }
                String ret = data.getString();
                if (ret == null) {
                    this.callback.done(null, AbstractStatus.createErrorStatus((String)"Read Target String failed! Error:null returned."));
                    return;
                }
                if (!GlobalStringData.this.isArray && ret.length() == 32) {
                    ret = String.valueOf(ret) + "...";
                }
                this.callback.done(ret, null);
            }
            catch (Exception e) {
                this.callback.done(null, AbstractStatus.createErrorStatus((String)("Read Target String failed! Error:" + e.getMessage())));
            }
        }
    }
}

