/*******************************************************************************
 * Copyright (c) ${year} Texas Instruments Incorporated - http://www.ti.com/
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Texas Instruments Incorporated - initial API and implementation
 *
 * Original Author:
 *     Boualem Sekhri.
 *
 *
 * Contributing Authors:
 *
 * About:
 * 		This script requires dojo , jquery
 *******************************************************************************/
	// Required for the modal dialog that shows critical errors
	require(['dijit/Dialog']);

    // check if websocket is supported
    if (!window.WebSocket && window.MozWebSocket){
        window.WebSocket = window.MozWebSocket;
    }
    if (!window.WebSocket)
    {
        alert("WebSockets are not supported by this browser.\nPlease use Firefox or Chrome!");
	}

	var $TI =
	{	helper :
		{
            getCurrentPage : function()
			{
				var sPath = getPathName();
				var sPage = sPath.substring(sPath.lastIndexOf('/') + 1);
				return sPage;
			},
			getPathName : function()
			{
				if( typeof $GC_original_pathname !== 'undefined') {
					return $GC_original_pathname;
				}
				return window.location.pathname;
			},
			getHref : function() {
				if( typeof $GC_original_href !== 'undefined') {
					return $GC_original_href;
				}
				return window.location.href;
			},
			getClass : function (object) 
			{
			  return Object.prototype.toString.call(object)
			    .match(/^\[object\s(.*)\]$/)[1];
			},
			
			// Prevents having two message dialogs on top of each other. 
			_modalDialogIsOpened : false,
			// If a HTML page has iframes $last_critical_error binding is fired in both the parent HTML and the 
			// child iframe. We don't want that to result in popping up two dialogs. 
			_modalDialogsEnabled : true, 
			// end dobrin test
			showDialog:function(title, content) {
				if( !this._modalDialogsEnabled) {
					return;
				}
				if( this._modalDialogIsOpened){ 
					return;
				}
				this._modalDialogIsOpened = true; 
				
				// convert \n breaks to a HTML <br> breaks. 
				var Re = new RegExp("\n","g");
				var reformattedContent = content.replace(Re,"<br>");
				
				this._inside = true;
				var dlg = new dijit.Dialog(
				{
				        title: title,
				        style: "width: 410px;",
				        content: "<table border='0' style='width:100%;'> <tr><td>" + reformattedContent +
				        "<br><br><br> </td></tr> <tr><td style='text-align: center;'>"+
				        "<button id='okBt'>OK</button></td></tr> </table>"

				});
				var that = this;
				dojo.connect(dojo.byId("okBt"),"onclick",null,function(){
					dlg.destroyRecursive();
					that._modalDialogIsOpened = false;
				});
				
				dlg.show();		
				
			},
			showError : function(title, content) {
				this.showDialog( title, '<strong>ERROR : </strong>' + content); 
			},
			showWarning : function(title, content) {
				this.showDialog( title, '<strong>Warning : </strong>' + content); 
			},
			showInformation : function(title, content) {
				this.showDialog( title, '<strong>Information : </strong>' + content); 
			},
			enableDialogs : function( enabled) {
				this._modalDialogsEnabled = enabled; 
			},
			getGCLibVersion : function() {
				return { 
					major : 1, 
					minor : 2, 
					revision : 0,
					path : "davinci.gc_1_2",
					name : "1.2.0"
				};
			},
			getDocumentVersion : function() {
				var head = document.head;
				var attrs = head !== null ? head.attributes : null; 
				var node = attrs !== null ? attrs.item("data-gc-version") : null;
				var version = node !== null ? node.value : null;
				if( version === null) {
					return null;
				}
				var versionName = version; 
				var ret = { name : versionName};
				var parts = version.split(".");
				if( parts.length > 0) {
					var major = parseInt(parts[0]);
					if( !isNaN(major)) {
						ret.major = major;
					}
				}
				if( parts.length > 1) {
					var minor = parseInt(parts[1]);
					if( !isNaN(minor)) {
						ret.minor = minor;
					}
				}
				return ret;
			},
			checkVersion : function() {
				var docVersion = this.getDocumentVersion();
				var libVersion = this.getGCLibVersion();

				if( docVersion === null) {
					window.location  = "lib/"+libVersion.path+"/WebContent/gc/backplane/error_missing_version.html";
					return;
				}
				
				if( libVersion.major !== docVersion.major) {
					window.location  = "lib/"+libVersion.path+"/WebContent/gc/backplane/error_incompatible_version.html";	
					return;
				}
			},
			log : function(msg) {
				if (window.$TI_eclipseLog) {
					window.$TI_eclipseLog(msg);
				} else {
					console.log(msg);
				}
			},
			valuesEqual : function (obj1, obj2){
				return obj1 === obj2; 
			},
			_getDefaultJsonPath : function() {
	        	var path = $TI.helper.getPathName();
	        	var jsonPath = "";
	        	var lastSlash = path.lastIndexOf("/");
	        	var lastDot = path.lastIndexOf(".");
	        	if( lastDot !== -1 && lastDot > lastSlash) {
	        		jsonPath = path.substr(0, lastDot) + ".json";
	        	}
	        	else {
	        		jsonPath = path + ".json";
	        	}
	        	return jsonPath; 
			}
		},
    //----------------define guiComposerServer (WebSocket client) -------------
        guiComposerServer : {

            // local options - that are not sent to the backplane. 
            _localOptions : [
	            'inPreProcessingFunction',
                'outPreProcessingFunction',
                'onPropertyChanged',
                'onBindStatusChanged',
                'setValueWhenEqual'
            ],
        	
        	// callback functions supported in the JSON file.  
            _supportedFunctions : [
            	'inPreProcessingFunction',
                'outPreProcessingFunction',
                'onPropertyChanged',
                'onBindStatusChanged'
             ],
             
             // binding properties that are part of the JSON binding object.
             _supportedBindngProperties : [
                'widgetId',
                'propertyName',
                'serverBindName',
                'options'
             ],
             
            // models that are local (do not exist on the backplane, unless requested by the backplane.)
             _localModels : [
                'widget.',
                'prop.'
             ],

             // TODO - remove this when full support for local properties is implemented 
            _localPropertiesSupport : false, 
             
            connected : false,
            widgetsBeingUpdatedList : {},
            _groupUpdateList : [],
            executeOperations : new Array(),
            operationIdCounter : 0,
            requestIdRegistry : {},
            dropUpdateWidgets : new Array(),
            defaultBindingsSent : null,
            _bindingsAddedListeners : {}, 
            
            join : function() 
            {
            	if( this._ws)
            		return;
            	var pathname = $TI.helper.getPathName();
                var socketURL = $TI.helper.getHref().replace('http://', 'ws://').replace('https://', 'wss://');
                if(pathname !== '/') {
                	socketURL = socketURL.replace(pathname,'/ws/');
                }
                var pos = socketURL.indexOf('#');
                if (pos > 0) {
                	socketURL = socketURL.substring(0, pos);
                }

                this._ws = new WebSocket(socketURL, "gui_composer");
                this._ws.onopen = this._onopen;
                this._ws.onmessage = this._onmessage;
                this._ws.onclose = this._onclose;
            },
            _onopen : function() 
            {
                $TI.guiComposerServer.connected = true;
                $TI.helper.log("guiComposer.js: connected = true");
                $TI.guiComposerServer._sendInitInfo();
                $TI.guiComposerServer.sendBindings();
                $TI.guiComposerServer.sendAllExecuteOperations();
                $TI.helper.log("guiComposer.js: $TI.guiComposerServer.defaultBindingsSent = true");
                $TI.guiComposerServer.defaultBindingsSent = true;
            },
            _send : function(message) {
                if (this._ws){
                    this._ws.send(message);
                }
                else{
                    alert("WebSocket Connection to server is closed!" );
                }
            },
            _onmessage : function(event) 
            {
                if (event.data)
                {
                    // create object from the json request
                    var requestObject = dojo.fromJson(event.data);
                    var requestName = requestObject.requestName;
                    
                    if(requestName === "ping") {
                        var pingReplyMessage = { requestName : "pingReply"};
                        var pingReplyMessageJson = dojo.toJson(pingReplyMessage);
                        $TI.guiComposerServer._send(pingReplyMessageJson);
                    }
                    else if(requestName === "propertyChange" || requestName === "propertyStatusChange") {
                    	$TI.guiComposerServer._onPropertyChange(requestObject);
                    }
                    else if(requestName === "groupRequest" ) {
                    	$TI.guiComposerServer._onGroupRequest(requestObject);
                    }
                    else if(requestName === "operationCompleted") {
                        var requestId = requestObject.requestId;
                        var result = requestObject.result;
                        var requestInfo = $TI.guiComposerServer.requestIdRegistry[requestId];
                        
                        if(requestInfo !== null) {
                            delete $TI.guiComposerServer.requestIdRegistry[requestId];
                            var operationId = requestInfo.operationId;
                            var callbackFunction = requestInfo.callbackFunction;
                            if(callbackFunction) {
                                try {
                                    callbackFunction(result, operationId );
                                }
                                catch(err) {
                                	$TI.helper.log('guiComposer.js: ERROR: in operation Completed callback');
                                }
                            }
                        }
                    }
                    else if(requestName === "trace") {
                        var logId = requestObject.id;
                        var message = requestObject.message;
                        var component = requestObject.component;
                        var traceMessage = { requestName : "trace", logId : logId, message : message, component : component};
                        var traceMessageJson = dojo.toJson(traceMessage);
                        $TI.guiComposerServer._send(traceMessageJson);
                    }
                    else {
                    	$TI.helper.log('guiComposer.js: ERROR: unknown requestName = ' + requestName);
                    }
                }
            },
            _onclose : function(event) {
                this._ws = null;
                $TI.guiComposerServer.connected = false;
            },
            
            _onPropertyChange : function( requestObject) {
            	var that = $TI.guiComposerServer;
                var requestName = requestObject.requestName;
                var widgetId = requestObject.widgetId;
                var propertyName = requestObject.propertyName;
                var newValue = requestObject.newValue;
                var timeSend = requestObject.timeSent;
                var setValueWhenEqual = requestObject.setValueWhenEqual; 
                var timeDelay = 0;
                var currentTime = null;
                if( timeSend) {
                   	currentTime = new Date().getTime();
                	timeDelay = currentTime - timeSend; 
                	if( timeDelay < 0) {
                		timeDelay = 0;
                	}
                }

            	$TI.helper.log( "guiComposer.js: INFO: _onmessage:"+requestName+" widget_id="+widgetId + ", propertyName=" + propertyName + ", value="+newValue + ", current delay="+timeDelay);
                if(widgetId === "backplane" && 
                	( propertyName === "value:backplane.$last_critical_error" || 
                	  propertyName === "backplane.$last_critical_error"))  {
                	var errorMessage = newValue;
                	if( errorMessage !== null && errorMessage.length !== 0){
                		$TI.helper.showError("Critical Error", errorMessage);
                	} 
                	return; 
            	}    

                var bind = that._bindings.getBind(widgetId, propertyName);
                if( bind && bind.inPreProcessingFunction) {
                   // we don't want errors in the inPreProcessingFunction function to cause script execution to stop.
                    try {
                		newValue = bind.inPreProcessingFunction(newValue);	
                	}
                	catch(err) {
                    	$TI.helper.log('guiComposer.js: ERROR: preprocessing function error. ' + err);
                	}
                }
                
                // set the property of the widget to the newValue;
                var widget = that._getWidgetAndAdd(widgetId);
                if(widget)
                {
                	if( requestName === "propertyChange") {
                		
                		var skipNextUpdate = false;
                		
                        if( timeSend) {
                        	if( that.dropUpdateWidgets[widgetId] && that.dropUpdateWidgets[widgetId][propertyName]) {
                       			var dropUpdate = that.dropUpdateWidgets[widgetId][propertyName].dropUpdate;
                       			if( typeof dropUpdate !== 'undefined') {
                           			var forceUpdate = that.dropUpdateWidgets[widgetId][propertyName].forceUpdate;
                           			var lastUpdate = that.dropUpdateWidgets[widgetId][propertyName].lastUpdate;
                           			
                           			// make sure we drop an update only if we the widget has been update at least once, otherwise don't skip. 
                           			if( typeof lastUpdate !== 'undefined') {
                           				
                           				// if the delay is too big, drop an update.  
                           				if( timeDelay > dropUpdate) {
                           					
                           					// if we don't care about force update , drop the update.
                           					if( typeof forceUpdate === 'undefined') {
                           						$TI.helper.log( "guiComposer.js: DROPPED UPDATE( id="+widgetId+" current delay="+timeDelay);
                           						skipNextUpdate = true;
                           					}
                           					
                           					// but if we haven't updated the widget for a long time, don't skip.
                           					if( !skipNextUpdate && (currentTime - lastUpdate  < forceUpdate)) {
                           						
                           						$TI.helper.log( "guiComposer.js: DROPPED UPDATE( id="+widgetId+
                              						" current delay="+timeDelay+" accumulated delay=" + (currentTime - lastUpdate));
                           						skipNextUpdate = true;
                           					}

                           					if( !skipNextUpdate) {
                           						// too much time without update - do not skip.
                           						$TI.helper.log( "guiComposer.js: FORCED UPDATE( id="+widgetId+
                           							" current delay="+timeDelay+" accumulated delay=" + (currentTime - lastUpdate));
                           					}
                           				}
                          			}                           				
                           			
                           			// save the time of last update.
                           			if( !skipNextUpdate && (typeof forceUpdate !== 'undefined')) {
                           				that.dropUpdateWidgets[widgetId][propertyName].lastUpdate = currentTime;
                           			}
                       			}
                       		}
                        }

                        if( skipNextUpdate) {
                        	if( typeof widget.skipNextUpdate !== 'undefined') {
           						$TI.helper.log( "guiComposer.js: WIDGET SKIP UPDATE ( id="+widgetId+" current delay="+timeDelay);
                        		widget.skipNextUpdate();
                        	}
                        	else {
                        		return;
                        	}
                        }
                        
                        //check if this is a new value
                        var currentValue = widget.get(propertyName);
        				var bind = that._bindings.getBind( widgetId, propertyName); 
                        var forceSet = bind && ( bind.setValueWhenEqual || setValueWhenEqual);  
                        if(forceSet || (newValue !== "null" && currentValue !== newValue)){
                        	that.widgetsBeingUpdatedList[widgetId+"."+propertyName] = newValue;
                        	if( widget._isGCProperty) {
                        		widget.set(propertyName, newValue, undefined, setValueWhenEqual);
                        	}
                        	else {
                        		widget.set(propertyName, newValue);
                        	}
                            that.widgetsBeingUpdatedList[widgetId+"."+propertyName] = undefined;                                
                        }
                	}
                	else if( requestName === "propertyStatusChange") {
                        if(widget.setBindStatus) {
                        	var status = {
                        		statusType : requestObject.statusType,
                        		message : requestObject.message
                        	}; 
                        	widget.setBindStatus( propertyName, status);
                        }
                	}
                }
                else {
                	$TI.helper.log('guiComposer.js: ERROR: widget not found. widgetId = ' + widgetId);
                }
            },
            
            _onGroupRequest : function( requestObject) {
            	var that = $TI.guiComposerServer; 
            	var requests = requestObject.requests;
            	var i = 0;
            	var length = requests.length;
            	var currentObject;
            	var newObject;
            	$TI.helper.log('guiComposer.js: INFO: group request, length = '+length);
            	
            	that._groupUpdateList = [];
            	// when properties are changed in groups, we buffer all changes of 
            	// any properties until we set the last one and send back to the backplane 
            	// only these are are left different from the backplane request.
            	for( i = 0; i < length; ++i) {
            		currentObject = requests[i];
            		if( currentObject.requestName === 'propertyChange') {
            			newObject = { 
	            			widgetId : currentObject.widgetId,
	            			propertyName : currentObject.propertyName,
	            			backplaneValue : currentObject.newValue,
	            			newValue : currentObject.newValue
	            		};
	            		that._groupUpdateList.push( newObject);
            		}
            	}
            	
            	for( i = 0; i < length; ++i) {
            		currentObject = requests[i];
            		if( currentObject.requestName === 'propertyChange') {
            			that._onPropertyChange( currentObject);
            		}
            	}

            	length = that._groupUpdateList.length;
            	for( i = 0; i < length; ++i) {
            		currentObject = that._groupUpdateList[i];
                    if( currentObject.newValue !== currentObject.backplaneValue) {
                    	_sendPropertyChange(currentObject.widgetId, currentObject.propertyName, currentObject.newValue);
                    }
            	}
            	that._groupUpdateList = [];
            },
            
            // API 
            setModelValue : function( modelBind, value, dataType) {
            	if( !(modelBind)) {
            		$TI.helper.log('guiComposer.js: ERROR: setModelValue('+modelBind+')');
            		return;
            	}
                var bind = new this._Bind();
                bind.serverBindName = modelBind;
                bind.options = {};
                bind.options.defaultValue = value;
                bind.options.dataType = dataType;
                bind.toSendToServer = true;
                bind.setModelValue = true;
                this._bindings.add( bind);
                this.sendBindings();
            },
            
            // API 
            addBinding : function(widgetId, propertyName, serverBindName, options) {
            	
            	if( !(widgetId) || !(propertyName)) {
            		$TI.helper.log('guiComposer.js: ERROR: addBinding('+widgetId+','+propertyName+')');
            		return;
            	}
                var widget = this._getWidgetAndAdd(widgetId);
                if( !widget) {
                    $TI.helper.log("guiComposer.js: ERROR: addBinding() failed. There is no widget with id = " + widgetId);
                    return;
                }
                
                var initialModelBindEnabled = true;
                
                //add a watch function
                var listener = function(propertyName, oldValue, newValue) {
                    $TI.guiComposerServer.widgetChangeListener(widgetId, propertyName, newValue);
                };
                $TI.helper.log("guiComposer.js: INFO: Adding watch to:" + widgetId + ":" + propertyName );
                widget.watch(propertyName, listener);
                
                var that = this;
                // support for automatic model bind disabled when the widget is hidden or disabled. 
                var modelBindEnabledListener = function(p, oldValue, newValue) {
                	$TI.helper.log("guiComposer.js: INFO: OnModelBindEnabledChanged( id=" + widgetId + ", value= " + newValue);
                	var bs = that._bindings._array;
	    			for( var i = 0; i < bs.length; ++i) {
	    				var bind = bs[i]; 
	    				if( bind.widgetId === widgetId) {
                			that.enableBinding(newValue, bind.widgetId, null);
                			break;
	    				}
	    			}
                }; 
                widget.watch("modelBindEnabled", modelBindEnabledListener);
                initialModelBindEnabled = widget.get( "modelBindEnabled");
                if(( typeof initialModelBindEnabled === "undefined") || (initialModelBindEnabled === null)) {
                	initialModelBindEnabled = true;
                }
                $TI.helper.log("guiComposer.js: INFO: Initial ModelBindEnabled = " + initialModelBindEnabled + " for id=" + widgetId);

                var bind = new this._Bind();
                bind.widgetId = widgetId;
                bind.widget = widget;
                bind.propertyName = propertyName;
                bind.serverBindName = serverBindName;
                bind.toSendToServer = true;

                var local = this._localPropertiesSupport; 
                if( local) {
                	local = !(bind.serverBindName);
	                if( !local) {
	                	local = this._isLocalBindName( bind.serverBindName); 
	                }
                }
                
                if( local) {
            		delete bind.toSendToServer;
            		bind.local = true;
            		bind.registeredLocal = false;
                }
                
                if( options) {
	                for( var i=0; i < this._localOptions.length; ++i) {
	               		var f = this._localOptions[i];
	               		if( options[f]) {
		               		bind[f] = options[f];
		               		delete options[f];
	               		}
	               	}
                }
                
                // add to the map of slow widgets if needed.
                if( options !== null && ( options.dropUpdate || options.forceUpdate)) {
                	if( typeof this.dropUpdateWidgets[widgetId] === 'undefined') {
                		this.dropUpdateWidgets[widgetId] = new Array();
                	}
                	if( typeof this.dropUpdateWidgets[widgetId][propertyName] === 'undefined') {
                		this.dropUpdateWidgets[widgetId][propertyName] = {}; 
                	}
                	if( options.dropUpdate) {
                		this.dropUpdateWidgets[widgetId][propertyName].dropUpdate = options.dropUpdate;
                		delete options.dropUpdate; // do not send to the server.
                	}
                	if( options.forceUpdate) {
                		this.dropUpdateWidgets[widgetId][propertyName].forceUpdate = options.forceUpdate;
                		delete options.forceUpdate; // do not send to the server.
                	}
                }

                bind.options = options;

                // make sure we send the disabled state to the backplane.
                if( bind.options && !initialModelBindEnabled) {
                	bind.options.disabled = true;
                }
                
                this._bindings.add( bind);
                this.sendBindings();
                this._connectLocalBindings();
            },

            _isLocalBindName : function( serverBindName) {
	            for( var i=0; i < this._localModels.length; ++i) {
	            	var localModel = this._localModels[i];
	            	if( serverBindName.indexOf(localModel) === 0) {
	            		// if it strarts with one of the local model, 
	            		// make sure it doesn't have any othe symbols but: 0-9, A-Z, a-z, dot, space, $. 
	            		for( var j = 0; j < serverBindName.length; ++j) {
	            			var ch = serverBindName.charAt(j);
	            			var isNumber = ch >= '0' && ch <= '9';
	            			var isAlphaLower = ch >= 'a' && ch <= 'z';
	            			var isAlphaUpper = ch >= 'A' && ch <= 'Z';
	            			var isSpace = ch === ' ';
	            			var isAllowedSpecial = ch === '.' || ch === '$' || ch === '_';
	            			var isAllowed = isNumber || isAlphaLower || isAlphaUpper || isSpace || isAllowedSpecial;     
	            			if( !isAllowed) {
	            				return false;
	            			}
	            		}
	            		return true;
	            	}
	            }
	            return false;
            },
            
            enableBinding : function(enable, widgetId, propertyName) {
            	this.enableBindings( enable, [ { widgetId: widgetId, propertyName : propertyName}]);
            },
            
            enableBindings : function(enable, widgetBindings) {
            	var enableBool = enable ? true : false;
           		var request = { requestName : "enableWidgetBindings", enable : enableBool, widgetBindings : widgetBindings };
                var requestJson = dojo.toJson(request);
           		$TI.guiComposerServer._send(requestJson);
            },
            
            addBindingsFromFile :  function (bindingDefinitionFile) {
	            if(!bindingDefinitionFile) {
                    return;
                }
	            // create/connect the webSocket
            	this.join();
	            var that = this;
 	            // -------------load json widget binding information
                dojo.xhrGet(
                {
                    url: bindingDefinitionFile,
                    handleAs: "json",
                    sync : true ,
                    load: function(data) {
                        for(var i in data.widgetBindings){
                            var wb = data.widgetBindings[i];
                            
                            // Evaluates the functions specified in the JSON file. 
                            // AddBinding expects function objects instead the function name.
                            for( var i=0; i < that._supportedFunctions.length; ++i) {
                        		var f = that._supportedFunctions[i];
                            	try {
                            		if(wb.options[f]) {
                            			wb.options[f] = eval(wb.options[f]);
                            		}
                            	}
                            	catch(err) {
                            		$TI.helper.log("guiComposer.js: ERROR: "+err);
                                	$TI.helper.showError('JSON File Error', 'File:'+bindingDefinitionFile+'\n' +err);
                            	}
                            }

                            // Binding records with no wigetId are used to initialize backplane bindings.  
                            if( !(wb.widgetId) && wb.serverBindName && wb.options && (typeof wb.options.defaultValue !== 'undefined' )) {
                                $TI.guiComposerServer.setModelValue( wb.serverBindName, wb.options.defaultValue, wb.options.dataType);
                            }
                            else {
                            	$TI.guiComposerServer.addBinding(wb.widgetId, wb.propertyName, wb.serverBindName, wb.options);
                            }
                        }
                        $TI.guiComposerServer._notifyBindingsAddedListeners(bindingDefinitionFile);
                    },
                    error: function(err) {
                        $TI.helper.log("guiComposer.js: Error loading 'binding definitions'file:" + bindingDefinitionFile + "\n"   + err);
                        // since we guiComposer.js tries to automatically load the corresponding JSON file 
                        // we don't want these failures to popup a error message
                        // only systaxt error will popup for now to help finding JSON sintax error easier.
                        if( err.toString().indexOf('SyntaxError') !== -1) {
                        	$TI.helper.showError('JSON File Error', 'File:'+bindingDefinitionFile+'\n' +err);
                        }
                    },
                });
	        },
	        
	        // execute an action on the server
	        // options syntax: { arguments :  argsValue, widgetId : widgetIdValue,
	        //                   propertyName : propertyNameValue, requestId : requestIdValue}
	        // Some or all of the options may be null
	        executeAsynchOperation : function(operationName, arguments, callbackFunction, operationId) {
	        	var newOperaton = {
	        		operationName : operationName, 
	        		arguments : arguments, 
	        		callbackFunction: callbackFunction, 
	        		operationId : operationId
		        };
	        	$TI.guiComposerServer.executeOperations.push(newOperaton);
	        	$TI.guiComposerServer.sendAllExecuteOperations();
	        },
	        
			// API - registers widget proxies  
	        registerWidget : function(widget, widgetId) {
	        	if( !this._widgets[widgetId]) {
	        		this._addWidget( widget, widgetId, false);
	        	} else {
	        		$TI.helper.log('guiComposer.js: ERROR: registerWidget id ='+ widgetId +' already exist.');
	        	}
	        },

	        _addWidget : function( widget, widgetId, isDojo) {
	        	var w = new this._GCWidget();
	        	w.widget = widget;
	        	w.widgetId = widgetId; 
	        	w.isDojo = isDojo;
	        	this._widgets[widgetId] = w;   
	        },
	        
        	// check first if it is in the list, then at dojo's list.  
	        _getWidgetAndAdd : function( widgetId) {
	        	var gcw = this._widgets[widgetId]; 
	        	if( gcw) {
	        		return gcw.widget; 
	        	} 
                var w = dijit.byId(widgetId);
                if( w) {
                	this._addWidget( w, widgetId, true);
                }
                return w;
	        },
	        
            // main listener for property change in all widgets
		    // sends change to ws server.
		    widgetChangeListener : function (widgetId, propertyName, newValue) {
		    	var that = $TI.guiComposerServer;
		    	
		    	// pass the value through the post processing function, if needed.  
                var bind = that._bindings.getBind(widgetId, propertyName);
                var groupIndex;
                var i;
                var currentObject;
                
                // don't send the server if we already nkow that it is not registered there.
                if( bind && !bind.existsOnServer) {
                	return;
                }
                
                if( bind && bind.outPreProcessingFunction) {
                   // we don't want errors in the outPreProcessingFunction function to cause script execution to stop.
                    try {
                		newValue = bind.outPreProcessingFunction(newValue);	
                	}
                	catch(err) {
                    	$TI.helper.log('guiComposer.js: ERROR: preprocessing function error. ' + err);
                	}
                }
                
                // if a property is part of group update, rememeber the new 
                groupIndex = -1;
                for( i = 0; i < that._groupUpdateList.length; ++i) {
                	currentObject = that._groupUpdateList[i];
                	if( widgetId === currentObject.widgetId && propertyName === currentObject.propertyName) {
                		groupIndex = i;
                		break;
                	}
                }
                if( groupIndex != -1) {
                	that._groupUpdateList[groupIndex].newValue = newValue;
                }
                else {
                	that._sendPropertyChange(widgetId, propertyName, newValue);
                }
		    },
		    
		    _sendPropertyChange : function( widgetId, propertyName, newValue) {
		    	var that = $TI.guiComposerServer;
		    	var messageObject;
		    	var messageJson;
		        if( that.widgetsBeingUpdatedList[widgetId+"."+propertyName] !== newValue) {
			        messageObject = { requestName: "propertyChange" , widgetId : widgetId , propertyName : propertyName, newValue : newValue  };
			        messageJson = dojo.toJson(messageObject);
			        $TI.helper.log('guiComposer.js: INFO: SEND widgetId='+widgetId+' propertyName='+propertyName+' newValue='+ newValue);			        
			        that._send(messageJson);
		        }
		    },
		    
		    _sendInitInfo : function() {
		    	if(!$TI.guiComposerServer.connected) {
		    		return;
		        };
		        try
		        {
		        	  $TI.helper.log("guiComposer.js: sending initial message");
		        	  var docVersion = $TI.helper.getDocumentVersion();
		        	  var libVersion = $TI.helper.getGCLibVersion();
		        	  var docHref = $TI.helper.getHref();
		        	  var messageObject = { 
		        			  requestName: "setInitInfo" , 
		        			  gcLibraryVersion : libVersion,
		        			  documentVersion : docVersion,
		        			  href : docHref
		        	  };
		        	  var messageJson = dojo.toJson(messageObject);
		        	  $TI.guiComposerServer._send(messageJson);
				}
				catch(err)
				{
				   $TI.helper.log("guiComposer.js: error in sendBindings :" + err);
				}
		    },
		    sendBindings : function() {
		    	if(!$TI.guiComposerServer.connected) {
		    		return;
		        }
		    	try {
	                var widgetBindingRequest = { 
	                	requestName : "addWidgetBindings", 
	                	widgetBindings : this._bindings.getBindingsToSend()
	                };
	                var widgetBindingRequestJson = dojo.toJson(widgetBindingRequest);
	                $TI.helper.log("guiComposer.js: sending bindings" +widgetBindingRequestJson);                
	                $TI.guiComposerServer._send(widgetBindingRequestJson);
	                this._bindings.markAsExistsOnServer();
		        }
		        catch(err) {
		           $TI.helper.log("guiComposer.js: error in sendBindings :" + err);
		        }
		    },
		    
		    sendAllExecuteOperations : function() {
		    	if(!$TI.guiComposerServer.connected) {
	            	return;
		        }
		        try {
		             $TI.helper.log("guiComposer.js: sending Execute Opreations" );
		             for( var i = 0; i < $TI.guiComposerServer.executeOperations.length; ++i) {
		            	 var currentOperation = $TI.guiComposerServer.executeOperations[i];
		            	 $TI.guiComposerServer.sendOneExecuteOperation(
		            			currentOperation.operationName, 
		            			currentOperation.arguments, 
		            			currentOperation.callbackFunction, 
		            			currentOperation.operationId
		            	);
		             }
			        // clear the executeOperations array 
		             $TI.guiComposerServer.executeOperations.length = 0;
		        }
		        catch(err) {
		           $TI.helper.log("guiComposer.js: error in Execute Opreations :" + err);
		        }
		    },

		    sendOneExecuteOperation : function( operationName, arguments, callbackFunction, operationId) {
	           if(operationName === null || operationName.length === 0)
	           {
	               return;
	           }
	           
	           if(callbackFunction === null)
	           {	               
	               // one-way operation: no return expected
	               // Note that critical-errors may still be received
	               var messageObject = { requestName: "executeOperation" , operationName : operationName , arguments : arguments};
	               var messageJson = dojo.toJson(messageObject);
	               $TI.guiComposerServer._send(messageJson);
	           }
	           else
	           {
                   // create a globally-unique-requestId that will be used to map back to a (callbackFunction, operationId)
                   $TI.guiComposerServer.operationIdCounter++;
                   var requestId = $TI.guiComposerServer.operationIdCounter.toString();
                   var requestInfo = {callbackFunction : callbackFunction, operationId : operationId };
                   $TI.guiComposerServer.requestIdRegistry[requestId] = requestInfo;
                   var messageObject = { requestName: "executeOperation" , operationName : operationName , arguments : arguments , requestId : requestId };
                   var messageJson = dojo.toJson(messageObject);	                   
                   $TI.guiComposerServer._send(messageJson);
	           }
		    },
		    
	    	// all widgets ( dojo and non-dojo ) are inside this map.
	    	_widgets : {
	    		toString : function() {
	    			var ret = '';
	    			var first = true;
	    			for(var propertyName in this) {
	    				if( propertyName !== 'toString') {
	    					if( !first) {
	    						ret += ',';
	    					}
	    					first = false;
	    					ret += propertyName + '=' + this[propertyName].toString();
	    				}
    				}	    	
	    			return ret;
	    		}
	    	},
	    	
	    	_GCWidget : function () {
	    		
				// properties:
				// 		String widgetId;
	    		// 		
				//    	boolean isDojo;
				//      Object ( get, set, watch ) proxy;
	    		
	    		this.toString = function() {
	    			return this.widgetId;
	    		};
	    	},
	    	
	    	// all bindings. 
	    	_bindings : {
	    		_array : new Array(),
	    		
	    		add : function( bind) {
	    			this._array.push( bind);
	    		},
	    		
	    		getBind : function( widgetId, propertyName) {
	    			for( var i = 0; i < this._array.length; ++i) {
	    				if( $TI.helper.valuesEqual(widgetId, this._array[i].widgetId) &&
	    					$TI.helper.valuesEqual(propertyName,this._array[i].propertyName))  {
	    					return this._array[i];
	    				} 
	    			}
	    			return null;
	    		},
	    		
	    		getBindingsToSend : function() {
	    			var ret = Array();     
	    			for( var i = 0; i < this._array.length; ++i) {
	    				var bind = this._array[i]; 
	    				if( bind.toSendToServer) {
	    	                var b = {}; 
	    	                for( var j=0; j < $TI.guiComposerServer._supportedBindngProperties.length; ++j) {
	    	                	var p = $TI.guiComposerServer._supportedBindngProperties[j];
	    	                	if( bind[p]) {
	    	                		b[p] = bind[p];
	    	                	}
	    	                }
	    	                ret.push(b);
	    				}
	    			}
	    			return ret; 
	    		},

	    		markAsExistsOnServer : function() {
	    			
	    			// remove set model value binds only   
	    			this._array = this._array.filter(function(bind) {
	    				return typeof bind.setModelValue === 'undefined';
	    			});
	    			
	    			// mark the remainning as sent to the server.
	    			for( var i = 0; i < this._array.length; ++i) {
	    				var bind = this._array[i]; 
	    				if( bind.toSendToServer) {
	    					bind.existsOnServer = true;
	    					delete bind.toSendToServer;
	    				}
	    			}
	    		},
	    	},
	    	
	    	_Bind : function () {
	    		
				// properties:
	    		// 		String widgetId
	    		//		String propertyName
	    		//      object widget 		{ get,set,watch } 
	    		// 		function inPreprocess
	    		// 		function outPreprocess
	    		// 		function onPropertyChanged
	    		// 		String serverBindName
	    		// 		boolean toSendToServer
	    		//		boolean existsOnServer
	    		//		boolean setModelValue
	    		//		boolean requestedByServer
	    		// 		boolean registeredLocal
	    		// 		boolean setValueWhenEqual
	    		
	    		this.toString = function() {
	    			return this.widget + '.'+this.propertyName;
	    		};
	    	},

	    	_localBindings : {
	    		
	    		_list : [], 
	    		
	    		add : function( bind) {
	    			var that = $TI.guiComposerServer;
	    			var wwc = this._getClinetBind( bind);
	    			var wws = this._getServerBind( bind);
	    			if( !wwc || !wws) {
                    	$TI.helper.log('guiComposer.js: ERROR: _localBindings.add - invalid widget description.');
                    	return;
	    			}
	    			var wc = that._getWidgetAndAdd(wwc.widgetId);
	    			var ws = that._getWidgetAndAdd(wws.widgetId);
	    			if( !wc || !ws) {
                    	$TI.helper.log('guiComposer.js: ERROR: _localBindings.add - no sunch widget.');
                    	return;
	    			}
	    			var pc = wwc.proprtyName;
	    			var ps = wws.propertyName;
	    			
	                var lc = function(propertyName, oldValue, newValue) {
	                	var currentValue = ws.get( ps);
	                	if( !$TI.helper.valuesEqual( newValue, currentValue)) {
	                		ws.set( ps, newValue);
	                	};
	                };
	                wc.watch(pc, lc);

	                var ls = function(propertyName, oldValue, newValue) {
                        var forceSet = bind && bind.setValueWhenEqual;  
	                	var currentValue = wc.get( pc);
	                	if( forceSet || !$TI.helper.valuesEqual( newValue, currentValue)) {
	                		wc.set( pc, newValue);
	                	};
	                };
	                ws.watch(ps, ls);
	                var binding = {
	                	clientWidget : wc,
	                	serverWidget : ws, 
	                	clientListener : lc, 
	                	serverListener : ls
	                };
	                bind.registeredLocal = true;
	    			this._list.push( binding);
	    		},

	    		_getClinetBind : function( bind) {
	    			return {
	    				widgetId : bind.widgetId, 
	    				proprtyName : bind.propertyName
	    			};
	    		},
	    		
	    		_getServerBind : function( bind) {
	    			var name = bind.serverBindName;
	    			if( name) {
	    				var that = $TI.guiComposerServer;
	    				var models = that._localModels;
	                    for( var i=0; i < models.length; ++i) {
	                    	var modelName = models[i];
	                    	if( bind.serverBindName.indexOf(modelName) === 0) {
		    					var id = bind.serverBindName.substring(modelName.length);
		    					if( modelName === 'prop.') {
		    						return {
		    		    				widgetId : 'prop', 
		    		    				propertyName : id
		    						};
		    					}
		    					if( modelName === 'widget.') {
			    					var lastDotIndex = id.lastIndexOf('.');
			    					if( lastDotIndex > 0) {
				    					var widgetId = id.substring(0, lastDotIndex);
				    					var propertyName = id.substring(lastDotIndex+1);
				    					return {
			    		    				widgetId : widgetId, 
			    		    				propertyName : propertyName
				    					};
			    					}
		    					}
	                    	}
	                    }
	    			}
	    			return null;
	    		},
	    	},

		    _connectLocalBindings : function() {
    			for( var i = 0; i < this._bindings._array.length; ++i) {
    				var bind = this._bindings._array[i];
    				// some properties are just declared in the JSON file - they don't have serverBindName.
    				// that is why we need the check bind.serverBindName.
    				if( bind.local && !(bind.registeredLocal) && bind.serverBindName) {
    			    	this._localBindings.add(bind);
    				}
    			}
		    },
		    
		    addBindingsAddedListener : function( callback, fileName) {
		    	if( typeof fileName === 'undefined')
		    		fileName = $TI.helper._getDefaultJsonPath();
		    	if( typeof this._bindingsAddedListeners[fileName] === 'undefined')
		    		this._bindingsAddedListeners[fileName] = new Array();
		    	this._bindingsAddedListeners[fileName].push( callback);
		    },
		    
		    _notifyBindingsAddedListeners : function ( fileName) {
		    	if( typeof this._bindingsAddedListeners[fileName] === 'undefined')
		    		return;
		    	var arr = this._bindingsAddedListeners[fileName];
		    	for (var i=0; i < arr.length; i++) 
		    		arr[i]();
		    }
        }, //guiComposerServer end >>>

        // API 
        GUIVars : {
    		getValue : function( propertyName, widgetID) {
    			var widget = this._getWidget(propertyName, widgetID, 'getValue');
    			if( typeof widget !== 'undefined')
    				return widget.get(propertyName);
    			else
    				return undefined;
    		},
    		setValue : function( propertyName, value, widgetID) {
    			var widget = this._getWidget(propertyName, widgetID, 'setValue');
    			if( typeof widget !== 'undefined')
    				widget.set(propertyName, value);
    		},
			getStatus : function( propertyName, widgetID) {
    			var widget = this._getWidget(propertyName, widgetID, 'getStatus');
    			if( typeof widget !== 'undefined')
    				if( widget.getBindStatus !== 'undefined')
    					return widget.getBindStatus(propertyName, status);
    			return null;
			},
			setStatus : function( propertyName, status, widgetID) {
    			var widget = this._getWidget(propertyName, widgetID, 'setStatus');
    			if( typeof widget !== 'undefined' && widget.setBindStatus !== 'undefined')
    				widget.setBindStatus(propertyName, status);
			},
			onSet : function( propertyName, listener, widgetID) {
    			var widget = this._getWidget(propertyName, widgetID, 'onSet');
    			if( typeof widget !== 'undefined')
    				widget.watch( propertyName, listener);
			},
			_getWidget : function( propertyName, widgetID, functionName) {
    			var widget = undefined;
    			if (typeof widgetID === 'undefined') {
	    			var bind = $TI.guiComposerServer._bindings.getBind('prop', propertyName);
	    			if( bind && bind.widget)
	    				widget = bind.widget;
    			}
    			else 
    				widget = dijit.byId(widgetID);
    			if( typeof widget === 'undefined' && typeof functionName !== 'undefined') 
    				$TI.helper.log('guiComposer.js: GUIVars.'+functionName+'() ERROR: no such GUI Varaiable : ' + propertyName);
    			return widget;
			}
        }
    }; //$TI end >>>

	// put the 'prop' widnget in the registry to handle all browser prop objects. 
	$TI.guiComposerServer.registerWidget( {
		
		_listeners : {},
		_listeners_bind_status : {},
		_listeners_progress : {},
		_isGCProperty : true, 
		
		get: function(property) {
			var ret = this[property];
			$TI.helper.log('prop.get('+property+')='+ret);
			return ret;
		},
		
		set: function(property, value, exception, setValueWhenEqual) {
			$TI.helper.log('prop.set('+property+','+value+')');
			
			var that = $TI.guiComposerServer;
			var oldValue = this[property];
			var bind = that._bindings.getBind( 'prop', property); 
			var forceSet = bind && ( bind.setValueWhenEqual || setValueWhenEqual);
			if( forceSet || !$TI.helper.valuesEqual(oldValue,value)) {
				this[property] = value;

				// TODO: remove onPropertyChanged and use the watch() method to add the listener directly.
				if( bind && bind.onPropertyChanged) {
					try {
						bind.onPropertyChanged(property, value, oldValue);
					}
					catch( err) {
						$TI.helper.log("guiComposer.js: ERROR in onPropertyChanged :" + err);
					}
				}
				
				var listeners = this._listeners[property]; 
				if( typeof listeners !== 'undefined') {
					
					// the following code supports rentrant calls on the same propery.  When rentrant calls on the same property are
					// detected, we need only to notify listeners that have already been called of further changes.  Listeners that
					// have not yet been notified will be notified of the new value once when this function returns to the parent caller and 
					// continues notifying the remaining listeners using the new value and the previous oldValue preserved on the call stack.
					var listener_progress = this._listeners_progress[property];
					if (listener_progress === undefined) {
						// first time called, setup structures for keeping track of progress.
						listener_progress = { count : 0 };
						this._listeners_progress[property] = listener_progress;
					}
					
					var saved_listeners_progress_count = listener_progress.count;   // save notification progress for the current level of nesting
					try {
						var count = saved_listeners_progress_count;   // reentrant case: only notify listeners that have already been notified.
						if ( count === 0) {
							count = listeners.length;   // non-reentrant case, notify all the listeners.
						}
						
						// start listener progress for current level of nesting (used to keep track of where we are as well as a flag to detect rentrancy).
						listener_progress.count = 1;   // reset the notification progress for the next level of nesting
						
						for(var i=0; i < count; i++) {
							// always recheck that the value hasn't changed to stop the rentrancy cycles that may occur.
							// also, reentrancy may be used to revert values, so listeners not notified previously need not be notified at all.
							listeners[i](property, oldValue, value);  // this call may trigger reentrant calls on the same property.
							listener_progress.count++;
							
							value = this[property];
							if( forceSet || $TI.helper.valuesEqual(oldValue,value)) {
								// value has been reverted back to the original value through reentrancy, so skip the remaining notifications
								// including the binding.
								break;
							}
						}
					}
					catch( err) {
						// error during onChangedNotification
						try {
							this.set(property, oldValue, err);  // restore the original value, and pass allong the error message too, so listeners know we are reverting.
						}
						catch( revertErr) {
							$TI.helper.log("guiComposer.js: nested ERROR in onPropertyChanged while recovering from: " + err);
						}
						throw err;  // let nested reentrant calls clean up themselves.  Note that if the same propery was changed numerous times, it will also be reverted numerous times.
					}
					finally {
						listener_progress.count = saved_listeners_progress_count;  // restore the notification progress for the previous level of nesting
					}
				}
			}
		},

		watch: function(property, listener) {
			$TI.helper.log('prop.watch('+property+')');
			if( typeof this._listeners[property] === 'undefined'){
				this._listeners[property] = new Array();
			}
			this._listeners[property].push( listener);
		},
		
		getBindStatus : function (property) {
			var ret = this[property + '$bind_status'];
			$TI.helper.log('prop.getBindStatus('+property+')='+ret);
			return ret;
		},
		
		setBindStatus : function (property, status) {
			var oldStatus = this[property + '$bind_status'];
			if( !$TI.helper.valuesEqual(oldStatus,status)) {
				this[property + '$bind_status'] = status;
				var bind = $TI.guiComposerServer._bindings.getBind( 'prop', property); 
				if( bind && bind.onBindStatusChanged) {
					try {
						bind.onBindStatusChanged(property, status, oldStatus);
					}
					catch( err) {
						$TI.helper.log("guiComposer.js: ERROR in onBindStatusChanged :" + err);
					}
				}
				
				var listeners = this._listeners_bind_status[property]; 
				if( typeof listeners !== 'undefined') {
					for( var i=0;  i < listeners.length; i++) {
						listeners[i](property, oldStatus, newStatus);
					}
				}
			}
		},
		
		watchBindStatus : function(property, listener) {
			$TI.helper.log('prop.watchBindStatus('+property+')');
			if( typeof this._listeners_bind_status[property] === 'undefined'){
				this._listeners_bind_status[property] = new Array();
			}
			this._listeners_bind_status[property].push( listener);
		} 
		
    }, 'prop');
	
	if (window.isMaqetta === undefined) {
	    // if versions don't match show error HTML page. 
		$TI.helper.checkVersion();
	    
	    require(["dojo/ready"], function(ready){
	        ready(function(){
	            // create/connect the webSocket
	            $TI.guiComposerServer.join();
	        	var jsonPath = $TI.helper._getDefaultJsonPath();
        		$TI.guiComposerServer.addBindingsFromFile(jsonPath);	
	        });
	   });    
	};
