define([
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/_base/array",
	"dojo/_base/event",
	"dojo/dom-geometry",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/i18n",
	"dijit/_WidgetBase",
	"dijit/_TemplatedMixin",
	"dijit/_WidgetsInTemplateMixin",
	"dijit/registry",
	"dijit/Tooltip",
	"dijit/form/_FormSelectWidget",
	"dojo/text!./resources/_CheckedMultiSelectItem.html",
	"dojo/text!./resources/CheckedMultiSelect.html",
	"dojo/i18n!./resources/nls/CheckedMultiSelect",
	"dojo/dom-style",
	"dojo/query",
	"dojo/dom-attr",
	"./_GCBaseWidget",
	"./libs/tools",
	"dojo/on",
	"./libs/_selectableWidget",
	"dojo/json",
	"dijit/form/CheckBox" // template
], function(declare, lang, array, event, domGeometry, domClass, domConstruct, i18n, Widget, TemplatedMixin, WidgetsInTemplateMixin, registry,
		Tooltip, FormSelectWidget, CheckedMultiSelectItem, CheckedMultiSelect, nlsCheckedMultiSelect,domStyle,query,domAttr,_GCBaseWidget,tools,on,
		_selectableWidget,json){

// module:
//		dojox/form/CheckedMultiSelect
// summary:
//		Extends the core dojox.form.CheckedMultiSelect to provide a "checkbox" selector


var formCheckedMultiSelectItem = declare("gc.dijit._CheckedMultiSelectItem", [Widget, TemplatedMixin, WidgetsInTemplateMixin], {
	// summary:
	//		The individual items for a CheckedMultiSelect

	templateString: CheckedMultiSelectItem,

	baseClass: "dojoxMultiSelectItem",

	// option: dojox.form.__SelectOption
	//		The option that is associated with this item
	option: null,
	parent: null,

	// disabled: boolean
	//		Whether or not this widget is disabled
	disabled: false,

	// readOnly: boolean
	//		Whether or not this widget is readOnly
	readOnly: false,
	postMixInProperties: function(){
		// summary:
		//		Set the appropriate _subClass value - based on if we are multi-
		//		or single-select
		this._type = this.parent.multiple ?
			{type: "checkbox", baseClass: "dijitCheckBox"} :
			{type: "radio", baseClass: "dijitRadio"};
		this.disabled = this.option.disabled = this.option.disabled||false;
		this.inherited(arguments);
	},

	postCreate: function(){
		// summary:
		//		Set innerHTML here - since the template gets messed up sometimes
		//		with rich text
		this.inherited(arguments);
		this.labelNode.innerHTML = this.option.label;
//		this.domNode.style.width="100%";
	},

	_changeBox: function(){
		// summary:
		//		Called to force the select to match the state of the check box
		//		(only on click of the checkbox)	 Radio-based calls _setValueAttr
		//		instead.
		if(this.get("disabled") || this.get("readOnly")){ return; }
		if(this.parent.multiple){
			this.option.selected = this.checkBox.get('value') && true;
		}else{
			this.parent.clearOptions();
			this.option.selected=true;
		}
		//for click style
		var ops=this.parent.options;
		array.forEach(ops,function(op){
			op.clicked=false;
		});
		this.option.clicked=true;
		// fire the parent's change
		this.parent._updateSelection();

		// refocus the parent
		this.parent.focus();
	},

	_onClick: function(e){
		// summary:
		//		Sets the click state (passes through to the check box)
//		console.debug("CheckedMultiSelect::_onClick");
		if(this.get("disabled") || this.get("readOnly")){
			event.stop(e);
		}else{
			this.checkBox._onClick(e);
		}
	},

	_updateBox: function(){
		// summary:
		//		Called to force the box to match the state of the select
		this.checkBox.set('value', this.option.selected);
		if(this.option.selected&&this.option.clicked)
			this.domNode.focus();
		else
			this.domNode.blur();
		/*
		var cells=this.domNode.getElementsByTagName("td");
		for(var i=0;i<cells.length;i++){
			if(this.option.clicked){
				var cellStyle="selectedTd";
				if(i==0)
					cellStyle+="0"; else
				if(i==cells.length-1)
					cellStyle+="1";
				domClass.add(cells[i],cellStyle);
			}else{
				domClass.remove(cells[i],"selectedTd");
				domClass.remove(cells[i],"selectedTd0");
				domClass.remove(cells[i],"selectedTd1");
				
			}
		}
		*/
		if(this.option.selected)
			domClass.add(this.domNode, "msRowSelected");
		else
			domClass.remove(this.domNode, "msRowSelected");
		if(this.parent.hideCheckbox)
			domStyle.set(this.checkBox.domNode.parentNode,"display","none");
		else
			domStyle.set(this.checkBox.domNode.parentNode,"display","");
			
	},

	_setDisabledAttr: function(value){
		// summary:
		//		Disables (or enables) all the children as well
		this.disabled = value||this.option.disabled;
		this.checkBox.set("disabled", this.disabled);
		domClass.toggle(this.domNode, "dojoxMultiSelectDisabled", this.disabled);
	},

	_setReadOnlyAttr: function(value){
		// summary:
		//		Sets read only (or unsets) all the children as well
		this.checkBox.set("readOnly", value);
		this.readOnly = value;
	}
});



var formCheckedMultiSelect = declare("gc.dijit.CheckedMultiSelect", [FormSelectWidget,_GCBaseWidget,_selectableWidget], {
	// summary:
	//		Extends the core dijit MultiSelect to provide a "checkbox" selector

	templateString: CheckedMultiSelect,

	baseClass: "dojoxCheckedMultiSelect",

	// required: Boolean
	//		User is required to check at least one item.
	required: false,

	// invalidMessage: String
	//		The message to display if value is invalid.
	invalidMessage: "$_unset_$",

	// _message: String
	//		Currently displayed message
	_message: "",

	// dropDown: Boolean
	//		Drop down version or not
	dropDown: false,

	// labelText: String
	//		Label of the drop down button
	labelText: "",

	// tooltipPosition: String[]
	//		See description of `Tooltip.defaultPosition` for details on this parameter.
	tooltipPosition: [],
	setStore: function(store, selectedValue, fetchArgs){
		// summary:
		//		If there is any items selected in the store, the value
		//		of the widget will be set to the values of these items.
		this.inherited(arguments);
		this._updateSelection();
	},
	postMixInProperties: function(){
		this.inherited(arguments);
		this._nlsResources = i18n.getLocalization("dojox.form", "CheckedMultiSelect", this.lang);
		if(this.invalidMessage == "$_unset_$"){ this.invalidMessage = this._nlsResources.invalidMessage; }
	},

	_fillContent: function(){
		// summary:
		//		Set the value to be the first, or the selected index
		this.inherited(arguments);

		// set value from selected option
		if(this.options.length && !this.value && this.srcNodeRef){
			var si = this.srcNodeRef.selectedIndex || 0; // || 0 needed for when srcNodeRef is not a SELECT
			this.value = this.options[si >= 0 ? si : 0].value;
		}
	},

	startup: function(){
		// summary:
		//		Set the value to be the first, or the selected index
		this.inherited(arguments);
	},

	_onMouseDown: function(e){
		// summary:
		//		Cancels the mousedown event to prevent others from stealing
		//		focus
		event.stop(e);
	},

	validator: function(){
		// summary:
		//		Overridable function used to validate that an item is selected if required =
		//		true.
		// tags:
		//		protected
		if(!this.required){ return true; }
		return array.some(this.getOptions(), function(opt){
			return opt.selected && opt.value != null && opt.value.toString().length != 0;
		});
	},

	validate: function(isFocused){
		Tooltip.hide(this.domNode);
		var isValid = this.isValid(isFocused);
		if(!isValid){ this.displayMessage(this.invalidMessage); }
		return isValid;
	},

	isValid: function(/*Boolean*/ isFocused){
		// summary:
		//		Tests if the required items are selected.
		//		Can override with your own routine in a subclass.
		// tags:
		//		protected
		return this.validator();
	},

	getErrorMessage: function(/*Boolean*/ isFocused){
		// summary:
		//		Return an error message to show if appropriate
		// tags:
		//		protected
		return this.invalidMessage;
	},

	displayMessage: function(/*String*/ message){
		// summary:
		//		Overridable method to display validation errors/hints.
		//		By default uses a tooltip.
		// tags:
		//		extension
		Tooltip.hide(this.domNode);
		if(message){
			Tooltip.show(message, this.domNode, this.tooltipPosition);
		}
	},

	onAfterAddOptionItem: function(item, option){
		// summary:
		//		a function that can be connected to in order to receive a
		//		notification that an item as been added to this dijit.
	},

	_addOptionItem: function(/*dojox.form.__SelectOption*/ option){
		var item;
		{
			item = new formCheckedMultiSelectItem({
				option: option,
				parent: this
			});
			this.wrapperDiv.appendChild(item.domNode);
		}
		this.onAfterAddOptionItem(item, option);
	},

	_refreshState: function(){
		// summary:
		//		Validate if selection changes.
		this.validate(this.focused);
	},

	onChange: function(newValue){
		// summary:
		//		Validate if selection changes.
		this._refreshState();
	},

	reset: function(){
		// Overridden so that the state will be cleared.
		this.inherited(arguments);
		Tooltip.hide(this.domNode);
	},

	_updateSelection: function(){
//		console.debug("CheckedMultiSelect:_updateSelection::id::"+this.id+"::callers:: "+ tools.getCallers().join("::"));	
//		console.debug("CheckedMultiSelect:_updateSelection::id::"+this.id+"::options:: "+json.stringify(this.options));	
		this._handleOnChange(this.value);
		this.updateAttrs();
		array.forEach(this._getChildren(), function(item){
			item._updateBox();
		});
	},

	_getChildren: function(){
		if(this.dropDown){
			return this.dropDownMenu.getChildren();
		}else{
			return array.map(this.wrapperDiv.childNodes, function(n){
				return registry.byNode(n);
			});
		}
	},

	invertSelection: function(onChange){
		// summary:
		//		Invert the selection
		// onChange: Boolean
		//		If null, onChange is not fired.
		if(this.multiple){
			array.forEach(this.options, function(i){
				i.selected = !i.selected;
			});
			this._updateSelection();
		}
	},

	_setDisabledAttr: function(value){
		// summary:
		//		Disable (or enable) all the children as well
		this.inherited(arguments);
		if(this.dropDown){
			this.dropDownButton.set("disabled", value);
		}
		array.forEach(this._getChildren(), function(node){
			if(node && node.set){
				node.set("disabled", value);
			}
		});
	},

	_setReadOnlyAttr: function(value){
		// summary:
		//		Sets read only (or unsets) all the children as well
		this.inherited(arguments);
		if("readOnly" in this.attributeMap){
			this._attrToDom("readOnly", value);
		}
		this.readOnly = value;
		array.forEach(this._getChildren(), function(node){
			if(node && node.set){
				node.set("readOnly", value);
			}
		});
	},

	uninitialize: function(){
		Tooltip.hide(this.domNode);
		// Make sure these children are destroyed
		array.forEach(this._getChildren(), function(child){
			child.destroyRecursive();
		});
		this.inherited(arguments);
	},
	///////////////////////////////
	index:-1,
	hideCheckbox:false,
	isNumber:function(n){
		return !isNaN(parseInt(n));
	},
	updateAttrs:function(){
	// when data changed or selected changed, we need run this to update all other attrs
		var i0=-1;
		var v0=null;
		var b0=0;
		array.forEach(this.options,function(op,i){
			if(op.selected){
				if(i0==-1){
					i0=i;
					v0=op.value;
				};
				var nv=parseInt(op.value);
				if(!isNaN(nv))
					b0+=nv;
			};
		});
		this._set("index",i0);
		this._set("value",v0);
		this._set("selectedBits",b0);
	},
	_setSelectedBitsAttr:function(bits){
		var bits0=parseInt(bits);
		if(isNaN(bits0))
			return;
		array.forEach(this.options,function(op){
			if((bits0&op.value)==op.value)
				op.selected=true;
			else
				op.selected=false;
		});
		this._updateSelection();
		
	},
	constructor:function(p){
		console.debug("gc.dijit.CheckedMultiSelect");
	},
	postCreate: function() {
		this.inherited(arguments);
		var docConnect1=null;
		var that=this;
		this.watch("value",function(attr,ov,nv){
//			console.debug("ID: "+that.id+"::"+attr+" changed old: "+ov+" new: "+nv);
		});
		/*
		on(this.domNode,"click",function(e){
			event.stop(e);
			console.debug("checkedselect click");
			domClass.remove(that.domNode,"notfocus");
			domClass.add(that.domNode,"isfocus");
			if(docConnect1===null)
				docConnect1=on(document,"click",function(){
				console.debug("document click");
				docConnect1.remove();
				docConnect1=null;
				domClass.remove(that.domNode,"isfocus");
				domClass.add(that.domNode,"notfocus");
			});
		});
		*/
//		this.watch("value",function(attr,ov,nv){
//			console.debug(attr+" changed old:"+ov+" new:"+nv);
//		});
	},
	_setStyleAttr: function( value){
	
		//  we need set style to different node
	

		var css={text:value,
				acceptNames:["position","top","left","z-index","width","height"]};
		tools.filterCss(css);
		tools.setCssText(this.domNode,css.accept.join(";"));
		tools.setCssText(this.selectNode, css.refuse.join(";"));
		this._set("style", value);
		
	},
	_setHideCheckboxAttr:function(hc){
		this._set("hideCheckbox",hc);
		this._updateSelection();
	},
	_setMultipleAttr:function(m){
		this._set("multiple",m);
		this._loadChildren();
	},
	/*
	 * for Maqetta canvas
	 */
	resize:function(){
		var css=this.style;
		this.style="";
		this.set("style",css);
		
	},
	_setValueAttr:function(nv){
		if(!tools.isArray(nv)){
			nv = [nv];
		};
		this.setOption("value",nv);
	},
	_getValueAttr:function(){
		console.debug("CheckedMultiSelect::_getValueAttr::value:::"+this.value);
		return this.value;
	},
	//we want value is a array even for a single select
	/*
	_getValueFromOpts: function(){
		var opts = this.getOptions() || [];
			// Set value to be the sum of all selected
			return array.map(array.filter(opts, function(i){
				return i.selected;
			}), function(i){
				return i.value;
			}) || [];
	}
*/
	
});

return formCheckedMultiSelect;
});

