define([
	"dojo/_base/declare",
	"dijit/_Widget",
	"./_GCBaseWidget",
	"dojo/store/Observable",
	"dojo/store/Memory",
	"dgrid/OnDemandGrid",
	"dgrid/Selection",
	"dgrid/Keyboard",
	"dgrid/editor",
	"dgrid/extensions/ColumnResizer",
	"dijit/_TemplatedMixin",
	"dijit/_WidgetsInTemplateMixin"
], function(declare, _Widget, _GCBaseWidget, Observable, Memory, DGrid, DGridSelection, DGridKeyboard, DGridEditor, DGridColumnResizer , _TemplatedMixin, _WidgetsInTemplateMixin) {
	return declare("gc.dijit.Dgrid", [_Widget, _GCBaseWidget], {
		baseClass: "dijitDGrid",
		declaredClass: 'DGrid',
		
		grid: null,				// widget node
		_cols: null,			// array of strings
		_colStore: null, 		// array of objects (for dgrid)
		_data: null,			// array of arrays
		_dataColumns : 0,		// max columns (detected during record scan)
		_lastDataColumns: 0,	// last known value of _dataColumns
		_dataStore: null,		// Observable Memory Store
		_firstLoad: false,		// flag to keep order of operations correct on startup
		
        postCreate: function() {
        	this.inherited(arguments);
        	this._cols = [];
        	this._data = [[]];
        	this._updateDataColumns();
        	this._regenerate();
        },
        
        _regenerate: function() {
        	if (this._dataStore) delete this._dataStore;
        	if (this.grid) delete this._grid;

        	this._lastDataColumns = this._dataColumns;
        	this._updateDataColumns();
        	
        	// if there are less columns specified than visible in the data records, fill up the columns. 
        	for( var i = this._cols.length; i < this._dataColumns; ++i) {
        		this._cols.push('Col'+i); // Add label
        	}

        	// convert to array of objects for dgrid
        	this._colStore = []; 
        	for (var i=0; i < this._cols.length; i++) {
        		this._colStore.push({
        			label: this._cols[i]
        		  , field: "f"+i
        		  , editor: 'text'
        		  , editOn: 'click'
        		});
        	}
        	
        	// setup initial data
        	var data = new Array();
			for (var i=0; i<this._data.length; i++) {
				var row = { id: 'id'+i};
				for (var j=0; j<this._data[i].length; j++) {
					row['f'+j] = this._data[i][j];
				}
				data.push( row);
			}
        	
			// create a new observable memory store & dgrid
        	this._dataStore = new Observable( new Memory({data: data, idProperty: 'id'}) );
        	this.grid = new DGrid({
        		columns: this._colStore
        	  , store: this._dataStore
            }, this.domNode);
        	
        	this.grid.startup();
        	
        	// if the number of columns has changed, notify the grid to refresh
        	if (this._lastDataColumns != this._dataColumns) {
        		// give grid.startup() a chance to finish
        		var self = this;
        		setTimeout(function(){ self.grid.refresh(); }, 250);
        	}
        },
        
        _setColumnsAttr: function(buf) {
        	this._cols = buf;
			this._regenerate();
			if (! this._firstLoad) this._firstLoad = true;
        },
        
        _setDataAttr: function(buf) {
        	if (! this._firstLoad) {
        		// grid not yet ready, reschedule
        		var self = this;
        		setTimeout(function() { self._setDataAttr(buf); }, 50);
        		return;
        	}
        	this._data = buf;
        	
        	// Regenerating the grid won't work for data updates, use _dataStore.notify()
			//this._regenerate();
        	
        	var data = new Array();
			for (var i=0; i<this._data.length; i++) {
				var row = { id: 'id'+i};
				for (var j=0; j<this._data[i].length; j++) {
					row['f'+j] = this._data[i][j];
				}
				data.push(row);
				this._dataStore.put(row);
			}
        },
        
        // scan records, determine max columns
        _updateDataColumns : function() {
        	this._dataColumns = 0;
        	var currentSize = 0;
			for (var i=0; i<this._data.length; i++) {
				currentSize = this._data[i].length;
				if( this._dataColumns < currentSize) {
					this._dataColumns = currentSize;
				}
			}
        }
	});
});
