define([
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dijit/_WidgetBase",
	"./_GCBaseWidget"
], function(declare,lang, _WidgetBase, _GCBaseWidget) {
	return declare("gc.dijit.MultiImage", [_WidgetBase, _GCBaseWidget], {
		baseClass: "dijitImage",
		
		images: [],
		selection : 0,
		putSrc:function()
		{
			if(!(lang.isArray(this.images)))
			{
				this.images=this.images.split(',');
			}
			if(this.images.length<=0)
				return;
			if(this.selection>=this.images.length||this.selection<0)
				this.selection=0;
			if(this.domNode){
				this.domNode.setAttribute("src", this.images[ this.selection]);
			}
			
		},
		
		buildRendering: function() {
			this.inherited(arguments);
			this.putSrc();
		},
		_setImagesAttr:function(images)
		{
			this._set("images",images);
			this.putSrc();
		},
		
		_getImagesAttr:function()
		{
			return this.images.join();
		},
		_setSelectionAttr: function(selection) {
			this._set("selection",selection);
			this.putSrc();
		}
	});
});