define([
	"dojo/_base/declare",
	"dojo/_base/lang",
    "./_BaseGraph"
], function(declare, lang, _BaseGraph) {
	return declare("gc.dijit.ScatterPlot", [_BaseGraph], {
		
		// members
		delayedRefresh: 0,
		showLines: false,
		
		// Attributes
		_setSeries0_XAttr : function(values) {
			this._setSeriesN(values, 0, true);
		},
		_setSeries0_YAttr : function(values) {
			this._setSeriesN(values, 0, false);
		},
		_setSeries1_XAttr : function(values) {
			this._setSeriesN(values, 1, true);
		},		
		_setSeries1_YAttr : function(values) {
			this._setSeriesN(values, 1, false);
		},
		
		_setSeriesN : function(values, index, isX) {
			if( this._graph) {
				var combinedValues = this.get('series'+index);			
				for (var ii = 0; ii < values.length; ++ii) {
					var element = combinedValues[ii];
					if (Object.prototype.toString.call(element) != '[object Array]') {
						element = [];
					}
					
					if (isX) {
						element[0] = values[ii];
					} else {
						element[1] = values[ii];
					}
					combinedValues[ii] = element;
				}
				
				this._set('series'+index, combinedValues);
				this._setGraphSeries(combinedValues, index, true);
				this._requstReplot();
			}
		},
			
		constructor: function(params, srcNodeRef) {
			var ii;
			var ss=this._params.series;
			for(ii=0;ii<ss.length;ii++){
				if(!(ss[ii].label))
					ss[ii].label="Series "+ii;
			};
			this.series0 = [0];
			for( var i = 1; i < this._numBuffers; ++i) {
				this["series"+i] = [[]];
			}
			
			this.delayedRefresh = (params.delayedRefresh != undefined) ? params.delayedRefresh : 0;
			if( this.delayedRefresh && this.delayedRefresh > 0) {
				this._timer = new timing.Timer(this.delayedRefresh);
				this._timer.onTick = this._onTick;
				this._timer._gc_widget = this;
			}

			var _self = this;
			this.showLines = (params.showLines != undefined) ? params.showLines : false;
			this._params.seriesDefaults = lang.mixin(this._params.seriesDefaults, {
				showLine: _self.showLines,
			});
			
			this._params.seriesDefaults.markerOptions = lang.mixin(this._params.seriesDefaults.markerOptions, {
				size: 3,
				style: 'circle',
				show: true,
				shadow: false,
			});
			
		},
		
		startup: function() {
			this.inherited(arguments);
			this.domNode.removeAttribute("title");
			this.seriesColor();
			var seriesAll = new Array();
			for( var i = 0; i < this._numBuffers; ++i) {
				var series = this["series"+i];
				seriesAll.push(series);
			}
            this._graph = $.jqplot(this.id, seriesAll, this._params);
		},

		_requstReplot : function() {
			if( this._timer) {
				if( this._timer.isRunning) {
					this._replotNeeded = true;
				}
				else {
					this._replot();
					this._replotNeeded = false;
					this._timer.start();
				}
			}
			else {
				this._replot();
			}
		},
		
		_replot : function() {
			if( this.modelBindEnabled) {
				this._graph.replot({resetAxes: (this.resetAxesOption === 'on')});
			}
		},

		_onTick : function() {
			// 'this' pointer is pointing to the timer object in this callback. 
			var that = this._gc_widget;
			if( that._replotNeeded) {
				that._replotNeeded = false;
				that._replot();
			} else {
				that._timer.stop();
			}
		}
	});
});