define([
    	"dojo/_base/declare",
    	"dijit/TitlePane",
    	"./_GCBaseWidget",
    	"dojo/dom-geometry",
    	"dojo/dom-style",
    	"dojo/_base/lang",
    	"./libs/tools"
    ], function(declare, TitlePane, _GCBaseWidget,domGeom,domStyle,lang,tools) {
    	return declare("gc.dijit.TitlePane", [TitlePane,_GCBaseWidget], {
    		_clientH:function (node,totalH){
    			domGeom.setMarginBox(node,{h:totalH});
    			var cH=domStyle.get(node,"height");
    			domStyle.set(node,"height","auto");
    			return cH;
    		},
    		_setClientH: function (){
    			var dnHeight=this.domNode.style.height;
    			dnHeight=parseInt(dnHeight);
    			if(isNaN(dnHeight)||dnHeight==0){
    				this.containerNode.style.height="auto";
    				return;
    			}
    			var tpH=domStyle.get(this.domNode,"height")-2;
    			var tnBox=domGeom.getMarginBox(this.titleBarNode);
    			tpH=tpH-tnBox.h;
    			//caculate hideNode
    			tpH=this._clientH(this.hideNode,tpH);
    			tpH=this._clientH(this.wipeNode,tpH);
//    			domStyle.set(this.domNode,"height","auto");
    			domGeom.setMarginBox(this.containerNode,{h:tpH});
  //  			this.domNode.style.height="auto";
    		},
    		_setChildrenModelBindEnabled:function(){
    			var childs;
    			var mbe=(this.modelBindEnabled&&this.open);
    			if(this.getChildren){
    				childs=this.getChildren();
    				for(var i=0;i<childs.length;i++){
    					childs[i].set("bindingDisabled",!mbe);
    				}
    			}
    		},
    		_setModelBindEnabledAttr:function(mbe){
    			this._set("modelBindEnabled",mbe);
    			this._setChildrenModelBindEnabled();
    		},
    		startup:function(){
    			this.inherited(arguments);
    			this._setClientH();
    			this.watch("open",function(attr,ov,nv){
    				this._setChildrenModelBindEnabled();
    			});
    			if(this.titleNode){
    				this.titleNode.style.color="inherit";
    			}
    		},
    		resize:function(){
    			this.inherited(arguments);
    			this._setClientH();
    		},
    		_setHidedefaultborderAttr:function(db){
    			this._set("hidedefaultborder",db);
    			if(this.hideNode){
    				if(db)
    					this.hideNode.style.border="none";
    				else
    					this.hideNode.style.border="";
    			}
    		},
    		_setStyleAttr:function(s){
    			if(lang.isObject(s))
    				this.inherited(s);
    			else{
    				var css={};
    				css.text=s;
    				css.acceptNames=["position","top","left","width","height"];
    				tools.filterCss(css);
    				this.domNode.style.cssText=css.accept.join(";");
    				this.titleBarNode.style.cssText=css.refuse.join(";");
   				
    			}
    		}

     	});
    });