define([
	"dojo/_base/declare",
	"dijit/Tooltip",
 	"dojo/_base/array", // array.forEach array.indexOf array.map
	"dojo/dom", // dom.byId
	"dojo/_base/lang", // lang.hitch lang.isArrayLike
	"dojo/mouse",
	"dojo/on",
], function(declare, tooltip,array,dom,lang,mouse,on) {
	var gcTip= declare("gc.dijit.Tooltip", [tooltip], {
		mousePos: true,
		position:{x:0,y:0},
		showDelay:1000,
		open: function(/*DomNode*/ target){
			if(this.mousePos){
				target={x:this.position.x,y:this.position.y,w:10,h:10};
			};
			this.inherited(arguments);
		},
		setPosition:function(e){
			this.position.x=e.pageX;
			this.position.y=e.pageY;
			
		},
		postCreate:function(){
			initTT();
			this.inherited(arguments);
		},
		_setConnectIdAttr: function(/*String|String[]}DomNode|DomNode[]*/ newId){
			//overwrite this function for display tooltip at mouse position
			if(!this.mousePos){
				this.inherited(arguments);
				return;
			}
			array.forEach(this._connections || [], function(nested){
				array.forEach(nested, function(handle){ handle.remove(); });
			}, this);

			// Make array of id's to connect to, excluding entries for nodes that don't exist yet, see startup()
			this._connectIds = array.filter(lang.isArrayLike(newId) ? newId : (newId ? [newId] : []),
					function(id){ return dom.byId(id, this.ownerDocument); }, this);

			// Make connections
			this._connections = array.map(this._connectIds, function(id){
				var node = dom.byId(id, this.ownerDocument),
					selector = this.selector,
					delegatedEvent = selector ?
						function(eventType){ return on.selector(selector, eventType); } :
						function(eventType){ return eventType; },
					self = this;
				return [
						on(node, delegatedEvent(mouse.enter), function(e){
							self.setPosition(e);
							self._onHover(this);
						}),
					on(node, "mousemove", function(e){
						self.setPosition(e);
					}),
					on(node, delegatedEvent("focusin"), function(e){
						self.setPosition(e);
						self._onHover(this);
					}),
					on(node, delegatedEvent(mouse.leave), lang.hitch(self, "_onUnHover")),
					on(node, delegatedEvent("focusout"), lang.hitch(self, "_onUnHover"))
				];
			}, this);

			this._set("connectId", newId);
		}

	});
	//this make tooltip keep open while mouse move over tooltip, so you can make a copy
	function initTT(){
		if(!tooltip._masterTT){  
			tooltip._masterTT = new tooltip._MasterTooltip(); 
		var mt=tooltip._masterTT;
		mt.hide0=mt.hide;
		mt.removeHTimer=function(){
			clearTimeout(mt.hTimer);
		};
		mt.init=function(){
			on(mt.containerNode,"mouseover",function(){
				mt.removeHTimer();			
			});
			on(mt.containerNode,"mouseout",function(){
				mt.hide(mt.aroundNode);
			});
		};
		mt.hide=function(an){
			mt.removeHTimer();
			mt.hTimer=setTimeout(function(){
				mt.hide0(an);
			},300);
		};
		mt.init();
		};
	}
	return gcTip;
});
