define([
	"dojo/_base/declare",
	"dojo/_base/lang",
    "dijit/_WidgetBase",
    "./_GCBaseWidget",
], function(declare, lang, _WidgetBase, _GCBaseWidget) {
	return declare("gc.dijit._BaseGraph", [_WidgetBase, _GCBaseWidget], {
		baseClass: "dijit dijitGraph",
		_graph: null,
		_params: {},
		_numBuffers : 8,
		_xMin: Number.MAX_VALUE,
		_xMax: Number.MIN_VALUE,
		_yMin: Number.MAX_VALUE,
		_yMax: Number.MIN_VALUE,
		
		/* public attributes */
		title: '',
		height: 0,
		width: 0,
		xLabel: '',
		yLabel: '',
		xMinValue: 0,
		xMaxValue: 0,
		yMinValue: 0,
		yMaxValue: 0,
		showLegend: false,
		showGridLines: true,
		backgroundColor: '',
		xShowTicks: true,
		yShowTicks: true,
		seriesName0: '',
		seriesName1: '',
		seriesName2: '',
		seriesName3: '',
		seriesName4: '',
		seriesName5: '',
		seriesName6: '',
		seriesName7: '',
		resetAxesOption: 'on', /* available options are 'on', 'off' and 'expandOnly'*/
		
		constructor: function(params, srcNodeRef) {
			console.log("_BaseGraph.constructor");
			this.title = (params.title != undefined) ? params.title : '';
			this.height = params.height = (params.height != undefined) ? Number(params.height) : 250;
			this.width = params.width = (params.width != undefined) ? Number(params.width) : 350;
			this.xLabel = (params.xLabel != undefined) ? params.xLabel : '';
			this.yLabel = (params.yLabel != undefined) ? params.yLabel : '';
			this.xMinValue = (params.xMinValue != undefined) ? Number(params.xMinValue) : 0;
			this.xMaxValue = (params.xMaxValue != undefined) ? Number(params.xMaxValue) : 10;
			this.yMinValue = (params.yMinValue != undefined) ? Number(params.yMinValue) : 0;
			this.yMaxValue = (params.yMaxValue != undefined) ? Number(params.yMaxValue) : 10;
			this.showLegend = (params.showLegend != undefined) ? params.showLegend : false;
			this.showGridLines = (params.showGridLines != undefined) ? params.showGridLines : true;
			this.backgroundColor = (params.backgroundColor) ? params.backgroundColor : null;
			this.xShowTicks = (params.xShowTicks != undefined) ? params.xShowTicks : true;
			this.yShowTicks = (params.yShowTicks != undefined) ? params.yShowTicks : true;
			this.resetAxesOption = (params.resetAxesOption != undefined) ? params.resetAxesOption: 'on';

			for( var i = 0; i < this._numBuffers; ++i) {
				var name = 'seriesName'+i;
				if (params[name]) {
					this[name] = params[name];
				}
			}
			
			this._params = lang.mixin({
				height: this.height,
				width: this.width,
				drawIfHidden: true,
				
				// TODO: Find out how to hide and show the title of the line graph.  
				// this is a hack until I find out how to show the plot 
            	// with no title, and then to reposition it when a non empty title is set. 
            	title: this.title,
	            legend: {show: this.showLegend},
	            grid: {
	            	drawGridlines: this.showGridLines,
	            	backgroundColor: this.backgroundColor,
	            },
	            seriesDefaults: {
	            	show: true,
	                lineWidth: 1,
	                showMarker: false,
	                shadow: false,
	                showLabel:false,
	                markerOptions: {
	                    show: false,
	                },
	            },
	            cursor: {
	                show: true,
	                zoom: true,
	                showTooltip: true,
	            },
	            axes: {
	            	xaxis: {
	            		label: this.xLabel,
	            		min: this.xMinValue,
	            		max: this.xMaxValue,
	            		tickOptions: {
	            			showLabel: this.xShowTicks, 
	            			showMark: this.xShowTicks,
	            		},
	                    tickRenderer: $.jqplot.CanvasAxisTickRenderer,
	                    labelRenderer: $.jqplot.CanvasAxisLabelRenderer,
	            	},
	            	yaxis: {
	            		label: this.yLabel,
	            		min: this.yMinValue,
	            		max: this.yMaxValue,
	            		tickOptions: {
	            			showLabel: this.yShowTicks, 
	            			showMark: this.yShowTicks,
	            		},
	                    tickRenderer: $.jqplot.CanvasAxisTickRenderer,
	                    labelRenderer: $.jqplot.CanvasAxisLabelRenderer,
	                    
	            	},
	            },
	            series: [{label: this.seriesName0}, 
	                     {label: this.seriesName1},
	                     {label: this.seriesName2},
	                     {label: this.seriesName3},
	                     {label: this.seriesName4},
	                     {label: this.seriesName5},
	                     {label: this.seriesName6},
	                     {label: this.seriesName7}],
			}, params);
		},
		_setTitleAttr : function( title) {
			if (this._graph) {
				this._set('title', title);
				this._graph.title.text = title;
				this._graph.replot();
			}
		},
		
		_setShowLegendAttr: function(show) {
			if (this._graph) {
				this._set('showLegend', show);
				this._graph.legend.show = show;
				this._graph.replot();
			}
		},
		
		_setShowGridLinesAttr: function(show) {
			if (this._graph) {
				this._set('showGridLines', show);
				this._graph.grid.drawGridlines = show;
				this._graph.replot();
			}
		},		
		
		_setYShowTicksAttr: function(show) {
			if (this._graph) {
				this._set('yShowTicks', show);
				this._graph.axes.yaxis.tickOptions.showMark = show;
				this._graph.axes.yaxis.tickOptions.showLabel = show;
				this._graph.replot();
			}
		},
		
		_setXShowTicksAttr: function(show) {
			if (this._graph) {
				this._set('xShowTicks', show);
				this._graph.axes.xaxis.tickOptions.showMark = show;
				this._graph.axes.xaxis.tickOptions.showLabel = show;
				this._graph.replot();
			}
		},
		
		_getTitleAttr: function() {
			if (this._graph)
				return this._graph.title.text;
			return null;
		},
	
		_setGraphSeries : function(values, index, valuePair) {
			if (this._graph) {
	            var serieData = new Array();
	            var scaleChanged = false;
	            
	            for(var i = 0; i < values.length ; i++) {
	            	var element = values[i];
	            	var elementX = 0;
	            	var elementY = 0;
	            	
	            	if (valuePair === true) {
	            		if (element.length != 2)
	            			continue;
	            		
	            		serieData.push(element);
	            		elementX = element[0];
	            		elementY = element[1];
	            		
	            	// else, use the i-index as the collection index.
	            	} else {
	            		serieData.push([i,element]);
	            		elementX = i;
	            		elementY = element;
	            	}
	                
	            	if (this.resetAxesOption === 'expandOnly') {
	            		/* track X axis */ {
		            		if (elementX < this._xMin) {
		            			this._xMin = elementX;
		            			scaleChanged = true;
		            		}
		            		if (elementX > this._xMax) {
		            			this._xMax = elementX;
		            			scaleChanged = true;
		            		}
	            		}
	            			
	            		/* track Y axis */ {
		            		if (elementY < this._yMin) {
		            			this._yMin = elementY;
		            			scaleChanged = true;
		            		}
		            		if (elementY > this._yMax) {
		            			this._yMax = elementY;
		            			scaleChanged = true;
		            		}
	            		}
	            	}	 	            	
	            };

            	if (scaleChanged)
            		this._reScale();

	            this._graph.series[index].data = serieData;
				this._graph.series[index].showLabel=true;
			}
		},
		
		_reScale: function() {
			if (this.resetAxesOption === 'expandOnly') {
				var yPadding = Math.abs(this._yMax-this._yMin) * 0.1;
				var xPadding = Math.abs(this._xMax-this._xMin) * 0.1;

				log('rescale y_max=' + this._yMax);
				log('rescale y_min=' + this._yMin);
				
				this._graph.replot({
					resetAxes: ['xaxis', 'yaxis'],
				  	axes: {
					  xaxis: {
						  min: this._xMin-xPadding,
						  max: this._xMax+xPadding
					  },
					  yaxis: {
						  /* need to add and sub track one make element visible at graph border */
						  min: this._yMin-yPadding,
						  max: this._yMax+yPadding
					  }
				  	}
				});
			}
		},
		
		//colors
		seriesColor:function(){
			var ss=this._params.series;
			var c;
			for(var i=0;i<ss.length;i++){
				c=this.getColor(i);
				if(c)
					ss[i].color=c;
			}
		},
		getColor:function(index){
			return this.get("color"+index);
		},
		setColor:function(index,c){
			this._set("color"+index,c);
		},
		_setColor1Attr:function(c){
			this.setColor(1,c);
		},
		_setColor2Attr:function(c){
			this.setColor(2,c);
		},
		_setColor3Attr:function(c){
			this.setColor(3,c);
		},
		_setColor4Attr:function(c){
			this.setColor(4,c);
		},
		_setColor5Attr:function(c){
			this.setColor(5,c);
		},
		_setColor6Attr:function(c){
			this.setColor(6,c);
		},
		_setColor7Attr:function(c){
			this.setColor(7,c);
		},
		_setColor0Attr:function(c){
			this.setColor(0,c);
		},
		resize:function(){
			if( this.modelBindEnabled) {
				this._graph.replot({resetAxes: this.resetAxesOption === 'on'});
			}
		}
	});
});