define([
	"dojo/_base/declare", 
	"dojo/dom-style",
	"dojo/_base/lang",
	"dojo/dom-class",
	"dojo/dom-geometry",
	"./tools",
	"dojo/_base/array"
], function(declare, domStyle,lang,domClass,gemo,tools,array){
    return declare("gc.dijit.libs._selectableWidget", [], {
    	labels : ["item1","item2","item3"],
    	getVi:function(index){
    		var vi="";
    		if(this.values&&index>=0&&index<this.values.length)
    		vi=this.values[index]+"";
    		else if(this.labels&&index>=0&&index<this.labels.length){
    			if(this.multiple)
    				vi=1<<index;
    			else
    	    		vi=this.labels[index]+"";
    		}
     		return vi;
    	},
	_setLabelsAttr : function(labels) {
		if(labels===undefined||labels===null)
			return;
		if(!tools.isArray(labels)){
			labels=labels.split(",");
		};
		this._set('labels', labels);
		
		var i;
		this.options=[];
		for(i=0;i<labels.length;i++){
			this.options[i]={label:labels[i]+"",
					value:this.getVi(i),
					selected:false,
					index:i,
					id:dijit.getUniqueId("select_option")};
		};
		tools.sortOptions(this,this.options);
		if(this._started)
		this._loadChildren();
	},
	sort:"none",
	_setSortAttr:function(s){
		this._set("sort",s);
		tools.sortOptions(this,this.options);
		if(this._started)
		this._loadChildren();
	},
	_setValuesAttr:function(values){
		if(values===undefined||values===null)
			return;
		if(!tools.isArray(values))
			values=values.split(",");
		this._set('values', values);
		this._setLabelsAttr(this.labels);
	},
	clearOptions:function(){
	//	console.debug("_selectableWidget:clearOptions::id::"+this.id+"::callers:: "+ tools.getCallers().join("::"));	
		var ii;
		for (ii=0;ii<this.options.length;ii++){
			this.options[ii].selected=false;
		}
	},
	_setIndexAttr:function(index){
	//	console.debug("_selectableWidget:_setIndexAttr::index::"+index);
		var i1=parseInt(index);
		if(isNaN(i1))
			return;
		if(i1>=this.options.length||i1<0)
			return;
		this.clearOptions();
		array.forEach(this.options,function(op){
			if(op.index==i1)
			{
				op.selected=true;
			}
		});
		this._updateSelection();
		
	},
	setOption:function(an,av){
	//	console.debug("_selectableWidget::setOption::name::"+an+" value::"+av);
		if(av===undefined||av===null)
			return;
		var av1;
		if(!tools.isArray(av))
			av1=[av];
		else
			av1=av;		
		if(!array.some(this.options,function(op){
			return array.some(av1,function(av10){
				if(op[an]==av10)
					return true;
				return false;
				
			});
		}))
			return;
		this.clearOptions(true);
		array.forEach(this.options,function(option){
			array.forEach(av1,function(av10){
				if(option[an]==av10){
					option.selected=true;
				};
			});
		});
		this._updateSelection();
		
	}
	
    });
});