/*******************************************************************************
 * Copyright (c) 2013 Texas Instruments Incorporated - http://www.ti.com/
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Texas Instruments Incorporated - initial API and implementation
 *
 * Original Author:
 * 		Dobrin Alexiev
 *
 * Contributing Authors:
 *
 * About:
 * 		Wraps a jQuery combo into a widget. 
 *******************************************************************************/

function JQCombo( widgetId, onUpdate) {
	this.widgetId = widgetId; 
	this.listeners = {};
	this.cachedProps = {};
	this.value = "";
	this.labels = [];
	this.onUpdate = onUpdate;
};

JQCombo.prototype.get = function( property) {
	console.log("get "+property);
	if( this._hasWidgetProperty( property)) {
		return this[property];
	}
	return null;
};

JQCombo.prototype.set = function( property, value) {
	console.log("set "+property + ":"+value);
	if( !this._hasWidgetProperty( property)) {
		return;
	}
	var oldValue = this[property];
	if( oldValue === value) {
		return;
	}
	this[property] = value;
	this.notify_listeners( property, oldValue, value);	
	this._updateCachedProerty( property, value);
	this._refresh();
};

JQCombo.prototype.watch = function( property, listener) {
	console.log("watch "+property);
	if( !this._hasWidgetProperty( property)) {
		return;
	}
	if( typeof this.listeners[property] === 'undefined') {
		this.listeners[property] = [];
	}
	this.listeners[property].push( listener);
};

JQCombo.prototype.notify_listeners = function( property, oldValue, newValue) {
	if( typeof this.listeners[property] !== 'undefined') {
		for( var i = 0; i < this.listeners[property].length; ++i) {
			this.listeners[property][i]( property, oldValue, newValue);
		}  
	} 										
};

JQCombo.prototype._refresh = function() {
	var that = this;
	var combo = this._getWidget();
	if( !combo) {
		return;
	}
	combo.empty();
	var l = this.labels;
	for( var i = 0; i < l.length; ++i) {
		combo.append(new Option(l[i], l[i]));
	};
	combo.val(this.value);
	combo.combobox("destroy");
	combo.combobox({
		selected: function(event, ui) {
			that.set('value', combo.val());					
		},
	});
	if ((typeof this.onUpdate != 'undefined') && (this.onUpdate != null))
		this.onUpdate();
};

JQCombo.prototype._getWidget = function( newValue) {
	return $('#'+ this.widgetId);
};

JQCombo.prototype.addCachedProperty = function( widgetProperty, cacheObject, cacheProperty) {
	if( cacheObject && cacheProperty) {
		this.cachedProps[cache] = {
			cacheObject : cacheObject,
			cacheProperty : cacheProperty 
		};
	}
};

JQCombo.prototype._updateCachedProerty = function( property, value) {
	var cacheEntry = this.cachedProps[property]; 
	if( cacheEntry) {
		cacheEntry.cacheObject[ cacheEntry.cacheProperty] = value;
	}
};

JQCombo.prototype._hasWidgetProperty = function( property) {
	return property === 'value' || property === 'labels';  
};

JQCombo.prototype.register = function( labelsBind, valueBind) {
	$TI.guiComposerServer.registerWidget( this, this.widgetId);
	$TI.guiComposerServer.addBinding( this.widgetId, "labels", labelsBind, {dataType: "Array"});
	$TI.guiComposerServer.addBinding( this.widgetId, "value", valueBind, {dataType: "String"});
};

/*
 * Initialize the combo box.
 */
function _initCombo(widgetId, elements, selElement) {
	var combo = $("#"+widgetId);
	if( !combo) {
		return;
	}
	if( typeof elements === 'undefined'){
		elements = ["None"];
	}
	if( typeof selElement === 'undefined'){
		selElement = "None";
	}
	combo.empty();
	elements.forEach( function(e) { 
	   combo.append(new Option(e, e)) ;
	});
	combo.val(selElement);
	combo.combobox("destroy");
	combo.combobox();			
}
