/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojox/charting/plot2d/_PlotEvents":function(){define("dojox/charting/plot2d/_PlotEvents",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/connect"],function(_1,_2,_3,_4){return _3("dojox.charting.plot2d._PlotEvents",null,{constructor:function(){this._shapeEvents=[];this._eventSeries={};},destroy:function(){this.resetEvents();this.inherited(arguments);},plotEvent:function(o){},raiseEvent:function(o){this.plotEvent(o);var t=_1.delegate(o);t.originalEvent=o.type;t.originalPlot=o.plot;t.type="onindirect";_2.forEach(this.chart.stack,function(_5){if(_5!==this&&_5.plotEvent){t.plot=_5;_5.plotEvent(t);}},this);},connect:function(_6,_7){this.dirty=true;return _4.connect(this,"plotEvent",_6,_7);},events:function(){return !!this.plotEvent.after;},resetEvents:function(){if(this._shapeEvents.length){_2.forEach(this._shapeEvents,function(_8){_8.shape.disconnect(_8.handle);});this._shapeEvents=[];}this.raiseEvent({type:"onplotreset",plot:this});},_connectSingleEvent:function(o,_9){this._shapeEvents.push({shape:o.eventMask,handle:o.eventMask.connect(_9,this,function(e){o.type=_9;o.event=e;this.raiseEvent(o);o.event=null;})});},_connectEvents:function(o){if(o){o.chart=this.chart;o.plot=this;o.hAxis=this.hAxis||null;o.vAxis=this.vAxis||null;o.eventMask=o.eventMask||o.shape;this._connectSingleEvent(o,"onmouseover");this._connectSingleEvent(o,"onmouseout");this._connectSingleEvent(o,"onclick");}},_reconnectEvents:function(_a){var a=this._eventSeries[_a];if(a){_2.forEach(a,this._connectEvents,this);}},fireEvent:function(_b,_c,_d,_e){var s=this._eventSeries[_b];if(s&&s.length&&_d<s.length){var o=s[_d];o.type=_c;o.event=_e||null;this.raiseEvent(o);o.event=null;}}});});},"dojo/uacss":function(){define(["./dom-geometry","./_base/lang","./ready","./sniff","./_base/window"],function(_f,_10,_11,has,_12){var _13=_12.doc.documentElement,ie=has("ie"),_14=has("opera"),maj=Math.floor,ff=has("ff"),_15=_f.boxModel.replace(/-/,""),_16={"dj_quirks":has("quirks"),"dj_opera":_14,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_gecko":has("mozilla")};if(ie){_16["dj_ie"]=true;_16["dj_ie"+maj(ie)]=true;_16["dj_iequirks"]=has("quirks");}if(ff){_16["dj_ff"+maj(ff)]=true;}_16["dj_"+_15]=true;var _17="";for(var clz in _16){if(_16[clz]){_17+=clz+" ";}}_13.className=_10.trim(_13.className+" "+_17);_11(90,function(){if(!_f.isBodyLtr()){var _18="dj_rtl dijitRtl "+_17.replace(/ /g,"-rtl ");_13.className=_10.trim(_13.className+" "+_18+"dj_rtl dijitRtl "+_17.replace(/ /g,"-rtl "));}});return has;});},"dojox/charting/axis2d/Invisible":function(){define("dojox/charting/axis2d/Invisible",["dojo/_base/lang","dojo/_base/declare","./Base","../scaler/linear","dojox/gfx","dojox/lang/utils"],function(_19,_1a,_1b,lin,g,du){return _1a("dojox.charting.axis2d.Invisible",_1b,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1},constructor:function(_1c,_1d){this.opt=_19.clone(this.defaultParams);du.updateWithObject(this.opt,_1d);du.updateWithPattern(this.opt,_1d,this.optionalParams);},dependOnData:function(){return !("min" in this.opt)||!("max" in this.opt);},clear:function(){delete this.scaler;delete this.ticks;this.dirty=true;return this;},initialized:function(){return "scaler" in this&&!(this.dirty&&this.dependOnData());},setWindow:function(_1e,_1f){this.scale=_1e;this.offset=_1f;return this.clear();},getWindowScale:function(){return "scale" in this?this.scale:1;},getWindowOffset:function(){return "offset" in this?this.offset:0;},calculate:function(min,max,_20){if(this.initialized()){return this;}var o=this.opt;this.labels=o.labels;this.scaler=lin.buildScaler(min,max,_20,o);var tsb=this.scaler.bounds;if("scale" in this){o.from=tsb.lower+this.offset;o.to=(tsb.upper-tsb.lower)/this.scale+o.from;if(!isFinite(o.from)||isNaN(o.from)||!isFinite(o.to)||isNaN(o.to)||o.to-o.from>=tsb.upper-tsb.lower){delete o.from;delete o.to;delete this.scale;delete this.offset;}else{if(o.from<tsb.lower){o.to+=tsb.lower-o.from;o.from=tsb.lower;}else{if(o.to>tsb.upper){o.from+=tsb.upper-o.to;o.to=tsb.upper;}}this.offset=o.from-tsb.lower;}this.scaler=lin.buildScaler(min,max,_20,o);tsb=this.scaler.bounds;if(this.scale==1&&this.offset==0){delete this.scale;delete this.offset;}}return this;},getScaler:function(){return this.scaler;},getTicks:function(){return this.ticks;}});});},"dojox/lang/utils":function(){define("dojox/lang/utils",["..","dojo/_base/lang"],function(_21,_22){var du=_22.getObject("lang.utils",true,_21);var _23={},_24=Object.prototype.toString;var _25=function(o){if(o){switch(_24.call(o)){case "[object Array]":return o.slice(0);case "[object Object]":return _22.delegate(o);}}return o;};_22.mixin(du,{coerceType:function(_26,_27){switch(typeof _26){case "number":return Number(eval("("+_27+")"));case "string":return String(_27);case "boolean":return Boolean(eval("("+_27+")"));}return eval("("+_27+")");},updateWithObject:function(_28,_29,_2a){if(!_29){return _28;}for(var x in _28){if(x in _29&&!(x in _23)){var t=_28[x];if(t&&typeof t=="object"){du.updateWithObject(t,_29[x],_2a);}else{_28[x]=_2a?du.coerceType(t,_29[x]):_25(_29[x]);}}}return _28;},updateWithPattern:function(_2b,_2c,_2d,_2e){if(!_2c||!_2d){return _2b;}for(var x in _2d){if(x in _2c&&!(x in _23)){_2b[x]=_2e?du.coerceType(_2d[x],_2c[x]):_25(_2c[x]);}}return _2b;},merge:function(_2f,_30){if(_30){var _31=_24.call(_2f),_32=_24.call(_30),t,i,l,m;switch(_32){case "[object Array]":if(_32==_31){t=new Array(Math.max(_2f.length,_30.length));for(i=0,l=t.length;i<l;++i){t[i]=du.merge(_2f[i],_30[i]);}return t;}return _30.slice(0);case "[object Object]":if(_32==_31&&_2f){t=_22.delegate(_2f);for(i in _30){if(i in _2f){l=_2f[i];m=_30[i];if(m!==l){t[i]=du.merge(l,m);}}else{t[i]=_22.clone(_30[i]);}}return t;}return _22.clone(_30);}}return _30;}});return du;});},"dojox/charting/plot2d/Pie":function(){define("dojox/charting/plot2d/Pie",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Base","./_PlotEvents","./common","../axis2d/common","dojox/gfx","dojox/gfx/matrix","dojox/lang/functional","dojox/lang/utils"],function(_33,arr,_34,_35,_36,dc,da,g,m,df,du){var _37=0.2;return _34("dojox.charting.plot2d.Pie",[_35,_36],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:20,labelStyle:"default",htmlLabels:true,radGrad:"native",fanSize:5,startAngle:0},optionalParams:{radius:0,omitLabels:false,stroke:{},outline:{},shadow:{},fill:{},styleFunc:null,font:"",fontColor:"",labelWiring:{}},constructor:function(_38,_39){this.opt=_33.clone(this.defaultParams);du.updateWithObject(this.opt,_39);du.updateWithPattern(this.opt,_39,this.optionalParams);this.axes=[];this.run=null;this.dyn=[];},clear:function(){this.inherited(arguments);this.dyn=[];this.run=null;return this;},setAxis:function(_3a){return this;},addSeries:function(run){this.run=run;return this;},getSeriesStats:function(){return _33.delegate(dc.defaultStats);},getRequiredColors:function(){return this.run?this.run.data.length:0;},render:function(dim,_3b){if(!this.dirty){return this;}this.resetEvents();this.dirty=false;this._eventSeries={};this.cleanGroup();var s=this.group,t=this.chart.theme;if(!this.run||!this.run.data.length){return this;}var rx=(dim.width-_3b.l-_3b.r)/2,ry=(dim.height-_3b.t-_3b.b)/2,r=Math.min(rx,ry),_3c="font" in this.opt?this.opt.font:t.series.font,_3d,_3e=m._degToRad(this.opt.startAngle),_3f=_3e,_40,_41,_42,_43,_44,_45,run=this.run.data,_46=this.events();this.dyn=[];if("radius" in this.opt){r=this.opt.radius;_45=r-this.opt.labelOffset;}var _47={cx:_3b.l+rx,cy:_3b.t+ry,r:r};if(this.opt.shadow||t.shadow){var _48=this.opt.shadow||t.shadow;var _49=_33.clone(_47);_49.cx+=_48.dx;_49.cy+=_48.dy;s.createCircle(_49).setFill(_48.color).setStroke(_48);}if(typeof run[0]=="number"){_41=df.map(run,"x ? Math.max(x, 0) : 0");if(df.every(_41,"<= 0")){s.createCircle(_47).setStroke(t.series.stroke);this.dyn=arr.map(_41,function(){return {};});return this;}else{_42=df.map(_41,"/this",df.foldl(_41,"+",0));if(this.opt.labels){_43=arr.map(_42,function(x){return x>0?this._getLabel(x*100)+"%":"";},this);}}}else{_41=df.map(run,"x ? Math.max(x.y, 0) : 0");if(df.every(_41,"<= 0")){s.createCircle(_47).setStroke(t.series.stroke);this.dyn=arr.map(_41,function(){return {};});return this;}else{_42=df.map(_41,"/this",df.foldl(_41,"+",0));if(this.opt.labels){_43=arr.map(_42,function(x,i){if(x<0){return "";}var v=run[i];return "text" in v?v.text:this._getLabel(x*100)+"%";},this);}}}var _4a=df.map(run,function(v,i){var _4b=[this.opt,this.run];if(v!==null&&typeof v!="number"){_4b.push(v);}if(this.opt.styleFunc){_4b.push(this.opt.styleFunc(v));}return t.next("slice",_4b,true);},this);if(this.opt.labels){_3d=_3c?g.normalizedLength(g.splitFontString(_3c).size):0;_44=df.foldl1(df.map(_43,function(_4c,i){var _4d=_4a[i].series.font;return g._base._getTextBox(_4c,{font:_4d}).w;},this),"Math.max(a, b)")/2;if(this.opt.labelOffset<0){r=Math.min(rx-2*_44,ry-_3d)+this.opt.labelOffset;}_45=r-this.opt.labelOffset;}var _4e=new Array(_42.length);arr.some(_42,function(_4f,i){if(_4f<0){return false;}if(_4f==0){this.dyn.push({fill:null,stroke:null});return false;}var v=run[i],_50=_4a[i],_51,o;if(_4f>=1){_51=this._plotFill(_50.series.fill,dim,_3b);_51=this._shapeFill(_51,{x:_47.cx-_47.r,y:_47.cy-_47.r,width:2*_47.r,height:2*_47.r});_51=this._pseudoRadialFill(_51,{x:_47.cx,y:_47.cy},_47.r);var _52=s.createCircle(_47).setFill(_51).setStroke(_50.series.stroke);this.dyn.push({fill:_51,stroke:_50.series.stroke});if(_46){o={element:"slice",index:i,run:this.run,shape:_52,x:i,y:typeof v=="number"?v:v.y,cx:_47.cx,cy:_47.cy,cr:r};this._connectEvents(o);_4e[i]=o;}return true;}var end=_3f+_4f*2*Math.PI;if(i+1==_42.length){end=_3e+2*Math.PI;}var _53=end-_3f,x1=_47.cx+r*Math.cos(_3f),y1=_47.cy+r*Math.sin(_3f),x2=_47.cx+r*Math.cos(end),y2=_47.cy+r*Math.sin(end);var _54=m._degToRad(this.opt.fanSize);if(_50.series.fill&&_50.series.fill.type==="radial"&&this.opt.radGrad==="fan"&&_53>_54){var _55=s.createGroup(),_56=Math.ceil(_53/_54),_57=_53/_56;_51=this._shapeFill(_50.series.fill,{x:_47.cx-_47.r,y:_47.cy-_47.r,width:2*_47.r,height:2*_47.r});for(var j=0;j<_56;++j){var _58=j==0?x1:_47.cx+r*Math.cos(_3f+(j-_37)*_57),_59=j==0?y1:_47.cy+r*Math.sin(_3f+(j-_37)*_57),_5a=j==_56-1?x2:_47.cx+r*Math.cos(_3f+(j+1+_37)*_57),_5b=j==_56-1?y2:_47.cy+r*Math.sin(_3f+(j+1+_37)*_57),fan=_55.createPath().moveTo(_47.cx,_47.cy).lineTo(_58,_59).arcTo(r,r,0,_57>Math.PI,true,_5a,_5b).lineTo(_47.cx,_47.cy).closePath().setFill(this._pseudoRadialFill(_51,{x:_47.cx,y:_47.cy},r,_3f+(j+0.5)*_57,_3f+(j+0.5)*_57));}_55.createPath().moveTo(_47.cx,_47.cy).lineTo(x1,y1).arcTo(r,r,0,_53>Math.PI,true,x2,y2).lineTo(_47.cx,_47.cy).closePath().setStroke(_50.series.stroke);_52=_55;}else{_52=s.createPath().moveTo(_47.cx,_47.cy).lineTo(x1,y1).arcTo(r,r,0,_53>Math.PI,true,x2,y2).lineTo(_47.cx,_47.cy).closePath().setStroke(_50.series.stroke);_51=_50.series.fill;if(_51&&_51.type==="radial"){_51=this._shapeFill(_51,{x:_47.cx-_47.r,y:_47.cy-_47.r,width:2*_47.r,height:2*_47.r});if(this.opt.radGrad==="linear"){_51=this._pseudoRadialFill(_51,{x:_47.cx,y:_47.cy},r,_3f,end);}}else{if(_51&&_51.type==="linear"){_51=this._plotFill(_51,dim,_3b);_51=this._shapeFill(_51,_52.getBoundingBox());}}_52.setFill(_51);}this.dyn.push({fill:_51,stroke:_50.series.stroke});if(_46){o={element:"slice",index:i,run:this.run,shape:_52,x:i,y:typeof v=="number"?v:v.y,cx:_47.cx,cy:_47.cy,cr:r};this._connectEvents(o);_4e[i]=o;}_3f=end;return false;},this);if(this.opt.labels){if(this.opt.labelStyle=="default"){_3f=_3e;arr.some(_42,function(_5c,i){if(_5c<=0){return false;}var _5d=_4a[i],_5e;if(_5c>=1){_5e=da.createText[this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx"](this.chart,s,_47.cx,_47.cy+_3d/2,"middle",_43[i],_5d.series.font,_5d.series.fontColor);if(this.opt.htmlLabels){this.htmlElements.push(_5e);}return true;}var end=_3f+_5c*2*Math.PI;if(i+1==_42.length){end=_3e+2*Math.PI;}if(this.opt.omitLabels&&end-_3f<0.001){return false;}var _5f=(_3f+end)/2,x=_47.cx+_45*Math.cos(_5f),y=_47.cy+_45*Math.sin(_5f)+_3d/2;_5e=da.createText[this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx"](this.chart,s,x,y,"middle",_43[i],_5d.series.font,_5d.series.fontColor);if(this.opt.htmlLabels){this.htmlElements.push(_5e);}_3f=end;return false;},this);}else{if(this.opt.labelStyle=="columns"){_3f=_3e;var _60=this.opt.omitLabels;var _61=[];arr.forEach(_42,function(_62,i){var end=_3f+_62*2*Math.PI;if(i+1==_42.length){end=_3e+2*Math.PI;}var _63=(_3f+end)/2;_61.push({angle:_63,left:Math.cos(_63)<0,theme:_4a[i],index:i,omit:_60?end-_3f<0.001:false});_3f=end;});var _64=g._base._getTextBox("a",{font:_3c}).h;this._getProperLabelRadius(_61,_64,_47.r*1.1);arr.forEach(_61,function(_65,i){if(!_65.omit){var _66=_47.cx-_47.r*2,_67=_47.cx+_47.r*2,_68=g._base._getTextBox(_43[i],{font:_65.theme.series.font}).w,x=_47.cx+_65.labelR*Math.cos(_65.angle),y=_47.cy+_65.labelR*Math.sin(_65.angle),_69=(_65.left)?(_66+_68):(_67-_68),_6a=(_65.left)?_66:_69;var _6b=s.createPath().moveTo(_47.cx+_47.r*Math.cos(_65.angle),_47.cy+_47.r*Math.sin(_65.angle));if(Math.abs(_65.labelR*Math.cos(_65.angle))<_47.r*2-_68){_6b.lineTo(x,y);}_6b.lineTo(_69,y).setStroke(_65.theme.series.labelWiring);var _6c=da.createText[this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx"](this.chart,s,_6a,y,"left",_43[i],_65.theme.series.font,_65.theme.series.fontColor);if(this.opt.htmlLabels){this.htmlElements.push(_6c);}}},this);}}}var esi=0;this._eventSeries[this.run.name]=df.map(run,function(v){return v<=0?null:_4e[esi++];});return this;},_getProperLabelRadius:function(_6d,_6e,_6f){var _70,_71,_72=1,_73=1;if(_6d.length==1){_6d[0].labelR=_6f;return;}for(var i=0;i<_6d.length;i++){var _74=Math.abs(Math.sin(_6d[i].angle));if(_6d[i].left){if(_72>=_74){_72=_74;_70=_6d[i];}}else{if(_73>=_74){_73=_74;_71=_6d[i];}}}_70.labelR=_71.labelR=_6f;this._calculateLabelR(_70,_6d,_6e);this._calculateLabelR(_71,_6d,_6e);},_calculateLabelR:function(_75,_76,_77){var i=_75.index,_78=_76.length,_79=_75.labelR,_7a;while(!(_76[i%_78].left^_76[(i+1)%_78].left)){if(!_76[(i+1)%_78].omit){_7a=(Math.sin(_76[i%_78].angle)*_79+((_76[i%_78].left)?(-_77):_77))/Math.sin(_76[(i+1)%_78].angle);_79=(_7a<_75.labelR)?_75.labelR:_7a;_76[(i+1)%_78].labelR=_79;}i++;}i=_75.index;var j=(i==0)?_78-1:i-1;while(!(_76[i].left^_76[j].left)){if(!_76[j].omit){_7a=(Math.sin(_76[i].angle)*_79+((_76[i].left)?_77:(-_77)))/Math.sin(_76[j].angle);_79=(_7a<_75.labelR)?_75.labelR:_7a;_76[j].labelR=_79;}i--;j--;i=(i<0)?i+_76.length:i;j=(j<0)?j+_76.length:j;}},_getLabel:function(_7b){return dc.getLabel(_7b,this.opt.fixed,this.opt.precision);}});});},"dijit/hccss":function(){define("dijit/hccss",["dojo/dom-class","dojo/hccss","dojo/ready","dojo/_base/window"],function(_7c,has,_7d,win){_7d(90,function(){if(has("highcontrast")){_7c.add(win.body(),"dijit_a11y");}});return has;});},"dojox/charting/action2d/Shake":function(){define(["dojo/_base/connect","dojo/_base/declare","./PlotAction","dojo/fx","dojo/fx/easing","dojox/gfx/matrix","dojox/gfx/fx"],function(hub,_7e,_7f,df,dfe,m,gf){var _80=3;return _7e("dojox.charting.action2d.Shake",_7f,{defaultParams:{duration:400,easing:dfe.backOut,shiftX:_80,shiftY:_80},optionalParams:{},constructor:function(_81,_82,_83){if(!_83){_83={};}this.shiftX=typeof _83.shiftX=="number"?_83.shiftX:_80;this.shiftY=typeof _83.shiftY=="number"?_83.shiftY:_80;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}var _84=o.run.name,_85=o.index,_86=[],_87,_88=o.type=="onmouseover"?this.shiftX:-this.shiftX,_89=o.type=="onmouseover"?this.shiftY:-this.shiftY;if(_84 in this.anim){_87=this.anim[_84][_85];}else{this.anim[_84]={};}if(_87){_87.action.stop(true);}else{this.anim[_84][_85]=_87={};}var _8a={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"translate",start:[this.shiftX,this.shiftY],end:[0,0]},m.identity]};if(o.shape){_86.push(gf.animateTransform(_8a));}if(o.oultine){_8a.shape=o.outline;_86.push(gf.animateTransform(_8a));}if(o.shadow){_8a.shape=o.shadow;_86.push(gf.animateTransform(_8a));}if(!_86.length){delete this.anim[_84][_85];return;}_87.action=df.combine(_86);if(o.type=="onmouseout"){hub.connect(_87.action,"onEnd",this,function(){if(this.anim[_84]){delete this.anim[_84][_85];}});}_87.action.play();}});});},"dojox/lang/functional/lambda":function(){define("dojox/lang/functional/lambda",["../..","dojo/_base/kernel","dojo/_base/lang","dojo/_base/array"],function(_8b,_8c,_8d,arr){var df=_8d.getObject("lang.functional",true,_8b);var _8e={};var _8f="ab".split(/a*/).length>1?String.prototype.split:function(sep){var r=this.split.call(this,sep),m=sep.exec(this);if(m&&m.index==0){r.unshift("");}return r;};var _90=function(s){var _91=[],_92=_8f.call(s,/\s*->\s*/m);if(_92.length>1){while(_92.length){s=_92.pop();_91=_92.pop().split(/\s*,\s*|\s+/m);if(_92.length){_92.push("(function("+_91+"){return ("+s+")})");}}}else{if(s.match(/\b_\b/)){_91=["_"];}else{var l=s.match(/^\s*(?:[+*\/%&|\^\.=<>]|!=)/m),r=s.match(/[+\-*\/%&|\^\.=<>!]\s*$/m);if(l||r){if(l){_91.push("$1");s="$1"+s;}if(r){_91.push("$2");s=s+"$2";}}else{var _93=s.replace(/(?:\b[A-Z]|\.[a-zA-Z_$])[a-zA-Z_$\d]*|[a-zA-Z_$][a-zA-Z_$\d]*:|this|true|false|null|undefined|typeof|instanceof|in|delete|new|void|arguments|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|escape|eval|isFinite|isNaN|parseFloat|parseInt|unescape|dojo|dijit|dojox|window|document|'(?:[^'\\]|\\.)*'|"(?:[^"\\]|\\.)*"/g,"").match(/([a-z_$][a-z_$\d]*)/gi)||[],t={};arr.forEach(_93,function(v){if(!(v in t)){_91.push(v);t[v]=1;}});}}}return {args:_91,body:s};};var _94=function(a){return a.length?function(){var i=a.length-1,x=df.lambda(a[i]).apply(this,arguments);for(--i;i>=0;--i){x=df.lambda(a[i]).call(this,x);}return x;}:function(x){return x;};};_8d.mixin(df,{rawLambda:function(s){return _90(s);},buildLambda:function(s){s=_90(s);return "function("+s.args.join(",")+"){return ("+s.body+");}";},lambda:function(s){if(typeof s=="function"){return s;}if(s instanceof Array){return _94(s);}if(s in _8e){return _8e[s];}s=_90(s);return _8e[s]=new Function(s.args,"return ("+s.body+");");},clearLambdaCache:function(){_8e={};}});return df;});},"dojox/charting/scaler/primitive":function(){define("dojox/charting/scaler/primitive",["dojo/_base/lang"],function(_95){var _96=_95.getObject("dojox.charting.scaler.primitive",true);return _95.mixin(_96,{buildScaler:function(min,max,_97,_98){if(min==max){min-=0.5;max+=0.5;}return {bounds:{lower:min,upper:max,from:min,to:max,scale:_97/(max-min),span:_97},scaler:_96};},buildTicks:function(_99,_9a){return {major:[],minor:[],micro:[]};},getTransformerFromModel:function(_9b){var _9c=_9b.bounds.from,_9d=_9b.bounds.scale;return function(x){return (x-_9c)*_9d;};},getTransformerFromPlot:function(_9e){var _9f=_9e.bounds.from,_a0=_9e.bounds.scale;return function(x){return x/_a0+_9f;};}});});},"dojox/lang/functional/reversed":function(){define("dojox/lang/functional/reversed",["dojo/_base/lang","dojo/_base/kernel","./lambda"],function(_a1,_a2,df){_a1.mixin(df,{filterRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_a2.global;f=df.lambda(f);var t=[],v,i=a.length-1;for(;i>=0;--i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}return t;},forEachRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_a2.global;f=df.lambda(f);for(var i=a.length-1;i>=0;f.call(o,a[i],i,a),--i){}},mapRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_a2.global;f=df.lambda(f);var n=a.length,t=new Array(n),i=n-1,j=0;for(;i>=0;t[j++]=f.call(o,a[i],i,a),--i){}return t;},everyRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_a2.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(!f.call(o,a[i],i,a)){return false;}}return true;},someRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_a2.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(f.call(o,a[i],i,a)){return true;}}return false;}});return df;});},"dojox/charting/plot2d/Candlesticks":function(){define("dojox/charting/plot2d/Candlesticks",["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(_a3,_a4,arr,_a5,_a6,dc,df,dfr,du,fx){var _a7=dfr.lambda("item.purgeGroup()");return _a4("dojox.charting.plot2d.Candlesticks",[_a5,_a6],{defaultParams:{hAxis:"x",vAxis:"y",gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_a8,_a9){this.opt=_a3.clone(this.defaultParams);du.updateWithObject(this.opt,_a9);du.updateWithPattern(this.opt,_a9,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},collectStats:function(_aa){var _ab=_a3.delegate(dc.defaultStats);for(var i=0;i<_aa.length;i++){var run=_aa[i];if(!run.data.length){continue;}var _ac=_ab.vmin,_ad=_ab.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;_ab.hmin=Math.min(_ab.hmin,x);_ab.hmax=Math.max(_ab.hmax,x);_ab.vmin=Math.min(_ab.vmin,val.open,val.close,val.high,val.low);_ab.vmax=Math.max(_ab.vmax,val.open,val.close,val.high,val.low);}});}if("ymin" in run){_ab.vmin=Math.min(_ac,run.ymin);}if("ymax" in run){_ab.vmax=Math.max(_ad,run.ymax);}}return _ab;},getSeriesStats:function(){var _ae=this.collectStats(this.series);_ae.hmin-=0.5;_ae.hmax+=0.5;return _ae;},render:function(dim,_af){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_af);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_a7);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(_b0){_b0.cleanGroup(s);});}var t=this.chart.theme,f,gap,_b1,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_b2=Math.max(0,this._vScaler.bounds.lower),_b3=vt(_b2),_b4=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_b1=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _b5=t.next("candlestick",[this.opt,run]),s=run.group,_b6=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var _b7=t.addMixin(_b5,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_af.l+gap,y=dim.height-_af.b,_b8=vt(v.open),_b9=vt(v.close),_ba=vt(v.high),low=vt(v.low);if("mid" in v){var mid=vt(v.mid);}if(low>_ba){var tmp=_ba;_ba=low;low=tmp;}if(_b1>=1){var _bb=_b8>_b9;var _bc={x1:_b1/2,x2:_b1/2,y1:y-_ba,y2:y-low},_bd={x:0,y:y-Math.max(_b8,_b9),width:_b1,height:Math.max(_bb?_b8-_b9:_b9-_b8,1)};var _be=s.createGroup();_be.setTransform({dx:x,dy:0});var _bf=_be.createGroup();_bf.createLine(_bc).setStroke(_b7.series.stroke);_bf.createRect(_bd).setStroke(_b7.series.stroke).setFill(_bb?_b7.series.fill:"white");if("mid" in v){_bf.createLine({x1:(_b7.series.stroke.width||1),x2:_b1-(_b7.series.stroke.width||1),y1:y-mid,y2:y-mid}).setStroke(_bb?"white":_b7.series.stroke);}run.dyn.fill=_b7.series.fill;run.dyn.stroke=_b7.series.stroke;if(_b4){var o={element:"candlestick",index:j,run:run,shape:_bf,x:x,y:y-Math.max(_b8,_b9),cx:_b1/2,cy:(y-Math.max(_b8,_b9))+(Math.max(_bb?_b8-_b9:_b9-_b8,1)/2),width:_b1,height:Math.max(_bb?_b8-_b9:_b9-_b8,1),data:v};this._connectEvents(o);_b6[j]=o;}}if(this.animate){this._animateCandlesticks(_be,y-low,_ba-low);}}}this._eventSeries[run.name]=_b6;run.dirty=false;}this.dirty=false;return this;},_animateCandlesticks:function(_c0,_c1,_c2){fx.animateTransform(_a3.delegate({shape:_c0,duration:1200,transform:[{name:"translate",start:[0,_c1-(_c1/_c2)],end:[0,0]},{name:"scale",start:[1,1/_c2],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/charting/widget/Sparkline":function(){define("dojox/charting/widget/Sparkline",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/query","./Chart","../themes/GreySkies","../plot2d/Lines","dojo/dom-prop"],function(_c3,_c4,_c5,_c6,_c7,_c8,_c9,_ca){_c5("dojox.charting.widget.Sparkline",_c7,{theme:_c8,margins:{l:0,r:0,t:0,b:0},type:"Lines",valueFn:"Number(x)",store:"",field:"",query:"",queryOptions:"",start:"0",count:"Infinity",sort:"",data:"",name:"default",buildRendering:function(){var n=this.srcNodeRef;if(!n.childNodes.length||!_c6("> .axis, > .plot, > .action, > .series",n).length){var _cb=document.createElement("div");_ca.set(_cb,{"class":"plot","name":"default","type":this.type});n.appendChild(_cb);var _cc=document.createElement("div");_ca.set(_cc,{"class":"series",plot:"default",name:this.name,start:this.start,count:this.count,valueFn:this.valueFn});_c4.forEach(["store","field","query","queryOptions","sort","data"],function(i){if(this[i].length){_ca.set(_cc,i,this[i]);}},this);n.appendChild(_cc);}this.inherited(arguments);}});});},"dojox/gfx/matrix":function(){define("dojox/gfx/matrix",["./_base","dojo/_base/lang"],function(g,_cd){var m=g.matrix={};var _ce={};m._degToRad=function(_cf){return _ce[_cf]||(_ce[_cf]=(Math.PI*_cf/180));};m._radToDeg=function(_d0){return _d0/Math.PI*180;};m.Matrix2D=function(arg){if(arg){if(typeof arg=="number"){this.xx=this.yy=arg;}else{if(arg instanceof Array){if(arg.length>0){var _d1=m.normalize(arg[0]);for(var i=1;i<arg.length;++i){var l=_d1,r=m.normalize(arg[i]);_d1=new m.Matrix2D();_d1.xx=l.xx*r.xx+l.xy*r.yx;_d1.xy=l.xx*r.xy+l.xy*r.yy;_d1.yx=l.yx*r.xx+l.yy*r.yx;_d1.yy=l.yx*r.xy+l.yy*r.yy;_d1.dx=l.xx*r.dx+l.xy*r.dy+l.dx;_d1.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}_cd.mixin(this,_d1);}}else{_cd.mixin(this,arg);}}}};_cd.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});_cd.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(_d2){var c=Math.cos(_d2);var s=Math.sin(_d2);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(_d3){return m.rotate(m._degToRad(_d3));},skewX:function(_d4){return new m.Matrix2D({xy:Math.tan(_d4)});},skewXg:function(_d5){return m.skewX(m._degToRad(_d5));},skewY:function(_d6){return new m.Matrix2D({yx:Math.tan(_d6)});},skewYg:function(_d7){return m.skewY(m._degToRad(_d7));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(_d8){return (_d8 instanceof m.Matrix2D)?_d8:new m.Matrix2D(_d8);},isIdentity:function(_d9){return _d9.xx==1&&_d9.xy==0&&_d9.yx==0&&_d9.yy==1&&_d9.dx==0&&_d9.dy==0;},clone:function(_da){var obj=new m.Matrix2D();for(var i in _da){if(typeof (_da[i])=="number"&&typeof (obj[i])=="number"&&obj[i]!=_da[i]){obj[i]=_da[i];}}return obj;},invert:function(_db){var M=m.normalize(_db),D=M.xx*M.yy-M.xy*M.yx;M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(_dc,x,y){return {x:_dc.xx*x+_dc.xy*y+_dc.dx,y:_dc.yx*x+_dc.yy*y+_dc.dy};},multiplyPoint:function(_dd,a,b){var M=m.normalize(_dd);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}return m._multiplyPoint(M,a.x,a.y);},multiplyRectangle:function(_de,_df){var M=m.normalize(_de);_df=_df||{x:0,y:0,width:0,height:0};if(m.isIdentity(M)){return {x:_df.x,y:_df.y,width:_df.width,height:_df.height};}var p0=m.multiplyPoint(M,_df.x,_df.y),p1=m.multiplyPoint(M,_df.x,_df.y+_df.height),p2=m.multiplyPoint(M,_df.x+_df.width,_df.y),p3=m.multiplyPoint(M,_df.x+_df.width,_df.y+_df.height),_e0=Math.min(p0.x,p1.x,p2.x,p3.x),_e1=Math.min(p0.y,p1.y,p2.y,p3.y),_e2=Math.max(p0.x,p1.x,p2.x,p3.x),_e3=Math.max(p0.y,p1.y,p2.y,p3.y);return {x:_e0,y:_e1,width:_e2-_e0,height:_e3-_e1};},multiply:function(_e4){var M=m.normalize(_e4);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}return M;},_sandwich:function(_e5,x,y){return m.multiply(m.translate(x,y),_e5,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}return m._sandwich(m.scale(a,b),c.x,c.y);}return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(_e6,a,b){if(arguments.length>2){return m._sandwich(m.rotate(_e6),a,b);}return m._sandwich(m.rotate(_e6),a.x,a.y);},rotategAt:function(_e7,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(_e7),a,b);}return m._sandwich(m.rotateg(_e7),a.x,a.y);},skewXAt:function(_e8,a,b){if(arguments.length>2){return m._sandwich(m.skewX(_e8),a,b);}return m._sandwich(m.skewX(_e8),a.x,a.y);},skewXgAt:function(_e9,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(_e9),a,b);}return m._sandwich(m.skewXg(_e9),a.x,a.y);},skewYAt:function(_ea,a,b){if(arguments.length>2){return m._sandwich(m.skewY(_ea),a,b);}return m._sandwich(m.skewY(_ea),a.x,a.y);},skewYgAt:function(_eb,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(_eb),a,b);}return m._sandwich(m.skewYg(_eb),a.x,a.y);}});g.Matrix2D=m.Matrix2D;return m;});},"dojox/lang/functional/scan":function(){define("dojox/lang/functional/scan",["dojo/_base/kernel","dojo/_base/lang","./lambda"],function(_ec,_ed,df){var _ee={};_ed.mixin(df,{scanl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_ec.global;f=df.lambda(f);var t,n,i;if(_ed.isArray(a)){t=new Array((n=a.length)+1);t[0]=z;for(i=0;i<n;z=f.call(o,z,a[i],i,a),t[++i]=z){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[z];for(i=0;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}else{t=[z];for(i in a){if(!(i in _ee)){t.push(z=f.call(o,z,a[i],i,a));}}}}return t;},scanl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ec.global;f=df.lambda(f);var t,n,z,_ef=true;if(_ed.isArray(a)){t=new Array(n=a.length);t[0]=z=a[0];for(var i=1;i<n;t[i]=z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){t=[z=a.next()];for(i=1;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}}else{for(i in a){if(!(i in _ee)){if(_ef){t=[z=a[i]];_ef=false;}else{t.push(z=f.call(o,z,a[i],i,a));}}}}}return t;},scanr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_ec.global;f=df.lambda(f);var n=a.length,t=new Array(n+1),i=n;t[n]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;},scanr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ec.global;f=df.lambda(f);var n=a.length,t=new Array(n),z=a[n-1],i=n-1;t[i]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;}});});},"dojox/charting/plot2d/Scatter":function(){define("dojox/charting/plot2d/Scatter",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx","dojox/gfx/gradutils"],function(_f0,arr,_f1,_f2,_f3,dc,df,dfr,du,fx,_f4){var _f5=dfr.lambda("item.purgeGroup()");return _f1("dojox.charting.plot2d.Scatter",[_f2,_f3],{defaultParams:{hAxis:"x",vAxis:"y",shadows:null,animate:null},optionalParams:{markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:"",styleFunc:null},constructor:function(_f6,_f7){this.opt=_f0.clone(this.defaultParams);du.updateWithObject(this.opt,_f7);du.updateWithPattern(this.opt,_f7,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},render:function(dim,_f8){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_f8);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_f5);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(_f9){_f9.cleanGroup(s);});}var t=this.chart.theme,_fa=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}var _fb=t.next("marker",[this.opt,run]),s=run.group,_fc,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);if(typeof run.data[0]=="number"){_fc=arr.map(run.data,function(v,i){return {x:ht(i+1)+_f8.l,y:dim.height-_f8.b-vt(v)};},this);}else{_fc=arr.map(run.data,function(v,i){return {x:ht(v.x)+_f8.l,y:dim.height-_f8.b-vt(v.y)};},this);}var _fd=new Array(_fc.length),_fe=new Array(_fc.length),_ff=new Array(_fc.length);arr.forEach(_fc,function(c,i){var _100=run.data[i],_101;if(this.opt.styleFunc||typeof _100!="number"){var _102=typeof _100!="number"?[_100]:[];if(this.opt.styleFunc){_102.push(this.opt.styleFunc(_100));}_101=t.addMixin(_fb,"marker",_102,true);}else{_101=t.post(_fb,"marker");}var path="M"+c.x+" "+c.y+" "+_101.symbol;if(_101.marker.shadow){_fd[i]=s.createPath("M"+(c.x+_101.marker.shadow.dx)+" "+(c.y+_101.marker.shadow.dy)+" "+_101.symbol).setStroke(_101.marker.shadow).setFill(_101.marker.shadow.color);if(this.animate){this._animateScatter(_fd[i],dim.height-_f8.b);}}if(_101.marker.outline){var _103=dc.makeStroke(_101.marker.outline);_103.width=2*_103.width+_101.marker.stroke.width;_ff[i]=s.createPath(path).setStroke(_103);if(this.animate){this._animateScatter(_ff[i],dim.height-_f8.b);}}var _104=dc.makeStroke(_101.marker.stroke),fill=this._plotFill(_101.marker.fill,dim,_f8);if(fill&&(fill.type==="linear"||fill.type=="radial")){var _105=_f4.getColor(fill,{x:c.x,y:c.y});if(_104){_104.color=_105;}_fe[i]=s.createPath(path).setStroke(_104).setFill(_105);}else{_fe[i]=s.createPath(path).setStroke(_104).setFill(fill);}if(this.animate){this._animateScatter(_fe[i],dim.height-_f8.b);}},this);if(_fe.length){run.dyn.marker=_fb.symbol;run.dyn.markerStroke=_fe[_fe.length-1].getStroke();run.dyn.markerFill=_fe[_fe.length-1].getFill();}if(_fa){var _106=new Array(_fe.length);arr.forEach(_fe,function(s,i){var o={element:"marker",index:i,run:run,shape:s,outline:_ff&&_ff[i]||null,shadow:_fd&&_fd[i]||null,cx:_fc[i].x,cy:_fc[i].y};if(typeof run.data[0]=="number"){o.x=i+1;o.y=run.data[i];}else{o.x=run.data[i].x;o.y=run.data[i].y;}this._connectEvents(o);_106[i]=o;},this);this._eventSeries[run.name]=_106;}else{delete this._eventSeries[run.name];}run.dirty=false;}this.dirty=false;return this;},_animateScatter:function(_107,_108){fx.animateTransform(_f0.delegate({shape:_107,duration:1200,transform:[{name:"translate",start:[0,_108],end:[0,0]},{name:"scale",start:[0,0],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/color/_base":function(){define("dojox/color/_base",["../main","dojo/_base/lang","dojo/_base/Color","dojo/colors"],function(_109,lang,_10a,_10b){var cx=lang.getObject("color",true,_109);cx.Color=_10a;cx.blend=_10a.blendColors;cx.fromRgb=_10a.fromRgb;cx.fromHex=_10a.fromHex;cx.fromArray=_10a.fromArray;cx.fromString=_10a.fromString;cx.greyscale=_10b.makeGrey;lang.mixin(cx,{fromCmy:function(cyan,_10c,_10d){if(lang.isArray(cyan)){_10c=cyan[1],_10d=cyan[2],cyan=cyan[0];}else{if(lang.isObject(cyan)){_10c=cyan.m,_10d=cyan.y,cyan=cyan.c;}}cyan/=100,_10c/=100,_10d/=100;var r=1-cyan,g=1-_10c,b=1-_10d;return new _10a({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromCmyk:function(cyan,_10e,_10f,_110){if(lang.isArray(cyan)){_10e=cyan[1],_10f=cyan[2],_110=cyan[3],cyan=cyan[0];}else{if(lang.isObject(cyan)){_10e=cyan.m,_10f=cyan.y,_110=cyan.b,cyan=cyan.c;}}cyan/=100,_10e/=100,_10f/=100,_110/=100;var r,g,b;r=1-Math.min(1,cyan*(1-_110)+_110);g=1-Math.min(1,_10e*(1-_110)+_110);b=1-Math.min(1,_10f*(1-_110)+_110);return new _10a({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromHsl:function(hue,_111,_112){if(lang.isArray(hue)){_111=hue[1],_112=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_111=hue.s,_112=hue.l,hue=hue.h;}}_111/=100;_112/=100;while(hue<0){hue+=360;}while(hue>=360){hue-=360;}var r,g,b;if(hue<120){r=(120-hue)/60,g=hue/60,b=0;}else{if(hue<240){r=0,g=(240-hue)/60,b=(hue-120)/60;}else{r=(hue-240)/60,g=0,b=(360-hue)/60;}}r=2*_111*Math.min(r,1)+(1-_111);g=2*_111*Math.min(g,1)+(1-_111);b=2*_111*Math.min(b,1)+(1-_111);if(_112<0.5){r*=_112,g*=_112,b*=_112;}else{r=(1-_112)*r+2*_112-1;g=(1-_112)*g+2*_112-1;b=(1-_112)*b+2*_112-1;}return new _10a({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});}});cx.fromHsv=function(hue,_113,_114){if(lang.isArray(hue)){_113=hue[1],_114=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_113=hue.s,_114=hue.v,hue=hue.h;}}if(hue==360){hue=0;}_113/=100;_114/=100;var r,g,b;if(_113==0){r=_114,b=_114,g=_114;}else{var _115=hue/60,i=Math.floor(_115),f=_115-i;var p=_114*(1-_113);var q=_114*(1-(_113*f));var t=_114*(1-(_113*(1-f)));switch(i){case 0:r=_114,g=t,b=p;break;case 1:r=q,g=_114,b=p;break;case 2:r=p,g=_114,b=t;break;case 3:r=p,g=q,b=_114;break;case 4:r=t,g=p,b=_114;break;case 5:r=_114,g=p,b=q;break;}}return new _10a({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});};lang.extend(_10a,{toCmy:function(){var cyan=1-(this.r/255),_116=1-(this.g/255),_117=1-(this.b/255);return {c:Math.round(cyan*100),m:Math.round(_116*100),y:Math.round(_117*100)};},toCmyk:function(){var cyan,_118,_119,_11a;var r=this.r/255,g=this.g/255,b=this.b/255;_11a=Math.min(1-r,1-g,1-b);cyan=(1-r-_11a)/(1-_11a);_118=(1-g-_11a)/(1-_11a);_119=(1-b-_11a)/(1-_11a);return {c:Math.round(cyan*100),m:Math.round(_118*100),y:Math.round(_119*100),b:Math.round(_11a*100)};},toHsl:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _11b=max-min;var h=0,s=0,l=(min+max)/2;if(l>0&&l<1){s=_11b/((l<0.5)?(2*l):(2-2*l));}if(_11b>0){if(max==r&&max!=g){h+=(g-b)/_11b;}if(max==g&&max!=b){h+=(2+(b-r)/_11b);}if(max==b&&max!=r){h+=(4+(r-g)/_11b);}h*=60;}return {h:h,s:Math.round(s*100),l:Math.round(l*100)};},toHsv:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _11c=max-min;var h=null,s=(max==0)?0:(_11c/max);if(s==0){h=0;}else{if(r==max){h=60*(g-b)/_11c;}else{if(g==max){h=120+60*(b-r)/_11c;}else{h=240+60*(r-g)/_11c;}}if(h<0){h+=360;}}return {h:h,s:Math.round(s*100),v:Math.round(max*100)};}});return cx;});},"dojox/charting/plot2d/OHLC":function(){define("dojox/charting/plot2d/OHLC",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,arr,_11d,_11e,_11f,dc,df,dfr,du,fx){var _120=dfr.lambda("item.purgeGroup()");return _11d("dojox.charting.plot2d.OHLC",[_11e,_11f],{defaultParams:{hAxis:"x",vAxis:"y",gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_121,_122){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_122);du.updateWithPattern(this.opt,_122,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},collectStats:function(_123){var _124=lang.delegate(dc.defaultStats);for(var i=0;i<_123.length;i++){var run=_123[i];if(!run.data.length){continue;}var _125=_124.vmin,_126=_124.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;_124.hmin=Math.min(_124.hmin,x);_124.hmax=Math.max(_124.hmax,x);_124.vmin=Math.min(_124.vmin,val.open,val.close,val.high,val.low);_124.vmax=Math.max(_124.vmax,val.open,val.close,val.high,val.low);}});}if("ymin" in run){_124.vmin=Math.min(_125,run.ymin);}if("ymax" in run){_124.vmax=Math.max(_126,run.ymax);}}return _124;},getSeriesStats:function(){var _127=this.collectStats(this.series);_127.hmin-=0.5;_127.hmax+=0.5;return _127;},render:function(dim,_128){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_128);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_120);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_129,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_12a=Math.max(0,this._vScaler.bounds.lower),_12b=vt(_12a),_12c=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_129=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _12d=t.next("candlestick",[this.opt,run]),s=run.group,_12e=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var _12f=t.addMixin(_12d,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_128.l+gap,y=dim.height-_128.b,open=vt(v.open),_130=vt(v.close),high=vt(v.high),low=vt(v.low);if(low>high){var tmp=high;high=low;low=tmp;}if(_129>=1){var hl={x1:_129/2,x2:_129/2,y1:y-high,y2:y-low},op={x1:0,x2:((_129/2)+((_12f.series.stroke.width||1)/2)),y1:y-open,y2:y-open},cl={x1:((_129/2)-((_12f.series.stroke.width||1)/2)),x2:_129,y1:y-_130,y2:y-_130};var _131=s.createGroup();_131.setTransform({dx:x,dy:0});var _132=_131.createGroup();_132.createLine(hl).setStroke(_12f.series.stroke);_132.createLine(op).setStroke(_12f.series.stroke);_132.createLine(cl).setStroke(_12f.series.stroke);run.dyn.stroke=_12f.series.stroke;if(_12c){var o={element:"candlestick",index:j,run:run,shape:_132,x:x,y:y-Math.max(open,_130),cx:_129/2,cy:(y-Math.max(open,_130))+(Math.max(open>_130?open-_130:_130-open,1)/2),width:_129,height:Math.max(open>_130?open-_130:_130-open,1),data:v};this._connectEvents(o);_12e[j]=o;}}if(this.animate){this._animateOHLC(_131,y-low,high-low);}}}this._eventSeries[run.name]=_12e;run.dirty=false;}this.dirty=false;return this;},_animateOHLC:function(_133,_134,_135){fx.animateTransform(lang.delegate({shape:_133,duration:1200,transform:[{name:"translate",start:[0,_134-(_134/_135)],end:[0,0]},{name:"scale",start:[1,1/_135],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dijit/a11yclick":function(){define("dijit/a11yclick",["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","dojo/_base/unload","dojo/_base/window"],function(on,_136,keys,_137,has,_138,win){var _139=null;if(has("dom-addeventlistener")){win.doc.addEventListener("keydown",function(evt){_139=evt.target;},true);}else{(function(){var _13a=function(evt){_139=evt.srcElement;};win.doc.attachEvent("onkeydown",_13a);_138.addOnWindowUnload(function(){win.doc.detachEvent("onkeydown",_13a);});})();}function _13b(e){return (e.keyCode===keys.ENTER||e.keyCode===keys.SPACE)&&!e.ctrlKey&&!e.shiftKey&&!e.altKey&&!e.metaKey;};return function(node,_13c){if(/input|button/i.test(node.nodeName)){return on(node,"click",_13c);}else{var _13d=[on(node,"keydown",function(e){if(_13b(e)){_139=e.target;e.preventDefault();}}),on(node,"keyup",function(e){if(_13b(e)&&e.target==_139){_139=null;on.emit(e.target,"click",{cancelable:true,bubbles:true});}}),on(node,"click",function(e){_13c.call(this,e);})];if(has("touch")){var _13e;_13d.push(on(node,"touchend",function(e){var _13f=e.target;_13e=setTimeout(function(){_13e=null;on.emit(_13f,"click",{cancelable:true,bubbles:true});},600);}),on(node,"click",function(e){if(_13e){clearTimeout(_13e);}}));}return {remove:function(){_136.forEach(_13d,function(h){h.remove();});if(_13e){clearTimeout(_13e);_13e=null;}}};}};return ret;});},"dojox/charting/plot2d/ClusteredColumns":function(){define("dojox/charting/plot2d/ClusteredColumns",["dojo/_base/declare","./Columns","./common"],function(_140,_141,dc){return _140("dojox.charting.plot2d.ClusteredColumns",_141,{getBarProperties:function(){var f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt,this.series.length);return {gap:f.gap,width:f.size,thickness:f.size};}});});},"dojox/charting/Chart":function(){define("dojox/charting/Chart",["../main","dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/dom-style","dojo/dom","dojo/dom-geometry","dojo/dom-construct","dojo/_base/Color","dojo/_base/sniff","./Element","./SimpleTheme","./Series","./axis2d/common","dojox/gfx/shape","dojox/gfx","dojox/lang/functional","dojox/lang/functional/fold","dojox/lang/functional/reversed"],function(_142,lang,arr,_143,_144,dom,_145,_146,_147,has,_148,_149,_14a,_14b,_14c,g,func,_14d,_14e){var dc=lang.getObject("charting",true,_142),_14f=func.lambda("item.clear()"),_150=func.lambda("item.purgeGroup()"),_151=func.lambda("item.destroy()"),_152=func.lambda("item.dirty = false"),_153=func.lambda("item.dirty = true"),_154=func.lambda("item.name");var _155=_143("dojox.charting.Chart",null,{constructor:function(node,_156){if(!_156){_156={};}this.margins=_156.margins?_156.margins:{l:10,t:10,r:10,b:10};this.stroke=_156.stroke;this.fill=_156.fill;this.delayInMs=_156.delayInMs||200;this.title=_156.title;this.titleGap=_156.titleGap;this.titlePos=_156.titlePos;this.titleFont=_156.titleFont;this.titleFontColor=_156.titleFontColor;this.chartTitle=null;this.theme=null;this.axes={};this.stack=[];this.plots={};this.series=[];this.runs={};this.dirty=true;this.node=dom.byId(node);var box=_145.getMarginBox(node);this.surface=g.createSurface(this.node,box.w||400,box.h||300);if(this.surface.declaredClass.indexOf("vml")==-1){this.plotGroup=this.surface.createGroup();}},destroy:function(){arr.forEach(this.series,_151);arr.forEach(this.stack,_151);func.forIn(this.axes,_151);this.surface.destroy();if(this.chartTitle&&this.chartTitle.tagName){_146.destroy(this.chartTitle);}},getCoords:function(){var node=this.node;var s=_144.getComputedStyle(node),_157=_145.getMarginBox(node,s);var abs=_145.position(node,true);_157.x=abs.x;_157.y=abs.y;return _157;},setTheme:function(_158){this.theme=_158.clone();this.dirty=true;return this;},addAxis:function(name,_159){var axis,_15a=_159&&_159.type||"Default";if(typeof _15a=="string"){if(!dc.axis2d||!dc.axis2d[_15a]){throw Error("Can't find axis: "+_15a+" - Check "+"require() dependencies.");}axis=new dc.axis2d[_15a](this,_159);}else{axis=new _15a(this,_159);}axis.name=name;axis.dirty=true;if(name in this.axes){this.axes[name].destroy();}this.axes[name]=axis;this.dirty=true;return this;},getAxis:function(name){return this.axes[name];},removeAxis:function(name){if(name in this.axes){this.axes[name].destroy();delete this.axes[name];this.dirty=true;}return this;},addPlot:function(name,_15b){var plot,_15c=_15b&&_15b.type||"Default";if(typeof _15c=="string"){if(!dc.plot2d||!dc.plot2d[_15c]){throw Error("Can't find plot: "+_15c+" - didn't you forget to dojo"+".require() it?");}plot=new dc.plot2d[_15c](this,_15b);}else{plot=new _15c(this,_15b);}plot.name=name;plot.dirty=true;if(name in this.plots){this.stack[this.plots[name]].destroy();this.stack[this.plots[name]]=plot;}else{this.plots[name]=this.stack.length;this.stack.push(plot);}this.dirty=true;return this;},getPlot:function(name){return this.stack[this.plots[name]];},removePlot:function(name){if(name in this.plots){var _15d=this.plots[name];delete this.plots[name];this.stack[_15d].destroy();this.stack.splice(_15d,1);func.forIn(this.plots,function(idx,name,_15e){if(idx>_15d){_15e[name]=idx-1;}});var ns=arr.filter(this.series,function(run){return run.plot!=name;});if(ns.length<this.series.length){arr.forEach(this.series,function(run){if(run.plot==name){run.destroy();}});this.runs={};arr.forEach(ns,function(run,_15f){this.runs[run.plot]=_15f;},this);this.series=ns;}this.dirty=true;}return this;},getPlotOrder:function(){return func.map(this.stack,_154);},setPlotOrder:function(_160){var _161={},_162=func.filter(_160,function(name){if(!(name in this.plots)||(name in _161)){return false;}_161[name]=1;return true;},this);if(_162.length<this.stack.length){func.forEach(this.stack,function(plot){var name=plot.name;if(!(name in _161)){_162.push(name);}});}var _163=func.map(_162,function(name){return this.stack[this.plots[name]];},this);func.forEach(_163,function(plot,i){this.plots[plot.name]=i;},this);this.stack=_163;this.dirty=true;return this;},movePlotToFront:function(name){if(name in this.plots){var _164=this.plots[name];if(_164){var _165=this.getPlotOrder();_165.splice(_164,1);_165.unshift(name);return this.setPlotOrder(_165);}}return this;},movePlotToBack:function(name){if(name in this.plots){var _166=this.plots[name];if(_166<this.stack.length-1){var _167=this.getPlotOrder();_167.splice(_166,1);_167.push(name);return this.setPlotOrder(_167);}}return this;},addSeries:function(name,data,_168){var run=new _14a(this,data,_168);run.name=name;if(name in this.runs){this.series[this.runs[name]].destroy();this.series[this.runs[name]]=run;}else{this.runs[name]=this.series.length;this.series.push(run);}this.dirty=true;if(!("ymin" in run)&&"min" in run){run.ymin=run.min;}if(!("ymax" in run)&&"max" in run){run.ymax=run.max;}return this;},getSeries:function(name){return this.series[this.runs[name]];},removeSeries:function(name){if(name in this.runs){var _169=this.runs[name];delete this.runs[name];this.series[_169].destroy();this.series.splice(_169,1);func.forIn(this.runs,function(idx,name,runs){if(idx>_169){runs[name]=idx-1;}});this.dirty=true;}return this;},updateSeries:function(name,data,_16a){if(name in this.runs){var run=this.series[this.runs[name]];run.update(data);if(_16a){this.dirty=true;}else{this._invalidateDependentPlots(run.plot,false);this._invalidateDependentPlots(run.plot,true);}}return this;},getSeriesOrder:function(_16b){return func.map(func.filter(this.series,function(run){return run.plot==_16b;}),_154);},setSeriesOrder:function(_16c){var _16d,_16e={},_16f=func.filter(_16c,function(name){if(!(name in this.runs)||(name in _16e)){return false;}var run=this.series[this.runs[name]];if(_16d){if(run.plot!=_16d){return false;}}else{_16d=run.plot;}_16e[name]=1;return true;},this);func.forEach(this.series,function(run){var name=run.name;if(!(name in _16e)&&run.plot==_16d){_16f.push(name);}});var _170=func.map(_16f,function(name){return this.series[this.runs[name]];},this);this.series=_170.concat(func.filter(this.series,function(run){return run.plot!=_16d;}));func.forEach(this.series,function(run,i){this.runs[run.name]=i;},this);this.dirty=true;return this;},moveSeriesToFront:function(name){if(name in this.runs){var _171=this.runs[name],_172=this.getSeriesOrder(this.series[_171].plot);if(name!=_172[0]){_172.splice(_171,1);_172.unshift(name);return this.setSeriesOrder(_172);}}return this;},moveSeriesToBack:function(name){if(name in this.runs){var _173=this.runs[name],_174=this.getSeriesOrder(this.series[_173].plot);if(name!=_174[_174.length-1]){_174.splice(_173,1);_174.push(name);return this.setSeriesOrder(_174);}}return this;},resize:function(_175,_176){var box;switch(arguments.length){case 1:box=lang.mixin({},_175);_145.setMarginBox(this.node,box);break;case 2:box={w:_175,h:_176};_145.setMarginBox(this.node,box);break;}box=_145.getMarginBox(this.node);var d=this.surface.getDimensions();if(d.width!=box.w||d.height!=box.h){this.surface.setDimensions(box.w,box.h);this.dirty=true;return this.render();}else{return this;}},getGeometry:function(){var ret={};func.forIn(this.axes,function(axis){if(axis.initialized()){ret[axis.name]={name:axis.name,vertical:axis.vertical,scaler:axis.scaler,ticks:axis.ticks};}});return ret;},setAxisWindow:function(name,_177,_178,zoom){var axis=this.axes[name];if(axis){axis.setWindow(_177,_178);arr.forEach(this.stack,function(plot){if(plot.hAxis==name||plot.vAxis==name){plot.zoom=zoom;}});}return this;},setWindow:function(sx,sy,dx,dy,zoom){if(!("plotArea" in this)){this.calculateGeometry();}func.forIn(this.axes,function(axis){var _179,_17a,_17b=axis.getScaler().bounds,s=_17b.span/(_17b.upper-_17b.lower);if(axis.vertical){_179=sy;_17a=dy/s/_179;}else{_179=sx;_17a=dx/s/_179;}axis.setWindow(_179,_17a);});arr.forEach(this.stack,function(plot){plot.zoom=zoom;});return this;},zoomIn:function(name,_17c,_17d){var axis=this.axes[name];if(axis){var _17e,_17f,_180=axis.getScaler().bounds;var _181=Math.min(_17c[0],_17c[1]);var _182=Math.max(_17c[0],_17c[1]);_181=_17c[0]<_180.lower?_180.lower:_181;_182=_17c[1]>_180.upper?_180.upper:_182;_17e=(_180.upper-_180.lower)/(_182-_181);_17f=_181-_180.lower;this.setAxisWindow(name,_17e,_17f);if(_17d){this.delayedRender();}else{this.render();}}},calculateGeometry:function(){if(this.dirty){return this.fullGeometry();}var _183=arr.filter(this.stack,function(plot){return plot.dirty||(plot.hAxis&&this.axes[plot.hAxis].dirty)||(plot.vAxis&&this.axes[plot.vAxis].dirty);},this);_184(_183,this.plotArea);return this;},fullGeometry:function(){this._makeDirty();arr.forEach(this.stack,_14f);if(!this.theme){this.setTheme(new _149());}arr.forEach(this.series,function(run){if(!(run.plot in this.plots)){if(!dc.plot2d||!dc.plot2d.Default){throw Error("Can't find plot: Default - didn't you forget to dojo"+".require() it?");}var plot=new dc.plot2d.Default(this,{});plot.name=run.plot;this.plots[run.plot]=this.stack.length;this.stack.push(plot);}this.stack[this.plots[run.plot]].addSeries(run);},this);arr.forEach(this.stack,function(plot){if(plot.assignAxes){plot.assignAxes(this.axes);}},this);var dim=this.dim=this.surface.getDimensions();dim.width=g.normalizedLength(dim.width);dim.height=g.normalizedLength(dim.height);func.forIn(this.axes,_14f);_184(this.stack,dim);var _185=this.offsets={l:0,r:0,t:0,b:0};func.forIn(this.axes,function(axis){func.forIn(axis.getOffsets(),function(o,i){_185[i]=Math.max(o,_185[i]);});});if(this.title){this.titleGap=(this.titleGap==0)?0:this.titleGap||this.theme.chart.titleGap||20;this.titlePos=this.titlePos||this.theme.chart.titlePos||"top";this.titleFont=this.titleFont||this.theme.chart.titleFont;this.titleFontColor=this.titleFontColor||this.theme.chart.titleFontColor||"black";var _186=g.normalizedLength(g.splitFontString(this.titleFont).size);_185[this.titlePos=="top"?"t":"b"]+=(_186+this.titleGap);}func.forIn(this.margins,function(o,i){_185[i]+=o;});this.plotArea={width:dim.width-_185.l-_185.r,height:dim.height-_185.t-_185.b};func.forIn(this.axes,_14f);_184(this.stack,this.plotArea);return this;},render:function(){if(this._delayedRenderHandle){clearTimeout(this._delayedRenderHandle);this._delayedRenderHandle=null;}if(this.theme){this.theme.clear();}if(this.dirty){return this.fullRender();}this.calculateGeometry();func.forEachRev(this.stack,function(plot){plot.render(this.dim,this.offsets);},this);func.forIn(this.axes,function(axis){axis.render(this.dim,this.offsets);},this);this._makeClean();return this;},fullRender:function(){this.fullGeometry();var _187=this.offsets,dim=this.dim;var w=Math.max(0,dim.width-_187.l-_187.r),h=Math.max(0,dim.height-_187.t-_187.b);arr.forEach(this.series,_150);func.forIn(this.axes,_150);arr.forEach(this.stack,_150);var _188=this.surface.children;for(var i=0;i<_188.length;++i){_14c.dispose(_188[i]);}if(this.chartTitle&&this.chartTitle.tagName){_146.destroy(this.chartTitle);}if(this.plotGroup){this.plotGroup.clear();}this.surface.clear();this.chartTitle=null;if(this.plotGroup){this._renderChartBackground(dim,_187);this._renderPlotBackground(dim,_187,w,h);this.surface.add(this.plotGroup);this.plotGroup.setClip({x:_187.l,y:_187.t,width:w,height:h});}else{this._renderPlotBackground(dim,_187,w,h);}func.foldr(this.stack,function(z,plot){return plot.render(dim,_187),0;},0);if(!this.plotGroup){this._renderChartBackground(dim,_187);}if(this.title){var _189=(g.renderer=="canvas"),_18a=_189||!has("ie")&&!has("opera")?"html":"gfx",_18b=g.normalizedLength(g.splitFontString(this.titleFont).size);this.chartTitle=_14b.createText[_18a](this,this.surface,dim.width/2,this.titlePos=="top"?_18b+this.margins.t:dim.height-this.margins.b,"middle",this.title,this.titleFont,this.titleFontColor);}func.forIn(this.axes,function(axis){axis.render(dim,_187);});this._makeClean();return this;},_renderChartBackground:function(dim,_18c){var t=this.theme,rect;var fill=this.fill!==undefined?this.fill:(t.chart&&t.chart.fill);var _18d=this.stroke!==undefined?this.stroke:(t.chart&&t.chart.stroke);if(fill=="inherit"){var node=this.node;fill=new _147(_144.get(node,"backgroundColor"));while(fill.a==0&&node!=document.documentElement){fill=new _147(_144.get(node,"backgroundColor"));node=node.parentNode;}}if(fill){if(this.plotGroup){fill=_148.prototype._shapeFill(_148.prototype._plotFill(fill,dim),{x:0,y:0,width:dim.width+1,height:dim.height+1});this.surface.createRect({width:dim.width+1,height:dim.height+1}).setFill(fill);}else{fill=_148.prototype._plotFill(fill,dim,_18c);if(_18c.l){rect={x:0,y:0,width:_18c.l,height:dim.height+1};this.surface.createRect(rect).setFill(_148.prototype._shapeFill(fill,rect));}if(_18c.r){rect={x:dim.width-_18c.r,y:0,width:_18c.r+1,height:dim.height+2};this.surface.createRect(rect).setFill(_148.prototype._shapeFill(fill,rect));}if(_18c.t){rect={x:0,y:0,width:dim.width+1,height:_18c.t};this.surface.createRect(rect).setFill(_148.prototype._shapeFill(fill,rect));}if(_18c.b){rect={x:0,y:dim.height-_18c.b,width:dim.width+1,height:_18c.b+2};this.surface.createRect(rect).setFill(_148.prototype._shapeFill(fill,rect));}}}if(_18d){this.surface.createRect({width:dim.width-1,height:dim.height-1}).setStroke(_18d);}},_renderPlotBackground:function(dim,_18e,w,h){var t=this.theme;var fill=t.plotarea&&t.plotarea.fill;var _18f=t.plotarea&&t.plotarea.stroke;var rect={x:_18e.l-1,y:_18e.t-1,width:w+2,height:h+2};if(fill){fill=_148.prototype._shapeFill(_148.prototype._plotFill(fill,dim,_18e),rect);this.surface.createRect(rect).setFill(fill);}if(_18f){this.surface.createRect({x:_18e.l,y:_18e.t,width:w+1,height:h+1}).setStroke(_18f);}},delayedRender:function(){if(!this._delayedRenderHandle){this._delayedRenderHandle=setTimeout(lang.hitch(this,function(){this.render();}),this.delayInMs);}return this;},connectToPlot:function(name,_190,_191){return name in this.plots?this.stack[this.plots[name]].connect(_190,_191):null;},fireEvent:function(_192,_193,_194){if(_192 in this.runs){var _195=this.series[this.runs[_192]].plot;if(_195 in this.plots){var plot=this.stack[this.plots[_195]];if(plot){plot.fireEvent(_192,_193,_194);}}}return this;},_makeClean:function(){arr.forEach(this.axes,_152);arr.forEach(this.stack,_152);arr.forEach(this.series,_152);this.dirty=false;},_makeDirty:function(){arr.forEach(this.axes,_153);arr.forEach(this.stack,_153);arr.forEach(this.series,_153);this.dirty=true;},_invalidateDependentPlots:function(_196,_197){if(_196 in this.plots){var plot=this.stack[this.plots[_196]],axis,_198=_197?"vAxis":"hAxis";if(plot[_198]){axis=this.axes[plot[_198]];if(axis&&axis.dependOnData()){axis.dirty=true;arr.forEach(this.stack,function(p){if(p[_198]&&p[_198]==plot[_198]){p.dirty=true;}});}}else{plot.dirty=true;}}}});function _199(_19a){return {min:_19a.hmin,max:_19a.hmax};};function _19b(_19c){return {min:_19c.vmin,max:_19c.vmax};};function _19d(_19e,h){_19e.hmin=h.min;_19e.hmax=h.max;};function _19f(_1a0,v){_1a0.vmin=v.min;_1a0.vmax=v.max;};function _1a1(_1a2,_1a3){if(_1a2&&_1a3){_1a2.min=Math.min(_1a2.min,_1a3.min);_1a2.max=Math.max(_1a2.max,_1a3.max);}return _1a2||_1a3;};function _184(_1a4,_1a5){var _1a6={},axes={};arr.forEach(_1a4,function(plot){var _1a7=_1a6[plot.name]=plot.getSeriesStats();if(plot.hAxis){axes[plot.hAxis]=_1a1(axes[plot.hAxis],_199(_1a7));}if(plot.vAxis){axes[plot.vAxis]=_1a1(axes[plot.vAxis],_19b(_1a7));}});arr.forEach(_1a4,function(plot){var _1a8=_1a6[plot.name];if(plot.hAxis){_19d(_1a8,axes[plot.hAxis]);}if(plot.vAxis){_19f(_1a8,axes[plot.vAxis]);}plot.initializeScalers(_1a5,_1a8);});};return _155;});},"dojox/charting/plot2d/MarkersOnly":function(){define("dojox/charting/plot2d/MarkersOnly",["dojo/_base/declare","./Default"],function(_1a9,_1aa){return _1a9("dojox.charting.plot2d.MarkersOnly",_1aa,{constructor:function(){this.opt.lines=false;this.opt.markers=true;}});});},"dojox/charting/plot2d/Areas":function(){define("dojox/charting/plot2d/Areas",["dojo/_base/declare","./Default"],function(_1ab,_1ac){return _1ab("dojox.charting.plot2d.Areas",_1ac,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});});},"dojox/charting/action2d/Base":function(){define("dojox/charting/action2d/Base",["dojo/_base/lang","dojo/_base/declare"],function(lang,_1ad){return _1ad("dojox.charting.action2d.Base",null,{constructor:function(_1ae,plot){this.chart=_1ae;this.plot=plot?(lang.isString(plot)?this.chart.getPlot(plot):plot):this.chart.getPlot("default");},connect:function(){},disconnect:function(){},destroy:function(){this.disconnect();}});});},"dojo/fx":function(){define(["./_base/lang","./Evented","./_base/kernel","./_base/array","./_base/connect","./_base/fx","./dom","./dom-style","./dom-geometry","./ready","require"],function(lang,_1af,dojo,_1b0,_1b1,_1b2,dom,_1b3,geom,_1b4,_1b5){if(!dojo.isAsync){_1b4(0,function(){var _1b6=["./fx/Toggler"];_1b5(_1b6);});}var _1b7=dojo.fx={};var _1b8={_fire:function(evt,args){if(this[evt]){this[evt].apply(this,args||[]);}return this;}};var _1b9=function(_1ba){this._index=-1;this._animations=_1ba||[];this._current=this._onAnimateCtx=this._onEndCtx=null;this.duration=0;_1b0.forEach(this._animations,function(a){this.duration+=a.duration;if(a.delay){this.duration+=a.delay;}},this);};_1b9.prototype=new _1af();lang.extend(_1b9,{_onAnimate:function(){this._fire("onAnimate",arguments);},_onEnd:function(){_1b1.disconnect(this._onAnimateCtx);_1b1.disconnect(this._onEndCtx);this._onAnimateCtx=this._onEndCtx=null;if(this._index+1==this._animations.length){this._fire("onEnd");}else{this._current=this._animations[++this._index];this._onAnimateCtx=_1b1.connect(this._current,"onAnimate",this,"_onAnimate");this._onEndCtx=_1b1.connect(this._current,"onEnd",this,"_onEnd");this._current.play(0,true);}},play:function(_1bb,_1bc){if(!this._current){this._current=this._animations[this._index=0];}if(!_1bc&&this._current.status()=="playing"){return this;}var _1bd=_1b1.connect(this._current,"beforeBegin",this,function(){this._fire("beforeBegin");}),_1be=_1b1.connect(this._current,"onBegin",this,function(arg){this._fire("onBegin",arguments);}),_1bf=_1b1.connect(this._current,"onPlay",this,function(arg){this._fire("onPlay",arguments);_1b1.disconnect(_1bd);_1b1.disconnect(_1be);_1b1.disconnect(_1bf);});if(this._onAnimateCtx){_1b1.disconnect(this._onAnimateCtx);}this._onAnimateCtx=_1b1.connect(this._current,"onAnimate",this,"_onAnimate");if(this._onEndCtx){_1b1.disconnect(this._onEndCtx);}this._onEndCtx=_1b1.connect(this._current,"onEnd",this,"_onEnd");this._current.play.apply(this._current,arguments);return this;},pause:function(){if(this._current){var e=_1b1.connect(this._current,"onPause",this,function(arg){this._fire("onPause",arguments);_1b1.disconnect(e);});this._current.pause();}return this;},gotoPercent:function(_1c0,_1c1){this.pause();var _1c2=this.duration*_1c0;this._current=null;_1b0.some(this._animations,function(a){if(a.duration<=_1c2){this._current=a;return true;}_1c2-=a.duration;return false;});if(this._current){this._current.gotoPercent(_1c2/this._current.duration,_1c1);}return this;},stop:function(_1c3){if(this._current){if(_1c3){for(;this._index+1<this._animations.length;++this._index){this._animations[this._index].stop(true);}this._current=this._animations[this._index];}var e=_1b1.connect(this._current,"onStop",this,function(arg){this._fire("onStop",arguments);_1b1.disconnect(e);});this._current.stop();}return this;},status:function(){return this._current?this._current.status():"stopped";},destroy:function(){if(this._onAnimateCtx){_1b1.disconnect(this._onAnimateCtx);}if(this._onEndCtx){_1b1.disconnect(this._onEndCtx);}}});lang.extend(_1b9,_1b8);_1b7.chain=function(_1c4){return new _1b9(_1c4);};var _1c5=function(_1c6){this._animations=_1c6||[];this._connects=[];this._finished=0;this.duration=0;_1b0.forEach(_1c6,function(a){var _1c7=a.duration;if(a.delay){_1c7+=a.delay;}if(this.duration<_1c7){this.duration=_1c7;}this._connects.push(_1b1.connect(a,"onEnd",this,"_onEnd"));},this);this._pseudoAnimation=new _1b2.Animation({curve:[0,1],duration:this.duration});var self=this;_1b0.forEach(["beforeBegin","onBegin","onPlay","onAnimate","onPause","onStop","onEnd"],function(evt){self._connects.push(_1b1.connect(self._pseudoAnimation,evt,function(){self._fire(evt,arguments);}));});};lang.extend(_1c5,{_doAction:function(_1c8,args){_1b0.forEach(this._animations,function(a){a[_1c8].apply(a,args);});return this;},_onEnd:function(){if(++this._finished>this._animations.length){this._fire("onEnd");}},_call:function(_1c9,args){var t=this._pseudoAnimation;t[_1c9].apply(t,args);},play:function(_1ca,_1cb){this._finished=0;this._doAction("play",arguments);this._call("play",arguments);return this;},pause:function(){this._doAction("pause",arguments);this._call("pause",arguments);return this;},gotoPercent:function(_1cc,_1cd){var ms=this.duration*_1cc;_1b0.forEach(this._animations,function(a){a.gotoPercent(a.duration<ms?1:(ms/a.duration),_1cd);});this._call("gotoPercent",arguments);return this;},stop:function(_1ce){this._doAction("stop",arguments);this._call("stop",arguments);return this;},status:function(){return this._pseudoAnimation.status();},destroy:function(){_1b0.forEach(this._connects,_1b1.disconnect);}});lang.extend(_1c5,_1b8);_1b7.combine=function(_1cf){return new _1c5(_1cf);};_1b7.wipeIn=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_1b2.animateProperty(lang.mixin({properties:{height:{start:function(){o=s.overflow;s.overflow="hidden";if(s.visibility=="hidden"||s.display=="none"){s.height="1px";s.display="";s.visibility="";return 1;}else{var _1d0=_1b3.get(node,"height");return Math.max(_1d0,1);}},end:function(){return node.scrollHeight;}}}},args));var fini=function(){s.height="auto";s.overflow=o;};_1b1.connect(anim,"onStop",fini);_1b1.connect(anim,"onEnd",fini);return anim;};_1b7.wipeOut=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_1b2.animateProperty(lang.mixin({properties:{height:{end:1}}},args));_1b1.connect(anim,"beforeBegin",function(){o=s.overflow;s.overflow="hidden";s.display="";});var fini=function(){s.overflow=o;s.height="auto";s.display="none";};_1b1.connect(anim,"onStop",fini);_1b1.connect(anim,"onEnd",fini);return anim;};_1b7.slideTo=function(args){var node=args.node=dom.byId(args.node),top=null,left=null;var init=(function(n){return function(){var cs=_1b3.getComputedStyle(n);var pos=cs.position;top=(pos=="absolute"?n.offsetTop:parseInt(cs.top)||0);left=(pos=="absolute"?n.offsetLeft:parseInt(cs.left)||0);if(pos!="absolute"&&pos!="relative"){var ret=geom.position(n,true);top=ret.y;left=ret.x;n.style.position="absolute";n.style.top=top+"px";n.style.left=left+"px";}};})(node);init();var anim=_1b2.animateProperty(lang.mixin({properties:{top:args.top||0,left:args.left||0}},args));_1b1.connect(anim,"beforeBegin",anim,init);return anim;};return _1b7;});},"dojox/charting/action2d/PlotAction":function(){define("dojox/charting/action2d/PlotAction",["dojo/_base/connect","dojo/_base/declare","./Base","dojo/fx/easing","dojox/lang/functional","dojox/lang/functional/object"],function(hub,_1d1,Base,dfe,df,dlfo){var _1d2=400,_1d3=dfe.backOut;return _1d1("dojox.charting.action2d.PlotAction",Base,{overOutEvents:{onmouseover:1,onmouseout:1},constructor:function(_1d4,plot,_1d5){this.anim={};if(!_1d5){_1d5={};}this.duration=_1d5.duration?_1d5.duration:_1d2;this.easing=_1d5.easing?_1d5.easing:_1d3;},connect:function(){this.handle=this.chart.connectToPlot(this.plot.name,this,"process");},disconnect:function(){if(this.handle){hub.disconnect(this.handle);this.handle=null;}},reset:function(){},destroy:function(){this.inherited(arguments);df.forIn(this.anim,function(o){df.forIn(o,function(anim){anim.action.stop(true);});});this.anim={};}});});},"dojox/charting/plot2d/commonStacked":function(){define("dojox/charting/plot2d/commonStacked",["dojo/_base/lang","./common"],function(lang,_1d6){var _1d7=lang.getObject("dojox.charting.plot2d.commonStacked",true);return lang.mixin(_1d7,{collectStats:function(_1d8){var _1d9=lang.delegate(_1d6.defaultStats);for(var i=0;i<_1d8.length;++i){var run=_1d8[i];for(var j=0;j<run.data.length;j++){var x,y;if(run.data[j]!==null){if(typeof run.data[j]=="number"||!run.data[j].hasOwnProperty("x")){y=_1d7.getIndexValue(_1d8,i,j);x=j+1;}else{x=run.data[j].x;if(x!==null){y=_1d7.getValue(_1d8,i,x);y=y!=null&&y.y?y.y:null;}}_1d9.hmin=Math.min(_1d9.hmin,x);_1d9.hmax=Math.max(_1d9.hmax,x);_1d9.vmin=Math.min(_1d9.vmin,y);_1d9.vmax=Math.max(_1d9.vmax,y);}}}return _1d9;},getIndexValue:function(_1da,i,_1db){var _1dc=0,v,j;for(j=0;j<=i;++j){v=_1da[j].data[_1db];if(v!=null){if(isNaN(v)){v=v.y||0;}_1dc+=v;}}return _1dc;},getValue:function(_1dd,i,x){var _1de=null,j,z;for(j=0;j<=i;++j){for(z=0;z<_1dd[j].data.length;z++){v=_1dd[j].data[z];if(v!==null){if(v.x==x){if(!_1de){_1de={x:x};}if(v.y!=null){if(_1de.y==null){_1de.y=0;}_1de.y+=v.y;}break;}else{if(v.x>x){break;}}}}}return _1de;}});});},"dojox/gfx/fx":function(){define("dojox/gfx/fx",["dojo/_base/lang","./_base","./matrix","dojo/_base/Color","dojo/_base/array","dojo/_base/fx","dojo/_base/connect"],function(lang,g,m,_1df,arr,fx,Hub){var fxg=g.fx={};function _1e0(_1e1,end){this.start=_1e1,this.end=end;};_1e0.prototype.getValue=function(r){return (this.end-this.start)*r+this.start;};function _1e2(_1e3,end,_1e4){this.start=_1e3,this.end=end;this.units=_1e4;};_1e2.prototype.getValue=function(r){return (this.end-this.start)*r+this.start+this.units;};function _1e5(_1e6,end){this.start=_1e6,this.end=end;this.temp=new _1df();};_1e5.prototype.getValue=function(r){return _1df.blendColors(this.start,this.end,r,this.temp);};function _1e7(_1e8){this.values=_1e8;this.length=_1e8.length;};_1e7.prototype.getValue=function(r){return this.values[Math.min(Math.floor(r*this.length),this.length-1)];};function _1e9(_1ea,def){this.values=_1ea;this.def=def?def:{};};_1e9.prototype.getValue=function(r){var ret=lang.clone(this.def);for(var i in this.values){ret[i]=this.values[i].getValue(r);}return ret;};function _1eb(_1ec,_1ed){this.stack=_1ec;this.original=_1ed;};_1eb.prototype.getValue=function(r){var ret=[];arr.forEach(this.stack,function(t){if(t instanceof m.Matrix2D){ret.push(t);return;}if(t.name=="original"&&this.original){ret.push(this.original);return;}if(t.name=="matrix"){if((t.start instanceof m.Matrix2D)&&(t.end instanceof m.Matrix2D)){var _1ee=new m.Matrix2D();for(var p in t.start){_1ee[p]=(t.end[p]-t.start[p])*r+t.start[p];}ret.push(_1ee);}return;}if(!(t.name in m)){return;}var f=m[t.name];if(typeof f!="function"){ret.push(f);return;}var val=arr.map(t.start,function(v,i){return (t.end[i]-v)*r+v;}),_1ef=f.apply(m,val);if(_1ef instanceof m.Matrix2D){ret.push(_1ef);}},this);return ret;};var _1f0=new _1df(0,0,0,0);function _1f1(prop,obj,name,def){if(prop.values){return new _1e7(prop.values);}var _1f2,_1f3,end;if(prop.start){_1f3=g.normalizeColor(prop.start);}else{_1f3=_1f2=obj?(name?obj[name]:obj):def;}if(prop.end){end=g.normalizeColor(prop.end);}else{if(!_1f2){_1f2=obj?(name?obj[name]:obj):def;}end=_1f2;}return new _1e5(_1f3,end);};function _1f4(prop,obj,name,def){if(prop.values){return new _1e7(prop.values);}var _1f5,_1f6,end;if(prop.start){_1f6=prop.start;}else{_1f6=_1f5=obj?obj[name]:def;}if(prop.end){end=prop.end;}else{if(typeof _1f5!="number"){_1f5=obj?obj[name]:def;}end=_1f5;}return new _1e0(_1f6,end);};fxg.animateStroke=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_1f7=args.shape,_1f8;Hub.connect(anim,"beforeBegin",anim,function(){_1f8=_1f7.getStroke();var prop=args.color,_1f9={},_1fa,_1fb,end;if(prop){_1f9.color=_1f1(prop,_1f8,"color",_1f0);}prop=args.style;if(prop&&prop.values){_1f9.style=new _1e7(prop.values);}prop=args.width;if(prop){_1f9.width=_1f4(prop,_1f8,"width",1);}prop=args.cap;if(prop&&prop.values){_1f9.cap=new _1e7(prop.values);}prop=args.join;if(prop){if(prop.values){_1f9.join=new _1e7(prop.values);}else{_1fb=prop.start?prop.start:(_1f8&&_1f8.join||0);end=prop.end?prop.end:(_1f8&&_1f8.join||0);if(typeof _1fb=="number"&&typeof end=="number"){_1f9.join=new _1e0(_1fb,end);}}}this.curve=new _1e9(_1f9,_1f8);});Hub.connect(anim,"onAnimate",_1f7,"setStroke");return anim;};fxg.animateFill=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_1fc=args.shape,fill;Hub.connect(anim,"beforeBegin",anim,function(){fill=_1fc.getFill();var prop=args.color,_1fd={};if(prop){this.curve=_1f1(prop,fill,"",_1f0);}});Hub.connect(anim,"onAnimate",_1fc,"setFill");return anim;};fxg.animateFont=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_1fe=args.shape,font;Hub.connect(anim,"beforeBegin",anim,function(){font=_1fe.getFont();var prop=args.style,_1ff={},_200,_201,end;if(prop&&prop.values){_1ff.style=new _1e7(prop.values);}prop=args.variant;if(prop&&prop.values){_1ff.variant=new _1e7(prop.values);}prop=args.weight;if(prop&&prop.values){_1ff.weight=new _1e7(prop.values);}prop=args.family;if(prop&&prop.values){_1ff.family=new _1e7(prop.values);}prop=args.size;if(prop&&prop.units){_201=parseFloat(prop.start?prop.start:(_1fe.font&&_1fe.font.size||"0"));end=parseFloat(prop.end?prop.end:(_1fe.font&&_1fe.font.size||"0"));_1ff.size=new _1e2(_201,end,prop.units);}this.curve=new _1e9(_1ff,font);});Hub.connect(anim,"onAnimate",_1fe,"setFont");return anim;};fxg.animateTransform=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_202=args.shape,_203;Hub.connect(anim,"beforeBegin",anim,function(){_203=_202.getTransform();this.curve=new _1eb(args.transform,_203);});Hub.connect(anim,"onAnimate",_202,"setTransform");return anim;};return fxg;});},"dijit/BackgroundIframe":function(){define("dijit/BackgroundIframe",["require","./main","dojo/_base/config","dojo/dom-construct","dojo/dom-style","dojo/_base/lang","dojo/on","dojo/sniff","dojo/_base/window"],function(_204,_205,_206,_207,_208,lang,on,has,win){var _209=new function(){var _20a=[];this.pop=function(){var _20b;if(_20a.length){_20b=_20a.pop();_20b.style.display="";}else{if(has("ie")<9){var burl=_206["dojoBlankHtmlUrl"]||_204.toUrl("dojo/resources/blank.html")||"javascript:\"\"";var html="<iframe src='"+burl+"' role='presentation'"+" style='position: absolute; left: 0px; top: 0px;"+"z-index: -1; filter:Alpha(Opacity=\"0\");'>";_20b=win.doc.createElement(html);}else{_20b=_207.create("iframe");_20b.src="javascript:\"\"";_20b.className="dijitBackgroundIframe";_20b.setAttribute("role","presentation");_208.set(_20b,"opacity",0.1);}_20b.tabIndex=-1;}return _20b;};this.push=function(_20c){_20c.style.display="none";_20a.push(_20c);};}();_205.BackgroundIframe=function(node){if(!node.id){throw new Error("no id");}if(has("ie")||has("mozilla")){var _20d=(this.iframe=_209.pop());node.appendChild(_20d);if(has("ie")<7||has("quirks")){this.resize(node);this._conn=on(node,"resize",lang.hitch(this,function(){this.resize(node);}));}else{_208.set(_20d,{width:"100%",height:"100%"});}}};lang.extend(_205.BackgroundIframe,{resize:function(node){if(this.iframe){_208.set(this.iframe,{width:node.offsetWidth+"px",height:node.offsetHeight+"px"});}},destroy:function(){if(this._conn){this._conn.remove();this._conn=null;}if(this.iframe){_209.push(this.iframe);delete this.iframe;}}});return _205.BackgroundIframe;});},"dojox/main":function(){define("dojox/main",["dojo/_base/kernel"],function(dojo){return dojo.dojox;});},"dojox/charting/action2d/Magnify":function(){define("dojox/charting/action2d/Magnify",["dojo/_base/connect","dojo/_base/declare","./PlotAction","dojox/gfx/matrix","dojox/gfx/fx","dojo/fx","dojo/fx/easing"],function(Hub,_20e,_20f,m,gf,df,dfe){var _210=2;return _20e("dojox.charting.action2d.Magnify",_20f,{defaultParams:{duration:400,easing:dfe.backOut,scale:_210},optionalParams:{},constructor:function(_211,plot,_212){this.scale=_212&&typeof _212.scale=="number"?_212.scale:_210;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)||!("cx" in o)||!("cy" in o)){return;}var _213=o.run.name,_214=o.index,_215=[],anim,init,_216;if(_213 in this.anim){anim=this.anim[_213][_214];}else{this.anim[_213]={};}if(anim){anim.action.stop(true);}else{this.anim[_213][_214]=anim={};}if(o.type=="onmouseover"){init=m.identity;_216=this.scale;}else{init=m.scaleAt(this.scale,o.cx,o.cy);_216=1/this.scale;}var _217={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"scaleAt",start:[1,o.cx,o.cy],end:[_216,o.cx,o.cy]},init]};if(o.shape){_215.push(gf.animateTransform(_217));}if(o.outline){_217.shape=o.outline;_215.push(gf.animateTransform(_217));}if(o.shadow){_217.shape=o.shadow;_215.push(gf.animateTransform(_217));}if(!_215.length){delete this.anim[_213][_214];return;}anim.action=df.combine(_215);if(o.type=="onmouseout"){Hub.connect(anim.action,"onEnd",this,function(){if(this.anim[_213]){delete this.anim[_213][_214];}});}anim.action.play();}});});},"dojo/Stateful":function(){define(["./_base/declare","./_base/lang","./_base/array","dojo/when"],function(_218,lang,_219,when){return _218("dojo.Stateful",null,{_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}return (apn[name]={s:"_"+name+"Setter",g:"_"+name+"Getter"});},postscript:function(_21a){if(_21a){this.set(_21a);}},_get:function(name,_21b){return typeof this[_21b.g]==="function"?this[_21b.g]():this[name];},get:function(name){return this._get(name,this._getAttrNames(name));},set:function(name,_21c){if(typeof name==="object"){for(var x in name){if(name.hasOwnProperty(x)&&x!="_watchCallbacks"){this.set(x,name[x]);}}return this;}var _21d=this._getAttrNames(name),_21e=this._get(name,_21d),_21f=this[_21d.s],_220;if(typeof _21f==="function"){_220=_21f.apply(this,Array.prototype.slice.call(arguments,1));}else{this[name]=_21c;}if(this._watchCallbacks){var self=this;when(_220,function(){self._watchCallbacks(name,_21e,_21c);});}return this;},_changeAttrValue:function(name,_221){var _222=this.get(name);this[name]=_221;if(this._watchCallbacks){this._watchCallbacks(name,_222,_221);}return this;},watch:function(name,_223){var _224=this._watchCallbacks;if(!_224){var self=this;_224=this._watchCallbacks=function(name,_225,_226,_227){var _228=function(_229){if(_229){_229=_229.slice();for(var i=0,l=_229.length;i<l;i++){_229[i].call(self,name,_225,_226);}}};_228(_224["_"+name]);if(!_227){_228(_224["*"]);}};}if(!_223&&typeof name==="function"){_223=name;name="*";}else{name="_"+name;}var _22a=_224[name];if(typeof _22a!=="object"){_22a=_224[name]=[];}_22a.push(_223);var _22b={};_22b.unwatch=_22b.remove=function(){var _22c=_219.indexOf(_22a,_223);if(_22c>-1){_22a.splice(_22c,1);}};return _22b;}});});},"dojox/charting/plot2d/Markers":function(){define("dojox/charting/plot2d/Markers",["dojo/_base/declare","./Default"],function(_22d,_22e){return _22d("dojox.charting.plot2d.Markers",_22e,{constructor:function(){this.opt.markers=true;}});});},"dojox/charting/plot2d/Bubble":function(){define("dojox/charting/plot2d/Bubble",["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,_22f,arr,_230,_231,dc,df,dfr,du,fx){var _232=dfr.lambda("item.purgeGroup()");return _22f("dojox.charting.plot2d.Bubble",[_230,_231],{defaultParams:{hAxis:"x",vAxis:"y",animate:null},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},styleFunc:null,font:"",fontColor:""},constructor:function(_233,_234){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_234);du.updateWithPattern(this.opt,_234,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},render:function(dim,_235){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_235);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_232);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_236=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}if(typeof run.data[0]=="number"){console.warn("dojox.charting.plot2d.Bubble: the data in the following series cannot be rendered as a bubble chart; ",run);continue;}var _237=t.next("circle",[this.opt,run]),s=run.group,_238=arr.map(run.data,function(v,i){return v?{x:ht(v.x)+_235.l,y:dim.height-_235.b-vt(v.y),radius:this._vScaler.bounds.scale*(v.size/2)}:null;},this);var _239=null,_23a=null,_23b=null,_23c=this.opt.styleFunc;var _23d=function(item){if(_23c){return t.addMixin(_237,"circle",[item,_23c(item)],true);}return t.addMixin(_237,"circle",item,true);};if(_237.series.shadow){_23b=arr.map(_238,function(item,i){if(item!==null){var _23e=_23d(run.data[i]),_23f=_23e.series.shadow;var _240=s.createCircle({cx:item.x+_23f.dx,cy:item.y+_23f.dy,r:item.radius}).setStroke(_23f).setFill(_23f.color);if(this.animate){this._animateBubble(_240,dim.height-_235.b,item.radius);}return _240;}return null;},this);if(_23b.length){run.dyn.shadow=_23b[_23b.length-1].getStroke();}}if(_237.series.outline){_23a=arr.map(_238,function(item,i){if(item!==null){var _241=_23d(run.data[i]),_242=dc.makeStroke(_241.series.outline);_242.width=2*_242.width+_237.series.stroke.width;var _243=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setStroke(_242);if(this.animate){this._animateBubble(_243,dim.height-_235.b,item.radius);}return _243;}return null;},this);if(_23a.length){run.dyn.outline=_23a[_23a.length-1].getStroke();}}_239=arr.map(_238,function(item,i){if(item!==null){var _244=_23d(run.data[i]),rect={x:item.x-item.radius,y:item.y-item.radius,width:2*item.radius,height:2*item.radius};var _245=this._plotFill(_244.series.fill,dim,_235);_245=this._shapeFill(_245,rect);var _246=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setFill(_245).setStroke(_244.series.stroke);if(this.animate){this._animateBubble(_246,dim.height-_235.b,item.radius);}return _246;}return null;},this);if(_239.length){run.dyn.fill=_239[_239.length-1].getFill();run.dyn.stroke=_239[_239.length-1].getStroke();}if(_236){var _247=new Array(_239.length);arr.forEach(_239,function(s,i){if(s!==null){var o={element:"circle",index:i,run:run,shape:s,outline:_23a&&_23a[i]||null,shadow:_23b&&_23b[i]||null,x:run.data[i].x,y:run.data[i].y,r:run.data[i].size/2,cx:_238[i].x,cy:_238[i].y,cr:_238[i].radius};this._connectEvents(o);_247[i]=o;}},this);this._eventSeries[run.name]=_247;}else{delete this._eventSeries[run.name];}run.dirty=false;}this.dirty=false;return this;},_animateBubble:function(_248,_249,size){fx.animateTransform(lang.delegate({shape:_248,duration:1200,transform:[{name:"translate",start:[0,_249],end:[0,0]},{name:"scale",start:[0,1/size],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojo/touch":function(){define(["./_base/kernel","./aspect","./dom","./on","./has","./mouse","./ready","./_base/window"],function(dojo,_24a,dom,on,has,_24b,_24c,win){var _24d=has("touch");var ios4=false;if(has("ios")){var ua=navigator.userAgent;var v=ua.match(/OS ([\d_]+)/)?RegExp.$1:"1";var os=parseFloat(v.replace(/_/,".").replace(/_/g,""));ios4=os<5;}var _24e,_24f;if(_24d){_24c(function(){_24f=win.body();win.doc.addEventListener("touchstart",function(evt){var _250=_24f;_24f=evt.target;on.emit(_250,"dojotouchout",{target:_250,relatedTarget:_24f,bubbles:true});on.emit(_24f,"dojotouchover",{target:_24f,relatedTarget:_250,bubbles:true});},true);on(win.doc,"touchmove",function(evt){var _251=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset));if(_251&&_24f!==_251){on.emit(_24f,"dojotouchout",{target:_24f,relatedTarget:_251,bubbles:true});on.emit(_251,"dojotouchover",{target:_251,relatedTarget:_24f,bubbles:true});_24f=_251;}});});_24e=function(node,_252){return on(win.doc,"touchmove",function(evt){if(node===win.doc||dom.isDescendant(_24f,node)){evt.target=_24f;_252.call(this,evt);}});};}function _253(type){return function(node,_254){return on(node,type,_254);};};var _255={press:_253(_24d?"touchstart":"mousedown"),move:_24d?_24e:_253("mousemove"),release:_253(_24d?"touchend":"mouseup"),cancel:_24d?_253("touchcancel"):_24b.leave,over:_253(_24d?"dojotouchover":"mouseover"),out:_253(_24d?"dojotouchout":"mouseout"),enter:_24b._eventHandler(_24d?"dojotouchover":"mouseover"),leave:_24b._eventHandler(_24d?"dojotouchout":"mouseout")};1&&(dojo.touch=_255);return _255;});},"dojox/gfx/gradutils":function(){define("dojox/gfx/gradutils",["./_base","dojo/_base/lang","./matrix","dojo/_base/Color"],function(g,lang,m,_256){var _257=g.gradutils={};function _258(o,c){if(o<=0){return c[0].color;}var len=c.length;if(o>=1){return c[len-1].color;}for(var i=0;i<len;++i){var stop=c[i];if(stop.offset>=o){if(i){var prev=c[i-1];return _256.blendColors(new _256(prev.color),new _256(stop.color),(o-prev.offset)/(stop.offset-prev.offset));}return stop.color;}}return c[len-1].color;};_257.getColor=function(fill,pt){var o;if(fill){switch(fill.type){case "linear":var _259=Math.atan2(fill.y2-fill.y1,fill.x2-fill.x1),_25a=m.rotate(-_259),_25b=m.project(fill.x2-fill.x1,fill.y2-fill.y1),p=m.multiplyPoint(_25b,pt),pf1=m.multiplyPoint(_25b,fill.x1,fill.y1),pf2=m.multiplyPoint(_25b,fill.x2,fill.y2),_25c=m.multiplyPoint(_25a,pf2.x-pf1.x,pf2.y-pf1.y).x;o=m.multiplyPoint(_25a,p.x-pf1.x,p.y-pf1.y).x/_25c;break;case "radial":var dx=pt.x-fill.cx,dy=pt.y-fill.cy;o=Math.sqrt(dx*dx+dy*dy)/fill.r;break;}return _258(o,fill.colors);}return new _256(fill||[0,0,0,0]);};_257.reverse=function(fill){if(fill){switch(fill.type){case "linear":case "radial":fill=lang.delegate(fill);if(fill.colors){var c=fill.colors,l=c.length,i=0,stop,n=fill.colors=new Array(c.length);for(;i<l;++i){stop=c[i];n[i]={offset:1-stop.offset,color:stop.color};}n.sort(function(a,b){return a.offset-b.offset;});}break;}}return fill;};return _257;});},"dojo/hccss":function(){define(["require","./_base/config","./dom-class","./dom-style","./has","./ready","./_base/window"],function(_25d,_25e,_25f,_260,has,_261,win){has.add("highcontrast",function(){var div=win.doc.createElement("div");div.style.cssText="border: 1px solid; border-color:red green; position: absolute; height: 5px; top: -999px;"+"background-image: url("+(_25e.blankGif||_25d.toUrl("./resources/blank.gif"))+");";win.body().appendChild(div);var cs=_260.getComputedStyle(div),_262=cs.backgroundImage,hc=(cs.borderTopColor==cs.borderRightColor)||(_262&&(_262=="none"||_262=="url(invalid-url:)"));if(has("ie")<=8){div.outerHTML="";}else{win.body().removeChild(div);}return hc;});_261(90,function(){if(has("highcontrast")){_25f.add(win.body(),"dj_a11y");}});return has;});},"dojo/string":function(){define(["./_base/kernel","./_base/lang"],function(_263,lang){var _264={};lang.setObject("dojo.string",_264);_264.rep=function(str,num){if(num<=0||!str){return "";}var buf=[];for(;;){if(num&1){buf.push(str);}if(!(num>>=1)){break;}str+=str;}return buf.join("");};_264.pad=function(text,size,ch,end){if(!ch){ch="0";}var out=String(text),pad=_264.rep(ch,Math.ceil((size-out.length)/ch.length));return end?out+pad:pad+out;};_264.substitute=function(_265,map,_266,_267){_267=_267||_263.global;_266=_266?lang.hitch(_267,_266):function(v){return v;};return _265.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g,function(_268,key,_269){var _26a=lang.getObject(key,false,map);if(_269){_26a=lang.getObject(_269,false,_267).call(_267,_26a,key);}return _266(_26a,key).toString();});};_264.trim=String.prototype.trim?lang.trim:function(str){str=str.replace(/^\s+/,"");for(var i=str.length-1;i>=0;i--){if(/\S/.test(str.charAt(i))){str=str.substring(0,i+1);break;}}return str;};return _264;});},"dojox/charting/plot2d/Lines":function(){define("dojox/charting/plot2d/Lines",["dojo/_base/declare","./Default"],function(_26b,_26c){return _26b("dojox.charting.plot2d.Lines",_26c,{constructor:function(){this.opt.lines=true;}});});},"dijit/registry":function(){define("dijit/registry",["dojo/_base/array","dojo/sniff","dojo/_base/unload","dojo/_base/window","./main"],function(_26d,has,_26e,win,_26f){var _270={},hash={};var _271={length:0,add:function(_272){if(hash[_272.id]){throw new Error("Tried to register widget with id=="+_272.id+" but that id is already registered");}hash[_272.id]=_272;this.length++;},remove:function(id){if(hash[id]){delete hash[id];this.length--;}},byId:function(id){return typeof id=="string"?hash[id]:id;},byNode:function(node){return hash[node.getAttribute("widgetId")];},toArray:function(){var ar=[];for(var id in hash){ar.push(hash[id]);}return ar;},getUniqueId:function(_273){var id;do{id=_273+"_"+(_273 in _270?++_270[_273]:_270[_273]=0);}while(hash[id]);return _26f._scopeName=="dijit"?id:_26f._scopeName+"_"+id;},findWidgets:function(root,_274){var _275=[];function _276(root){for(var node=root.firstChild;node;node=node.nextSibling){if(node.nodeType==1){var _277=node.getAttribute("widgetId");if(_277){var _278=hash[_277];if(_278){_275.push(_278);}}else{if(node!==_274){_276(node);}}}}};_276(root);return _275;},_destroyAll:function(){_26f._curFocus=null;_26f._prevFocus=null;_26f._activeStack=[];_26d.forEach(_271.findWidgets(win.body()),function(_279){if(!_279._destroyed){if(_279.destroyRecursive){_279.destroyRecursive();}else{if(_279.destroy){_279.destroy();}}}});},getEnclosingWidget:function(node){while(node){var id=node.nodeType==1&&node.getAttribute("widgetId");if(id){return hash[id];}node=node.parentNode;}return null;},_hash:hash};_26f.registry=_271;return _271;});},"dijit/Destroyable":function(){define("dijit/Destroyable",["dojo/_base/array","dojo/aspect","dojo/_base/declare"],function(_27a,_27b,_27c){return _27c("dijit.Destroyable",null,{destroy:function(_27d){this._destroyed=true;},own:function(){_27a.forEach(arguments,function(_27e){var _27f="destroyRecursive" in _27e?"destroyRecursive":"destroy" in _27e?"destroy":"remove";var odh=_27b.before(this,"destroy",function(_280){_27e[_27f](_280);});var hdh=_27b.after(_27e,_27f,function(){odh.remove();hdh.remove();},true);},this);return arguments;}});});},"dojox/charting/plot2d/StackedAreas":function(){define("dojox/charting/plot2d/StackedAreas",["dojo/_base/declare","./Stacked"],function(_281,_282){return _281("dojox.charting.plot2d.StackedAreas",_282,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});});},"dijit/_base/manager":function(){define("dijit/_base/manager",["dojo/_base/array","dojo/_base/config","dojo/_base/lang","../registry","../main"],function(_283,_284,lang,_285,_286){var _287={};_283.forEach(["byId","getUniqueId","findWidgets","_destroyAll","byNode","getEnclosingWidget"],function(name){_287[name]=_285[name];});lang.mixin(_287,{defaultDuration:_284["defaultDuration"]||200});lang.mixin(_286,_287);return _286;});},"dojox/charting/plot2d/Stacked":function(){define(["dojo/_base/declare","./Default","./commonStacked"],function(_288,_289,_28a){return _288("dojox.charting.plot2d.Stacked",_289,{getSeriesStats:function(){var _28b=_28a.collectStats(this.series);return _28b;},buildSegments:function(i,_28c){var run=this.series[i],min=_28c?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0,max=_28c?Math.min(run.data.length-1,Math.ceil(this._hScaler.bounds.to)):run.data.length-1,rseg=null,_28d=[];for(var j=min;j<=max;j++){var _28e=_28c?_28a.getIndexValue(this.series,i,j):_28a.getValue(this.series,i,run.data[j]?run.data[j].x:null);if(_28e!=null&&(_28c||_28e.y!=null)){if(!rseg){rseg=[];_28d.push({index:j,rseg:rseg});}rseg.push(_28e);}else{if(!this.opt.interpolate||_28c){rseg=null;}}}return _28d;}});});},"dojo/fx/easing":function(){define(["../_base/lang"],function(lang){var _28f={linear:function(n){return n;},quadIn:function(n){return Math.pow(n,2);},quadOut:function(n){return n*(n-2)*-1;},quadInOut:function(n){n=n*2;if(n<1){return Math.pow(n,2)/2;}return -1*((--n)*(n-2)-1)/2;},cubicIn:function(n){return Math.pow(n,3);},cubicOut:function(n){return Math.pow(n-1,3)+1;},cubicInOut:function(n){n=n*2;if(n<1){return Math.pow(n,3)/2;}n-=2;return (Math.pow(n,3)+2)/2;},quartIn:function(n){return Math.pow(n,4);},quartOut:function(n){return -1*(Math.pow(n-1,4)-1);},quartInOut:function(n){n=n*2;if(n<1){return Math.pow(n,4)/2;}n-=2;return -1/2*(Math.pow(n,4)-2);},quintIn:function(n){return Math.pow(n,5);},quintOut:function(n){return Math.pow(n-1,5)+1;},quintInOut:function(n){n=n*2;if(n<1){return Math.pow(n,5)/2;}n-=2;return (Math.pow(n,5)+2)/2;},sineIn:function(n){return -1*Math.cos(n*(Math.PI/2))+1;},sineOut:function(n){return Math.sin(n*(Math.PI/2));},sineInOut:function(n){return -1*(Math.cos(Math.PI*n)-1)/2;},expoIn:function(n){return (n==0)?0:Math.pow(2,10*(n-1));},expoOut:function(n){return (n==1)?1:(-1*Math.pow(2,-10*n)+1);},expoInOut:function(n){if(n==0){return 0;}if(n==1){return 1;}n=n*2;if(n<1){return Math.pow(2,10*(n-1))/2;}--n;return (-1*Math.pow(2,-10*n)+2)/2;},circIn:function(n){return -1*(Math.sqrt(1-Math.pow(n,2))-1);},circOut:function(n){n=n-1;return Math.sqrt(1-Math.pow(n,2));},circInOut:function(n){n=n*2;if(n<1){return -1/2*(Math.sqrt(1-Math.pow(n,2))-1);}n-=2;return 1/2*(Math.sqrt(1-Math.pow(n,2))+1);},backIn:function(n){var s=1.70158;return Math.pow(n,2)*((s+1)*n-s);},backOut:function(n){n=n-1;var s=1.70158;return Math.pow(n,2)*((s+1)*n+s)+1;},backInOut:function(n){var s=1.70158*1.525;n=n*2;if(n<1){return (Math.pow(n,2)*((s+1)*n-s))/2;}n-=2;return (Math.pow(n,2)*((s+1)*n+s)+2)/2;},elasticIn:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;n=n-1;return -1*Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p);},elasticOut:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;return Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p)+1;},elasticInOut:function(n){if(n==0){return 0;}n=n*2;if(n==2){return 1;}var p=0.3*1.5;var s=p/4;if(n<1){n-=1;return -0.5*(Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p));}n-=1;return 0.5*(Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p))+1;},bounceIn:function(n){return (1-_28f.bounceOut(1-n));},bounceOut:function(n){var s=7.5625;var p=2.75;var l;if(n<(1/p)){l=s*Math.pow(n,2);}else{if(n<(2/p)){n-=(1.5/p);l=s*Math.pow(n,2)+0.75;}else{if(n<(2.5/p)){n-=(2.25/p);l=s*Math.pow(n,2)+0.9375;}else{n-=(2.625/p);l=s*Math.pow(n,2)+0.984375;}}}return l;},bounceInOut:function(n){if(n<0.5){return _28f.bounceIn(n*2)/2;}return (_28f.bounceOut(n*2-1)/2)+0.5;}};lang.setObject("dojo.fx.easing",_28f);return _28f;});},"dojox/charting/action2d/Highlight":function(){define("dojox/charting/action2d/Highlight",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/declare","dojo/_base/Color","dojo/_base/connect","dojox/color/_base","./PlotAction","dojo/fx/easing","dojox/gfx/fx"],function(dojo,lang,_290,_291,hub,c,_292,dfe,dgf){var _293=100,_294=75,_295=50,cc=function(_296){return function(){return _296;};},hl=function(_297){var a=new c.Color(_297),x=a.toHsl();if(x.s==0){x.l=x.l<50?100:0;}else{x.s=_293;if(x.l<_295){x.l=_294;}else{if(x.l>_294){x.l=_295;}else{x.l=x.l-_295>_294-x.l?_295:_294;}}}return c.fromHsl(x);};return _290("dojox.charting.action2d.Highlight",_292,{defaultParams:{duration:400,easing:dfe.backOut},optionalParams:{highlight:"red"},constructor:function(_298,plot,_299){var a=_299&&_299.highlight;this.colorFun=a?(lang.isFunction(a)?a:cc(a)):hl;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}var _29a=o.run.name,_29b=o.index,anim,_29c,_29d;if(_29a in this.anim){anim=this.anim[_29a][_29b];}else{this.anim[_29a]={};}if(anim){anim.action.stop(true);}else{var _29e=o.shape.getFill();if(!_29e||!(_29e instanceof _291)){return;}this.anim[_29a][_29b]=anim={start:_29e,end:this.colorFun(_29e)};}var _29f=anim.start,end=anim.end;if(o.type=="onmouseout"){var t=_29f;_29f=end;end=t;}anim.action=dgf.animateFill({shape:o.shape,duration:this.duration,easing:this.easing,color:{start:_29f,end:end}});if(o.type=="onmouseout"){hub.connect(anim.action,"onEnd",this,function(){if(this.anim[_29a]){delete this.anim[_29a][_29b];}});}anim.action.play();}});});},"dojox/charting/axis2d/Base":function(){define("dojox/charting/axis2d/Base",["dojo/_base/declare","../Element"],function(_2a0,_2a1){return _2a0("dojox.charting.axis2d.Base",_2a1,{constructor:function(_2a2,_2a3){this.vertical=_2a3&&_2a3.vertical;this.opt={};this.opt.min=_2a3&&_2a3.min;this.opt.max=_2a3&&_2a3.max;},clear:function(){return this;},initialized:function(){return false;},calculate:function(min,max,span){return this;},getScaler:function(){return null;},getTicks:function(){return null;},getOffsets:function(){return {l:0,r:0,t:0,b:0};},render:function(dim,_2a4){this.dirty=false;return this;}});});},"dojox/charting/plot2d/Grid":function(){define("dojox/charting/plot2d/Grid",["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/array","./CartesianBase","./common","dojox/lang/utils","dojox/gfx/fx"],function(lang,_2a5,hub,arr,_2a6,dc,du,fx){return _2a5("dojox.charting.plot2d.Grid",_2a6,{defaultParams:{hAxis:"x",vAxis:"y",hMajorLines:true,hMinorLines:false,vMajorLines:true,vMinorLines:false,hStripes:false,vStripes:false,animate:null,enableCache:false,renderOnAxis:true},optionalParams:{majorHLine:{},minorHLine:{},majorVLine:{},minorVLine:{}},constructor:function(_2a7,_2a8){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_2a8);du.updateWithPattern(this.opt,_2a8,this.optionalParams);this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;if(this.opt.enableCache){this._lineFreePool=[];this._lineUsePool=[];}},addSeries:function(run){return this;},getSeriesStats:function(){return lang.delegate(dc.defaultStats);},cleanGroup:function(){this.inherited(arguments);if(this.opt.enableCache){this._lineFreePool=this._lineFreePool.concat(this._lineUsePool);this._lineUsePool=[];}},createLine:function(_2a9,_2aa){var line;if(this.opt.enableCache&&this._lineFreePool.length>0){line=this._lineFreePool.pop();line.setShape(_2aa);_2a9.add(line);}else{line=_2a9.createLine(_2aa);}if(this.opt.enableCache){this._lineUsePool.push(line);}return line;},render:function(dim,_2ab){if(this.zoom){return this.performZoom(dim,_2ab);}this.dirty=this.isDirty();if(!this.dirty){return this;}this.cleanGroup();var s=this.group,ta=this.chart.theme,_2ac;var _2ad=this.opt.renderOnAxis;if(this._vAxis){var _2ae=this._vAxis.getScaler();if(_2ae){var vt=_2ae.scaler.getTransformerFromModel(_2ae);var _2af;_2af=this._vAxis.getTicks();if(_2af!=null){if(this.opt.hMinorLines){_2ac=this.opt.minorHLine||(ta.grid&&ta.grid.minorLine)||ta.axis.minorTick;arr.forEach(_2af.minor,function(tick){if(!_2ad&&tick.value==(this._vAxis.opt.leftBottom?_2ae.bounds.from:_2ae.bounds.to)){return;}var y=dim.height-_2ab.b-vt(tick.value);var _2b0=this.createLine(s,{x1:_2ab.l,y1:y,x2:dim.width-_2ab.r,y2:y}).setStroke(_2ac);if(this.animate){this._animateGrid(_2b0,"h",_2ab.l,_2ab.r+_2ab.l-dim.width);}},this);}if(this.opt.hMajorLines){_2ac=this.opt.majorHLine||(ta.grid&&ta.grid.majorLine)||ta.axis.majorTick;arr.forEach(_2af.major,function(tick){if(!_2ad&&tick.value==(this._vAxis.opt.leftBottom?_2ae.bounds.from:_2ae.bounds.to)){return;}var y=dim.height-_2ab.b-vt(tick.value);var _2b1=this.createLine(s,{x1:_2ab.l,y1:y,x2:dim.width-_2ab.r,y2:y}).setStroke(_2ac);if(this.animate){this._animateGrid(_2b1,"h",_2ab.l,_2ab.r+_2ab.l-dim.width);}},this);}}}}if(this._hAxis){var _2b2=this._hAxis.getScaler();if(_2b2){var ht=_2b2.scaler.getTransformerFromModel(_2b2);_2af=this._hAxis.getTicks();if(this!=null){if(_2af&&this.opt.vMinorLines){_2ac=this.opt.minorVLine||(ta.grid&&ta.grid.minorLine)||ta.axis.minorTick;arr.forEach(_2af.minor,function(tick){if(!_2ad&&tick.value==(this._hAxis.opt.leftBottom?_2b2.bounds.from:_2b2.bounds.to)){return;}var x=_2ab.l+ht(tick.value);var _2b3=this.createLine(s,{x1:x,y1:_2ab.t,x2:x,y2:dim.height-_2ab.b}).setStroke(_2ac);if(this.animate){this._animateGrid(_2b3,"v",dim.height-_2ab.b,dim.height-_2ab.b-_2ab.t);}},this);}if(_2af&&this.opt.vMajorLines){_2ac=this.opt.majorVLine||(ta.grid&&ta.grid.majorLine)||ta.axis.majorTick;arr.forEach(_2af.major,function(tick){if(!_2ad&&tick.value==(this._hAxis.opt.leftBottom?_2b2.bounds.from:_2b2.bounds.to)){return;}var x=_2ab.l+ht(tick.value);var _2b4=this.createLine(s,{x1:x,y1:_2ab.t,x2:x,y2:dim.height-_2ab.b}).setStroke(_2ac);if(this.animate){this._animateGrid(_2b4,"v",dim.height-_2ab.b,dim.height-_2ab.b-_2ab.t);}},this);}}}}this.dirty=false;return this;},_animateGrid:function(_2b5,type,_2b6,size){var _2b7=type=="h"?[_2b6,0]:[0,_2b6];var _2b8=type=="h"?[1/size,1]:[1,1/size];fx.animateTransform(lang.delegate({shape:_2b5,duration:1200,transform:[{name:"translate",start:_2b7,end:[0,0]},{name:"scale",start:_2b8,end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dijit/a11y":function(){define("dijit/a11y",["dojo/_base/array","dojo/_base/config","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/sniff","./main"],function(_2b9,_2ba,_2bb,dom,_2bc,_2bd,has,_2be){var _2bf=(_2be._isElementShown=function(elem){var s=_2bd.get(elem);return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_2bc.get(elem,"type")!="hidden");});_2be.hasDefaultTabStop=function(elem){switch(elem.nodeName.toLowerCase()){case "a":return _2bc.has(elem,"href");case "area":case "button":case "input":case "object":case "select":case "textarea":return true;case "iframe":var body;try{var _2c0=elem.contentDocument;if("designMode" in _2c0&&_2c0.designMode=="on"){return true;}body=_2c0.body;}catch(e1){try{body=elem.contentWindow.document.body;}catch(e2){return false;}}return body&&(body.contentEditable=="true"||(body.firstChild&&body.firstChild.contentEditable=="true"));default:return elem.contentEditable=="true";}};var _2c1=(_2be.isTabNavigable=function(elem){if(_2bc.get(elem,"disabled")){return false;}else{if(_2bc.has(elem,"tabIndex")){return _2bc.get(elem,"tabIndex")>=0;}else{return _2be.hasDefaultTabStop(elem);}}});_2be._getTabNavigable=function(root){var _2c2,last,_2c3,_2c4,_2c5,_2c6,_2c7={};function _2c8(node){return node&&node.tagName.toLowerCase()=="input"&&node.type&&node.type.toLowerCase()=="radio"&&node.name&&node.name.toLowerCase();};var _2c9=function(_2ca){for(var _2cb=_2ca.firstChild;_2cb;_2cb=_2cb.nextSibling){if(_2cb.nodeType!=1||(has("ie")<=9&&_2cb.scopeName!=="HTML")||!_2bf(_2cb)){continue;}if(_2c1(_2cb)){var _2cc=+_2bc.get(_2cb,"tabIndex");if(!_2bc.has(_2cb,"tabIndex")||_2cc==0){if(!_2c2){_2c2=_2cb;}last=_2cb;}else{if(_2cc>0){if(!_2c3||_2cc<_2c4){_2c4=_2cc;_2c3=_2cb;}if(!_2c5||_2cc>=_2c6){_2c6=_2cc;_2c5=_2cb;}}}var rn=_2c8(_2cb);if(_2bc.get(_2cb,"checked")&&rn){_2c7[rn]=_2cb;}}if(_2cb.nodeName.toUpperCase()!="SELECT"){_2c9(_2cb);}}};if(_2bf(root)){_2c9(root);}function rs(node){return _2c7[_2c8(node)]||node;};return {first:rs(_2c2),last:rs(last),lowest:rs(_2c3),highest:rs(_2c5)};};_2be.getFirstInTabbingOrder=function(root,doc){var _2cd=_2be._getTabNavigable(dom.byId(root,doc));return _2cd.lowest?_2cd.lowest:_2cd.first;};_2be.getLastInTabbingOrder=function(root,doc){var _2ce=_2be._getTabNavigable(dom.byId(root,doc));return _2ce.last?_2ce.last:_2ce.highest;};return {hasDefaultTabStop:_2be.hasDefaultTabStop,isTabNavigable:_2be.isTabNavigable,_getTabNavigable:_2be._getTabNavigable,getFirstInTabbingOrder:_2be.getFirstInTabbingOrder,getLastInTabbingOrder:_2be.getLastInTabbingOrder};});},"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n></div>\n","dojox/lang/functional/fold":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/kernel","./lambda"],function(lang,arr,_2cf,df){var _2d0={};lang.mixin(df,{foldl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_2cf.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}else{for(i in a){if(!(i in _2d0)){z=f.call(o,z,a[i],i,a);}}}}return z;},foldl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_2cf.global;f=df.lambda(f);var z,i,n;if(lang.isArray(a)){z=a[0];for(i=1,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){z=a.next();for(i=1;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}}else{var _2d1=true;for(i in a){if(!(i in _2d0)){if(_2d1){z=a[i];_2d1=false;}else{z=f.call(o,z,a[i],i,a);}}}}}return z;},foldr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_2cf.global;f=df.lambda(f);for(var i=a.length;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},foldr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_2cf.global;f=df.lambda(f);var n=a.length,z=a[n-1],i=n-1;for(;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},reduce:function(a,f,z){return arguments.length<3?df.foldl1(a,f):df.foldl(a,f,z);},reduceRight:function(a,f,z){return arguments.length<3?df.foldr1(a,f):df.foldr(a,f,z);},unfold:function(pr,f,g,z,o){o=o||_2cf.global;f=df.lambda(f);g=df.lambda(g);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(f.call(o,z)),z=g.call(o,z)){}return t;}});});},"dojox/charting/plot2d/Spider":function(){define("dojox/charting/plot2d/Spider",["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/array","dojo/dom-geometry","dojo/_base/fx","dojo/fx","dojo/_base/sniff","./Base","./_PlotEvents","dojo/_base/Color","dojox/color/_base","./common","../axis2d/common","../scaler/primitive","dojox/gfx","dojox/gfx/matrix","dojox/gfx/fx","dojox/lang/functional","dojox/lang/utils","dojo/fx/easing"],function(lang,_2d2,hub,arr,_2d3,_2d4,_2d5,has,Base,_2d6,_2d7,_2d8,dc,da,_2d9,g,m,_2da,df,du,_2db){var _2dc=0.2;var _2dd=_2d2("dojox.charting.plot2d.Spider",[Base,_2d6],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:-10,labelStyle:"default",htmlLabels:true,startAngle:-90,divisions:3,axisColor:"",axisWidth:0,spiderColor:"",spiderWidth:0,seriesWidth:0,seriesFillAlpha:0.2,spiderOrigin:0.16,markerSize:3,spiderType:"polygon",animationType:_2db.backOut,axisTickFont:"",axisTickFontColor:"",axisFont:"",axisFontColor:""},optionalParams:{radius:0,font:"",fontColor:""},constructor:function(_2de,_2df){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_2df);du.updateWithPattern(this.opt,_2df,this.optionalParams);this.dyn=[];this.datas={};this.labelKey=[];this.oldSeriePoints={};this.animations={};},clear:function(){this.inherited(arguments);this.dyn=[];this.axes=[];this.datas={};this.labelKey=[];this.oldSeriePoints={};this.animations={};return this;},setAxis:function(axis){if(axis){if(axis.opt.min!=undefined){this.datas[axis.name].min=axis.opt.min;}if(axis.opt.max!=undefined){this.datas[axis.name].max=axis.opt.max;}}return this;},addSeries:function(run){var _2e0=false;this.series.push(run);for(var key in run.data){var val=run.data[key],data=this.datas[key];if(data){data.vlist.push(val);data.min=Math.min(data.min,val);data.max=Math.max(data.max,val);}else{var _2e1="__"+key;this.axes.push(_2e1);this[_2e1]=key;this.datas[key]={min:val,max:val,vlist:[val]};}}if(this.labelKey.length<=0){for(var key in run.data){this.labelKey.push(key);}}return this;},getSeriesStats:function(){return dc.collectSimpleStats(this.series);},render:function(dim,_2e2){if(!this.dirty){return this;}this.dirty=false;this.cleanGroup();var s=this.group,t=this.chart.theme;this.resetEvents();if(!this.series||!this.series.length){return this;}var o=this.opt,ta=t.axis,rx=(dim.width-_2e2.l-_2e2.r)/2,ry=(dim.height-_2e2.t-_2e2.b)/2,r=Math.min(rx,ry),_2e3=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font)||"normal normal normal 7pt Tahoma",_2e4=o.axisFont||(ta.tick&&ta.tick.titleFont)||"normal normal normal 11pt Tahoma",_2e5=o.axisTickFontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"silver",_2e6=o.axisFontColor||(ta.tick&&ta.tick.titleFontColor)||"black",_2e7=o.axisColor||(ta.tick&&ta.tick.axisColor)||"silver",_2e8=o.spiderColor||(ta.tick&&ta.tick.spiderColor)||"silver",_2e9=o.axisWidth||(ta.stroke&&ta.stroke.width)||2,_2ea=o.spiderWidth||(ta.stroke&&ta.stroke.width)||2,_2eb=o.seriesWidth||(ta.stroke&&ta.stroke.width)||2,_2ec=g.normalizedLength(g.splitFontString(_2e4).size),_2ed=m._degToRad(o.startAngle),_2ee=_2ed,step,_2ef,_2f0,_2f1,_2f2,_2f3,_2f4,_2f5,_2f6,_2f7,_2f8,ro=o.spiderOrigin,dv=o.divisions>=3?o.divisions:3,ms=o.markerSize,spt=o.spiderType,at=o.animationType,_2f9=o.labelOffset<-10?o.labelOffset:-10,_2fa=0.2;if(o.labels){_2f1=arr.map(this.series,function(s){return s.name;},this);_2f2=df.foldl1(df.map(_2f1,function(_2fb,i){var font=t.series.font;return g._base._getTextBox(_2fb,{font:font}).w;},this),"Math.max(a, b)")/2;r=Math.min(rx-2*_2f2,ry-_2ec)+_2f9;_2f3=r-_2f9;}if("radius" in o){r=o.radius;_2f3=r-_2f9;}r/=(1+_2fa);var _2fc={cx:_2e2.l+rx,cy:_2e2.t+ry,r:r};for(var i=this.series.length-1;i>=0;i--){var _2fd=this.series[i];if(!this.dirty&&!_2fd.dirty){t.skip();continue;}_2fd.cleanGroup();var run=_2fd.data;if(run!==null){var len=this._getObjectLength(run);if(!_2f4||_2f4.length<=0){_2f4=[],_2f5=[],_2f8=[];this._buildPoints(_2f4,len,_2fc,r,_2ee,true);this._buildPoints(_2f5,len,_2fc,r*ro,_2ee,true);this._buildPoints(_2f8,len,_2fc,_2f3,_2ee);if(dv>2){_2f6=[],_2f7=[];for(var j=0;j<dv-2;j++){_2f6[j]=[];this._buildPoints(_2f6[j],len,_2fc,r*(ro+(1-ro)*(j+1)/(dv-1)),_2ee,true);_2f7[j]=r*(ro+(1-ro)*(j+1)/(dv-1));}}}}}var _2fe=s.createGroup(),_2ff={color:_2e7,width:_2e9},_300={color:_2e8,width:_2ea};for(var j=_2f4.length-1;j>=0;--j){var _301=_2f4[j],st={x:_301.x+(_301.x-_2fc.cx)*_2fa,y:_301.y+(_301.y-_2fc.cy)*_2fa},nd={x:_301.x+(_301.x-_2fc.cx)*_2fa/2,y:_301.y+(_301.y-_2fc.cy)*_2fa/2};_2fe.createLine({x1:_2fc.cx,y1:_2fc.cy,x2:st.x,y2:st.y}).setStroke(_2ff);this._drawArrow(_2fe,st,nd,_2ff);}var _302=s.createGroup();for(var j=_2f8.length-1;j>=0;--j){var _301=_2f8[j],_303=g._base._getTextBox(this.labelKey[j],{font:_2e4}).w||0,_304=this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx",elem=da.createText[_304](this.chart,_302,(!_2d3.isBodyLtr()&&_304=="html")?(_301.x+_303-dim.width):_301.x,_301.y,"middle",this.labelKey[j],_2e4,_2e6);if(this.opt.htmlLabels){this.htmlElements.push(elem);}}var _305=s.createGroup();if(spt=="polygon"){_305.createPolyline(_2f4).setStroke(_300);_305.createPolyline(_2f5).setStroke(_300);if(_2f6.length>0){for(var j=_2f6.length-1;j>=0;--j){_305.createPolyline(_2f6[j]).setStroke(_300);}}}else{var _306=this._getObjectLength(this.datas);_305.createCircle({cx:_2fc.cx,cy:_2fc.cy,r:r}).setStroke(_300);_305.createCircle({cx:_2fc.cx,cy:_2fc.cy,r:r*ro}).setStroke(_300);if(_2f7.length>0){for(var j=_2f7.length-1;j>=0;--j){_305.createCircle({cx:_2fc.cx,cy:_2fc.cy,r:_2f7[j]}).setStroke(_300);}}}var _307=s.createGroup(),len=this._getObjectLength(this.datas),k=0;for(var key in this.datas){var data=this.datas[key],min=data.min,max=data.max,_308=max-min,end=_2ee+2*Math.PI*k/len;for(var i=0;i<dv;i++){var text=min+_308*i/(dv-1),_301=this._getCoordinate(_2fc,r*(ro+(1-ro)*i/(dv-1)),end);text=this._getLabel(text);var _303=g._base._getTextBox(text,{font:_2e3}).w||0,_304=this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx";if(this.opt.htmlLabels){this.htmlElements.push(da.createText[_304](this.chart,_307,(!_2d3.isBodyLtr()&&_304=="html")?(_301.x+_303-dim.width):_301.x,_301.y,"start",text,_2e3,_2e5));}}k++;}this.chart.seriesShapes={};var _309=[];for(var i=this.series.length-1;i>=0;i--){var _2fd=this.series[i],run=_2fd.data;if(run!==null){var _30a=[],k=0,_30b=[];for(var key in run){var data=this.datas[key],min=data.min,max=data.max,_308=max-min,_30c=run[key],end=_2ee+2*Math.PI*k/len,_301=this._getCoordinate(_2fc,r*(ro+(1-ro)*(_30c-min)/_308),end);_30a.push(_301);_30b.push({sname:_2fd.name,key:key,data:_30c});k++;}_30a[_30a.length]=_30a[0];_30b[_30b.length]=_30b[0];var _30d=this._getBoundary(_30a),_30e=t.next("spider",[o,_2fd]),ts=_2fd.group,f=g.normalizeColor(_30e.series.fill),sk={color:_30e.series.fill,width:_2eb};f.a=o.seriesFillAlpha;_2fd.dyn={fill:f,stroke:sk};var osps=this.oldSeriePoints[_2fd.name];var cs=this._createSeriesEntry(ts,(osps||_2f5),_30a,f,sk,r,ro,ms,at);this.chart.seriesShapes[_2fd.name]=cs;this.oldSeriePoints[_2fd.name]=_30a;var po={element:"spider_poly",index:i,id:"spider_poly_"+_2fd.name,run:_2fd,plot:this,shape:cs.poly,parent:ts,brect:_30d,cx:_2fc.cx,cy:_2fc.cy,cr:r,f:f,s:s};this._connectEvents(po);var so={element:"spider_plot",index:i,id:"spider_plot_"+_2fd.name,run:_2fd,plot:this,shape:_2fd.group};this._connectEvents(so);arr.forEach(cs.circles,function(c,i){var _30f=c.getShape(),co={element:"spider_circle",index:i,id:"spider_circle_"+_2fd.name+i,run:_2fd,plot:this,shape:c,parent:ts,tdata:_30b[i],cx:_30a[i].x,cy:_30a[i].y,f:f,s:s};this._connectEvents(co);},this);}}return this;},_createSeriesEntry:function(ts,osps,sps,f,sk,r,ro,ms,at){var _310=ts.createPolyline(osps).setFill(f).setStroke(sk),_311=[];for(var j=0;j<osps.length;j++){var _312=osps[j],cr=ms;var _313=ts.createCircle({cx:_312.x,cy:_312.y,r:cr}).setFill(f).setStroke(sk);_311.push(_313);}var _314=arr.map(sps,function(np,j){var sp=osps[j],anim=new _2d4.Animation({duration:1000,easing:at,curve:[sp.y,np.y]});var spl=_310,sc=_311[j];hub.connect(anim,"onAnimate",function(y){var _315=spl.getShape();_315.points[j].y=y;spl.setShape(_315);var _316=sc.getShape();_316.cy=y;sc.setShape(_316);});return anim;});var _317=arr.map(sps,function(np,j){var sp=osps[j],anim=new _2d4.Animation({duration:1000,easing:at,curve:[sp.x,np.x]});var spl=_310,sc=_311[j];hub.connect(anim,"onAnimate",function(x){var _318=spl.getShape();_318.points[j].x=x;spl.setShape(_318);var _319=sc.getShape();_319.cx=x;sc.setShape(_319);});return anim;});var _31a=_2d5.combine(_314.concat(_317));_31a.play();return {group:ts,poly:_310,circles:_311};},plotEvent:function(o){var _31b=o.id?o.id:"default",a;if(_31b in this.animations){a=this.animations[_31b];a.anim&&a.anim.stop(true);}else{a=this.animations[_31b]={};}if(o.element=="spider_poly"){if(!a.color){var _31c=o.shape.getFill();if(!_31c||!(_31c instanceof _2d7)){return;}a.color={start:_31c,end:_31d(_31c)};}var _31e=a.color.start,end=a.color.end;if(o.type=="onmouseout"){var t=_31e;_31e=end;end=t;}a.anim=_2da.animateFill({shape:o.shape,duration:800,easing:_2db.backOut,color:{start:_31e,end:end}});a.anim.play();}else{if(o.element=="spider_circle"){var init,_31f,_320=1.5;if(o.type=="onmouseover"){init=m.identity;_31f=_320;var _321={type:"rect"};_321.x=o.cx;_321.y=o.cy;_321.w=_321.h=1;var lt=this.chart.getCoords();_321.x+=lt.x;_321.y+=lt.y;_321.x=Math.round(_321.x);_321.y=Math.round(_321.y);this.aroundRect=_321;var _322=["after-centered","before-centered"];dc.doIfLoaded("dijit/Tooltip",lang.hitch(this,function(_323){_323.show(o.tdata.sname+"<br/>"+o.tdata.key+"<br/>"+o.tdata.data,this.aroundRect,_322);}));}else{init=m.scaleAt(_320,o.cx,o.cy);_31f=1/_320;dc.doIfLoaded("dijit/Tooltip",lang.hitch(this,function(_324){this.aroundRect&&_324.hide(this.aroundRect);}));}var cs=o.shape.getShape(),init=m.scaleAt(_320,cs.cx,cs.cy),_325={shape:o.shape,duration:200,easing:_2db.backOut,transform:[{name:"scaleAt",start:[1,cs.cx,cs.cy],end:[_31f,cs.cx,cs.cy]},init]};a.anim=_2da.animateTransform(_325);a.anim.play();}else{if(o.element=="spider_plot"){if(o.type=="onmouseover"&&!has("ie")){o.shape.moveToFront();}}}}},_getBoundary:function(_326){var xmax=_326[0].x,xmin=_326[0].x,ymax=_326[0].y,ymin=_326[0].y;for(var i=0;i<_326.length;i++){var _327=_326[i];xmax=Math.max(_327.x,xmax);ymax=Math.max(_327.y,ymax);xmin=Math.min(_327.x,xmin);ymin=Math.min(_327.y,ymin);}return {x:xmin,y:ymin,width:xmax-xmin,height:ymax-ymin};},_drawArrow:function(s,_328,end,_329){var len=Math.sqrt(Math.pow(end.x-_328.x,2)+Math.pow(end.y-_328.y,2)),sin=(end.y-_328.y)/len,cos=(end.x-_328.x)/len,_32a={x:end.x+(len/3)*(-sin),y:end.y+(len/3)*cos},_32b={x:end.x+(len/3)*sin,y:end.y+(len/3)*(-cos)};s.createPolyline([_328,_32a,_32b]).setFill(_329.color).setStroke(_329);},_buildPoints:function(_32c,_32d,_32e,_32f,_330,_331){for(var i=0;i<_32d;i++){var end=_330+2*Math.PI*i/_32d;_32c.push(this._getCoordinate(_32e,_32f,end));}if(_331){_32c.push(this._getCoordinate(_32e,_32f,_330+2*Math.PI));}},_getCoordinate:function(_332,_333,_334){return {x:_332.cx+_333*Math.cos(_334),y:_332.cy+_333*Math.sin(_334)};},_getObjectLength:function(obj){var _335=0;if(lang.isObject(obj)){for(var key in obj){_335++;}}return _335;},_getLabel:function(_336){return dc.getLabel(_336,this.opt.fixed,this.opt.precision);}});function _31d(_337){var a=new _2d8.Color(_337),x=a.toHsl();if(x.s==0){x.l=x.l<50?100:0;}else{x.s=100;if(x.l<50){x.l=75;}else{if(x.l>75){x.l=50;}else{x.l=x.l-50>75-x.l?50:75;}}}var _337=_2d8.fromHsl(x);_337.a=0.7;return _337;};return _2dd;});},"dojox/charting/plot2d/StackedBars":function(){define(["dojo/_base/declare","./Bars","./commonStacked"],function(_338,Bars,_339){return _338("dojox.charting.plot2d.StackedBars",Bars,{getSeriesStats:function(){var _33a=_339.collectStats(this.series),t;_33a.hmin-=0.5;_33a.hmax+=0.5;t=_33a.hmin,_33a.hmin=_33a.vmin,_33a.vmin=t;t=_33a.hmax,_33a.hmax=_33a.vmax,_33a.vmax=t;return _33a;},getValue:function(_33b,_33c,_33d,_33e){var y,x;if(_33e){x=_33c;y=_339.getIndexValue(this.series,_33d,x);}else{x=_33b.x-1;y=_339.getValue(this.series,_33d,_33b.x);y=y?y.y:null;}return {y:y,x:x};}});});},"dojox/charting/themes/GreySkies":function(){define("dojox/charting/themes/GreySkies",["../SimpleTheme","./common"],function(_33f,_340){_340.GreySkies=new _33f();return _340.GreySkies;});},"dijit/place":function(){define("dijit/place",["dojo/_base/array","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/window","dojo/window","./main"],function(_341,_342,_343,_344,win,_345,_346){function _347(node,_348,_349,_34a){var view=_345.getBox(node.ownerDocument);if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){win.body(node.ownerDocument).appendChild(node);}var best=null;_341.some(_348,function(_34b){var _34c=_34b.corner;var pos=_34b.pos;var _34d=0;var _34e={w:{"L":view.l+view.w-pos.x,"R":pos.x-view.l,"M":view.w}[_34c.charAt(1)],h:{"T":view.t+view.h-pos.y,"B":pos.y-view.t,"M":view.h}[_34c.charAt(0)]};var s=node.style;s.left=s.right="auto";if(_349){var res=_349(node,_34b.aroundCorner,_34c,_34e,_34a);_34d=typeof res=="undefined"?0:res;}var _34f=node.style;var _350=_34f.display;var _351=_34f.visibility;if(_34f.display=="none"){_34f.visibility="hidden";_34f.display="";}var bb=_342.position(node);_34f.display=_350;_34f.visibility=_351;var _352={"L":pos.x,"R":pos.x-bb.w,"M":Math.max(view.l,Math.min(view.l+view.w,pos.x+(bb.w>>1))-bb.w)}[_34c.charAt(1)],_353={"T":pos.y,"B":pos.y-bb.h,"M":Math.max(view.t,Math.min(view.t+view.h,pos.y+(bb.h>>1))-bb.h)}[_34c.charAt(0)],_354=Math.max(view.l,_352),_355=Math.max(view.t,_353),endX=Math.min(view.l+view.w,_352+bb.w),endY=Math.min(view.t+view.h,_353+bb.h),_356=endX-_354,_357=endY-_355;_34d+=(bb.w-_356)+(bb.h-_357);if(best==null||_34d<best.overflow){best={corner:_34c,aroundCorner:_34b.aroundCorner,x:_354,y:_355,w:_356,h:_357,overflow:_34d,spaceAvailable:_34e};}return !_34d;});if(best.overflow&&_349){_349(node,best.aroundCorner,best.corner,best.spaceAvailable,_34a);}var l=_342.isBodyLtr(node.ownerDocument),s=node.style;s.top=best.y+"px";s[l?"left":"right"]=(l?best.x:view.w-best.x-best.w)+"px";s[l?"right":"left"]="auto";return best;};var _358={at:function(node,pos,_359,_35a){var _35b=_341.map(_359,function(_35c){var c={corner:_35c,pos:{x:pos.x,y:pos.y}};if(_35a){c.pos.x+=_35c.charAt(1)=="L"?_35a.x:-_35a.x;c.pos.y+=_35c.charAt(0)=="T"?_35a.y:-_35a.y;}return c;});return _347(node,_35b);},around:function(node,_35d,_35e,_35f,_360){var _361=(typeof _35d=="string"||"offsetWidth" in _35d)?_342.position(_35d,true):_35d;if(_35d.parentNode){var _362=_343.getComputedStyle(_35d).position=="absolute";var _363=_35d.parentNode;while(_363&&_363.nodeType==1&&_363.nodeName!="BODY"){var _364=_342.position(_363,true),pcs=_343.getComputedStyle(_363);if(/relative|absolute/.test(pcs.position)){_362=false;}if(!_362&&/hidden|auto|scroll/.test(pcs.overflow)){var _365=Math.min(_361.y+_361.h,_364.y+_364.h);var _366=Math.min(_361.x+_361.w,_364.x+_364.w);_361.x=Math.max(_361.x,_364.x);_361.y=Math.max(_361.y,_364.y);_361.h=_365-_361.y;_361.w=_366-_361.x;}if(pcs.position=="absolute"){_362=true;}_363=_363.parentNode;}}var x=_361.x,y=_361.y,_367="w" in _361?_361.w:(_361.w=_361.width),_368="h" in _361?_361.h:(_344.deprecated("place.around: dijit/place.__Rectangle: { x:"+x+", y:"+y+", height:"+_361.height+", width:"+_367+" } has been deprecated.  Please use { x:"+x+", y:"+y+", h:"+_361.height+", w:"+_367+" }","","2.0"),_361.h=_361.height);var _369=[];function push(_36a,_36b){_369.push({aroundCorner:_36a,corner:_36b,pos:{x:{"L":x,"R":x+_367,"M":x+(_367>>1)}[_36a.charAt(1)],y:{"T":y,"B":y+_368,"M":y+(_368>>1)}[_36a.charAt(0)]}});};_341.forEach(_35e,function(pos){var ltr=_35f;switch(pos){case "above-centered":push("TM","BM");break;case "below-centered":push("BM","TM");break;case "after-centered":ltr=!ltr;case "before-centered":push(ltr?"ML":"MR",ltr?"MR":"ML");break;case "after":ltr=!ltr;case "before":push(ltr?"TL":"TR",ltr?"TR":"TL");push(ltr?"BL":"BR",ltr?"BR":"BL");break;case "below-alt":ltr=!ltr;case "below":push(ltr?"BL":"BR",ltr?"TL":"TR");push(ltr?"BR":"BL",ltr?"TR":"TL");break;case "above-alt":ltr=!ltr;case "above":push(ltr?"TL":"TR",ltr?"BL":"BR");push(ltr?"TR":"TL",ltr?"BR":"BL");break;default:push(pos.aroundCorner,pos.corner);}});var _36c=_347(node,_369,_360,{w:_367,h:_368});_36c.aroundNodePos=_361;return _36c;}};return _346.place=_358;});},"dojox/charting/plot2d/Columns":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,arr,_36d,_36e,_36f,dc,df,dfr,du,fx){var _370=dfr.lambda("item.purgeGroup()");return _36d("dojox.charting.plot2d.Columns",[_36e,_36f],{defaultParams:{hAxis:"x",vAxis:"y",gap:0,animate:null,enableCache:false},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},styleFunc:null,font:"",fontColor:""},constructor:function(_371,_372){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_372);du.updateWithPattern(this.opt,_372,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},getSeriesStats:function(){var _373=dc.collectSimpleStats(this.series);_373.hmin-=0.5;_373.hmax+=0.5;return _373;},createRect:function(run,_374,_375){var rect;if(this.opt.enableCache&&run._rectFreePool.length>0){rect=run._rectFreePool.pop();rect.setShape(_375);_374.add(rect);}else{rect=_374.createRect(_375);}if(this.opt.enableCache){run._rectUsePool.push(rect);}return rect;},render:function(dim,_376){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_376);}this.getSeriesStats();this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,_370);this._eventSeries={};this.cleanGroup();s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_377=Math.max(0,this._vScaler.bounds.lower),_378=vt(_377),_379=this.events();var bar=this.getBarProperties();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._rectFreePool=(run._rectFreePool?run._rectFreePool:[]).concat(run._rectUsePool?run._rectUsePool:[]);run._rectUsePool=[];}var _37a=t.next("column",[this.opt,run]),_37b=new Array(run.data.length);s=run.group;var _37c=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var min=_37c?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0;var max=_37c?Math.min(run.data.length,Math.ceil(this._hScaler.bounds.to)):run.data.length;for(var j=min;j<max;++j){var _37d=run.data[j];if(_37d!=null){var val=this.getValue(_37d,j,i,_37c),vv=vt(val.y),h=Math.abs(vv-_378),_37e,_37f;if(this.opt.styleFunc||typeof _37d!="number"){var _380=typeof _37d!="number"?[_37d]:[];if(this.opt.styleFunc){_380.push(this.opt.styleFunc(_37d));}_37e=t.addMixin(_37a,"column",_380,true);}else{_37e=t.post(_37a,"column");}if(bar.width>=1&&h>=0){var rect={x:_376.l+ht(val.x+0.5)+bar.gap+bar.thickness*i,y:dim.height-_376.b-(val.y>_377?vv:_378),width:bar.width,height:h};if(_37e.series.shadow){var _381=lang.clone(rect);_381.x+=_37e.series.shadow.dx;_381.y+=_37e.series.shadow.dy;_37f=this.createRect(run,s,_381).setFill(_37e.series.shadow.color).setStroke(_37e.series.shadow);if(this.animate){this._animateColumn(_37f,dim.height-_376.b+_378,h);}}var _382=this._plotFill(_37e.series.fill,dim,_376);_382=this._shapeFill(_382,rect);var _383=this.createRect(run,s,rect).setFill(_382).setStroke(_37e.series.stroke);run.dyn.fill=_383.getFill();run.dyn.stroke=_383.getStroke();if(_379){var o={element:"column",index:j,run:run,shape:_383,shadow:_37f,x:val.x+0.5,y:val.y};this._connectEvents(o);_37b[j]=o;}if(this.animate){this._animateColumn(_383,dim.height-_376.b-_378,h);}}}}this._eventSeries[run.name]=_37b;run.dirty=false;}this.dirty=false;return this;},getValue:function(_384,j,_385,_386){var y,x;if(_386){if(typeof _384=="number"){y=_384;}else{y=_384.y;}x=j;}else{y=_384.y;x=_384.x-1;}return {y:y,x:x};},getBarProperties:function(){var f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);return {gap:f.gap,width:f.size,thickness:0};},_animateColumn:function(_387,_388,_389){if(_389==0){_389=1;}fx.animateTransform(lang.delegate({shape:_387,duration:1200,transform:[{name:"translate",start:[0,_388-(_388/_389)],end:[0,0]},{name:"scale",start:[1,1/_389],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/lang/functional/array":function(){define("dojox/lang/functional/array",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","./lambda"],function(_38a,lang,arr,df){var _38b={};lang.mixin(df,{filter:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_38a.global;f=df.lambda(f);var t=[],v,i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){v=a.next();if(f.call(o,v,i++,a)){t.push(v);}}}else{for(i in a){if(!(i in _38b)){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}}}return t;},forEach:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_38a.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();f.call(o,a.next(),i++,a)){}}else{for(i in a){if(!(i in _38b)){f.call(o,a[i],i,a);}}}}return o;},map:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_38a.global;f=df.lambda(f);var t,n,i;if(lang.isArray(a)){t=new Array(n=a.length);for(i=0;i<n;t[i]=f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[];for(i=0;a.hasNext();t.push(f.call(o,a.next(),i++,a))){}}else{t=[];for(i in a){if(!(i in _38b)){t.push(f.call(o,a[i],i,a));}}}}return t;},every:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_38a.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(!f.call(o,a[i],i,a)){return false;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(!f.call(o,a.next(),i++,a)){return false;}}}else{for(i in a){if(!(i in _38b)){if(!f.call(o,a[i],i,a)){return false;}}}}}return true;},some:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_38a.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(f.call(o,a[i],i,a)){return true;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(f.call(o,a.next(),i++,a)){return true;}}}else{for(i in a){if(!(i in _38b)){if(f.call(o,a[i],i,a)){return true;}}}}}return false;}});return df;});},"dojox/charting/themes/common":function(){define(["dojo/_base/lang"],function(lang){return lang.getObject("dojox.charting.themes",true);});},"dojox/charting/plot2d/common":function(){define("dojox/charting/plot2d/common",["dojo/_base/lang","dojo/_base/array","dojo/_base/Color","dojox/gfx","dojox/lang/functional","../scaler/common"],function(lang,arr,_38c,g,df,sc){var _38d=lang.getObject("dojox.charting.plot2d.common",true);return lang.mixin(_38d,{doIfLoaded:sc.doIfLoaded,makeStroke:function(_38e){if(!_38e){return _38e;}if(typeof _38e=="string"||_38e instanceof _38c){_38e={color:_38e};}return g.makeParameters(g.defaultStroke,_38e);},augmentColor:function(_38f,_390){var t=new _38c(_38f),c=new _38c(_390);c.a=t.a;return c;},augmentStroke:function(_391,_392){var s=_38d.makeStroke(_391);if(s){s.color=_38d.augmentColor(s.color,_392);}return s;},augmentFill:function(fill,_393){var fc,c=new _38c(_393);if(typeof fill=="string"||fill instanceof _38c){return _38d.augmentColor(fill,_393);}return fill;},defaultStats:{vmin:Number.POSITIVE_INFINITY,vmax:Number.NEGATIVE_INFINITY,hmin:Number.POSITIVE_INFINITY,hmax:Number.NEGATIVE_INFINITY},collectSimpleStats:function(_394){var _395=lang.delegate(_38d.defaultStats);for(var i=0;i<_394.length;++i){var run=_394[i];for(var j=0;j<run.data.length;j++){if(run.data[j]!==null){if(typeof run.data[j]=="number"){var _396=_395.vmin,_397=_395.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,i){if(val!==null){var x=i+1,y=val;if(isNaN(y)){y=0;}_395.hmin=Math.min(_395.hmin,x);_395.hmax=Math.max(_395.hmax,x);_395.vmin=Math.min(_395.vmin,y);_395.vmax=Math.max(_395.vmax,y);}});}if("ymin" in run){_395.vmin=Math.min(_396,run.ymin);}if("ymax" in run){_395.vmax=Math.max(_397,run.ymax);}}else{var _398=_395.hmin,_399=_395.hmax,_396=_395.vmin,_397=_395.vmax;if(!("xmin" in run)||!("xmax" in run)||!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,i){if(val!==null){var x="x" in val?val.x:i+1,y=val.y;if(isNaN(x)){x=0;}if(isNaN(y)){y=0;}_395.hmin=Math.min(_395.hmin,x);_395.hmax=Math.max(_395.hmax,x);_395.vmin=Math.min(_395.vmin,y);_395.vmax=Math.max(_395.vmax,y);}});}if("xmin" in run){_395.hmin=Math.min(_398,run.xmin);}if("xmax" in run){_395.hmax=Math.max(_399,run.xmax);}if("ymin" in run){_395.vmin=Math.min(_396,run.ymin);}if("ymax" in run){_395.vmax=Math.max(_397,run.ymax);}}break;}}}return _395;},calculateBarSize:function(_39a,opt,_39b){if(!_39b){_39b=1;}var gap=opt.gap,size=(_39a-2*gap)/_39b;if("minBarSize" in opt){size=Math.max(size,opt.minBarSize);}if("maxBarSize" in opt){size=Math.min(size,opt.maxBarSize);}size=Math.max(size,1);gap=(_39a-size*_39b)/2;return {size:size,gap:gap};},collectStackedStats:function(_39c){var _39d=lang.clone(_38d.defaultStats);if(_39c.length){_39d.hmin=Math.min(_39d.hmin,1);_39d.hmax=df.foldl(_39c,"seed, run -> Math.max(seed, run.data.length)",_39d.hmax);for(var i=0;i<_39d.hmax;++i){var v=_39c[0].data[i];v=v&&(typeof v=="number"?v:v.y);if(isNaN(v)){v=0;}_39d.vmin=Math.min(_39d.vmin,v);for(var j=1;j<_39c.length;++j){var t=_39c[j].data[i];t=t&&(typeof t=="number"?t:t.y);if(isNaN(t)){t=0;}v+=t;}_39d.vmax=Math.max(_39d.vmax,v);}}return _39d;},curve:function(a,_39e){var _39f=a.slice(0);if(_39e=="x"){_39f[_39f.length]=_39f[0];}var p=arr.map(_39f,function(item,i){if(i==0){return "M"+item.x+","+item.y;}if(!isNaN(_39e)){var dx=item.x-_39f[i-1].x,dy=_39f[i-1].y;return "C"+(item.x-(_39e-1)*(dx/_39e))+","+dy+" "+(item.x-(dx/_39e))+","+item.y+" "+item.x+","+item.y;}else{if(_39e=="X"||_39e=="x"||_39e=="S"){var p0,p1=_39f[i-1],p2=_39f[i],p3;var bz1x,bz1y,bz2x,bz2y;var f=1/6;if(i==1){if(_39e=="x"){p0=_39f[_39f.length-2];}else{p0=p1;}f=1/3;}else{p0=_39f[i-2];}if(i==(_39f.length-1)){if(_39e=="x"){p3=_39f[1];}else{p3=p2;}f=1/3;}else{p3=_39f[i+1];}var p1p2=Math.sqrt((p2.x-p1.x)*(p2.x-p1.x)+(p2.y-p1.y)*(p2.y-p1.y));var p0p2=Math.sqrt((p2.x-p0.x)*(p2.x-p0.x)+(p2.y-p0.y)*(p2.y-p0.y));var p1p3=Math.sqrt((p3.x-p1.x)*(p3.x-p1.x)+(p3.y-p1.y)*(p3.y-p1.y));var _3a0=p0p2*f;var _3a1=p1p3*f;if(_3a0>p1p2/2&&_3a1>p1p2/2){_3a0=p1p2/2;_3a1=p1p2/2;}else{if(_3a0>p1p2/2){_3a0=p1p2/2;_3a1=p1p2/2*p1p3/p0p2;}else{if(_3a1>p1p2/2){_3a1=p1p2/2;_3a0=p1p2/2*p0p2/p1p3;}}}if(_39e=="S"){if(p0==p1){_3a0=0;}if(p2==p3){_3a1=0;}}bz1x=p1.x+_3a0*(p2.x-p0.x)/p0p2;bz1y=p1.y+_3a0*(p2.y-p0.y)/p0p2;bz2x=p2.x-_3a1*(p3.x-p1.x)/p1p3;bz2y=p2.y-_3a1*(p3.y-p1.y)/p1p3;}}return "C"+(bz1x+","+bz1y+" "+bz2x+","+bz2y+" "+p2.x+","+p2.y);});return p.join(" ");},getLabel:function(_3a2,_3a3,_3a4){return sc.doIfLoaded("dojo/number",function(_3a5){return (_3a3?_3a5.format(_3a2,{places:_3a4}):_3a5.format(_3a2))||"";},function(){return _3a3?_3a2.toFixed(_3a4):_3a2.toString();});}});});},"dijit/_Widget":function(){define("dijit/_Widget",["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_3a6,_3a7,_3a8,_3a9,has,_3aa,lang,_3ab,_3ac,_3ad,_3ae,_3af,_3b0){function _3b1(){};function _3b2(_3b3){return function(obj,_3b4,_3b5,_3b6){if(obj&&typeof _3b4=="string"&&obj[_3b4]==_3b1){return obj.on(_3b4.substring(2).toLowerCase(),lang.hitch(_3b5,_3b6));}return _3b3.apply(_3a8,arguments);};};_3a6.around(_3a8,"connect",_3b2);if(_3aa.connect){_3a6.around(_3aa,"connect",_3b2);}var _3b7=_3a9("dijit._Widget",[_3ae,_3af,_3b0],{onClick:_3b1,onDblClick:_3b1,onKeyDown:_3b1,onKeyPress:_3b1,onKeyUp:_3b1,onMouseDown:_3b1,onMouseMove:_3b1,onMouseOut:_3b1,onMouseOver:_3b1,onMouseLeave:_3b1,onMouseEnter:_3b1,onMouseUp:_3b1,constructor:function(_3b8){this._toConnect={};for(var name in _3b8){if(this[name]===_3b1){this._toConnect[name.replace(/^on/,"").toLowerCase()]=_3b8[name];delete _3b8[name];}}},postCreate:function(){this.inherited(arguments);for(var name in this._toConnect){this.on(name,this._toConnect[name]);}delete this._toConnect;},on:function(type,func){if(this[this._onMap(type)]===_3b1){return _3a8.connect(this.domNode,type.toLowerCase(),this,func);}return this.inherited(arguments);},_setFocusedAttr:function(val){this._focused=val;this._set("focused",val);},setAttribute:function(attr,_3b9){_3aa.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");this.set(attr,_3b9);},attr:function(name,_3ba){if(_3a7.isDebug){var _3bb=arguments.callee._ach||(arguments.callee._ach={}),_3bc=(arguments.callee.caller||"unknown caller").toString();if(!_3bb[_3bc]){_3aa.deprecated(this.declaredClass+"::attr() is deprecated. Use get() or set() instead, called from "+_3bc,"","2.0");_3bb[_3bc]=true;}}var args=arguments.length;if(args>=2||typeof name==="object"){return this.set.apply(this,arguments);}else{return this.get(name);}},getDescendants:function(){_3aa.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");return this.containerNode?_3ab("[widgetId]",this.containerNode).map(_3ad.byNode):[];},_onShow:function(){this.onShow();},onShow:function(){},onHide:function(){},onClose:function(){return true;}});if(has("dijit-legacy-requires")){_3ac(0,function(){var _3bd=["dijit/_base"];require(_3bd);});}return _3b7;});},"dojo/cache":function(){define(["./_base/kernel","./text"],function(dojo){return dojo.cache;});},"dijit/_OnDijitClickMixin":function(){define("dijit/_OnDijitClickMixin",["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","dojo/_base/unload","dojo/_base/window","./a11yclick"],function(on,_3be,keys,_3bf,has,_3c0,win,_3c1){var ret=_3bf("dijit._OnDijitClickMixin",null,{connect:function(obj,_3c2,_3c3){return this.inherited(arguments,[obj,_3c2=="ondijitclick"?_3c1:_3c2,_3c3]);}});ret.a11yclick=_3c1;return ret;});},"dijit/_FocusMixin":function(){define("dijit/_FocusMixin",["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(_3c4,_3c5,_3c6,lang){lang.extend(_3c5,{focused:false,onFocus:function(){},onBlur:function(){},_onFocus:function(){this.onFocus();},_onBlur:function(){this.onBlur();}});return _3c6("dijit._FocusMixin",null,{_focusManager:_3c4});});},"dojox/charting/plot2d/Bars":function(){define("dojox/charting/plot2d/Bars",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./CartesianBase","./_PlotEvents","./common","dojox/gfx/fx","dojox/lang/utils","dojox/lang/functional","dojox/lang/functional/reversed"],function(dojo,lang,arr,_3c7,_3c8,_3c9,dc,fx,du,df,dfr){var _3ca=dfr.lambda("item.purgeGroup()");return _3c7("dojox.charting.plot2d.Bars",[_3c8,_3c9],{defaultParams:{hAxis:"x",vAxis:"y",gap:0,animate:null,enableCache:false},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},styleFunc:null,font:"",fontColor:""},constructor:function(_3cb,_3cc){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_3cc);du.updateWithPattern(this.opt,_3cc,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},getSeriesStats:function(){var _3cd=dc.collectSimpleStats(this.series),t;_3cd.hmin-=0.5;_3cd.hmax+=0.5;t=_3cd.hmin,_3cd.hmin=_3cd.vmin,_3cd.vmin=t;t=_3cd.hmax,_3cd.hmax=_3cd.vmax,_3cd.vmax=t;return _3cd;},createRect:function(run,_3ce,_3cf){var rect;if(this.opt.enableCache&&run._rectFreePool.length>0){rect=run._rectFreePool.pop();rect.setShape(_3cf);_3ce.add(rect);}else{rect=_3ce.createRect(_3cf);}if(this.opt.enableCache){run._rectUsePool.push(rect);}return rect;},render:function(dim,_3d0){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_3d0);}this.dirty=this.isDirty();this.resetEvents();var s;if(this.dirty){arr.forEach(this.series,_3ca);this._eventSeries={};this.cleanGroup();s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_3d1=Math.max(0,this._hScaler.bounds.lower),_3d2=ht(_3d1),_3d3=this.events();var bar=this.getBarProperties();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._rectFreePool=(run._rectFreePool?run._rectFreePool:[]).concat(run._rectUsePool?run._rectUsePool:[]);run._rectUsePool=[];}var _3d4=t.next("bar",[this.opt,run]),_3d5=new Array(run.data.length);s=run.group;var _3d6=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var min=_3d6?Math.max(0,Math.floor(this._vScaler.bounds.from-1)):0;var max=_3d6?Math.min(run.data.length,Math.ceil(this._vScaler.bounds.to)):run.data.length;for(var j=min;j<max;++j){var _3d7=run.data[j];if(_3d7!=null){var val=this.getValue(_3d7,j,i,_3d6),hv=ht(val.y),w=Math.abs(hv-_3d2),_3d8,_3d9;if(this.opt.styleFunc||typeof _3d7!="number"){var _3da=typeof _3d7!="number"?[_3d7]:[];if(this.opt.styleFunc){_3da.push(this.opt.styleFunc(_3d7));}_3d8=t.addMixin(_3d4,"bar",_3da,true);}else{_3d8=t.post(_3d4,"bar");}if(w>=0&&bar.height>=1){var rect={x:_3d0.l+(val.y<_3d1?hv:_3d2),y:dim.height-_3d0.b-vt(val.x+1.5)+bar.gap+bar.thickness*(this.series.length-i-1),width:w,height:bar.height};if(_3d8.series.shadow){var _3db=lang.clone(rect);_3db.x+=_3d8.series.shadow.dx;_3db.y+=_3d8.series.shadow.dy;_3d9=this.createRect(run,s,_3db).setFill(_3d8.series.shadow.color).setStroke(_3d8.series.shadow);if(this.animate){this._animateBar(_3d9,_3d0.l+_3d2,-w);}}var _3dc=this._plotFill(_3d8.series.fill,dim,_3d0);_3dc=this._shapeFill(_3dc,rect);var _3dd=this.createRect(run,s,rect).setFill(_3dc).setStroke(_3d8.series.stroke);run.dyn.fill=_3dd.getFill();run.dyn.stroke=_3dd.getStroke();if(_3d3){var o={element:"bar",index:j,run:run,shape:_3dd,shadow:_3d9,x:val.y,y:val.x+1.5};this._connectEvents(o);_3d5[j]=o;}if(this.animate){this._animateBar(_3dd,_3d0.l+_3d2,-w);}}}}this._eventSeries[run.name]=_3d5;run.dirty=false;}this.dirty=false;return this;},getValue:function(_3de,j,_3df,_3e0){var y,x;if(_3e0){if(typeof _3de=="number"){y=_3de;}else{y=_3de.y;}x=j;}else{y=_3de.y;x=_3de.x-1;}return {y:y,x:x};},getBarProperties:function(){var f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);return {gap:f.gap,height:f.size,thickness:0};},_animateBar:function(_3e1,_3e2,_3e3){if(_3e3==0){_3e3=1;}fx.animateTransform(lang.delegate({shape:_3e1,duration:1200,transform:[{name:"translate",start:[_3e2-(_3e2/_3e3),0],end:[0,0]},{name:"scale",start:[1/_3e3,1],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/gfx/_base":function(){define("dojox/gfx/_base",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/Color","dojo/_base/sniff","dojo/_base/window","dojo/_base/array","dojo/dom","dojo/dom-construct","dojo/dom-geometry"],function(_3e4,lang,_3e5,has,win,arr,dom,_3e6,_3e7){var g=lang.getObject("dojox.gfx",true),b=g._base={};g._hasClass=function(node,_3e8){var cls=node.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+_3e8+" ")>=0;};g._addClass=function(node,_3e9){var cls=node.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+_3e9+" ")<0){node.setAttribute("className",cls+(cls?" ":"")+_3e9);}};g._removeClass=function(node,_3ea){var cls=node.getAttribute("className");if(cls){node.setAttribute("className",cls.replace(new RegExp("(^|\\s+)"+_3ea+"(\\s+|$)"),"$1$2"));}};b._getFontMeasurements=function(){var _3eb={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};var p;if(has("ie")){win.doc.documentElement.style.fontSize="100%";}var div=_3e6.create("div",{style:{position:"absolute",left:"0",top:"-100px",width:"30px",height:"1000em",borderWidth:"0",margin:"0",padding:"0",outline:"none",lineHeight:"1",overflow:"hidden"}},win.body());for(p in _3eb){div.style.fontSize=p;_3eb[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}win.body().removeChild(div);return _3eb;};var _3ec=null;b._getCachedFontMeasurements=function(_3ed){if(_3ed||!_3ec){_3ec=b._getFontMeasurements();}return _3ec;};var _3ee=null,_3ef={};b._getTextBox=function(text,_3f0,_3f1){var m,s,al=arguments.length;var i;if(!_3ee){_3ee=_3e6.create("div",{style:{position:"absolute",top:"-10000px",left:"0"}},win.body());}m=_3ee;m.className="";s=m.style;s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";if(al>1&&_3f0){for(i in _3f0){if(i in _3ef){continue;}s[i]=_3f0[i];}}if(al>2&&_3f1){m.className=_3f1;}m.innerHTML=text;if(m["getBoundingClientRect"]){var bcr=m.getBoundingClientRect();return {l:bcr.left,t:bcr.top,w:bcr.width||(bcr.right-bcr.left),h:bcr.height||(bcr.bottom-bcr.top)};}else{return _3e7.getMarginBox(m);}};var _3f2=0;b._getUniqueId=function(){var id;do{id=_3e4._scopeName+"xUnique"+(++_3f2);}while(dom.byId(id));return id;};lang.mixin(g,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},getDefault:(function(){var _3f3={};return function(type){var t=_3f3[type];if(t){return new t();}t=_3f3[type]=new Function();t.prototype=g["default"+type];return new t();};})(),normalizeColor:function(_3f4){return (_3f4 instanceof _3e5)?_3f4:new _3e5(_3f4);},normalizeParameters:function(_3f5,_3f6){var x;if(_3f6){var _3f7={};for(x in _3f5){if(x in _3f6&&!(x in _3f7)){_3f5[x]=_3f6[x];}}}return _3f5;},makeParameters:function(_3f8,_3f9){var i=null;if(!_3f9){return lang.delegate(_3f8);}var _3fa={};for(i in _3f8){if(!(i in _3fa)){_3fa[i]=lang.clone((i in _3f9)?_3f9[i]:_3f8[i]);}}return _3fa;},formatNumber:function(x,_3fb){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var _3fc=val.indexOf(".");if(_3fc>=0&&val.length-_3fc>5){val=x.toFixed(4);}}if(x<0){return val;}return _3fb?" "+val:val;},makeFontString:function(font){return font.style+" "+font.variant+" "+font.weight+" "+font.size+" "+font.family;},splitFontString:function(str){var font=g.getDefault("Font");var t=str.split(/\s+/);do{if(t.length<5){break;}font.style=t[0];font.variant=t[1];font.weight=t[2];var i=t[3].indexOf("/");font.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;}else{if(t[4].charAt(0)=="/"){j=5;}}}if(j<t.length){font.family=t.slice(j).join(" ");}}while(false);return font;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return g._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*g.px_in_pt();},px2pt:function(len){return len/g.px_in_pt();},normalizedLength:function(len){if(len.length===0){return 0;}if(len.length>2){var _3fd=g.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_3fd;case "in":return val*72*_3fd;case "pc":return val*12*_3fd;case "mm":return val*g.mm_in_pt*_3fd;case "cm":return val*g.cm_in_pt*_3fd;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-Za-z])|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,equalSources:function(a,b){return a&&b&&a===b;},switchTo:function(_3fe){var ns=typeof _3fe=="string"?g[_3fe]:_3fe;if(ns){arr.forEach(["Group","Rect","Ellipse","Circle","Line","Polyline","Image","Text","Path","TextPath","Surface","createSurface","fixTarget"],function(name){g[name]=ns[name];});}}});return g;});},"dojox/charting/plot2d/CartesianBase":function(){define("dojox/charting/plot2d/CartesianBase",["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","./Base","../scaler/primitive","dojox/gfx/fx"],function(lang,_3ff,hub,Base,_400,fx){return _3ff("dojox.charting.plot2d.CartesianBase",Base,{constructor:function(_401,_402){this.axes=["hAxis","vAxis"];this.zoom=null,this.zoomQueue=[];this.lastWindow={vscale:1,hscale:1,xoffset:0,yoffset:0};},clear:function(){this.inherited(arguments);this._hAxis=null;this._vAxis=null;return this;},cleanGroup:function(_403){this.inherited(arguments,[_403||this.chart.plotGroup]);},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},toPage:function(_404){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromModel(sh),tv=sv.scaler.getTransformerFromModel(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_405){var r={};r.x=th(_405[ah.name])+c.x+o.l;r.y=c.y+dim.height-o.b-tv(_405[av.name]);return r;};return _404?t(_404):t;},toData:function(_406){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromPlot(sh),tv=sv.scaler.getTransformerFromPlot(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_407){var r={};r[ah.name]=th(_407.x-c.x-o.l);r[av.name]=tv(c.y+dim.height-_407.y-o.b);return r;};return _406?t(_406):t;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},performZoom:function(dim,_408){var vs=this._vAxis.scale||1,hs=this._hAxis.scale||1,_409=dim.height-_408.b,_40a=this._hScaler.bounds,_40b=(_40a.from-_40a.lower)*_40a.scale,_40c=this._vScaler.bounds,_40d=(_40c.from-_40c.lower)*_40c.scale,_40e=vs/this.lastWindow.vscale,_40f=hs/this.lastWindow.hscale,_410=(this.lastWindow.xoffset-_40b)/((this.lastWindow.hscale==1)?hs:this.lastWindow.hscale),_411=(_40d-this.lastWindow.yoffset)/((this.lastWindow.vscale==1)?vs:this.lastWindow.vscale),_412=this.group,anim=fx.animateTransform(lang.delegate({shape:_412,duration:1200,transform:[{name:"translate",start:[0,0],end:[_408.l*(1-_40f),_409*(1-_40e)]},{name:"scale",start:[1,1],end:[_40f,_40e]},{name:"original"},{name:"translate",start:[0,0],end:[_410,_411]}]},this.zoom));lang.mixin(this.lastWindow,{vscale:vs,hscale:hs,xoffset:_40b,yoffset:_40d});this.zoomQueue.push(anim);hub.connect(anim,"onEnd",this,function(){this.zoom=null;this.zoomQueue.shift();if(this.zoomQueue.length>0){this.zoomQueue[0].play();}});if(this.zoomQueue.length==1){this.zoomQueue[0].play();}return this;},initializeScalers:function(dim,_413){if(this._hAxis){if(!this._hAxis.initialized()){this._hAxis.calculate(_413.hmin,_413.hmax,dim.width);}this._hScaler=this._hAxis.getScaler();}else{this._hScaler=_400.buildScaler(_413.hmin,_413.hmax,dim.width);}if(this._vAxis){if(!this._vAxis.initialized()){this._vAxis.calculate(_413.vmin,_413.vmax,dim.height);}this._vScaler=this._vAxis.getScaler();}else{this._vScaler=_400.buildScaler(_413.vmin,_413.vmax,dim.height);}return this;}});});},"dijit/focus":function(){define("dijit/focus",["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/ready","dojo/sniff","dojo/Stateful","dojo/_base/unload","dojo/_base/window","dojo/window","./a11y","./registry","./main"],function(_414,_415,dom,_416,_417,_418,lang,on,_419,has,_41a,_41b,win,_41c,a11y,_41d,_41e){var _41f=_415([_41a,_418],{curNode:null,activeStack:[],constructor:function(){var _420=lang.hitch(this,function(node){if(dom.isDescendant(this.curNode,node)){this.set("curNode",null);}if(dom.isDescendant(this.prevNode,node)){this.set("prevNode",null);}});_414.before(_417,"empty",_420);_414.before(_417,"destroy",_420);},registerIframe:function(_421){return this.registerWin(_421.contentWindow,_421);},registerWin:function(_422,_423){var _424=this;var _425=function(evt){_424._justMouseDowned=true;setTimeout(function(){_424._justMouseDowned=false;},0);if(has("ie")&&evt&&evt.srcElement&&evt.srcElement.parentNode==null){return;}_424._onTouchNode(_423||evt.target||evt.srcElement,"mouse");};var doc=has("ie")?_422.document.documentElement:_422.document;if(doc){if(has("ie")){_422.document.body.attachEvent("onmousedown",_425);var _426=function(evt){var tag=evt.srcElement.tagName.toLowerCase();if(tag=="#document"||tag=="body"){return;}if(a11y.isTabNavigable(evt.srcElement)){_424._onFocusNode(_423||evt.srcElement);}else{_424._onTouchNode(_423||evt.srcElement);}};doc.attachEvent("onfocusin",_426);var _427=function(evt){_424._onBlurNode(_423||evt.srcElement);};doc.attachEvent("onfocusout",_427);return {remove:function(){_422.document.detachEvent("onmousedown",_425);doc.detachEvent("onfocusin",_426);doc.detachEvent("onfocusout",_427);doc=null;}};}else{doc.body.addEventListener("mousedown",_425,true);doc.body.addEventListener("touchstart",_425,true);var _428=function(evt){_424._onFocusNode(_423||evt.target);};doc.addEventListener("focus",_428,true);var _429=function(evt){_424._onBlurNode(_423||evt.target);};doc.addEventListener("blur",_429,true);return {remove:function(){doc.body.removeEventListener("mousedown",_425,true);doc.body.removeEventListener("touchstart",_425,true);doc.removeEventListener("focus",_428,true);doc.removeEventListener("blur",_429,true);doc=null;}};}}},_onBlurNode:function(node){if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);}this._clearFocusTimer=setTimeout(lang.hitch(this,function(){this.set("prevNode",this.curNode);this.set("curNode",null);}),0);if(this._justMouseDowned){return;}if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);}this._clearActiveWidgetsTimer=setTimeout(lang.hitch(this,function(){delete this._clearActiveWidgetsTimer;this._setStack([]);}),0);},_onTouchNode:function(node,by){if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);delete this._clearActiveWidgetsTimer;}var _42a=[];try{while(node){var _42b=_416.get(node,"dijitPopupParent");if(_42b){node=_41d.byId(_42b).domNode;}else{if(node.tagName&&node.tagName.toLowerCase()=="body"){if(node===win.body()){break;}node=_41c.get(node.ownerDocument).frameElement;}else{var id=node.getAttribute&&node.getAttribute("widgetId"),_42c=id&&_41d.byId(id);if(_42c&&!(by=="mouse"&&_42c.get("disabled"))){_42a.unshift(id);}node=node.parentNode;}}}}catch(e){}this._setStack(_42a,by);},_onFocusNode:function(node){if(!node){return;}if(node.nodeType==9){return;}if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);delete this._clearFocusTimer;}this._onTouchNode(node);if(node==this.curNode){return;}this.set("prevNode",this.curNode);this.set("curNode",node);},_setStack:function(_42d,by){var _42e=this.activeStack;this.set("activeStack",_42d);for(var _42f=0;_42f<Math.min(_42e.length,_42d.length);_42f++){if(_42e[_42f]!=_42d[_42f]){break;}}var _430;for(var i=_42e.length-1;i>=_42f;i--){_430=_41d.byId(_42e[i]);if(_430){_430._hasBeenBlurred=true;_430.set("focused",false);if(_430._focusManager==this){_430._onBlur(by);}this.emit("widget-blur",_430,by);}}for(i=_42f;i<_42d.length;i++){_430=_41d.byId(_42d[i]);if(_430){_430.set("focused",true);if(_430._focusManager==this){_430._onFocus(by);}this.emit("widget-focus",_430,by);}}},focus:function(node){if(node){try{node.focus();}catch(e){}}}});var _431=new _41f();_419(function(){var _432=_431.registerWin(_41c.get(win.doc));if(has("ie")){_41b.addOnWindowUnload(function(){if(_432){_432.remove();_432=null;}});}});_41e.focus=function(node){_431.focus(node);};for(var attr in _431){if(!/^_/.test(attr)){_41e.focus[attr]=typeof _431[attr]=="function"?lang.hitch(_431,attr):_431[attr];}}_431.watch(function(attr,_433,_434){_41e.focus[attr]=_434;});return _431;});},"dojox/charting/widget/Legend":function(){define("dojox/charting/widget/Legend",["dojo/_base/lang","dojo/_base/declare","dijit/_WidgetBase","dojox/gfx","dojo/_base/array","dojox/lang/functional","dojox/lang/functional/array","dojox/lang/functional/fold","dojo/dom","dojo/dom-construct","dojo/dom-class","dijit/registry"],function(lang,_435,_436,gfx,_437,df,dfa,dff,dom,_438,_439,_43a){var _43b=/\.(StackedColumns|StackedAreas|ClusteredBars)$/;return _435("dojox.charting.widget.Legend",_436,{chartRef:"",horizontal:true,swatchSize:18,legendBody:null,postCreate:function(){if(!this.chart&&this.chartRef){this.chart=_43a.byId(this.chartRef)||_43a.byNode(dom.byId(this.chartRef));if(!this.chart){}}this.chart=this.chart.chart||this.chart;this.refresh();},buildRendering:function(){this.domNode=_438.create("table",{role:"group","aria-label":"chart legend","class":"dojoxLegendNode"});this.legendBody=_438.create("tbody",null,this.domNode);this.inherited(arguments);},destroy:function(){if(this._surfaces){_437.forEach(this._surfaces,function(_43c){_43c.destroy();});}this.inherited(arguments);},refresh:function(){if(this._surfaces){_437.forEach(this._surfaces,function(_43d){_43d.destroy();});}this._surfaces=[];while(this.legendBody.lastChild){_438.destroy(this.legendBody.lastChild);}if(this.horizontal){_439.add(this.domNode,"dojoxLegendHorizontal");this._tr=_438.create("tr",null,this.legendBody);this._inrow=0;}var s=this.series||this.chart.series;if(s.length==0){return;}if(s[0].chart.stack[0].declaredClass=="dojox.charting.plot2d.Pie"){var t=s[0].chart.stack[0];if(typeof t.run.data[0]=="number"){var _43e=df.map(t.run.data,"Math.max(x, 0)");var _43f=df.map(_43e,"/this",df.foldl(_43e,"+",0));_437.forEach(_43f,function(x,i){this._addLabel(t.dyn[i],t._getLabel(x*100)+"%");},this);}else{_437.forEach(t.run.data,function(x,i){this._addLabel(t.dyn[i],x.legend||x.text||x.y);},this);}}else{if(this._isReversal()){s=s.slice(0).reverse();}_437.forEach(s,function(x){this._addLabel(x.dyn,x.legend||x.name);},this);}},_addLabel:function(dyn,_440){var _441=_438.create("td"),icon=_438.create("div",null,_441),text=_438.create("label",null,_441),div=_438.create("div",{style:{"width":this.swatchSize+"px","height":this.swatchSize+"px","float":"left"}},icon);_439.add(icon,"dojoxLegendIcon dijitInline");_439.add(text,"dojoxLegendText");if(this._tr){this._tr.appendChild(_441);if(++this._inrow===this.horizontal){this._tr=_438.create("tr",null,this.legendBody);this._inrow=0;}}else{var tr=_438.create("tr",null,this.legendBody);tr.appendChild(_441);}this._makeIcon(div,dyn);text.innerHTML=String(_440);text.dir=this.getTextDir(_440,text.dir);},_makeIcon:function(div,dyn){var mb={h:this.swatchSize,w:this.swatchSize};var _442=gfx.createSurface(div,mb.w,mb.h);this._surfaces.push(_442);if(dyn.fill){_442.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setFill(dyn.fill).setStroke(dyn.stroke);}else{if(dyn.stroke||dyn.marker){var line={x1:0,y1:mb.h/2,x2:mb.w,y2:mb.h/2};if(dyn.stroke){_442.createLine(line).setStroke(dyn.stroke);}if(dyn.marker){var c={x:mb.w/2,y:mb.h/2};_442.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.markerFill).setStroke(dyn.markerStroke);}}else{_442.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setStroke("black");_442.createLine({x1:2,y1:2,x2:mb.w-2,y2:mb.h-2}).setStroke("black");_442.createLine({x1:2,y1:mb.h-2,x2:mb.w-2,y2:2}).setStroke("black");}}},_isReversal:function(){return (!this.horizontal)&&_437.some(this.chart.stack,function(item){return _43b.test(item.declaredClass);});}});});},"dojox/charting/plot2d/StackedLines":function(){define("dojox/charting/plot2d/StackedLines",["dojo/_base/declare","./Stacked"],function(_443,_444){return _443("dojox.charting.plot2d.StackedLines",_444,{constructor:function(){this.opt.lines=true;}});});},"dojox/charting/plot2d/StackedColumns":function(){define("dojox/charting/plot2d/StackedColumns",["dojo/_base/declare","./Columns","./commonStacked"],function(_445,_446,_447){return _445("dojox.charting.plot2d.StackedColumns",_446,{getSeriesStats:function(){var _448=_447.collectStats(this.series);_448.hmin-=0.5;_448.hmax+=0.5;return _448;},getValue:function(_449,_44a,_44b,_44c){var y,x;if(_44c){x=_44a;y=_447.getIndexValue(this.series,_44b,x);}else{x=_449.x-1;y=_447.getValue(this.series,_44b,_449.x);y=y?y.y:null;}return {y:y,x:x};}});});},"dojox/charting/Series":function(){define("dojox/charting/Series",["dojo/_base/lang","dojo/_base/declare","./Element"],function(lang,_44d,_44e){return _44d("dojox.charting.Series",_44e,{constructor:function(_44f,data,_450){lang.mixin(this,_450);if(typeof this.plot!="string"){this.plot="default";}this.update(data);},clear:function(){this.dyn={};},update:function(data){if(lang.isArray(data)){this.data=data;}else{this.source=data;this.data=this.source.data;if(this.source.setSeriesObject){this.source.setSeriesObject(this);}}this.dirty=true;this.clear();}});});},"dojox/charting/plot2d/Default":function(){define("dojox/charting/plot2d/Default",["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,_451,arr,_452,_453,dc,df,dfr,du,fx){var _454=dfr.lambda("item.purgeGroup()");var _455=1200;return _451("dojox.charting.plot2d.Default",[_452,_453],{defaultParams:{hAxis:"x",vAxis:"y",lines:true,areas:false,markers:false,tension:"",animate:false,enableCache:false,interpolate:false},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},styleFunc:null,font:"",fontColor:"",marker:"",markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:""},constructor:function(_456,_457){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_457);du.updateWithPattern(this.opt,_457,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},createPath:function(run,_458,_459){var path;if(this.opt.enableCache&&run._pathFreePool.length>0){path=run._pathFreePool.pop();path.setShape(_459);_458.add(path);}else{path=_458.createPath(_459);}if(this.opt.enableCache){run._pathUsePool.push(path);}return path;},buildSegments:function(i,_45a){var run=this.series[i],min=_45a?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0,max=_45a?Math.min(run.data.length,Math.ceil(this._hScaler.bounds.to)):run.data.length,rseg=null,_45b=[];for(var j=min;j<max;j++){if(run.data[j]!=null&&(_45a||run.data[j].y!=null)){if(!rseg){rseg=[];_45b.push({index:j,rseg:rseg});}rseg.push((_45a&&run.data[j].hasOwnProperty("y"))?run.data[j].y:run.data[j]);}else{if(!this.opt.interpolate||_45a){rseg=null;}}}return _45b;},render:function(dim,_45c){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_45c);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,_454);this._eventSeries={};this.cleanGroup();this.group.setTransform(null);s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_45d,_45e,_45f,_460=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._pathFreePool=(run._pathFreePool?run._pathFreePool:[]).concat(run._pathUsePool?run._pathUsePool:[]);run._pathUsePool=[];}if(!run.data.length){run.dirty=false;t.skip();continue;}var _461=t.next(this.opt.areas?"area":"line",[this.opt,run],true),_462,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_463=this._eventSeries[run.name]=new Array(run.data.length);s=run.group;var _464=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var _465=this.buildSegments(i,_464);for(var seg=0;seg<_465.length;seg++){var _466=_465[seg];if(_464){_462=arr.map(_466.rseg,function(v,i){return {x:ht(i+_466.index+1)+_45c.l,y:dim.height-_45c.b-vt(v),data:v};},this);}else{_462=arr.map(_466.rseg,function(v){return {x:ht(v.x)+_45c.l,y:dim.height-_45c.b-vt(v.y),data:v};},this);}if(_464&&this.opt.interpolate){while(seg<_465.length){seg++;_466=_465[seg];if(_466){_462=_462.concat(arr.map(_466.rseg,function(v,i){return {x:ht(i+_466.index+1)+_45c.l,y:dim.height-_45c.b-vt(v),data:v};},this));}}}var _467=this.opt.tension?dc.curve(_462,this.opt.tension):"";if(this.opt.areas&&_462.length>1){var fill=this._plotFill(_461.series.fill,dim,_45c),_468=lang.clone(_462);if(this.opt.tension){var _469="L"+_468[_468.length-1].x+","+(dim.height-_45c.b)+" L"+_468[0].x+","+(dim.height-_45c.b)+" L"+_468[0].x+","+_468[0].y;run.dyn.fill=s.createPath(_467+" "+_469).setFill(fill).getFill();}else{_468.push({x:_462[_462.length-1].x,y:dim.height-_45c.b});_468.push({x:_462[0].x,y:dim.height-_45c.b});_468.push(_462[0]);run.dyn.fill=s.createPolyline(_468).setFill(fill).getFill();}}if(this.opt.lines||this.opt.markers){_45d=_461.series.stroke;if(_461.series.outline){_45e=run.dyn.outline=dc.makeStroke(_461.series.outline);_45e.width=2*_45e.width+_45d.width;}}if(this.opt.markers){run.dyn.marker=_461.symbol;}var _46a=null,_46b=null,_46c=null;if(_45d&&_461.series.shadow&&_462.length>1){var _46d=_461.series.shadow,_46e=arr.map(_462,function(c){return {x:c.x+_46d.dx,y:c.y+_46d.dy};});if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_46e,this.opt.tension)).setStroke(_46d).getStroke();}else{run.dyn.shadow=s.createPolyline(_46e).setStroke(_46d).getStroke();}}if(this.opt.markers&&_461.marker.shadow){_46d=_461.marker.shadow;_46c=arr.map(_46e,function(c){return this.createPath(run,s,"M"+c.x+" "+c.y+" "+_461.symbol).setStroke(_46d).setFill(_46d.color);},this);}}if(this.opt.lines&&_462.length>1){if(_45e){if(this.opt.tension){run.dyn.outline=s.createPath(_467).setStroke(_45e).getStroke();}else{run.dyn.outline=s.createPolyline(_462).setStroke(_45e).getStroke();}}if(this.opt.tension){run.dyn.stroke=s.createPath(_467).setStroke(_45d).getStroke();}else{run.dyn.stroke=s.createPolyline(_462).setStroke(_45d).getStroke();}}if(this.opt.markers){var _46f=_461;_46a=new Array(_462.length);_46b=new Array(_462.length);_45e=null;if(_46f.marker.outline){_45e=dc.makeStroke(_46f.marker.outline);_45e.width=2*_45e.width+(_46f.marker.stroke?_46f.marker.stroke.width:0);}arr.forEach(_462,function(c,i){if(this.opt.styleFunc||typeof c.data!="number"){var _470=typeof c.data!="number"?[c.data]:[];if(this.opt.styleFunc){_470.push(this.opt.styleFunc(c.data));}_46f=t.addMixin(_461,"marker",_470,true);}else{_46f=t.post(_461,"marker");}var path="M"+c.x+" "+c.y+" "+_46f.symbol;if(_45e){_46b[i]=this.createPath(run,s,path).setStroke(_45e);}_46a[i]=this.createPath(run,s,path).setStroke(_46f.marker.stroke).setFill(_46f.marker.fill);},this);run.dyn.markerFill=_46f.marker.fill;run.dyn.markerStroke=_46f.marker.stroke;if(_460){arr.forEach(_46a,function(s,i){var o={element:"marker",index:i+_466.index,run:run,shape:s,outline:_46b[i]||null,shadow:_46c&&_46c[i]||null,cx:_462[i].x,cy:_462[i].y};if(_464){o.x=i+_466.index+1;o.y=_466.rseg[i];}else{o.x=_466.rseg[i].x;o.y=_466.rseg[i].y;}this._connectEvents(o);_463[i+_466.index]=o;},this);}else{delete this._eventSeries[run.name];}}}run.dirty=false;}if(this.animate){var _471=this.group;fx.animateTransform(lang.delegate({shape:_471,duration:_455,transform:[{name:"translate",start:[0,dim.height-_45c.b],end:[0,0]},{name:"scale",start:[1,0],end:[1,1]},{name:"original"}]},this.animate)).play();}this.dirty=false;return this;}});});},"dojox/charting/plot2d/Base":function(){define("dojox/charting/plot2d/Base",["dojo/_base/declare","../Element","dojo/_base/array","./common"],function(_472,_473,arr,_474){return _472("dojox.charting.plot2d.Base",_473,{constructor:function(_475,_476){},clear:function(){this.series=[];this.dirty=true;return this;},setAxis:function(axis){return this;},assignAxes:function(axes){arr.forEach(this.axes,function(axis){if(this[axis]){this.setAxis(axes[this[axis]]);}},this);},addSeries:function(run){this.series.push(run);return this;},getSeriesStats:function(){return _474.collectSimpleStats(this.series);},calculateAxes:function(dim){this.initializeScalers(dim,this.getSeriesStats());return this;},initializeScalers:function(){return this;},isDataDirty:function(){return arr.some(this.series,function(item){return item.dirty;});},render:function(dim,_477){return this;},getRequiredColors:function(){return this.series.length;}});});},"dojox/charting/action2d/Tooltip":function(){define("dojox/charting/action2d/Tooltip",["dojo/_base/kernel","dijit/Tooltip","dojo/_base/lang","dojo/_base/declare","dojo/dom-style","./PlotAction","dojox/gfx/matrix","dojox/lang/functional","dojox/lang/functional/scan","dojox/lang/functional/fold"],function(dojo,_478,lang,_479,_47a,_47b,m,df,dfs,dff){var _47c=function(o){var t=o.run&&o.run.data&&o.run.data[o.index];if(t&&typeof t!="number"&&(t.tooltip||t.text)){return t.tooltip||t.text;}if(o.element=="candlestick"){return "<table cellpadding=\"1\" cellspacing=\"0\" border=\"0\" style=\"font-size:0.9em;\">"+"<tr><td>Open:</td><td align=\"right\"><strong>"+o.data.open+"</strong></td></tr>"+"<tr><td>High:</td><td align=\"right\"><strong>"+o.data.high+"</strong></td></tr>"+"<tr><td>Low:</td><td align=\"right\"><strong>"+o.data.low+"</strong></td></tr>"+"<tr><td>Close:</td><td align=\"right\"><strong>"+o.data.close+"</strong></td></tr>"+(o.data.mid!==undefined?"<tr><td>Mid:</td><td align=\"right\"><strong>"+o.data.mid+"</strong></td></tr>":"")+"</table>";}return o.element=="bar"?o.x:o.y;};var pi4=Math.PI/4,pi2=Math.PI/2;return _479("dojox.charting.action2d.Tooltip",_47b,{defaultParams:{text:_47c},optionalParams:{},constructor:function(_47d,plot,_47e){this.text=_47e&&_47e.text?_47e.text:_47c;this.connect();},process:function(o){if(o.type==="onplotreset"||o.type==="onmouseout"){_478.hide(this.aroundRect);this.aroundRect=null;if(o.type==="onplotreset"){delete this.angles;}return;}if(!o.shape||o.type!=="onmouseover"){return;}var _47f={type:"rect"},_480=["after-centered","before-centered"];switch(o.element){case "marker":_47f.x=o.cx;_47f.y=o.cy;_47f.w=_47f.h=1;break;case "circle":_47f.x=o.cx-o.cr;_47f.y=o.cy-o.cr;_47f.w=_47f.h=2*o.cr;break;case "spider_circle":_47f.x=o.cx;_47f.y=o.cy;_47f.w=_47f.h=1;break;case "spider_plot":return;case "column":_480=["above-centered","below-centered"];case "bar":_47f=lang.clone(o.shape.getShape());_47f.w=_47f.width;_47f.h=_47f.height;break;case "candlestick":_47f.x=o.x;_47f.y=o.y;_47f.w=o.width;_47f.h=o.height;break;default:if(!this.angles){if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}}var _481=m._degToRad(o.plot.opt.startAngle),_482=(this.angles[o.index]+this.angles[o.index+1])/2+_481;_47f.x=o.cx+o.cr*Math.cos(_482);_47f.y=o.cy+o.cr*Math.sin(_482);_47f.w=_47f.h=1;if(_481&&(_482<0||_482>2*Math.PI)){_482=Math.abs(2*Math.PI-Math.abs(_482));}if(_482<pi4){}else{if(_482<pi2+pi4){_480=["below-centered","above-centered"];}else{if(_482<Math.PI+pi4){_480=["before-centered","after-centered"];}else{if(_482<2*Math.PI-pi4){_480=["above-centered","below-centered"];}}}}break;}var lt=this.chart.getCoords();_47f.x+=lt.x;_47f.y+=lt.y;_47f.x=Math.round(_47f.x);_47f.y=Math.round(_47f.y);_47f.w=Math.ceil(_47f.w);_47f.h=Math.ceil(_47f.h);this.aroundRect=_47f;var _483=this.text(o);if(this.chart.getTextDir){var _484=(_47a.get(this.chart.node,"direction")=="rtl");var _485=(this.chart.getTextDir(_483)=="rtl");}if(_483){if(_485&&!_484){_478.show("<span dir = 'rtl'>"+_483+"</span>",this.aroundRect,_480);}else{if(!_485&&_484){_478.show("<span dir = 'ltr'>"+_483+"</span>",this.aroundRect,_480);}else{_478.show(_483,this.aroundRect,_480);}}}}});});},"dijit/main":function(){define("dijit/main",["dojo/_base/kernel"],function(dojo){return dojo.dijit;});},"dojox/gfx":function(){require({cache:{"dojox/gfx/_base":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/Color","dojo/_base/sniff","dojo/_base/window","dojo/_base/array","dojo/dom","dojo/dom-construct","dojo/dom-geometry"],function(_486,lang,_487,has,win,arr,dom,_488,_489){var g=lang.getObject("dojox.gfx",true),b=g._base={};g._hasClass=function(node,_48a){var cls=node.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+_48a+" ")>=0;};g._addClass=function(node,_48b){var cls=node.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+_48b+" ")<0){node.setAttribute("className",cls+(cls?" ":"")+_48b);}};g._removeClass=function(node,_48c){var cls=node.getAttribute("className");if(cls){node.setAttribute("className",cls.replace(new RegExp("(^|\\s+)"+_48c+"(\\s+|$)"),"$1$2"));}};b._getFontMeasurements=function(){var _48d={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};var p;if(has("ie")){win.doc.documentElement.style.fontSize="100%";}var div=_488.create("div",{style:{position:"absolute",left:"0",top:"-100px",width:"30px",height:"1000em",borderWidth:"0",margin:"0",padding:"0",outline:"none",lineHeight:"1",overflow:"hidden"}},win.body());for(p in _48d){div.style.fontSize=p;_48d[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}win.body().removeChild(div);return _48d;};var _48e=null;b._getCachedFontMeasurements=function(_48f){if(_48f||!_48e){_48e=b._getFontMeasurements();}return _48e;};var _490=null,_491={};b._getTextBox=function(text,_492,_493){var m,s,al=arguments.length;var i;if(!_490){_490=_488.create("div",{style:{position:"absolute",top:"-10000px",left:"0"}},win.body());}m=_490;m.className="";s=m.style;s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";if(al>1&&_492){for(i in _492){if(i in _491){continue;}s[i]=_492[i];}}if(al>2&&_493){m.className=_493;}m.innerHTML=text;if(m["getBoundingClientRect"]){var bcr=m.getBoundingClientRect();return {l:bcr.left,t:bcr.top,w:bcr.width||(bcr.right-bcr.left),h:bcr.height||(bcr.bottom-bcr.top)};}else{return _489.getMarginBox(m);}};var _494=0;b._getUniqueId=function(){var id;do{id=_486._scopeName+"xUnique"+(++_494);}while(dom.byId(id));return id;};lang.mixin(g,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},getDefault:(function(){var _495={};return function(type){var t=_495[type];if(t){return new t();}t=_495[type]=new Function();t.prototype=g["default"+type];return new t();};})(),normalizeColor:function(_496){return (_496 instanceof _487)?_496:new _487(_496);},normalizeParameters:function(_497,_498){var x;if(_498){var _499={};for(x in _497){if(x in _498&&!(x in _499)){_497[x]=_498[x];}}}return _497;},makeParameters:function(_49a,_49b){var i=null;if(!_49b){return lang.delegate(_49a);}var _49c={};for(i in _49a){if(!(i in _49c)){_49c[i]=lang.clone((i in _49b)?_49b[i]:_49a[i]);}}return _49c;},formatNumber:function(x,_49d){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var _49e=val.indexOf(".");if(_49e>=0&&val.length-_49e>5){val=x.toFixed(4);}}if(x<0){return val;}return _49d?" "+val:val;},makeFontString:function(font){return font.style+" "+font.variant+" "+font.weight+" "+font.size+" "+font.family;},splitFontString:function(str){var font=g.getDefault("Font");var t=str.split(/\s+/);do{if(t.length<5){break;}font.style=t[0];font.variant=t[1];font.weight=t[2];var i=t[3].indexOf("/");font.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;}else{if(t[4].charAt(0)=="/"){j=5;}}}if(j<t.length){font.family=t.slice(j).join(" ");}}while(false);return font;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return g._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*g.px_in_pt();},px2pt:function(len){return len/g.px_in_pt();},normalizedLength:function(len){if(len.length===0){return 0;}if(len.length>2){var _49f=g.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_49f;case "in":return val*72*_49f;case "pc":return val*12*_49f;case "mm":return val*g.mm_in_pt*_49f;case "cm":return val*g.cm_in_pt*_49f;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-Za-z])|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,equalSources:function(a,b){return a&&b&&a===b;},switchTo:function(_4a0){var ns=typeof _4a0=="string"?g[_4a0]:_4a0;if(ns){arr.forEach(["Group","Rect","Ellipse","Circle","Line","Polyline","Image","Text","Path","TextPath","Surface","createSurface","fixTarget"],function(name){g[name]=ns[name];});}}});return g;});},"dojox/gfx/renderer":function(){define("dojox/gfx/renderer",["./_base","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","dojo/_base/config"],function(g,lang,has,win,_4a1){var _4a2=null;return {load:function(id,_4a3,load){if(_4a2&&id!="force"){load(_4a2);return;}var _4a4=_4a1.forceGfxRenderer,_4a5=!_4a4&&(lang.isString(_4a1.gfxRenderer)?_4a1.gfxRenderer:"svg,vml,canvas,silverlight").split(","),_4a6,_4a7;while(!_4a4&&_4a5.length){switch(_4a5.shift()){case "svg":if("SVGAngle" in win.global){_4a4="svg";}break;case "vml":if(has("ie")){_4a4="vml";}break;case "silverlight":try{if(has("ie")){_4a6=new ActiveXObject("AgControl.AgControl");if(_4a6&&_4a6.IsVersionSupported("1.0")){_4a7=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_4a7=true;}}}catch(e){_4a7=false;}finally{_4a6=null;}if(_4a7){_4a4="silverlight";}break;case "canvas":if(win.global.CanvasRenderingContext2D){_4a4="canvas";}break;}}if(_4a4==="canvas"&&_4a1.canvasEvents!==false){_4a4="canvasWithEvents";}if(_4a1.isDebug){}function _4a8(){_4a3(["dojox/gfx/"+_4a4],function(_4a9){g.renderer=_4a4;_4a2=_4a9;load(_4a9);});};if(_4a4=="svg"&&typeof window.svgweb!="undefined"){window.svgweb.addOnLoad(_4a8);}else{_4a8();}}};});}}});define("dojox/gfx",["dojo/_base/lang","./gfx/_base","./gfx/renderer!"],function(lang,_4aa,_4ab){_4aa.switchTo(_4ab);return _4aa;});},"dojox/gfx/shape":function(){define("dojox/gfx/shape",["./_base","dojo/_base/lang","dojo/_base/declare","dojo/_base/kernel","dojo/_base/sniff","dojo/_base/connect","dojo/_base/array","dojo/dom-construct","dojo/_base/Color","./matrix"],function(g,lang,_4ac,_4ad,has,_4ae,arr,_4af,_4b0,_4b1){var _4b2=g.shape={};var _4b3={};var _4b4={};_4b2.register=function(s){var t=s.declaredClass.split(".").pop();var i=t in _4b3?++_4b3[t]:((_4b3[t]=0));var uid=t+i;_4b4[uid]=s;return uid;};_4b2.byId=function(id){return _4b4[id];};_4b2.dispose=function(s,_4b5){if(_4b5&&s.children){for(var i=0;i<s.children.length;++i){_4b2.dispose(s.children[i],true);}}delete _4b4[s.getUID()];};_4b2.Shape=_4ac("dojox.gfx.shape.Shape",null,{constructor:function(){this.rawNode=null;this.shape=null;this.matrix=null;this.fillStyle=null;this.strokeStyle=null;this.bbox=null;this.parent=null;this.parentMatrix=null;var uid=_4b2.register(this);this.getUID=function(){return uid;};},destroy:function(){_4b2.dispose(this);},getNode:function(){return this.rawNode;},getShape:function(){return this.shape;},getTransform:function(){return this.matrix;},getFill:function(){return this.fillStyle;},getStroke:function(){return this.strokeStyle;},getParent:function(){return this.parent;},getBoundingBox:function(){return this.bbox;},getTransformedBoundingBox:function(){var b=this.getBoundingBox();if(!b){return null;}var m=this._getRealMatrix(),gm=_4b1;return [gm.multiplyPoint(m,b.x,b.y),gm.multiplyPoint(m,b.x+b.width,b.y),gm.multiplyPoint(m,b.x+b.width,b.y+b.height),gm.multiplyPoint(m,b.x,b.y+b.height)];},getEventSource:function(){return this.rawNode;},setClip:function(clip){this.clip=clip;},getClip:function(){return this.clip;},setShape:function(_4b6){this.shape=g.makeParameters(this.shape,_4b6);this.bbox=null;return this;},setFill:function(fill){if(!fill){this.fillStyle=null;return this;}var f=null;if(typeof (fill)=="object"&&"type" in fill){switch(fill.type){case "linear":f=g.makeParameters(g.defaultLinearGradient,fill);break;case "radial":f=g.makeParameters(g.defaultRadialGradient,fill);break;case "pattern":f=g.makeParameters(g.defaultPattern,fill);break;}}else{f=g.normalizeColor(fill);}this.fillStyle=f;return this;},setStroke:function(_4b7){if(!_4b7){this.strokeStyle=null;return this;}if(typeof _4b7=="string"||lang.isArray(_4b7)||_4b7 instanceof _4b0){_4b7={color:_4b7};}var s=this.strokeStyle=g.makeParameters(g.defaultStroke,_4b7);s.color=g.normalizeColor(s.color);return this;},setTransform:function(_4b8){this.matrix=_4b1.clone(_4b8?_4b1.normalize(_4b8):_4b1.identity);return this._applyTransform();},_applyTransform:function(){return this;},moveToFront:function(){var p=this.getParent();if(p){p._moveChildToFront(this);this._moveToFront();}return this;},moveToBack:function(){var p=this.getParent();if(p){p._moveChildToBack(this);this._moveToBack();}return this;},_moveToFront:function(){},_moveToBack:function(){},applyRightTransform:function(_4b9){return _4b9?this.setTransform([this.matrix,_4b9]):this;},applyLeftTransform:function(_4ba){return _4ba?this.setTransform([_4ba,this.matrix]):this;},applyTransform:function(_4bb){return _4bb?this.setTransform([this.matrix,_4bb]):this;},removeShape:function(_4bc){if(this.parent){this.parent.remove(this,_4bc);}return this;},_setParent:function(_4bd,_4be){this.parent=_4bd;return this._updateParentMatrix(_4be);},_updateParentMatrix:function(_4bf){this.parentMatrix=_4bf?_4b1.clone(_4bf):null;return this._applyTransform();},_getRealMatrix:function(){var m=this.matrix;var p=this.parent;while(p){if(p.matrix){m=_4b1.multiply(p.matrix,m);}p=p.parent;}return m;}});_4b2._eventsProcessing={connect:function(name,_4c0,_4c1){return _4ae.connect(this.getEventSource(),name,_4b2.fixCallback(this,g.fixTarget,_4c0,_4c1));},disconnect:function(_4c2){_4ae.disconnect(_4c2);}};_4b2.fixCallback=function(_4c3,_4c4,_4c5,_4c6){if(!_4c6){_4c6=_4c5;_4c5=null;}if(lang.isString(_4c6)){_4c5=_4c5||_4ad.global;if(!_4c5[_4c6]){throw (["dojox.gfx.shape.fixCallback: scope[\"",_4c6,"\"] is null (scope=\"",_4c5,"\")"].join(""));}return function(e){return _4c4(e,_4c3)?_4c5[_4c6].apply(_4c5,arguments||[]):undefined;};}return !_4c5?function(e){return _4c4(e,_4c3)?_4c6.apply(_4c5,arguments):undefined;}:function(e){return _4c4(e,_4c3)?_4c6.apply(_4c5,arguments||[]):undefined;};};lang.extend(_4b2.Shape,_4b2._eventsProcessing);_4b2.Container={_init:function(){this.children=[];},openBatch:function(){},closeBatch:function(){},add:function(_4c7){var _4c8=_4c7.getParent();if(_4c8){_4c8.remove(_4c7,true);}this.children.push(_4c7);return _4c7._setParent(this,this._getRealMatrix());},remove:function(_4c9,_4ca){for(var i=0;i<this.children.length;++i){if(this.children[i]==_4c9){if(_4ca){}else{_4c9.parent=null;_4c9.parentMatrix=null;}this.children.splice(i,1);break;}}return this;},clear:function(_4cb){var _4cc;for(var i=0;i<this.children.length;++i){_4cc=this.children[i];_4cc.parent=null;_4cc.parentMatrix=null;if(_4cb){_4cc.destroy();}}this.children=[];return this;},getBoundingBox:function(){if(this.children){var _4cd=null;arr.forEach(this.children,function(_4ce){var bb=_4ce.getBoundingBox();if(bb){var ct=_4ce.getTransform();if(ct){bb=_4b1.multiplyRectangle(ct,bb);}if(_4cd){_4cd.x=Math.min(_4cd.x,bb.x);_4cd.y=Math.min(_4cd.y,bb.y);_4cd.endX=Math.max(_4cd.endX,bb.x+bb.width);_4cd.endY=Math.max(_4cd.endY,bb.y+bb.height);}else{_4cd={x:bb.x,y:bb.y,endX:bb.x+bb.width,endY:bb.y+bb.height};}}});if(_4cd){_4cd.width=_4cd.endX-_4cd.x;_4cd.height=_4cd.endY-_4cd.y;}return _4cd;}return null;},_moveChildToFront:function(_4cf){for(var i=0;i<this.children.length;++i){if(this.children[i]==_4cf){this.children.splice(i,1);this.children.push(_4cf);break;}}return this;},_moveChildToBack:function(_4d0){for(var i=0;i<this.children.length;++i){if(this.children[i]==_4d0){this.children.splice(i,1);this.children.unshift(_4d0);break;}}return this;}};_4b2.Surface=_4ac("dojox.gfx.shape.Surface",null,{constructor:function(){this.rawNode=null;this._parent=null;this._nodes=[];this._events=[];},destroy:function(){arr.forEach(this._nodes,_4af.destroy);this._nodes=[];arr.forEach(this._events,_4ae.disconnect);this._events=[];this.rawNode=null;if(has("ie")){while(this._parent.lastChild){_4af.destroy(this._parent.lastChild);}}else{this._parent.innerHTML="";}this._parent=null;},getEventSource:function(){return this.rawNode;},_getRealMatrix:function(){return null;},isLoaded:true,onLoad:function(_4d1){},whenLoaded:function(_4d2,_4d3){var f=lang.hitch(_4d2,_4d3);if(this.isLoaded){f(this);}else{var h=_4ae.connect(this,"onLoad",function(_4d4){_4ae.disconnect(h);f(_4d4);});}}});lang.extend(_4b2.Surface,_4b2._eventsProcessing);_4b2.Rect=_4ac("dojox.gfx.shape.Rect",_4b2.Shape,{constructor:function(_4d5){this.shape=g.getDefault("Rect");this.rawNode=_4d5;},getBoundingBox:function(){return this.shape;}});_4b2.Ellipse=_4ac("dojox.gfx.shape.Ellipse",_4b2.Shape,{constructor:function(_4d6){this.shape=g.getDefault("Ellipse");this.rawNode=_4d6;},getBoundingBox:function(){if(!this.bbox){var _4d7=this.shape;this.bbox={x:_4d7.cx-_4d7.rx,y:_4d7.cy-_4d7.ry,width:2*_4d7.rx,height:2*_4d7.ry};}return this.bbox;}});_4b2.Circle=_4ac("dojox.gfx.shape.Circle",_4b2.Shape,{constructor:function(_4d8){this.shape=g.getDefault("Circle");this.rawNode=_4d8;},getBoundingBox:function(){if(!this.bbox){var _4d9=this.shape;this.bbox={x:_4d9.cx-_4d9.r,y:_4d9.cy-_4d9.r,width:2*_4d9.r,height:2*_4d9.r};}return this.bbox;}});_4b2.Line=_4ac("dojox.gfx.shape.Line",_4b2.Shape,{constructor:function(_4da){this.shape=g.getDefault("Line");this.rawNode=_4da;},getBoundingBox:function(){if(!this.bbox){var _4db=this.shape;this.bbox={x:Math.min(_4db.x1,_4db.x2),y:Math.min(_4db.y1,_4db.y2),width:Math.abs(_4db.x2-_4db.x1),height:Math.abs(_4db.y2-_4db.y1)};}return this.bbox;}});_4b2.Polyline=_4ac("dojox.gfx.shape.Polyline",_4b2.Shape,{constructor:function(_4dc){this.shape=g.getDefault("Polyline");this.rawNode=_4dc;},setShape:function(_4dd,_4de){if(_4dd&&_4dd instanceof Array){this.inherited(arguments,[{points:_4dd}]);if(_4de&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{this.inherited(arguments,[_4dd]);}return this;},_normalizePoints:function(){var p=this.shape.points,l=p&&p.length;if(l&&typeof p[0]=="number"){var _4df=[];for(var i=0;i<l;i+=2){_4df.push({x:p[i],y:p[i+1]});}this.shape.points=_4df;}},getBoundingBox:function(){if(!this.bbox&&this.shape.points.length){var p=this.shape.points;var l=p.length;var t=p[0];var bbox={l:t.x,t:t.y,r:t.x,b:t.y};for(var i=1;i<l;++i){t=p[i];if(bbox.l>t.x){bbox.l=t.x;}if(bbox.r<t.x){bbox.r=t.x;}if(bbox.t>t.y){bbox.t=t.y;}if(bbox.b<t.y){bbox.b=t.y;}}this.bbox={x:bbox.l,y:bbox.t,width:bbox.r-bbox.l,height:bbox.b-bbox.t};}return this.bbox;}});_4b2.Image=_4ac("dojox.gfx.shape.Image",_4b2.Shape,{constructor:function(_4e0){this.shape=g.getDefault("Image");this.rawNode=_4e0;},getBoundingBox:function(){return this.shape;},setStroke:function(){return this;},setFill:function(){return this;}});_4b2.Text=_4ac(_4b2.Shape,{constructor:function(_4e1){this.fontStyle=null;this.shape=g.getDefault("Text");this.rawNode=_4e1;},getFont:function(){return this.fontStyle;},setFont:function(_4e2){this.fontStyle=typeof _4e2=="string"?g.splitFontString(_4e2):g.makeParameters(g.defaultFont,_4e2);this._setFont();return this;}});_4b2.Creator={createShape:function(_4e3){switch(_4e3.type){case g.defaultPath.type:return this.createPath(_4e3);case g.defaultRect.type:return this.createRect(_4e3);case g.defaultCircle.type:return this.createCircle(_4e3);case g.defaultEllipse.type:return this.createEllipse(_4e3);case g.defaultLine.type:return this.createLine(_4e3);case g.defaultPolyline.type:return this.createPolyline(_4e3);case g.defaultImage.type:return this.createImage(_4e3);case g.defaultText.type:return this.createText(_4e3);case g.defaultTextPath.type:return this.createTextPath(_4e3);}return null;},createGroup:function(){return this.createObject(g.Group);},createRect:function(rect){return this.createObject(g.Rect,rect);},createEllipse:function(_4e4){return this.createObject(g.Ellipse,_4e4);},createCircle:function(_4e5){return this.createObject(g.Circle,_4e5);},createLine:function(line){return this.createObject(g.Line,line);},createPolyline:function(_4e6){return this.createObject(g.Polyline,_4e6);},createImage:function(_4e7){return this.createObject(g.Image,_4e7);},createText:function(text){return this.createObject(g.Text,text);},createPath:function(path){return this.createObject(g.Path,path);},createTextPath:function(text){return this.createObject(g.TextPath,{}).setText(text);},createObject:function(_4e8,_4e9){return null;}};return _4b2;});},"dojox/charting/Chart2D":function(){define("dojox/charting/Chart2D",["dojo/_base/kernel","dojo/_base/lang","..","./Chart","./axis2d/Default","./axis2d/Invisible","./plot2d/Default","./plot2d/Lines","./plot2d/Areas","./plot2d/Markers","./plot2d/MarkersOnly","./plot2d/Scatter","./plot2d/Stacked","./plot2d/StackedLines","./plot2d/StackedAreas","./plot2d/Columns","./plot2d/StackedColumns","./plot2d/ClusteredColumns","./plot2d/Bars","./plot2d/StackedBars","./plot2d/ClusteredBars","./plot2d/Grid","./plot2d/Pie","./plot2d/Bubble","./plot2d/Candlesticks","./plot2d/OHLC","./plot2d/Spider"],function(_4ea,lang,_4eb,_4ec){_4ea.deprecated("dojox.charting.Chart2D","Use dojox.charting.Chart instead and require all other components explicitly","2.0");return lang.setObject("dojox.charting.Chart2D",_4ec);});},"dojox/charting/scaler/linear":function(){define(["dojo/_base/lang","./common"],function(lang,_4ed){var _4ee=lang.getObject("dojox.charting.scaler.linear",true);var _4ef=3,_4f0=_4ed.getNumericLabel;function _4f1(val,text){val=val.toLowerCase();for(var i=text.length-1;i>=0;--i){if(val===text[i]){return true;}}return false;};var _4f2=function(min,max,_4f3,_4f4,_4f5,_4f6,span){_4f3=lang.delegate(_4f3);if(!_4f4){if(_4f3.fixUpper=="major"){_4f3.fixUpper="minor";}if(_4f3.fixLower=="major"){_4f3.fixLower="minor";}}if(!_4f5){if(_4f3.fixUpper=="minor"){_4f3.fixUpper="micro";}if(_4f3.fixLower=="minor"){_4f3.fixLower="micro";}}if(!_4f6){if(_4f3.fixUpper=="micro"){_4f3.fixUpper="none";}if(_4f3.fixLower=="micro"){_4f3.fixLower="none";}}var _4f7=_4f1(_4f3.fixLower,["major"])?Math.floor(_4f3.min/_4f4)*_4f4:_4f1(_4f3.fixLower,["minor"])?Math.floor(_4f3.min/_4f5)*_4f5:_4f1(_4f3.fixLower,["micro"])?Math.floor(_4f3.min/_4f6)*_4f6:_4f3.min,_4f8=_4f1(_4f3.fixUpper,["major"])?Math.ceil(_4f3.max/_4f4)*_4f4:_4f1(_4f3.fixUpper,["minor"])?Math.ceil(_4f3.max/_4f5)*_4f5:_4f1(_4f3.fixUpper,["micro"])?Math.ceil(_4f3.max/_4f6)*_4f6:_4f3.max;if(_4f3.useMin){min=_4f7;}if(_4f3.useMax){max=_4f8;}var _4f9=(!_4f4||_4f3.useMin&&_4f1(_4f3.fixLower,["major"]))?min:Math.ceil(min/_4f4)*_4f4,_4fa=(!_4f5||_4f3.useMin&&_4f1(_4f3.fixLower,["major","minor"]))?min:Math.ceil(min/_4f5)*_4f5,_4fb=(!_4f6||_4f3.useMin&&_4f1(_4f3.fixLower,["major","minor","micro"]))?min:Math.ceil(min/_4f6)*_4f6,_4fc=!_4f4?0:(_4f3.useMax&&_4f1(_4f3.fixUpper,["major"])?Math.round((max-_4f9)/_4f4):Math.floor((max-_4f9)/_4f4))+1,_4fd=!_4f5?0:(_4f3.useMax&&_4f1(_4f3.fixUpper,["major","minor"])?Math.round((max-_4fa)/_4f5):Math.floor((max-_4fa)/_4f5))+1,_4fe=!_4f6?0:(_4f3.useMax&&_4f1(_4f3.fixUpper,["major","minor","micro"])?Math.round((max-_4fb)/_4f6):Math.floor((max-_4fb)/_4f6))+1,_4ff=_4f5?Math.round(_4f4/_4f5):0,_500=_4f6?Math.round(_4f5/_4f6):0,_501=_4f4?Math.floor(Math.log(_4f4)/Math.LN10):0,_502=_4f5?Math.floor(Math.log(_4f5)/Math.LN10):0,_503=span/(max-min);if(!isFinite(_503)){_503=1;}return {bounds:{lower:_4f7,upper:_4f8,from:min,to:max,scale:_503,span:span},major:{tick:_4f4,start:_4f9,count:_4fc,prec:_501},minor:{tick:_4f5,start:_4fa,count:_4fd,prec:_502},micro:{tick:_4f6,start:_4fb,count:_4fe,prec:0},minorPerMajor:_4ff,microPerMinor:_500,scaler:_4ee};};return lang.mixin(_4ee,{buildScaler:function(min,max,span,_504,_505,_506){var h={fixUpper:"none",fixLower:"none",natural:false};if(_504){if("fixUpper" in _504){h.fixUpper=String(_504.fixUpper);}if("fixLower" in _504){h.fixLower=String(_504.fixLower);}if("natural" in _504){h.natural=Boolean(_504.natural);}}_506=!_506||_506<_4ef?_4ef:_506;if("min" in _504){min=_504.min;}if("max" in _504){max=_504.max;}if(_504.includeZero){if(min>0){min=0;}if(max<0){max=0;}}h.min=min;h.useMin=true;h.max=max;h.useMax=true;if("from" in _504){min=_504.from;h.useMin=false;}if("to" in _504){max=_504.to;h.useMax=false;}if(max<=min){return _4f2(min,max,h,0,0,0,span);}if(!_505){_505=max-min;}var mag=Math.floor(Math.log(_505)/Math.LN10),_507=_504&&("majorTickStep" in _504)?_504.majorTickStep:Math.pow(10,mag),_508=0,_509=0,_50a;if(_504&&("minorTickStep" in _504)){_508=_504.minorTickStep;}else{do{_508=_507/10;if(!h.natural||_508>0.9){_50a=_4f2(min,max,h,_507,_508,0,span);if(_50a.bounds.scale*_50a.minor.tick>_506){break;}}_508=_507/5;if(!h.natural||_508>0.9){_50a=_4f2(min,max,h,_507,_508,0,span);if(_50a.bounds.scale*_50a.minor.tick>_506){break;}}_508=_507/2;if(!h.natural||_508>0.9){_50a=_4f2(min,max,h,_507,_508,0,span);if(_50a.bounds.scale*_50a.minor.tick>_506){break;}}return _4f2(min,max,h,_507,0,0,span);}while(false);}if(_504&&("microTickStep" in _504)){_509=_504.microTickStep;_50a=_4f2(min,max,h,_507,_508,_509,span);}else{do{_509=_508/10;if(!h.natural||_509>0.9){_50a=_4f2(min,max,h,_507,_508,_509,span);if(_50a.bounds.scale*_50a.micro.tick>_4ef){break;}}_509=_508/5;if(!h.natural||_509>0.9){_50a=_4f2(min,max,h,_507,_508,_509,span);if(_50a.bounds.scale*_50a.micro.tick>_4ef){break;}}_509=_508/2;if(!h.natural||_509>0.9){_50a=_4f2(min,max,h,_507,_508,_509,span);if(_50a.bounds.scale*_50a.micro.tick>_4ef){break;}}_509=0;}while(false);}return _509?_50a:_4f2(min,max,h,_507,_508,0,span);},buildTicks:function(_50b,_50c){var step,next,tick,_50d=_50b.major.start,_50e=_50b.minor.start,_50f=_50b.micro.start;if(_50c.microTicks&&_50b.micro.tick){step=_50b.micro.tick,next=_50f;}else{if(_50c.minorTicks&&_50b.minor.tick){step=_50b.minor.tick,next=_50e;}else{if(_50b.major.tick){step=_50b.major.tick,next=_50d;}else{return null;}}}var _510=1/_50b.bounds.scale;if(_50b.bounds.to<=_50b.bounds.from||isNaN(_510)||!isFinite(_510)||step<=0||isNaN(step)||!isFinite(step)){return null;}var _511=[],_512=[],_513=[];while(next<=_50b.bounds.to+_510){if(Math.abs(_50d-next)<step/2){tick={value:_50d};if(_50c.majorLabels){tick.label=_4f0(_50d,_50b.major.prec,_50c);}_511.push(tick);_50d+=_50b.major.tick;_50e+=_50b.minor.tick;_50f+=_50b.micro.tick;}else{if(Math.abs(_50e-next)<step/2){if(_50c.minorTicks){tick={value:_50e};if(_50c.minorLabels&&(_50b.minMinorStep<=_50b.minor.tick*_50b.bounds.scale)){tick.label=_4f0(_50e,_50b.minor.prec,_50c);}_512.push(tick);}_50e+=_50b.minor.tick;_50f+=_50b.micro.tick;}else{if(_50c.microTicks){_513.push({value:_50f});}_50f+=_50b.micro.tick;}}next+=step;}return {major:_511,minor:_512,micro:_513};},getTransformerFromModel:function(_514){var _515=_514.bounds.from,_516=_514.bounds.scale;return function(x){return (x-_515)*_516;};},getTransformerFromPlot:function(_517){var _518=_517.bounds.from,_519=_517.bounds.scale;return function(x){return x/_519+_518;};}});});},"dojox/gfx/renderer":function(){define("dojox/gfx/renderer",["./_base","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","dojo/_base/config"],function(g,lang,has,win,_51a){var _51b=null;return {load:function(id,_51c,load){if(_51b&&id!="force"){load(_51b);return;}var _51d=_51a.forceGfxRenderer,_51e=!_51d&&(lang.isString(_51a.gfxRenderer)?_51a.gfxRenderer:"svg,vml,canvas,silverlight").split(","),_51f,_520;while(!_51d&&_51e.length){switch(_51e.shift()){case "svg":if("SVGAngle" in win.global){_51d="svg";}break;case "vml":if(has("ie")){_51d="vml";}break;case "silverlight":try{if(has("ie")){_51f=new ActiveXObject("AgControl.AgControl");if(_51f&&_51f.IsVersionSupported("1.0")){_520=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_520=true;}}}catch(e){_520=false;}finally{_51f=null;}if(_520){_51d="silverlight";}break;case "canvas":if(win.global.CanvasRenderingContext2D){_51d="canvas";}break;}}if(_51d==="canvas"&&_51a.canvasEvents!==false){_51d="canvasWithEvents";}if(_51a.isDebug){}function _521(){_51c(["dojox/gfx/"+_51d],function(_522){g.renderer=_51d;_51b=_522;load(_522);});};if(_51d=="svg"&&typeof window.svgweb!="undefined"){window.svgweb.addOnLoad(_521);}else{_521();}}};});},"dojox/lang/functional":function(){define("dojox/lang/functional",["./functional/lambda","./functional/array","./functional/object"],function(df){return df;});},"dojox/charting/widget/Chart":function(){define("dojox/charting/widget/Chart",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","dojo/dom-attr","dojo/_base/declare","dojo/query","dijit/_WidgetBase","../Chart","dojox/lang/utils","dojox/lang/functional","dojox/lang/functional/lambda"],function(_523,lang,arr,_524,_525,_526,_527,_528,du,df,dfl){var _529,_52a,_52b,_52c,_52d,_52e=function(o){return o;},dc=lang.getObject("dojox.charting");_529=function(node,type,kw){var dp=eval("("+type+".prototype.defaultParams)");var x,attr;for(x in dp){if(x in kw){continue;}attr=node.getAttribute(x);kw[x]=du.coerceType(dp[x],attr==null||typeof attr=="undefined"?dp[x]:attr);}var op=eval("("+type+".prototype.optionalParams)");for(x in op){if(x in kw){continue;}attr=node.getAttribute(x);if(attr!=null){kw[x]=du.coerceType(op[x],attr);}}};_52a=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.axis2d[type]){type=_523._scopeName+"x.charting.axis2d."+type;}var axis=eval("("+type+")");if(axis){kw.type=axis;}}else{type=_523._scopeName+"x.charting.axis2d.Default";}_529(node,type,kw);if(kw.font||kw.fontColor){if(!kw.tick){kw.tick={};}if(kw.font){kw.tick.font=kw.font;}if(kw.fontColor){kw.tick.fontColor=kw.fontColor;}}return o;};_52b=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.plot2d&&dc.plot2d[type]){type=_523._scopeName+"x.charting.plot2d."+type;}var plot=eval("("+type+")");if(plot){kw.type=plot;}}else{type=_523._scopeName+"x.charting.plot2d.Default";}_529(node,type,kw);return o;};_52c=function(node){var plot=node.getAttribute("plot"),type=node.getAttribute("type");if(!plot){plot="default";}var o={plot:plot,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.action2d[type]){type=_523._scopeName+"x.charting.action2d."+type;}var _52f=eval("("+type+")");if(!_52f){return null;}o.action=_52f;}else{return null;}_529(node,type,kw);return o;};_52d=function(node){var ga=lang.partial(_524.get,node);var name=ga("name");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs,t;t=ga("plot");if(t!=null){kw.plot=t;}t=ga("marker");if(t!=null){kw.marker=t;}t=ga("stroke");if(t!=null){kw.stroke=eval("("+t+")");}t=ga("outline");if(t!=null){kw.outline=eval("("+t+")");}t=ga("shadow");if(t!=null){kw.shadow=eval("("+t+")");}t=ga("fill");if(t!=null){kw.fill=eval("("+t+")");}t=ga("font");if(t!=null){kw.font=t;}t=ga("fontColor");if(t!=null){kw.fontColor=eval("("+t+")");}t=ga("legend");if(t!=null){kw.legend=t;}t=ga("data");if(t!=null){o.type="data";o.data=t?arr.map(String(t).split(","),Number):[];return o;}t=ga("array");if(t!=null){o.type="data";o.data=eval("("+t+")");return o;}t=ga("store");if(t!=null){o.type="store";o.data=eval("("+t+")");t=ga("field");o.field=t!=null?t:"value";t=ga("query");if(!!t){kw.query=t;}t=ga("queryOptions");if(!!t){kw.queryOptions=eval("("+t+")");}t=ga("start");if(!!t){kw.start=Number(t);}t=ga("count");if(!!t){kw.count=Number(t);}t=ga("sort");if(!!t){kw.sort=eval("("+t+")");}t=ga("valueFn");if(!!t){kw.valueFn=dfl.lambda(t);}return o;}return null;};return _525("dojox.charting.widget.Chart",_527,{theme:null,margins:null,stroke:undefined,fill:undefined,buildRendering:function(){this.inherited(arguments);n=this.domNode;var axes=_526("> .axis",n).map(_52a).filter(_52e),_530=_526("> .plot",n).map(_52b).filter(_52e),_531=_526("> .action",n).map(_52c).filter(_52e),_532=_526("> .series",n).map(_52d).filter(_52e);n.innerHTML="";var c=this.chart=new _528(n,{margins:this.margins,stroke:this.stroke,fill:this.fill,textDir:this.textDir});if(this.theme){c.setTheme(this.theme);}axes.forEach(function(axis){c.addAxis(axis.name,axis.kwArgs);});_530.forEach(function(plot){c.addPlot(plot.name,plot.kwArgs);});this.actions=_531.map(function(_533){return new _533.action(c,_533.plot,_533.kwArgs);});var _534=df.foldl(_532,function(_535,_536){if(_536.type=="data"){c.addSeries(_536.name,_536.data,_536.kwArgs);_535=true;}else{c.addSeries(_536.name,[0],_536.kwArgs);var kw={};du.updateWithPattern(kw,_536.kwArgs,{"query":"","queryOptions":null,"start":0,"count":1},true);if(_536.kwArgs.sort){kw.sort=lang.clone(_536.kwArgs.sort);}lang.mixin(kw,{onComplete:function(data){var _537;if("valueFn" in _536.kwArgs){var fn=_536.kwArgs.valueFn;_537=arr.map(data,function(x){return fn(_536.data.getValue(x,_536.field,0));});}else{_537=arr.map(data,function(x){return _536.data.getValue(x,_536.field,0);});}c.addSeries(_536.name,_537,_536.kwArgs).render();}});_536.data.fetch(kw);}return _535;},false);if(_534){c.render();}},destroy:function(){this.chart.destroy();this.inherited(arguments);},resize:function(box){this.chart.resize(box);}});});},"dojox/charting/scaler/common":function(){define("dojox/charting/scaler/common",["dojo/_base/lang"],function(lang){var eq=function(a,b){return Math.abs(a-b)<=0.000001*(Math.abs(a)+Math.abs(b));};var _538=lang.getObject("dojox.charting.scaler.common",true);var _539={};return lang.mixin(_538,{doIfLoaded:function(_53a,_53b,_53c){if(_539[_53a]==undefined){try{_539[_53a]=require(_53a);}catch(e){_539[_53a]=null;}}if(_539[_53a]){return _53b(_539[_53a]);}else{return _53c();}},getNumericLabel:function(_53d,_53e,_53f){var def="";_538.doIfLoaded("dojo/number",function(_540){def=(_53f.fixed?_540.format(_53d,{places:_53e<0?-_53e:0}):_540.format(_53d))||"";},function(){def=_53f.fixed?_53d.toFixed(_53e<0?-_53e:0):_53d.toString();});if(_53f.labelFunc){var r=_53f.labelFunc(def,_53d,_53e);if(r){return r;}}if(_53f.labels){var l=_53f.labels,lo=0,hi=l.length;while(lo<hi){var mid=Math.floor((lo+hi)/2),val=l[mid].value;if(val<_53d){lo=mid+1;}else{hi=mid;}}if(lo<l.length&&eq(l[lo].value,_53d)){return l[lo].text;}--lo;if(lo>=0&&lo<l.length&&eq(l[lo].value,_53d)){return l[lo].text;}lo+=2;if(lo<l.length&&eq(l[lo].value,_53d)){return l[lo].text;}}return def;}});});},"dojox/charting/axis2d/common":function(){define("dojox/charting/axis2d/common",["dojo/_base/lang","dojo/_base/window","dojo/dom-geometry","dojox/gfx"],function(lang,win,_541,g){var _542=lang.getObject("dojox.charting.axis2d.common",true);var _543=function(s){s.marginLeft="0px";s.marginTop="0px";s.marginRight="0px";s.marginBottom="0px";s.paddingLeft="0px";s.paddingTop="0px";s.paddingRight="0px";s.paddingBottom="0px";s.borderLeftWidth="0px";s.borderTopWidth="0px";s.borderRightWidth="0px";s.borderBottomWidth="0px";};var _544=function(n){if(n["getBoundingClientRect"]){var bcr=n.getBoundingClientRect();return bcr.width||(bcr.right-bcr.left);}else{return _541.getMarginBox(n).w;}};return lang.mixin(_542,{createText:{gfx:function(_545,_546,x,y,_547,text,font,_548){return _546.createText({x:x,y:y,text:text,align:_547}).setFont(font).setFill(_548);},html:function(_549,_54a,x,y,_54b,text,font,_54c,_54d){var p=win.doc.createElement("div"),s=p.style,_54e;if(_549.getTextDir){p.dir=_549.getTextDir(text);}_543(s);s.font=font;p.innerHTML=String(text).replace(/\s/g,"&nbsp;");s.color=_54c;s.position="absolute";s.left="-10000px";win.body().appendChild(p);var size=g.normalizedLength(g.splitFontString(font).size);if(!_54d){_54e=_544(p);}if(p.dir=="rtl"){x+=_54d?_54d:_54e;}win.body().removeChild(p);s.position="relative";if(_54d){s.width=_54d+"px";switch(_54b){case "middle":s.textAlign="center";s.left=(x-_54d/2)+"px";break;case "end":s.textAlign="right";s.left=(x-_54d)+"px";break;default:s.left=x+"px";s.textAlign="left";break;}}else{switch(_54b){case "middle":s.left=Math.floor(x-_54e/2)+"px";break;case "end":s.left=Math.floor(x-_54e)+"px";break;default:s.left=Math.floor(x)+"px";break;}}s.top=Math.floor(y-size)+"px";s.whiteSpace="nowrap";var wrap=win.doc.createElement("div"),w=wrap.style;_543(w);w.width="0px";w.height="0px";wrap.appendChild(p);_549.node.insertBefore(wrap,_549.node.firstChild);return wrap;}}});});},"dijit/_TemplatedMixin":function(){define("dijit/_TemplatedMixin",["dojo/_base/lang","dojo/touch","./_WidgetBase","dojo/string","dojo/cache","dojo/_base/array","dojo/_base/declare","dojo/dom-construct","dojo/sniff","dojo/_base/unload"],function(lang,_54f,_550,_551,_552,_553,_554,_555,has,_556){var _557=_554("dijit._TemplatedMixin",null,{templateString:null,templatePath:null,_skipNodeCache:false,_earlyTemplatedStartup:false,constructor:function(){this._attachPoints=[];this._attachEvents=[];},_stringRepl:function(tmpl){var _558=this.declaredClass,_559=this;return _551.substitute(tmpl,this,function(_55a,key){if(key.charAt(0)=="!"){_55a=lang.getObject(key.substr(1),false,_559);}if(typeof _55a=="undefined"){throw new Error(_558+" template:"+key);}if(_55a==null){return "";}return key.charAt(0)=="!"?_55a:_55a.toString().replace(/"/g,"&quot;");},this);},buildRendering:function(){if(!this.templateString){this.templateString=_552(this.templatePath,{sanitize:true});}var _55b=_557.getCachedTemplate(this.templateString,this._skipNodeCache,this.ownerDocument);var node;if(lang.isString(_55b)){node=_555.toDom(this._stringRepl(_55b),this.ownerDocument);if(node.nodeType!=1){throw new Error("Invalid template: "+_55b);}}else{node=_55b.cloneNode(true);}this.domNode=node;this.inherited(arguments);this._attachTemplateNodes(node,function(n,p){return n.getAttribute(p);});this._beforeFillContent();this._fillContent(this.srcNodeRef);},_beforeFillContent:function(){},_fillContent:function(_55c){var dest=this.containerNode;if(_55c&&dest){while(_55c.hasChildNodes()){dest.appendChild(_55c.firstChild);}}},_attachTemplateNodes:function(_55d,_55e){var _55f=lang.isArray(_55d)?_55d:(_55d.all||_55d.getElementsByTagName("*"));var x=lang.isArray(_55d)?0:-1;for(;x<0||_55f[x];x++){var _560=(x==-1)?_55d:_55f[x];if(this.widgetsInTemplate&&(_55e(_560,"dojoType")||_55e(_560,"data-dojo-type"))){continue;}var _561=_55e(_560,"dojoAttachPoint")||_55e(_560,"data-dojo-attach-point");if(_561){var _562,_563=_561.split(/\s*,\s*/);while((_562=_563.shift())){if(lang.isArray(this[_562])){this[_562].push(_560);}else{this[_562]=_560;}this._attachPoints.push(_562);}}var _564=_55e(_560,"dojoAttachEvent")||_55e(_560,"data-dojo-attach-event");if(_564){var _565,_566=_564.split(/\s*,\s*/);var trim=lang.trim;while((_565=_566.shift())){if(_565){var _567=null;if(_565.indexOf(":")!=-1){var _568=_565.split(":");_565=trim(_568[0]);_567=trim(_568[1]);}else{_565=trim(_565);}if(!_567){_567=_565;}this._attachEvents.push(this.connect(_560,_54f[_565]||_565,_567));}}}}},destroyRendering:function(){_553.forEach(this._attachPoints,function(_569){delete this[_569];},this);this._attachPoints=[];_553.forEach(this._attachEvents,this.disconnect,this);this._attachEvents=[];this.inherited(arguments);}});_557._templateCache={};_557.getCachedTemplate=function(_56a,_56b,doc){var _56c=_557._templateCache;var key=_56a;var _56d=_56c[key];if(_56d){try{if(!_56d.ownerDocument||_56d.ownerDocument==(doc||document)){return _56d;}}catch(e){}_555.destroy(_56d);}_56a=_551.trim(_56a);if(_56b||_56a.match(/\$\{([^\}]+)\}/g)){return (_56c[key]=_56a);}else{var node=_555.toDom(_56a,doc);if(node.nodeType!=1){throw new Error("Invalid template: "+_56a);}return (_56c[key]=node);}};if(has("ie")){_556.addOnWindowUnload(function(){var _56e=_557._templateCache;for(var key in _56e){var _56f=_56e[key];if(typeof _56f=="object"){_555.destroy(_56f);}delete _56e[key];}});}lang.extend(_550,{dojoAttachEvent:"",dojoAttachPoint:""});return _557;});},"dojox/lang/functional/object":function(){define("dojox/lang/functional/object",["dojo/_base/kernel","dojo/_base/lang","./lambda"],function(_570,lang,df){var _571={};lang.mixin(df,{keys:function(obj){var t=[];for(var i in obj){if(!(i in _571)){t.push(i);}}return t;},values:function(obj){var t=[];for(var i in obj){if(!(i in _571)){t.push(obj[i]);}}return t;},filterIn:function(obj,f,o){o=o||_570.global;f=df.lambda(f);var t={},v,i;for(i in obj){if(!(i in _571)){v=obj[i];if(f.call(o,v,i,obj)){t[i]=v;}}}return t;},forIn:function(obj,f,o){o=o||_570.global;f=df.lambda(f);for(var i in obj){if(!(i in _571)){f.call(o,obj[i],i,obj);}}return o;},mapIn:function(obj,f,o){o=o||_570.global;f=df.lambda(f);var t={},i;for(i in obj){if(!(i in _571)){t[i]=f.call(o,obj[i],i,obj);}}return t;}});return df;});},"dojo/window":function(){define(["./_base/lang","./sniff","./_base/window","./dom","./dom-geometry","./dom-style"],function(lang,has,_572,dom,geom,_573){var _574={getBox:function(doc){doc=doc||_572.doc;var _575=(doc.compatMode=="BackCompat")?_572.body(doc):doc.documentElement,_576=geom.docScroll(doc),w,h;if(has("touch")){var _577=_574.get(doc);w=_577.innerWidth||_575.clientWidth;h=_577.innerHeight||_575.clientHeight;}else{w=_575.clientWidth;h=_575.clientHeight;}return {l:_576.x,t:_576.y,w:w,h:h};},get:function(doc){if(has("ie")&&_574!==document.parentWindow){doc.parentWindow.execScript("document._parentWindow = window;","Javascript");var win=doc._parentWindow;doc._parentWindow=null;return win;}return doc.parentWindow||doc.defaultView;},scrollIntoView:function(node,pos){try{node=dom.byId(node);var doc=node.ownerDocument||_572.doc,body=_572.body(doc),html=doc.documentElement||body.parentNode,isIE=has("ie"),isWK=has("webkit");if((!(has("mozilla")||isIE||isWK||has("opera"))||node==body||node==html)&&(typeof node.scrollIntoView!="undefined")){node.scrollIntoView(false);return;}var _578=doc.compatMode=="BackCompat",_579=(isIE>=9&&"frameElement" in node.ownerDocument.parentWindow)?((html.clientHeight>0&&html.clientWidth>0&&(body.clientHeight==0||body.clientWidth==0||body.clientHeight>html.clientHeight||body.clientWidth>html.clientWidth))?html:body):(_578?body:html),_57a=isWK?body:_579,_57b=_579.clientWidth,_57c=_579.clientHeight,rtl=!geom.isBodyLtr(doc),_57d=pos||geom.position(node),el=node.parentNode,_57e=function(el){return ((isIE<=6||(isIE&&_578))?false:(_573.get(el,"position").toLowerCase()=="fixed"));};if(_57e(node)){return;}while(el){if(el==body){el=_57a;}var _57f=geom.position(el),_580=_57e(el);if(el==_57a){_57f.w=_57b;_57f.h=_57c;if(_57a==html&&isIE&&rtl){_57f.x+=_57a.offsetWidth-_57f.w;}if(_57f.x<0||!isIE){_57f.x=0;}if(_57f.y<0||!isIE){_57f.y=0;}}else{var pb=geom.getPadBorderExtents(el);_57f.w-=pb.w;_57f.h-=pb.h;_57f.x+=pb.l;_57f.y+=pb.t;var _581=el.clientWidth,_582=_57f.w-_581;if(_581>0&&_582>0){_57f.w=_581;_57f.x+=(rtl&&(isIE||el.clientLeft>pb.l))?_582:0;}_581=el.clientHeight;_582=_57f.h-_581;if(_581>0&&_582>0){_57f.h=_581;}}if(_580){if(_57f.y<0){_57f.h+=_57f.y;_57f.y=0;}if(_57f.x<0){_57f.w+=_57f.x;_57f.x=0;}if(_57f.y+_57f.h>_57c){_57f.h=_57c-_57f.y;}if(_57f.x+_57f.w>_57b){_57f.w=_57b-_57f.x;}}var l=_57d.x-_57f.x,t=_57d.y-Math.max(_57f.y,0),r=l+_57d.w-_57f.w,bot=t+_57d.h-_57f.h;if(r*l>0){var s=Math[l<0?"max":"min"](l,r);if(rtl&&((isIE==8&&!_578)||isIE>=9)){s=-s;}_57d.x+=el.scrollLeft;el.scrollLeft+=s;_57d.x-=el.scrollLeft;}if(bot*t>0){_57d.y+=el.scrollTop;el.scrollTop+=Math[t<0?"max":"min"](t,bot);_57d.y-=el.scrollTop;}el=(el!=_57a)&&!_580&&el.parentNode;}}catch(error){console.error("scrollIntoView: "+error);node.scrollIntoView(false);}}};1&&lang.setObject("dojo.window",_574);return _574;});},"dojox/charting/axis2d/Default":function(){define("dojox/charting/axis2d/Default",["dojo/_base/lang","dojo/_base/array","dojo/_base/sniff","dojo/_base/declare","dojo/_base/connect","dojo/dom-geometry","./Invisible","../scaler/common","../scaler/linear","./common","dojox/gfx","dojox/lang/utils","dojox/lang/functional"],function(lang,arr,has,_583,_584,_585,_586,_587,lin,_588,g,du,df){var _589=45;return _583("dojox.charting.axis2d.Default",_586,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,rotation:0,htmlLabels:true,enableCache:false,dropLabels:true,labelSizeChange:false},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0,maxLabelCharCount:0,trailingSymbol:null,stroke:{},majorTick:{},minorTick:{},microTick:{},tick:{},font:"",fontColor:"",title:"",titleGap:0,titleFont:"",titleFontColor:"",titleOrientation:""},constructor:function(_58a,_58b){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_58b);du.updateWithPattern(this.opt,_58b,this.optionalParams);if(this.opt.enableCache){this._textFreePool=[];this._lineFreePool=[];this._textUsePool=[];this._lineUsePool=[];}this._invalidMaxLabelSize=true;},setWindow:function(_58c,_58d){if(_58c!=this.scale){this._invalidMaxLabelSize=true;}return this.inherited(arguments);},_groupLabelWidth:function(_58e,font,_58f){if(!_58e.length){return 0;}if(_58e.length>50){_58e.length=50;}if(lang.isObject(_58e[0])){_58e=df.map(_58e,function(_590){return _590.text;});}if(_58f){_58e=df.map(_58e,function(_591){return lang.trim(_591).length==0?"":_591.substring(0,_58f)+this.trailingSymbol;},this);}var s=_58e.join("<br>");return g._base._getTextBox(s,{font:font}).w||0;},_getMaxLabelSize:function(min,max,span,_592,font,size){if(this._maxLabelSize==null&&arguments.length==6){var o=this.opt;this.scaler.minMinorStep=this._prevMinMinorStep=0;var ob=lang.clone(o);delete ob.to;delete ob.from;var sb=lin.buildScaler(min,max,span,ob,o.to-o.from);sb.minMinorStep=0;this._majorStart=sb.major.start;var tb=lin.buildTicks(sb,o);if(size&&tb){var _593=0,_594=0;var _595=function(tick){if(tick.label){this.push(tick.label);}};var _596=[];if(this.opt.majorLabels){arr.forEach(tb.major,_595,_596);_593=this._groupLabelWidth(_596,font,ob.maxLabelCharCount);if(ob.maxLabelSize){_593=Math.min(ob.maxLabelSize,_593);}}_596=[];if(this.opt.dropLabels&&this.opt.minorLabels){arr.forEach(tb.minor,_595,_596);_594=this._groupLabelWidth(_596,font,ob.maxLabelCharCount);if(ob.maxLabelSize){_594=Math.min(ob.maxLabelSize,_594);}}this._maxLabelSize={majLabelW:_593,minLabelW:_594,majLabelH:size,minLabelH:size};}else{this._maxLabelSize=null;}}return this._maxLabelSize;},calculate:function(min,max,span){this.inherited(arguments);this.scaler.minMinorStep=this._prevMinMinorStep;if((this._invalidMaxLabelSize||span!=this._oldSpan)&&(min!=Infinity&&max!=-Infinity)){this._invalidMaxLabelSize=false;if(this.opt.labelSizeChange){this._maxLabelSize=null;}this._oldSpan=span;var o=this.opt;var ta=this.chart.theme.axis,_597=o.rotation%360,_598=this.chart.theme.axis.tick.labelGap,font=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),size=font?g.normalizedLength(g.splitFontString(font).size):0,_599=this._getMaxLabelSize(min,max,span,_597,font,size);if(typeof _598!="number"){_598=4;}if(_599&&o.dropLabels){var cosr=Math.abs(Math.cos(_597*Math.PI/180)),sinr=Math.abs(Math.sin(_597*Math.PI/180));var _59a,_59b;if(_597<0){_597+=360;}switch(_597){case 0:case 180:if(this.vertical){_59a=_59b=size;}else{_59a=_599.majLabelW;_59b=_599.minLabelW;}break;case 90:case 270:if(this.vertical){_59a=_599.majLabelW;_59b=_599.minLabelW;}else{_59a=_59b=size;}break;default:_59a=this.vertical?Math.min(_599.majLabelW,size/cosr):Math.min(_599.majLabelW,size/sinr);var gap1=Math.sqrt(_599.minLabelW*_599.minLabelW+size*size),gap2=this.vertical?size*cosr+_599.minLabelW*sinr:_599.minLabelW*cosr+size*sinr;_59b=Math.min(gap1,gap2);break;}this.scaler.minMinorStep=this._prevMinMinorStep=Math.max(_59a,_59b)+_598;var _59c=this.scaler.minMinorStep<=this.scaler.minor.tick*this.scaler.bounds.scale;if(!_59c){this._skipInterval=Math.floor((_59a+_598)/(this.scaler.major.tick*this.scaler.bounds.scale));}else{this._skipInterval=0;}}else{this._skipInterval=0;}}this.ticks=lin.buildTicks(this.scaler,this.opt);return this;},getOffsets:function(){var s=this.scaler,_59d={l:0,r:0,t:0,b:0};if(!s){return _59d;}var o=this.opt,a,b,c,d,gl=_587.getNumericLabel,_59e=0,ma=s.major,mi=s.minor,ta=this.chart.theme.axis,_59f=this.chart.theme.axis.tick.labelGap,_5a0=o.titleFont||(ta.title&&ta.title.font),_5a1=(o.titleGap==0)?0:o.titleGap||(ta.title&&ta.title.gap),_5a2=this.chart.theme.getTick("major",o),_5a3=this.chart.theme.getTick("minor",o),_5a4=_5a0?g.normalizedLength(g.splitFontString(_5a0).size):0,_5a5=o.rotation%360,_5a6=o.leftBottom,cosr=Math.abs(Math.cos(_5a5*Math.PI/180)),sinr=Math.abs(Math.sin(_5a5*Math.PI/180));this.trailingSymbol=(o.trailingSymbol===undefined||o.trailingSymbol===null)?this.trailingSymbol:o.trailingSymbol;if(typeof _59f!="number"){_59f=4;}if(_5a5<0){_5a5+=360;}var _5a7=this._getMaxLabelSize();if(_5a7){var side;var _5a8=Math.ceil(Math.max(_5a7.majLabelW,_5a7.minLabelW))+1,size=Math.ceil(Math.max(_5a7.majLabelH,_5a7.minLabelH))+1;if(this.vertical){side=_5a6?"l":"r";switch(_5a5){case 0:case 180:_59d[side]=_5a8;_59d.t=_59d.b=size/2;break;case 90:case 270:_59d[side]=size;_59d.t=_59d.b=_5a8/2;break;default:if(_5a5<=_589||(180<_5a5&&_5a5<=(180+_589))){_59d[side]=size*sinr/2+_5a8*cosr;_59d[_5a6?"t":"b"]=size*cosr/2+_5a8*sinr;_59d[_5a6?"b":"t"]=size*cosr/2;}else{if(_5a5>(360-_589)||(180>_5a5&&_5a5>(180-_589))){_59d[side]=size*sinr/2+_5a8*cosr;_59d[_5a6?"b":"t"]=size*cosr/2+_5a8*sinr;_59d[_5a6?"t":"b"]=size*cosr/2;}else{if(_5a5<90||(180<_5a5&&_5a5<270)){_59d[side]=size*sinr+_5a8*cosr;_59d[_5a6?"t":"b"]=size*cosr+_5a8*sinr;}else{_59d[side]=size*sinr+_5a8*cosr;_59d[_5a6?"b":"t"]=size*cosr+_5a8*sinr;}}}break;}_59d[side]+=_59f+Math.max(_5a2.length,_5a3.length)+(o.title?(_5a4+_5a1):0);}else{side=_5a6?"b":"t";switch(_5a5){case 0:case 180:_59d[side]=size;_59d.l=_59d.r=_5a8/2;break;case 90:case 270:_59d[side]=_5a8;_59d.l=_59d.r=size/2;break;default:if((90-_589)<=_5a5&&_5a5<=90||(270-_589)<=_5a5&&_5a5<=270){_59d[side]=size*cosr/2+_5a8*sinr;_59d[_5a6?"r":"l"]=size*sinr/2+_5a8*cosr;_59d[_5a6?"l":"r"]=size*sinr/2;}else{if(90<=_5a5&&_5a5<=(90+_589)||270<=_5a5&&_5a5<=(270+_589)){_59d[side]=size*cosr/2+_5a8*sinr;_59d[_5a6?"l":"r"]=size*sinr/2+_5a8*cosr;_59d[_5a6?"r":"l"]=size*sinr/2;}else{if(_5a5<_589||(180<_5a5&&_5a5<(180+_589))){_59d[side]=size*cosr+_5a8*sinr;_59d[_5a6?"r":"l"]=size*sinr+_5a8*cosr;}else{_59d[side]=size*cosr+_5a8*sinr;_59d[_5a6?"l":"r"]=size*sinr+_5a8*cosr;}}}break;}_59d[side]+=_59f+Math.max(_5a2.length,_5a3.length)+(o.title?(_5a4+_5a1):0);}}return _59d;},cleanGroup:function(_5a9){if(this.opt.enableCache&&this.group){this._lineFreePool=this._lineFreePool.concat(this._lineUsePool);this._lineUsePool=[];this._textFreePool=this._textFreePool.concat(this._textUsePool);this._textUsePool=[];}this.inherited(arguments);},createText:function(_5aa,_5ab,x,y,_5ac,_5ad,font,_5ae,_5af){if(!this.opt.enableCache||_5aa=="html"){return _588.createText[_5aa](this.chart,_5ab,x,y,_5ac,_5ad,font,_5ae,_5af);}var text;if(this._textFreePool.length>0){text=this._textFreePool.pop();text.setShape({x:x,y:y,text:_5ad,align:_5ac});_5ab.add(text);}else{text=_588.createText[_5aa](this.chart,_5ab,x,y,_5ac,_5ad,font,_5ae);}this._textUsePool.push(text);return text;},createLine:function(_5b0,_5b1){var line;if(this.opt.enableCache&&this._lineFreePool.length>0){line=this._lineFreePool.pop();line.setShape(_5b1);_5b0.add(line);}else{line=_5b0.createLine(_5b1);}if(this.opt.enableCache){this._lineUsePool.push(line);}return line;},render:function(dim,_5b2){if(!this.dirty||!this.scaler){return this;}var o=this.opt,ta=this.chart.theme.axis,_5b3=o.leftBottom,_5b4=o.rotation%360,_5b5,stop,_5b6,_5b7=0,_5b8,_5b9,_5ba,_5bb,_5bc,_5bd,_5be=this.chart.theme.axis.tick.labelGap,_5bf=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),_5c0=o.titleFont||(ta.title&&ta.title.font),_5c1=o.fontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"black",_5c2=o.titleFontColor||(ta.title&&ta.title.fontColor)||"black",_5c3=(o.titleGap==0)?0:o.titleGap||(ta.title&&ta.title.gap)||15,_5c4=o.titleOrientation||(ta.title&&ta.title.orientation)||"axis",_5c5=this.chart.theme.getTick("major",o),_5c6=this.chart.theme.getTick("minor",o),_5c7=this.chart.theme.getTick("micro",o),_5c8=Math.max(_5c5.length,_5c6.length,_5c7.length),_5c9="stroke" in o?o.stroke:ta.stroke,size=_5bf?g.normalizedLength(g.splitFontString(_5bf).size):0,cosr=Math.abs(Math.cos(_5b4*Math.PI/180)),sinr=Math.abs(Math.sin(_5b4*Math.PI/180)),_5ca=_5c0?g.normalizedLength(g.splitFontString(_5c0).size):0;if(typeof _5be!="number"){_5be=4;}if(_5b4<0){_5b4+=360;}var _5cb=this._getMaxLabelSize();_5cb=_5cb&&_5cb.majLabelW;if(this.vertical){_5b5={y:dim.height-_5b2.b};stop={y:_5b2.t};_5b6={y:(dim.height-_5b2.b+_5b2.t)/2};_5b8=size*sinr+(_5cb||0)*cosr+_5be+Math.max(_5c5.length,_5c6.length)+_5ca+_5c3;_5b9={x:0,y:-1};_5bc={x:0,y:0};_5ba={x:1,y:0};_5bb={x:_5be,y:0};switch(_5b4){case 0:_5bd="end";_5bc.y=size*0.4;break;case 90:_5bd="middle";_5bc.x=-size;break;case 180:_5bd="start";_5bc.y=-size*0.4;break;case 270:_5bd="middle";break;default:if(_5b4<_589){_5bd="end";_5bc.y=size*0.4;}else{if(_5b4<90){_5bd="end";_5bc.y=size*0.4;}else{if(_5b4<(180-_589)){_5bd="start";}else{if(_5b4<(180+_589)){_5bd="start";_5bc.y=-size*0.4;}else{if(_5b4<270){_5bd="start";_5bc.x=_5b3?0:size*0.4;}else{if(_5b4<(360-_589)){_5bd="end";_5bc.x=_5b3?0:size*0.4;}else{_5bd="end";_5bc.y=size*0.4;}}}}}}}if(_5b3){_5b5.x=stop.x=_5b2.l;_5b7=(_5c4&&_5c4=="away")?90:270;_5b6.x=_5b2.l-_5b8+(_5b7==270?_5ca:0);_5ba.x=-1;_5bb.x=-_5bb.x;}else{_5b5.x=stop.x=dim.width-_5b2.r;_5b7=(_5c4&&_5c4=="axis")?90:270;_5b6.x=dim.width-_5b2.r+_5b8-(_5b7==270?0:_5ca);switch(_5bd){case "start":_5bd="end";break;case "end":_5bd="start";break;case "middle":_5bc.x+=size;break;}}}else{_5b5={x:_5b2.l};stop={x:dim.width-_5b2.r};_5b6={x:(dim.width-_5b2.r+_5b2.l)/2};_5b8=size*cosr+(_5cb||0)*sinr+_5be+Math.max(_5c5.length,_5c6.length)+_5ca+_5c3;_5b9={x:1,y:0};_5bc={x:0,y:0};_5ba={x:0,y:1};_5bb={x:0,y:_5be};switch(_5b4){case 0:_5bd="middle";_5bc.y=size;break;case 90:_5bd="start";_5bc.x=-size*0.4;break;case 180:_5bd="middle";break;case 270:_5bd="end";_5bc.x=size*0.4;break;default:if(_5b4<(90-_589)){_5bd="start";_5bc.y=_5b3?size:0;}else{if(_5b4<(90+_589)){_5bd="start";_5bc.x=-size*0.4;}else{if(_5b4<180){_5bd="start";_5bc.y=_5b3?0:-size;}else{if(_5b4<(270-_589)){_5bd="end";_5bc.y=_5b3?0:-size;}else{if(_5b4<(270+_589)){_5bd="end";_5bc.y=_5b3?size*0.4:0;}else{_5bd="end";_5bc.y=_5b3?size:0;}}}}}}if(_5b3){_5b5.y=stop.y=dim.height-_5b2.b;_5b7=(_5c4&&_5c4=="axis")?180:0;_5b6.y=dim.height-_5b2.b+_5b8-(_5b7?_5ca:0);}else{_5b5.y=stop.y=_5b2.t;_5b7=(_5c4&&_5c4=="away")?180:0;_5b6.y=_5b2.t-_5b8+(_5b7?0:_5ca);_5ba.y=-1;_5bb.y=-_5bb.y;switch(_5bd){case "start":_5bd="end";break;case "end":_5bd="start";break;case "middle":_5bc.y-=size;break;}}}this.cleanGroup();var s=this.group,c=this.scaler,t=this.ticks,f=lin.getTransformerFromModel(this.scaler),_5cc=(!o.title||!_5b7)&&!_5b4&&this.opt.htmlLabels&&!has("ie")&&!has("opera")?"html":"gfx",dx=_5ba.x*_5c5.length,dy=_5ba.y*_5c5.length,skip=this._skipInterval;s.createLine({x1:_5b5.x,y1:_5b5.y,x2:stop.x,y2:stop.y}).setStroke(_5c9);if(o.title){var _5cd=_588.createText[_5cc](this.chart,s,_5b6.x,_5b6.y,"middle",o.title,_5c0,_5c2);if(_5cc=="html"){this.htmlElements.push(_5cd);}else{_5cd.setTransform(g.matrix.rotategAt(_5b7,_5b6.x,_5b6.y));}}if(t==null){this.dirty=false;return this;}var rel=(t.major.length>0)?(t.major[0].value-this._majorStart)/c.major.tick:0;var _5ce=this.opt.majorLabels;arr.forEach(t.major,function(tick,i){var _5cf=f(tick.value),elem,x=_5b5.x+_5b9.x*_5cf,y=_5b5.y+_5b9.y*_5cf;i+=rel;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_5c5);if(tick.label&&(!skip||(i-(1+skip))%(1+skip)==0)){var _5d0=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_5bf,o.maxLabelCharCount):{text:tick.label,truncated:false};_5d0=o.maxLabelSize?this.getTextWithLimitLength(_5d0.text,_5bf,o.maxLabelSize,_5d0.truncated):_5d0;elem=this.createText(_5cc,s,x+dx+_5bb.x+(_5b4?0:_5bc.x),y+dy+_5bb.y+(_5b4?0:_5bc.y),_5bd,_5d0.text,_5bf,_5c1);if(this.chart.truncateBidi&&_5d0.truncated){this.chart.truncateBidi(elem,tick.label,_5cc);}_5d0.truncated&&this.labelTooltip(elem,this.chart,tick.label,_5d0.text,_5bf,_5cc);if(_5cc=="html"){this.htmlElements.push(elem);}else{if(_5b4){elem.setTransform([{dx:_5bc.x,dy:_5bc.y},g.matrix.rotategAt(_5b4,x+dx+_5bb.x,y+dy+_5bb.y)]);}}}},this);dx=_5ba.x*_5c6.length;dy=_5ba.y*_5c6.length;_5ce=this.opt.minorLabels&&c.minMinorStep<=c.minor.tick*c.bounds.scale;arr.forEach(t.minor,function(tick){var _5d1=f(tick.value),elem,x=_5b5.x+_5b9.x*_5d1,y=_5b5.y+_5b9.y*_5d1;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_5c6);if(_5ce&&tick.label){var _5d2=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_5bf,o.maxLabelCharCount):{text:tick.label,truncated:false};_5d2=o.maxLabelSize?this.getTextWithLimitLength(_5d2.text,_5bf,o.maxLabelSize,_5d2.truncated):_5d2;elem=this.createText(_5cc,s,x+dx+_5bb.x+(_5b4?0:_5bc.x),y+dy+_5bb.y+(_5b4?0:_5bc.y),_5bd,_5d2.text,_5bf,_5c1);if(this.chart.getTextDir&&_5d2.truncated){this.chart.truncateBidi(elem,tick.label,_5cc);}_5d2.truncated&&this.labelTooltip(elem,this.chart,tick.label,_5d2.text,_5bf,_5cc);if(_5cc=="html"){this.htmlElements.push(elem);}else{if(_5b4){elem.setTransform([{dx:_5bc.x,dy:_5bc.y},g.matrix.rotategAt(_5b4,x+dx+_5bb.x,y+dy+_5bb.y)]);}}}},this);dx=_5ba.x*_5c7.length;dy=_5ba.y*_5c7.length;arr.forEach(t.micro,function(tick){var _5d3=f(tick.value),elem,x=_5b5.x+_5b9.x*_5d3,y=_5b5.y+_5b9.y*_5d3;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_5c7);},this);this.dirty=false;return this;},labelTooltip:function(elem,_5d4,_5d5,_5d6,font,_5d7){var _5d8=["dijit/Tooltip"];var _5d9={type:"rect"},_5da=["above","below"],_5db=g._base._getTextBox(_5d6,{font:font}).w||0,_5dc=font?g.normalizedLength(g.splitFontString(font).size):0;if(_5d7=="html"){lang.mixin(_5d9,_585.position(elem.firstChild,true));_5d9.width=Math.ceil(_5db);_5d9.height=Math.ceil(_5dc);this._events.push({shape:dojo,handle:_584.connect(elem.firstChild,"onmouseover",this,function(e){require(_5d8,function(_5dd){_5dd.show(_5d5,_5d9,_5da);});})});this._events.push({shape:dojo,handle:_584.connect(elem.firstChild,"onmouseout",this,function(e){require(_5d8,function(_5de){_5de.hide(_5d9);});})});}else{var shp=elem.getShape(),lt=_5d4.getCoords();_5d9=lang.mixin(_5d9,{x:shp.x-_5db/2,y:shp.y});_5d9.x+=lt.x;_5d9.y+=lt.y;_5d9.x=Math.round(_5d9.x);_5d9.y=Math.round(_5d9.y);_5d9.width=Math.ceil(_5db);_5d9.height=Math.ceil(_5dc);this._events.push({shape:elem,handle:elem.connect("onmouseenter",this,function(e){require(_5d8,function(_5df){_5df.show(_5d5,_5d9,_5da);});})});this._events.push({shape:elem,handle:elem.connect("onmouseleave",this,function(e){require(_5d8,function(_5e0){_5e0.hide(_5d9);});})});}}});});},"dojox/charting/plot2d/ClusteredBars":function(){define("dojox/charting/plot2d/ClusteredBars",["dojo/_base/declare","./Bars","./common"],function(_5e1,Bars,dc){return _5e1("dojox.charting.plot2d.ClusteredBars",Bars,{getBarProperties:function(){var f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt,this.series.length);return {gap:f.gap,height:f.size,thickness:f.size};}});});},"dojox/charting/action2d/MoveSlice":function(){define("dojox/charting/action2d/MoveSlice",["dojo/_base/connect","dojo/_base/declare","dojo/_base/array","./PlotAction","dojo/fx/easing","dojox/gfx/matrix","dojox/gfx/fx","dojox/lang/functional","dojox/lang/functional/scan","dojox/lang/functional/fold"],function(hub,_5e2,_5e3,_5e4,dfe,m,gf,df,dfs,dff){var _5e5=1.05,_5e6=7;return _5e2("dojox.charting.action2d.MoveSlice",_5e4,{defaultParams:{duration:400,easing:dfe.backOut,scale:_5e5,shift:_5e6},optionalParams:{},constructor:function(_5e7,plot,_5e8){if(!_5e8){_5e8={};}this.scale=typeof _5e8.scale=="number"?_5e8.scale:_5e5;this.shift=typeof _5e8.shift=="number"?_5e8.shift:_5e6;this.connect();},process:function(o){if(!o.shape||o.element!="slice"||!(o.type in this.overOutEvents)){return;}if(!this.angles){var _5e9=m._degToRad(o.plot.opt.startAngle);if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}this.angles=_5e3.map(this.angles,function(item){return item+_5e9;});}var _5ea=o.index,anim,_5eb,_5ec,_5ed,_5ee,_5ef=(this.angles[_5ea]+this.angles[_5ea+1])/2,_5f0=m.rotateAt(-_5ef,o.cx,o.cy),_5f1=m.rotateAt(_5ef,o.cx,o.cy);anim=this.anim[_5ea];if(anim){anim.action.stop(true);}else{this.anim[_5ea]=anim={};}if(o.type=="onmouseover"){_5ed=0;_5ee=this.shift;_5eb=1;_5ec=this.scale;}else{_5ed=this.shift;_5ee=0;_5eb=this.scale;_5ec=1;}anim.action=gf.animateTransform({shape:o.shape,duration:this.duration,easing:this.easing,transform:[_5f1,{name:"translate",start:[_5ed,0],end:[_5ee,0]},{name:"scaleAt",start:[_5eb,o.cx,o.cy],end:[_5ec,o.cx,o.cy]},_5f0]});if(o.type=="onmouseout"){hub.connect(anim.action,"onEnd",this,function(){delete this.anim[_5ea];});}anim.action.play();},reset:function(){delete this.angles;}});});},"dojo/colors":function(){define(["./_base/kernel","./_base/lang","./_base/Color","./_base/array"],function(dojo,lang,_5f2,_5f3){var _5f4={};lang.setObject("dojo.colors",_5f4);var _5f5=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=_5f2.fromRgb=function(_5f6,obj){var m=_5f6.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=_5f3.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return _5f2.fromArray(a,obj);}return _5f2.fromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_5f5(m1,m2,H+1/3)*256,_5f5(m1,m2,H)*256,_5f5(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return _5f2.fromArray(a,obj);}}return null;};var _5f7=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};_5f2.prototype.sanitize=function(){var t=this;t.r=Math.round(_5f7(t.r,0,255));t.g=Math.round(_5f7(t.g,0,255));t.b=Math.round(_5f7(t.b,0,255));t.a=_5f7(t.a,0,1);return this;};_5f4.makeGrey=_5f2.makeGrey=function(g,a){return _5f2.fromArray([g,g,g,a]);};lang.mixin(_5f2.named,{"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"blanchedalmond":[255,235,205],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"oldlace":[253,245,230],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"whitesmoke":[245,245,245],"yellowgreen":[154,205,50]});return _5f2;});},"dojox/charting/SimpleTheme":function(){define("dojox/charting/SimpleTheme",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/Color","dojox/lang/utils","dojox/gfx/gradutils"],function(lang,arr,_5f8,_5f9,dlu,dgg){var _5fa=_5f8("dojox.charting.SimpleTheme",null,{shapeSpaces:{shape:1,shapeX:1,shapeY:1},constructor:function(_5fb){_5fb=_5fb||{};var def=_5fa.defaultTheme;arr.forEach(["chart","plotarea","axis","grid","series","marker","indicator"],function(name){this[name]=lang.delegate(def[name],_5fb[name]);},this);if(_5fb.seriesThemes&&_5fb.seriesThemes.length){this.colors=null;this.seriesThemes=_5fb.seriesThemes.slice(0);}else{this.seriesThemes=null;this.colors=(_5fb.colors||_5fa.defaultColors).slice(0);}this.markerThemes=null;if(_5fb.markerThemes&&_5fb.markerThemes.length){this.markerThemes=_5fb.markerThemes.slice(0);}this.markers=_5fb.markers?lang.clone(_5fb.markers):lang.delegate(_5fa.defaultMarkers);this.noGradConv=_5fb.noGradConv;this.noRadialConv=_5fb.noRadialConv;if(_5fb.reverseFills){this.reverseFills();}this._current=0;this._buildMarkerArray();},clone:function(){var _5fc=new this.constructor({chart:this.chart,plotarea:this.plotarea,axis:this.axis,grid:this.grid,series:this.series,marker:this.marker,colors:this.colors,markers:this.markers,indicator:this.indicator,seriesThemes:this.seriesThemes,markerThemes:this.markerThemes,noGradConv:this.noGradConv,noRadialConv:this.noRadialConv});arr.forEach(["clone","clear","next","skip","addMixin","post","getTick"],function(name){if(this.hasOwnProperty(name)){_5fc[name]=this[name];}},this);return _5fc;},clear:function(){this._current=0;},next:function(_5fd,_5fe,_5ff){var _600=dlu.merge,_601,_602;if(this.colors){_601=lang.delegate(this.series);_602=lang.delegate(this.marker);var _603=new _5f9(this.colors[this._current%this.colors.length]),old;if(_601.stroke&&_601.stroke.color){_601.stroke=lang.delegate(_601.stroke);old=new _5f9(_601.stroke.color);_601.stroke.color=new _5f9(_603);_601.stroke.color.a=old.a;}else{_601.stroke={color:_603};}if(_602.stroke&&_602.stroke.color){_602.stroke=lang.delegate(_602.stroke);old=new _5f9(_602.stroke.color);_602.stroke.color=new _5f9(_603);_602.stroke.color.a=old.a;}else{_602.stroke={color:_603};}if(!_601.fill||_601.fill.type){_601.fill=_603;}else{old=new _5f9(_601.fill);_601.fill=new _5f9(_603);_601.fill.a=old.a;}if(!_602.fill||_602.fill.type){_602.fill=_603;}else{old=new _5f9(_602.fill);_602.fill=new _5f9(_603);_602.fill.a=old.a;}}else{_601=this.seriesThemes?_600(this.series,this.seriesThemes[this._current%this.seriesThemes.length]):this.series;_602=this.markerThemes?_600(this.marker,this.markerThemes[this._current%this.markerThemes.length]):_601;}var _604=_602&&_602.symbol||this._markers[this._current%this._markers.length];var _605={series:_601,marker:_602,symbol:_604};++this._current;if(_5fe){_605=this.addMixin(_605,_5fd,_5fe);}if(_5ff){_605=this.post(_605,_5fd);}return _605;},skip:function(){++this._current;},addMixin:function(_606,_607,_608,_609){if(lang.isArray(_608)){arr.forEach(_608,function(m){_606=this.addMixin(_606,_607,m);},this);}else{var t={};if("color" in _608){if(_607=="line"||_607=="area"){lang.setObject("series.stroke.color",_608.color,t);lang.setObject("marker.stroke.color",_608.color,t);}else{lang.setObject("series.fill",_608.color,t);}}arr.forEach(["stroke","outline","shadow","fill","font","fontColor","labelWiring"],function(name){var _60a="marker"+name.charAt(0).toUpperCase()+name.substr(1),b=_60a in _608;if(name in _608){lang.setObject("series."+name,_608[name],t);if(!b){lang.setObject("marker."+name,_608[name],t);}}if(b){lang.setObject("marker."+name,_608[_60a],t);}});if("marker" in _608){t.symbol=_608.marker;t.symbol=_608.marker;}_606=dlu.merge(_606,t);}if(_609){_606=this.post(_606,_607);}return _606;},post:function(_60b,_60c){var fill=_60b.series.fill,t;if(!this.noGradConv&&this.shapeSpaces[fill.space]&&fill.type=="linear"){if(_60c=="bar"){t={x1:fill.y1,y1:fill.x1,x2:fill.y2,y2:fill.x2};}else{if(!this.noRadialConv&&fill.space=="shape"&&(_60c=="slice"||_60c=="circle")){t={type:"radial",cx:0,cy:0,r:100};}}if(t){return dlu.merge(_60b,{series:{fill:t}});}}return _60b;},getTick:function(name,_60d){var tick=this.axis.tick,_60e=name+"Tick",_60f=dlu.merge;if(tick){if(this.axis[_60e]){tick=_60f(tick,this.axis[_60e]);}}else{tick=this.axis[_60e];}if(_60d){if(tick){if(_60d[_60e]){tick=_60f(tick,_60d[_60e]);}}else{tick=_60d[_60e];}}return tick;},inspectObjects:function(f){arr.forEach(["chart","plotarea","axis","grid","series","marker","indicator"],function(name){f(this[name]);},this);if(this.seriesThemes){arr.forEach(this.seriesThemes,f);}if(this.markerThemes){arr.forEach(this.markerThemes,f);}},reverseFills:function(){this.inspectObjects(function(o){if(o&&o.fill){o.fill=dgg.reverse(o.fill);}});},addMarker:function(name,_610){this.markers[name]=_610;this._buildMarkerArray();},setMarkers:function(obj){this.markers=obj;this._buildMarkerArray();},_buildMarkerArray:function(){this._markers=[];for(var p in this.markers){this._markers.push(this.markers[p]);}}});lang.mixin(_5fa,{defaultMarkers:{CIRCLE:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",SQUARE:"m-3,-3 l0,6 6,0 0,-6 z",DIAMOND:"m0,-3 l3,3 -3,3 -3,-3 z",CROSS:"m0,-3 l0,6 m-3,-3 l6,0",X:"m-3,-3 l6,6 m0,-6 l-6,6",TRIANGLE:"m-3,3 l3,-6 3,6 z",TRIANGLE_INVERTED:"m-3,-3 l3,6 3,-6 z"},defaultColors:["#54544c","#858e94","#6e767a","#948585","#474747"],defaultTheme:{chart:{stroke:null,fill:"white",pageStyle:null,titleGap:20,titlePos:"top",titleFont:"normal normal bold 14pt Tahoma",titleFontColor:"#333"},plotarea:{stroke:null,fill:"white"},axis:{stroke:{color:"#333",width:1},tick:{color:"#666",position:"center",font:"normal normal normal 7pt Tahoma",fontColor:"#333",labelGap:4},majorTick:{width:1,length:6},minorTick:{width:0.8,length:3},microTick:{width:0.5,length:1},title:{gap:15,font:"normal normal normal 11pt Tahoma",fontColor:"#333",orientation:"axis"}},series:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000",labelWiring:{width:1,color:"#ccc"}},marker:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000"},indicator:{lineStroke:{width:1.5,color:"#333"},lineOutline:{width:0.1,color:"#ccc"},lineShadow:null,stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",radius:3,font:"normal normal normal 10pt Tahoma",fontColor:"#000",markerFill:"#ccc",markerSymbol:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",markerStroke:{width:1.5,color:"#333"},markerOutline:{width:0.1,color:"#ccc"},markerShadow:null}}});return _5fa;});},"dijit/Tooltip":function(){require({cache:{"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n></div>\n"}});define("dijit/Tooltip",["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","./main"],function(_611,_612,fx,dom,_613,_614,_615,lang,_616,on,has,_617,_618,_619,_61a,_61b,_61c,_61d){var _61e=_612("dijit._MasterTooltip",[_619,_61a],{duration:_617.defaultDuration,templateString:_61c,postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.bgIframe=new _61b(this.domNode);this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});},show:function(_61f,_620,_621,rtl,_622){if(this.aroundNode&&this.aroundNode===_620&&this.containerNode.innerHTML==_61f){return;}if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_61f;if(_622){this.set("textDir",_622);}this.containerNode.align=rtl?"right":"left";var pos=_618.around(this.domNode,_620,_621&&_621.length?_621:_623.defaultPosition,!rtl,lang.hitch(this,"orient"));var _624=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_624.y+((_624.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_624.x+((_624.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}else{this.connectorNode.style.left="";this.connectorNode.style.top="";}}_615.set(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_620;},orient:function(node,_625,_626,_627,_628){this.connectorNode.style.top="";var _629=_627.h,_62a=_627.w;node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_625+"-"+_626];this.domNode.style.width="auto";var size=_614.position(this.domNode);if(has("ie")==9){size.w+=2;}var _62b=Math.min((Math.max(_62a,1)),size.w);_614.setMarginBox(this.domNode,{w:_62b});if(_626.charAt(0)=="B"&&_625.charAt(0)=="B"){var bb=_614.position(node);var _62c=this.connectorNode.offsetHeight;if(bb.h>_629){var _62d=_629-((_628.h+_62c)>>1);this.connectorNode.style.top=_62d+"px";this.connectorNode.style.bottom="";}else{this.connectorNode.style.bottom=Math.min(Math.max(_628.h/2-_62c/2,0),bb.h-_62c)+"px";this.connectorNode.style.top="";}}else{this.connectorNode.style.top="";this.connectorNode.style.bottom="";}return Math.max(0,size.w-_62a);},_onShow:function(){if(has("ie")){this.domNode.style.filter="";}},hide:function(_62e){if(this._onDeck&&this._onDeck[1]==_62e){this._onDeck=null;}else{if(this.aroundNode===_62e){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}}},_onHide:function(){this.domNode.style.cssText="";this.containerNode.innerHTML="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}},_setAutoTextDir:function(node){this.applyTextDir(node,has("ie")?node.outerText:node.textContent);_611.forEach(node.children,function(_62f){this._setAutoTextDir(_62f);},this);},_setTextDirAttr:function(_630){this._set("textDir",_630);if(_630=="auto"){this._setAutoTextDir(this.containerNode);}else{this.containerNode.dir=this.textDir;}}});_61d.showTooltip=function(_631,_632,_633,rtl,_634){if(_633){_633=_611.map(_633,function(val){return {after:"after-centered",before:"before-centered"}[val]||val;});}if(!_623._masterTT){_61d._masterTT=_623._masterTT=new _61e();}return _623._masterTT.show(_631,_632,_633,rtl,_634);};_61d.hideTooltip=function(_635){return _623._masterTT&&_623._masterTT.hide(_635);};var _623=_612("dijit.Tooltip",_619,{label:"",showDelay:400,connectId:[],position:[],selector:"",_setConnectIdAttr:function(_636){_611.forEach(this._connections||[],function(_637){_611.forEach(_637,function(_638){_638.remove();});},this);this._connectIds=_611.filter(lang.isArrayLike(_636)?_636:(_636?[_636]:[]),function(id){return dom.byId(id,this.ownerDocument);},this);this._connections=_611.map(this._connectIds,function(id){var node=dom.byId(id,this.ownerDocument),_639=this.selector,_63a=_639?function(_63b){return on.selector(_639,_63b);}:function(_63c){return _63c;},self=this;return [on(node,_63a(_616.enter),function(){self._onHover(this);}),on(node,_63a("focusin"),function(){self._onHover(this);}),on(node,_63a(_616.leave),lang.hitch(self,"_onUnHover")),on(node,_63a("focusout"),lang.hitch(self,"_onUnHover"))];},this);this._set("connectId",_636);},addTarget:function(node){var id=node.id||node;if(_611.indexOf(this._connectIds,id)==-1){this.set("connectId",this._connectIds.concat(id));}},removeTarget:function(node){var id=node.id||node,idx=_611.indexOf(this._connectIds,id);if(idx>=0){this._connectIds.splice(idx,1);this.set("connectId",this._connectIds);}},buildRendering:function(){this.inherited(arguments);_613.add(this.domNode,"dijitTooltipData");},startup:function(){this.inherited(arguments);var ids=this.connectId;_611.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);},getContent:function(node){return this.label||this.domNode.innerHTML;},_onHover:function(_63d){if(!this._showTimer){this._showTimer=this.defer(function(){this.open(_63d);},this.showDelay);}},_onUnHover:function(){if(this._showTimer){this._showTimer.remove();delete this._showTimer;}this.close();},open:function(_63e){if(this._showTimer){this._showTimer.remove();delete this._showTimer;}var _63f=this.getContent(_63e);if(!_63f){return;}_623.show(_63f,_63e,this.position,!this.isLeftToRight(),this.textDir);this._connectNode=_63e;this.onShow(_63e,this.position);},close:function(){if(this._connectNode){_623.hide(this._connectNode);delete this._connectNode;this.onHide();}if(this._showTimer){this._showTimer.remove();delete this._showTimer;}},onShow:function(){},onHide:function(){},destroy:function(){this.close();_611.forEach(this._connections||[],function(_640){_611.forEach(_640,function(_641){_641.remove();});},this);this.inherited(arguments);}});_623._MasterTooltip=_61e;_623.show=_61d.showTooltip;_623.hide=_61d.hideTooltip;_623.defaultPosition=["after-centered","before-centered"];return _623;});},"dojox/charting/Element":function(){define("dojox/charting/Element",["dojo/_base/lang","dojo/_base/array","dojo/dom-construct","dojo/_base/declare","dojox/gfx","dojox/gfx/shape"],function(lang,arr,_642,_643,gfx,_644){return _643("dojox.charting.Element",null,{chart:null,group:null,htmlElements:null,dirty:true,constructor:function(_645){this.chart=_645;this.group=null;this.htmlElements=[];this.dirty=true;this.trailingSymbol="...";this._events=[];},purgeGroup:function(){this.destroyHtmlElements();if(this.group){this.group.removeShape();var _646=this.group.children;for(var i=0;i<_646.length;++i){_644.dispose(_646[i],true);}this.group.clear();_644.dispose(this.group,true);this.group=null;}this.dirty=true;if(this._events.length){arr.forEach(this._events,function(item){item.shape.disconnect(item.handle);});this._events=[];}return this;},cleanGroup:function(_647){this.destroyHtmlElements();if(!_647){_647=this.chart.surface;}if(this.group){var _648=this.group.children;for(var i=0;i<_648.length;++i){_644.dispose(_648[i],true);}this.group.clear();}else{this.group=_647.createGroup();}this.dirty=true;return this;},destroyHtmlElements:function(){if(this.htmlElements.length){arr.forEach(this.htmlElements,_642.destroy);this.htmlElements=[];}},destroy:function(){this.purgeGroup();},getTextWidth:function(s,font){return gfx._base._getTextBox(s,{font:font}).w||0;},getTextWithLimitLength:function(s,font,_649,_64a){if(!s||s.length<=0){return {text:"",truncated:_64a||false};}if(!_649||_649<=0){return {text:s,truncated:_64a||false};}var _64b=2,_64c=0.618,_64d=s.substring(0,1)+this.trailingSymbol,_64e=this.getTextWidth(_64d,font);if(_649<=_64e){return {text:_64d,truncated:true};}var _64f=this.getTextWidth(s,font);if(_64f<=_649){return {text:s,truncated:_64a||false};}else{var _650=0,end=s.length;while(_650<end){if(end-_650<=_64b){while(this.getTextWidth(s.substring(0,_650)+this.trailingSymbol,font)>_649){_650-=1;}return {text:(s.substring(0,_650)+this.trailingSymbol),truncated:true};}var _651=_650+Math.round((end-_650)*_64c),_652=this.getTextWidth(s.substring(0,_651),font);if(_652<_649){_650=_651;end=end;}else{_650=_650;end=_651;}}}},getTextWithLimitCharCount:function(s,font,_653,_654){if(!s||s.length<=0){return {text:"",truncated:_654||false};}if(!_653||_653<=0||s.length<=_653){return {text:s,truncated:_654||false};}return {text:s.substring(0,_653)+this.trailingSymbol,truncated:true};},_plotFill:function(fill,dim,_655){if(!fill||!fill.type||!fill.space){return fill;}var _656=fill.space,span;switch(fill.type){case "linear":if(_656==="plot"||_656==="shapeX"||_656==="shapeY"){fill=gfx.makeParameters(gfx.defaultLinearGradient,fill);fill.space=_656;if(_656==="plot"||_656==="shapeX"){span=dim.height-_655.t-_655.b;fill.y1=_655.t+span*fill.y1/100;fill.y2=_655.t+span*fill.y2/100;}if(_656==="plot"||_656==="shapeY"){span=dim.width-_655.l-_655.r;fill.x1=_655.l+span*fill.x1/100;fill.x2=_655.l+span*fill.x2/100;}}break;case "radial":if(_656==="plot"){fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_656;var _657=dim.width-_655.l-_655.r,_658=dim.height-_655.t-_655.b;fill.cx=_655.l+_657*fill.cx/100;fill.cy=_655.t+_658*fill.cy/100;fill.r=fill.r*Math.sqrt(_657*_657+_658*_658)/200;}break;case "pattern":if(_656==="plot"||_656==="shapeX"||_656==="shapeY"){fill=gfx.makeParameters(gfx.defaultPattern,fill);fill.space=_656;if(_656==="plot"||_656==="shapeX"){span=dim.height-_655.t-_655.b;fill.y=_655.t+span*fill.y/100;fill.height=span*fill.height/100;}if(_656==="plot"||_656==="shapeY"){span=dim.width-_655.l-_655.r;fill.x=_655.l+span*fill.x/100;fill.width=span*fill.width/100;}}break;}return fill;},_shapeFill:function(fill,bbox){if(!fill||!fill.space){return fill;}var _659=fill.space,span;switch(fill.type){case "linear":if(_659==="shape"||_659==="shapeX"||_659==="shapeY"){fill=gfx.makeParameters(gfx.defaultLinearGradient,fill);fill.space=_659;if(_659==="shape"||_659==="shapeX"){span=bbox.width;fill.x1=bbox.x+span*fill.x1/100;fill.x2=bbox.x+span*fill.x2/100;}if(_659==="shape"||_659==="shapeY"){span=bbox.height;fill.y1=bbox.y+span*fill.y1/100;fill.y2=bbox.y+span*fill.y2/100;}}break;case "radial":if(_659==="shape"){fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_659;fill.cx=bbox.x+bbox.width/2;fill.cy=bbox.y+bbox.height/2;fill.r=fill.r*bbox.width/200;}break;case "pattern":if(_659==="shape"||_659==="shapeX"||_659==="shapeY"){fill=gfx.makeParameters(gfx.defaultPattern,fill);fill.space=_659;if(_659==="shape"||_659==="shapeX"){span=bbox.width;fill.x=bbox.x+span*fill.x/100;fill.width=span*fill.width/100;}if(_659==="shape"||_659==="shapeY"){span=bbox.height;fill.y=bbox.y+span*fill.y/100;fill.height=span*fill.height/100;}}break;}return fill;},_pseudoRadialFill:function(fill,_65a,_65b,_65c,end){if(!fill||fill.type!=="radial"||fill.space!=="shape"){return fill;}var _65d=fill.space;fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_65d;if(arguments.length<4){fill.cx=_65a.x;fill.cy=_65a.y;fill.r=fill.r*_65b/100;return fill;}var _65e=arguments.length<5?_65c:(end+_65c)/2;return {type:"linear",x1:_65a.x,y1:_65a.y,x2:_65a.x+fill.r*_65b*Math.cos(_65e)/100,y2:_65a.y+fill.r*_65b*Math.sin(_65e)/100,colors:fill.colors};return fill;}});});},"dijit/_WidgetBase":function(){define("dijit/_WidgetBase",["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./Destroyable","./registry"],function(_65f,_660,_661,_662,_663,_664,dom,_665,_666,_667,_668,_669,has,_66a,lang,on,_66b,_66c,_66d,win,_66e,_66f){has.add("dijit-legacy-requires",!_66a.isAsync);if(has("dijit-legacy-requires")){_66b(0,function(){var _670=["dijit/_base/manager"];_65f(_670);});}var _671={};function _672(obj){var ret={};for(var attr in obj){ret[attr.toLowerCase()]=true;}return ret;};function _673(attr){return function(val){_665[val?"set":"remove"](this.domNode,attr,val);this._set(attr,val);};};return _664("dijit._WidgetBase",[_66c,_66e],{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_673("lang"),dir:"",_setDirAttr:_673("dir"),textDir:"","class":"",_setClassAttr:{node:"domNode",type:"class"},style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,ownerDocument:null,_setOwnerDocumentAttr:function(val){this._set("ownerDocument",val);},attributeMap:{},_blankGif:_662.blankGif||_65f.toUrl("dojo/resources/blank.gif"),postscript:function(_674,_675){this.create(_674,_675);},create:function(_676,_677){this.srcNodeRef=dom.byId(_677);this._connects=[];this._supportingWidgets=[];if(this.srcNodeRef&&(typeof this.srcNodeRef.id=="string")){this.id=this.srcNodeRef.id;}if(_676){this.params=_676;lang.mixin(this,_676);}this.postMixInProperties();if(!this.id){this.id=_66f.getUniqueId(this.declaredClass.replace(/\./g,"_"));if(this.params){delete this.params.id;}}this.ownerDocument=this.ownerDocument||(this.srcNodeRef?this.srcNodeRef.ownerDocument:win.doc);this.ownerDocumentBody=win.body(this.ownerDocument);_66f.add(this);this.buildRendering();var _678;if(this.domNode){this._applyAttributes();var _679=this.srcNodeRef;if(_679&&_679.parentNode&&this.domNode!==_679){_679.parentNode.replaceChild(this.domNode,_679);_678=true;}this.domNode.setAttribute("widgetId",this.id);}this.postCreate();if(_678){delete this.srcNodeRef;}this._created=true;},_applyAttributes:function(){var ctor=this.constructor,list=ctor._setterAttrs;if(!list){list=(ctor._setterAttrs=[]);for(var attr in this.attributeMap){list.push(attr);}var _67a=ctor.prototype;for(var _67b in _67a){if(_67b in this.attributeMap){continue;}var _67c="_set"+_67b.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();})+"Attr";if(_67c in _67a){list.push(_67b);}}}var _67d={};for(var key in this.params||{}){_67d[key]=this[key];}_660.forEach(list,function(attr){if(attr in _67d){}else{if(this[attr]){this.set(attr,this[attr]);}}},this);for(key in _67d){this.set(key,_67d[key]);}},postMixInProperties:function(){},buildRendering:function(){if(!this.domNode){this.domNode=this.srcNodeRef||this.ownerDocument.createElement("div");}if(this.baseClass){var _67e=this.baseClass.split(" ");if(!this.isLeftToRight()){_67e=_67e.concat(_660.map(_67e,function(name){return name+"Rtl";}));}_666.add(this.domNode,_67e);}},postCreate:function(){},startup:function(){if(this._started){return;}this._started=true;_660.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});},destroyRecursive:function(_67f){this._beingDestroyed=true;this.destroyDescendants(_67f);this.destroy(_67f);},destroy:function(_680){this._beingDestroyed=true;this.uninitialize();function _681(w){if(w.destroyRecursive){w.destroyRecursive(_680);}else{if(w.destroy){w.destroy(_680);}}};_660.forEach(this._connects,lang.hitch(this,"disconnect"));_660.forEach(this._supportingWidgets,_681);if(this.domNode){_660.forEach(_66f.findWidgets(this.domNode,this.containerNode),_681);}this.destroyRendering(_680);_66f.remove(this.id);this._destroyed=true;},destroyRendering:function(_682){if(this.bgIframe){this.bgIframe.destroy(_682);delete this.bgIframe;}if(this.domNode){if(_682){_665.remove(this.domNode,"widgetId");}else{_667.destroy(this.domNode);}delete this.domNode;}if(this.srcNodeRef){if(!_682){_667.destroy(this.srcNodeRef);}delete this.srcNodeRef;}},destroyDescendants:function(_683){_660.forEach(this.getChildren(),function(_684){if(_684.destroyRecursive){_684.destroyRecursive(_683);}});},uninitialize:function(){return false;},_setStyleAttr:function(_685){var _686=this.domNode;if(lang.isObject(_685)){_669.set(_686,_685);}else{if(_686.style.cssText){_686.style.cssText+="; "+_685;}else{_686.style.cssText=_685;}}this._set("style",_685);},_attrToDom:function(attr,_687,_688){_688=arguments.length>=3?_688:this.attributeMap[attr];_660.forEach(lang.isArray(_688)?_688:[_688],function(_689){var _68a=this[_689.node||_689||"domNode"];var type=_689.type||"attribute";switch(type){case "attribute":if(lang.isFunction(_687)){_687=lang.hitch(this,_687);}var _68b=_689.attribute?_689.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);if(_68a.tagName){_665.set(_68a,_68b,_687);}else{_68a.set(_68b,_687);}break;case "innerText":_68a.innerHTML="";_68a.appendChild(this.ownerDocument.createTextNode(_687));break;case "innerHTML":_68a.innerHTML=_687;break;case "class":_666.replace(_68a,_687,this[attr]);break;}},this);},get:function(name){var _68c=this._getAttrNames(name);return this[_68c.g]?this[_68c.g]():this[name];},set:function(name,_68d){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _68e=this._getAttrNames(name),_68f=this[_68e.s];if(lang.isFunction(_68f)){var _690=_68f.apply(this,Array.prototype.slice.call(arguments,1));}else{var _691=this.focusNode&&!lang.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_691].tagName,_692=_671[tag]||(_671[tag]=_672(this[_691])),map=name in this.attributeMap?this.attributeMap[name]:_68e.s in this?this[_68e.s]:((_68e.l in _692&&typeof _68d!="function")||/^aria-|^data-|^role$/.test(name))?_691:null;if(map!=null){this._attrToDom(name,_68d,map);}this._set(name,_68d);}return _690||this;},_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();});return (apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});},_set:function(name,_693){var _694=this[name];this[name]=_693;if(this._created&&_693!==_694){if(this._watchCallbacks){this._watchCallbacks(name,_694,_693);}this.emit("attrmodified-"+name,{detail:{prevValue:_694,newValue:_693}});}},emit:function(type,_695,_696){_695=_695||{};if(_695.bubbles===undefined){_695.bubbles=true;}if(_695.cancelable===undefined){_695.cancelable=true;}if(!_695.detail){_695.detail={};}_695.detail.widget=this;var ret,_697=this["on"+type];if(_697){ret=_697.apply(this,_696?_696:[_695]);}if(this._started&&!this._beingDestroyed){on.emit(this.domNode,type.toLowerCase(),_695);}return ret;},on:function(type,func){var _698=this._onMap(type);if(_698){return _661.after(this,_698,func,true);}return this.own(on(this.domNode,type,func))[0];},_onMap:function(type){var ctor=this.constructor,map=ctor._onMap;if(!map){map=(ctor._onMap={});for(var attr in ctor.prototype){if(/^on/.test(attr)){map[attr.replace(/^on/,"").toLowerCase()]=attr;}}}return map[typeof type=="string"&&type.toLowerCase()];},toString:function(){return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";},getChildren:function(){return this.containerNode?_66f.findWidgets(this.containerNode):[];},getParent:function(){return _66f.getEnclosingWidget(this.domNode.parentNode);},connect:function(obj,_699,_69a){return this.own(_663.connect(obj,_699,this,_69a))[0];},disconnect:function(_69b){_69b.remove();},subscribe:function(t,_69c){return this.own(_66d.subscribe(t,lang.hitch(this,_69c)))[0];},unsubscribe:function(_69d){_69d.remove();},isLeftToRight:function(){return this.dir?(this.dir=="ltr"):_668.isBodyLtr(this.ownerDocument);},isFocusable:function(){return this.focus&&(_669.get(this.domNode,"display")!="none");},placeAt:function(_69e,_69f){var _6a0=!_69e.tagName&&_66f.byId(_69e);if(_6a0&&_6a0.addChild&&(!_69f||typeof _69f==="number")){_6a0.addChild(this,_69f);}else{var ref=_6a0?(_6a0.containerNode&&!/after|before|replace/.test(_69f||"")?_6a0.containerNode:_6a0.domNode):dom.byId(_69e,this.ownerDocument);_667.place(this.domNode,ref,_69f);if(!this._started&&(this.getParent()||{})._started){this.startup();}}return this;},getTextDir:function(text,_6a1){return _6a1;},applyTextDir:function(){},defer:function(fcn,_6a2){var _6a3=setTimeout(lang.hitch(this,function(){_6a3=null;if(!this._destroyed){lang.hitch(this,fcn)();}}),_6a2||0);return {remove:function(){if(_6a3){clearTimeout(_6a3);_6a3=null;}return null;}};}});});}}});define("dojox/charting/widget/Chart2D",["dojo/_base/kernel","dojo/_base/lang","./Chart","../Chart2D","../action2d/Highlight","../action2d/Magnify","../action2d/MoveSlice","../action2d/Shake","../action2d/Tooltip"],function(_6a4,lang,_6a5){_6a4.deprecated("dojox.charting.widget.Chart2D","Use dojo.charting.widget.Chart instead and require all other components explicitly","2.0");return lang.setObject("dojox.charting.widget.Chart2D",_6a5);});