/*******************************************************************************
 * Copyright (c) ${year} Texas Instruments Incorporated - http://www.ti.com/
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Texas Instruments Incorporated - initial API and implementation
 *
 * Original Author:
 *     Boualem Sekhri.
 *
 *
 * Contributing Authors:
 *
 * About:
 * 		This script requires dojo , jquery
 *******************************************************************************/
	// Required for the modal dialog that shows critical errors
	require(['dijit/Dialog']);
	
    // check if websocket is supported
    if (!window.WebSocket && window.MozWebSocket){
        window.WebSocket = window.MozWebSocket;
    }
    if (!window.WebSocket)
    {
        alert("WebSockets are not supported by this browser.\nPlease use Firefox or Chrome!");
	}

	var $TI =
	{	helper :
		{
            getCurrentPage : function()
			{
				var sPath = getPathName();
				var sPage = sPath.substring(sPath.lastIndexOf('/') + 1);
				return sPage;
			},
			getPathName : function()
			{
				if( typeof $GC_original_pathname != 'undefined') {
					return $GC_original_pathname;
				}
				return window.location.pathname;
			},
			getHref : function() {
				if( typeof $GC_original_href != 'undefined') {
					return $GC_original_href;
				}
				return window.location.href;
			},
			getClass : function (object) 
			{
			  return Object.prototype.toString.call(object)
			    .match(/^\[object\s(.*)\]$/)[1];
			},
			   showDialog:function(title, content)
			{
				var dlg = new dijit.Dialog(
				{
				        title: title,
				        style: "width: 410px;",
				        content: "<table border='0' style='width:100%;'> <tr><td>"+content+
				        "<br><br><br> </td></tr> <tr><td style='text-align: center;'>"+
				        "<button id='okBt'>OK</button></td></tr> </table>"

				});
				dojo.connect(dojo.byId("okBt"),"onclick",null,function(){
					dlg.destroyRecursive();
				});
				
				dlg.show();			
			},
			showError : function(title, content)
			{
				this.showDialog( title, '<strong>ERROR : </strong>' + content); 
			},
			showWarning : function(title, content)
			{
				this.showDialog( title, '<strong>Warning : </strong>' + content); 
			},
			showInformation : function(title, content)
			{
				this.showDialog( title, '<strong>Information : </strong>' + content); 
			},
			getGCLibVersion : function() {
				return { 
					major : 1, 
					minor : 0, 
					revision : 1, 
					path : "davinci.gc_1_0",
					name : "1.0.1"
				};
			},
			getDocumentVersion : function() {
				var head = document.head;
				var attrs = head != null ? head.attributes : null; 
				var node = attrs != null ? attrs.item("data-gc-version") : null;
				var version = node != null ? node.value : null;
				if( version == null) {
					return null;
				}
				var versionName = version; 
				var ret = { name : versionName};
				var parts = version.split(".");
				if( parts.length > 0) {
					var major = parseInt(parts[0]);
					if( !isNaN(major)) {
						ret.major = major;
					}
				}
				if( parts.length > 1) {
					var minor = parseInt(parts[1]);
					if( !isNaN(minor)) {
						ret.minor = minor;
					}
				}
				return ret;
			},
			checkVersion : function() {
				var docVersion = this.getDocumentVersion();
				var libVersion = this.getGCLibVersion();

				if( docVersion == null) {
					window.location  = "lib/"+libVersion.path+"/WebContent/gc/backplane/error_missing_version.html";
					return;
				}
				
				if( libVersion.major != docVersion.major) {
					window.location  = "lib/"+libVersion.path+"/WebContent/gc/backplane/error_incompatible_version.html";	
					return;
				}
			},
			log : function(msg) {
				if (window.$TI_eclipseLog) {
					window.$TI_eclipseLog(msg);
				} else {
					console.log(msg);
				}
			}
		},
    //----------------define guiComposerServer (WebSocket client) -------------
        guiComposerServer : {
            connected : false,
            widgetsBeingUpdatedList : {},
            widgetRegistry : {},
            widgetBindings : new Array(),
            activeWidgetBindings : new Array(),
            executeOperations : new Array(),
            inPreProcessingFunctionRegistry: {},
            outPreProcessingFunctionRegistry : {},
            operationIdCounter : 0,
            requestIdRegistry : {},
            dropUpdateWidgets : new Array(),
            defaultBindingsSent : null, 
            join : function() 
            {
            	var pathname = $TI.helper.getPathName();
                var socketURL = $TI.helper.getHref().replace('http://', 'ws://').replace('https://', 'wss://');
                if(pathname != '/') {
                	socketURL = socketURL.replace(pathname,'/ws/');
                }

                this._ws = new WebSocket(socketURL, "gui_composer");
                this._ws.onopen = this._onopen;
                this._ws.onmessage = this._onmessage;
                this._ws.onclose = this._onclose;
            },
            _onopen : function() 
            {
                $TI.guiComposerServer.connected = true;
                $TI.helper.log("guiComposer.js: connected = true");
                $TI.guiComposerServer._sendInitInfo();
                $TI.guiComposerServer.sendBindings();
                $TI.guiComposerServer.sendAllExecuteOperations();
                $TI.helper.log("guiComposer.js: $TI.guiComposerServer.defaultBindingsSent = true");
                $TI.guiComposerServer.defaultBindingsSent = true;
            },
            _send : function(message) 
            {
                if (this._ws){
                    this._ws.send(message);
                }
                else{
                    alert("WebSocket Connection to server is closed!" );
                }
            },
            _onmessage : function(event) 
            {
                if (event.data)
                {
                    // create object from the json request
                    var requestObject = dojo.fromJson(event.data);
                    var requestName = requestObject.requestName;
                    
                    if(requestName === "ping")
                    {
                        var pingReplyMessage = { requestName : "pingReply"};
                        var pingReplyMessageJson = dojo.toJson(pingReplyMessage);
                        $TI.guiComposerServer._send(pingReplyMessageJson);
                    }
                    else if(requestName === "propertyChange" || 
                    		requestName === "propertyStatusChange")
                    {
                        var widgetId = requestObject.widgetId;
                        var propertyName = requestObject.propertyName;
                        var newValue = requestObject.newValue;
                        var timeSend = requestObject.timeSent;
                        var timeDelay = 0;
                        var currentTime = null;
                        if( timeSend) {
                           	currentTime = new Date().getTime();
                        	timeDelay = currentTime - timeSend; 
                        	if( timeDelay < 0) {
                        		timeDelay = 0;
                        	}
                        }

                    	$TI.helper.log( "guiComposer.js: INFO: _onmessage: id="+widgetId + ", current delay="+timeDelay+")");
                        
                        if(widgetId === "backplane" && propertyName === "value:backplane.$last_critical_error")
                    	{
	                    	var errorMessage = requestObject.newValue;
	                    	if( errorMessage != null && errorMessage.length != 0)
	                    	{
	                    		//alert("Critical Error: \n" + errorMessage);
	                    		$TI.helper.showError("Critical Error", errorMessage);
	                    	} 
	                    	
	                    	return; 
                    	}    

						// perform preProcessing on the received data if we have a inPreProcessingFunction regitstred for the current [widgetId, propertyName]]
                        if(($TI.guiComposerServer.inPreProcessingFunctionRegistry[widgetId]) )
                        {  
	                        var inPreProcessingFunction = ($TI.guiComposerServer.inPreProcessingFunctionRegistry[widgetId]) [propertyName];
	                        if(inPreProcessingFunction != null)
	                        {
	                           // we don't want errors in the inPreProcessingFunction 
	                           // function to cause script execution to stop.
	                            try 
	                            {
                            		newValue = inPreProcessingFunction(newValue);	
	                        	}
	                        	catch(err)
	                        	{
	                        	    // should we show something to the user??
	                        	}
	                        }
                        }
                        
                        // set the property of the widget to the newValue;
                        var widget = dijit.byId(widgetId);
                        if( !widget)
                        {
                            widget = $TI.guiComposerServer.widgetRegistry[widgetId];
                        }
                        
                        if(widget)
                        {
                        	if( requestName === "propertyChange") {
                        		
                        		var skipNextUpdate = false;
                        		
                                if( timeSend) {
                                	if( $TI.guiComposerServer.dropUpdateWidgets[widgetId] && $TI.guiComposerServer.dropUpdateWidgets[widgetId][propertyName]) {
                               			var dropUpdate = $TI.guiComposerServer.dropUpdateWidgets[widgetId][propertyName].dropUpdate;
                               			if( typeof dropUpdate != 'undefined') {
                                   			var forceUpdate = $TI.guiComposerServer.dropUpdateWidgets[widgetId][propertyName].forceUpdate;
                                   			var lastUpdate = $TI.guiComposerServer.dropUpdateWidgets[widgetId][propertyName].lastUpdate;
                                   			
                                   			// make sure we drop an update only if we the widget has been update at least once, otherwise don't skip. 
                                   			if( typeof lastUpdate != 'undefined') {
                                   				
                                   				// if the delay is too big, drop an update.  
                                   				if( timeDelay > dropUpdate) {
                                   					
                                   					// if we don't care about force update , drop the update.
                                   					if( typeof forceUpdate == 'undefined') {
                                   						$TI.helper.log( "guiComposer.js: DROPPED UPDATE( id="+widgetId+" current delay="+timeDelay);
                                   						skipNextUpdate = true;
                                   					}
                                   					
                                   					// but if we haven't updated the widget for a long time, don't skip.
                                   					if( !skipNextUpdate && (currentTime - lastUpdate  < forceUpdate)) {
                                   						
                                   						$TI.helper.log( "guiComposer.js: DROPPED UPDATE( id="+widgetId+
                                      						" current delay="+timeDelay+" accumulated delay=" + (currentTime - lastUpdate));
                                   						skipNextUpdate = true;
                                   					}

                                   					if( !skipNextUpdate) {
                                   						// too much time without update - do not skip.
                                   						$TI.helper.log( "guiComposer.js: FORCED UPDATE( id="+widgetId+
                                   							" current delay="+timeDelay+" accumulated delay=" + (currentTime - lastUpdate));
                                   					}
                                   				}
                                  			}                           				
                                   			
                                   			// save the time of last update.
                                   			if( !skipNextUpdate && (typeof forceUpdate != 'undefined')) {
                                   				$TI.guiComposerServer.dropUpdateWidgets[widgetId][propertyName].lastUpdate = currentTime;
                                   			}
                               			}
                               		}
                                }

                                if( skipNextUpdate) {
                                	if( typeof widget.skipNextUpdate != 'undefined') {
                   						$TI.helper.log( "guiComposer.js: WIDGET SKIP UPDATE ( id="+widgetId+" current delay="+timeDelay);
                                		widget.skipNextUpdate();
                                	}
                                	else {
                                		return;
                                	}
                                }
                                
	                            //check if this is a new value
	                            var currentValue = widget.get(propertyName);
	
	                            if(newValue != "null" && currentValue != newValue)
	                            {
	                                $TI.guiComposerServer.widgetsBeingUpdatedList[widgetId+"."+propertyName] = true;
	                                widget.set(propertyName, newValue);
	                                $TI.guiComposerServer.widgetsBeingUpdatedList[widgetId+"."+propertyName] = false;                                
	                            }
                        	}
                        	else if( requestName === "propertyStatusChange") {
                                if(widget.setBindStatus) {
                                	var status = {
                                		statusType : requestObject.statusType,
                                		message : requestObject.message
                                	}; 
                                	widget.setBindStatus( propertyName, status);
                                }
                        	}
                        }
                        else
                        {
                            alert("widget not found. widgetId =" + widgetId);
                        }
                    }
                    else if(requestName === "operationCompleted")
                    {
                        var requestId = requestObject.requestId;
                        var result = requestObject.result;
                        
                        var requestInfo = $TI.guiComposerServer.requestIdRegistry[requestId];

                        
                        if(requestInfo != null)
                        {
                            // remove it from the list
	                        //var idx = $TI.guiComposerServer.requestIdRegistry.indexOf(requestId); // Find the index
	                        //if(idx!=-1) $TI.guiComposerServer.requestIdRegistry.splice(idx, 1)
                            delete $TI.guiComposerServer.requestIdRegistry[requestId];
                            
                            var operationId = requestInfo.operationId;
                            var callbackFunction = requestInfo.callbackFunction;
                            
                            if(callbackFunction)
                            {
                                try
                                {
                                    callbackFunction(result, operationId );
                                }
                                catch(err)
                                {
                                    //  should we inform the user??
                                }
                            }
                        
                        }
                    
                    }
                    else if(requestName === "trace")
                    {
                        var logId = requestObject.id;
                        var message = requestObject.message;
                        var component = requestObject.component;
                         
                        var traceMessage = { requestName : "trace", logId : logId, message : message, component : component};
                        var traceMessageJson = dojo.toJson(traceMessage);
                        $TI.guiComposerServer._send(traceMessageJson);
                    }
                    else
                    {
                        alert("unknown requestName = " + requestName);
                    }
                }
            },
            _onclose : function(event) 
            {
                this._ws = null;
                $TI.guiComposerServer.connected = false;
            },
            setModelValue : function( modelBind, value) {
            	addBindings( null, null, modelBind, { defaultValue : value});
            },
            addBinding : function(widgetId, propertyName, serverBindName, options)
            {
            	// support for setting model bind values without creating widget binds. 
                if( typeof widgetId == 'undefined' || widgetId == null || widgetId.length == 0) {
                	
                	if( typeof serverBindName != 'undefined' && 
                		typeof options != 'undefined' && 
                		typeof options.defaultValue != 'undefined') {
                		
                        var widgetBinding = { serverBindName: serverBindName, options: options };
                        $TI.guiComposerServer.widgetBindings.push(widgetBinding);
                        $TI.guiComposerServer.sendBindings();
                	}
                	else {
                		$TI.helper.log("guiComposer.js: ERROR: widgetId is null or empty.");
                	}
                    return;
                } 
                          
                var widgetProxy = dijit.byId(widgetId);
                if( !widgetProxy) {
                    widgetProxy = $TI.guiComposerServer.widgetRegistry[widgetId];
                }
                
                var initialModelBindEnabled = true;
                
                if(widgetProxy) {
                    //add a watch function
                    var listener = function(propertyName, oldValue, newValue) {
                        $TI.guiComposerServer.widgetChangeListener(widgetId, propertyName, newValue);
                    };
                    $TI.helper.log("guiComposer.js: INFO: Adding watch to:" + widgetId + ":" + propertyName );
                    widgetProxy.watch(propertyName, listener);
                    
                    // support for automatic model bind disabled when the widget is hidden or disabled. 
                    var modelBindEnabledListener = function(p, oldValue, newValue) {
                    	$TI.helper.log("guiComposer.js: INFO: OnModelBindEnabledChanged( id=" + 
                    		widgetId + ", prop=" + propertyName + ", value= " + newValue);
                    	for (var i = 0; i < $TI.guiComposerServer.activeWidgetBindings.length; ++i) {
                    		if (widgetId === $TI.guiComposerServer.activeWidgetBindings[i].widgetId) {
                    			$TI.guiComposerServer.enableBinding(newValue, widgetId, null);
                    			break;
                    		}
                    	}
                    	
                    }; 
                    widgetProxy.watch("modelBindEnabled", modelBindEnabledListener);
                    initialModelBindEnabled = widgetProxy.get( "modelBindEnabled");
                    if(( typeof initialModelBindEnabled === "undefined") || (initialModelBindEnabled === null)) {
                    	initialModelBindEnabled = true;
                    }
                    $TI.helper.log("guiComposer.js: INFO: Initial ModelBindEnabled = " + initialModelBindEnabled + " for id=" + widgetId);
                }
                else {
                    $TI.helper.log("guiComposer.js: ERROR: AddBinding() failed. There is no widget with id = '" + widgetId +"'");
                    return;
                }

                // extract inPreProcessingFunction and outPreProcessingFunction from options
                if( options != null) {
                	this.inPreProcessingFunction = options.inPreProcessingFunction;
                    this.outPreProcessingFunction = options.outPreProcessingFunction;
                    delete options.inPreProcessingFunction;
                    delete options.outPreProcessingFunction;
                }

                // add to the map of slow widgets if needed.
                if( options != null && ( options.dropUpdate || options.forceUpdate)) {
                	if( typeof this.dropUpdateWidgets[widgetId] == 'undefined') {
                		this.dropUpdateWidgets[widgetId] = new Array();
                	}
                	if( typeof this.dropUpdateWidgets[widgetId][propertyName] == 'undefined') {
                		this.dropUpdateWidgets[widgetId][propertyName] = {}; 
                	}
                	if( options.dropUpdate) {
                		this.dropUpdateWidgets[widgetId][propertyName].dropUpdate = options.dropUpdate;
                		delete options.dropUpdate; // do not send to the server.
                	}
                	if( options.forceUpdate) {
                		this.dropUpdateWidgets[widgetId][propertyName].forceUpdate = options.forceUpdate;
                		delete options.forceUpdate; // do not send to the server.
                	}
                }

                // create the widgetBinding-----
                var widgetBinding = {  widgetId: widgetId, propertyName: propertyName,
                                        serverBindName: serverBindName, options: options 
                                    };

                if( widgetBinding.options && !initialModelBindEnabled) {
                	widgetBinding.options.disabled = true;
                }
                 
                // add it to the widgetBindings. will be sent later------
                $TI.guiComposerServer.widgetBindings.push(widgetBinding);
                
                // store inPreProcessingFunction if not null 
                if(this.inPreProcessingFunction && this.inPreProcessingFunction != null)
                {
                    if(! (widgetId in $TI.guiComposerServer.inPreProcessingFunctionRegistry))
                    {
                	   $TI.guiComposerServer.inPreProcessingFunctionRegistry[widgetId] = {};
                	}
                	$TI.guiComposerServer.inPreProcessingFunctionRegistry[widgetId][ propertyName]= this.inPreProcessingFunction;
                }
                
                
                // store outPreProcessingFunction if not null 
                if(this.outPreProcessingFunction && this.outPreProcessingFunction != null)
                {
                    if(! (widgetId in $TI.guiComposerServer.outPreProcessingFunctionRegistry))
                    {
                       $TI.guiComposerServer.outPreProcessingFunctionRegistry[widgetId] = {};
                    }
                    $TI.guiComposerServer.outPreProcessingFunctionRegistry[widgetId][ propertyName]= this.outPreProcessingFunction;
                }
                
                
                // send it for the web-server
                $TI.guiComposerServer.sendBindings();
            },
            removeBinding : function(widgetId, propertyName)
            {
                if(!$TI.guiComposerServer.connected)
                {   
                    // todo: inform the user that we have no connection as this time
                    return;
                }
                
                
                if(widgetId==null || widgetId.length==0)   
                {
                    $TI.helper.log("guiComposer.js: removeBinding widgetId cannot be null");
                    return;
                } 
                
                if(propertyName==null || propertyName.length==0)   
                {
                    $TI.helper.log("guiComposer.js: removeBinding propertyName cannot be null");
                    return;
                } 
                
                  
                try
                {
                    $TI.helper.log("guiComposer.js: remove bindings" );                
                 
                    // create a "removeWidgetBindings" request and send to webServer
                    var removeWidgetBindingRequest = { requestName : "removeWidgetBindings", widgetBindings : [ {widgetId: widgetId, propertyName: propertyName}] };
                    var removeWidgetBindingRequestJson = dojo.toJson(removeWidgetBindingRequest);
                    $TI.guiComposerServer._send(removeWidgetBindingRequestJson);
                    
                    
	                // remove binding from cache
	                for (var i = 0; i < $TI.guiComposerServer.activeWidgetBindings.length; ++i) {
	                	var binding = $TI.guiComposerServer.activeWidgetBindings[i];
	                	if (binding.widgetId === widgetId && binding.propertyName === propertyName) {
	                		$TI.guiComposerServer.activeWidgetBindings.splice(i, 1);
	                		break;
	                	}
	                }
                    
                    // clear the binding array------
                    $TI.guiComposerServer.widgetBindings.length = 0;
               }
               catch(err)
               {
                  $TI.helper.log("guiComposer.js: error in sendBindings :" + err);
               }
            },
            enableBinding : function(enable, widgetId, propertyName) {
            	this.enableBindings( enable, [ { widgetId: widgetId, propertyName : propertyName}]);
            },
            enableBindings : function(enable, widgetBindings) {
            	var enableBool = enable ? true : false;
           		var request = { requestName : "enableWidgetBindings", enable : enableBool, widgetBindings : widgetBindings };
                var requestJson = dojo.toJson(request);
           		$TI.guiComposerServer._send(requestJson);
            },
            addBindingsFromFile :  function (bindingDefinitionFile)
	        {
	            if(bindingDefinitionFile == null)
                {
                    return;
                }

 	            // -------------load json widget binding information
                dojo.xhrGet(
                {
                    url: bindingDefinitionFile,
                    handleAs: "json",
                    sync : true ,
                    load: function(data)
                    {
                        var widgetBindingsFromFile = data.widgetBindings;
                        var widgetBinding;
                        for(var i in widgetBindingsFromFile)
                        {
                            widgetBinding = widgetBindingsFromFile[i];
                            // special tretement for inPreProcessingFunction and outPreProcessingFunction                            
                            try
                            {
                                if(widgetBinding.options.inPreProcessingFunction)
                                {
                                	widgetBinding.options.inPreProcessingFunction = eval(widgetBinding.options.inPreProcessingFunction);
                                    
                                }
                            }
                            catch(err)
                            {                            
                            }
                            
                            try
                            {
                                if(widgetBinding.options.outPreProcessingFunction)
                                {
                                	widgetBinding.options.outPreProcessingFunction = eval(widgetBinding.options.outPreProcessingFunction);
                                }
                            }
                            catch(err)
                            {                            
                            }                            
                            
                            $TI.guiComposerServer.addBinding(widgetBinding.widgetId, widgetBinding.propertyName, 
                                                        widgetBinding.serverBindName, widgetBinding.options);
                        }
                    },
                    error: function(err)
                    {
                        $TI.helper.log("guiComposer.js: Error loading 'binding definitions'file:" + bindingDefinitionFile + "\n"   + err);
                    }
                });
	        },
	        // execute an action on the server
	        // options syntax: { arguments :  argsValue, widgetId : widgetIdValue,
	        //                   propertyName : propertyNameValue, requestId : requestIdValue}
	        // Some or all of the options may be null
	        executeAsynchOperation : function(operationName, arguments, callbackFunction, operationId)
	        {
	        	var newOperaton = {
	        		operationName : operationName, 
	        		arguments : arguments, 
	        		callbackFunction: callbackFunction, 
	        		operationId : operationId
		        };
	        	$TI.guiComposerServer.executeOperations.push(newOperaton);
	        	$TI.guiComposerServer.sendAllExecuteOperations();
	        },
	        
	        //------------------------            
            registerWidget : function(widgetProxy, widgetId)
            {
                
                if(widgetProxy !=null && widgetId !=null && widgetId.length !=0)
                {
                    var widgetIdType = $TI.helper.getClass(widgetId);
                    $TI.guiComposerServer.widgetRegistry[widgetId] = widgetProxy;
                }
            },
            // ---------main listener for property change in all widgets
		    // sends change to ws server.
		    widgetChangeListener : function (widgetId, propertyName, newValue)
		    {
                // perform preProcessing on the received data if we have a outPreProcessingFunction regitstred for the current [widgetId, propertyName]]
                if(($TI.guiComposerServer.outPreProcessingFunctionRegistry[widgetId]) )
                {  
                    var outPreProcessingFunction = ($TI.guiComposerServer.outPreProcessingFunctionRegistry[widgetId]) [propertyName];
                    if(outPreProcessingFunction != null)
                    {
                       // we don't want errors in the outPreProcessingFunction 
                       // function to cause script execution to stop.
                        try 
                        {
                       		newValue = outPreProcessingFunction(newValue);	
                        }
                        catch(err)
                        {
                            // should we show something to the user??
                        }
                    }
                }
		        
		        
		        // send change info to server
		        // (widgetId.property) + (newValue)
		        // or (bind) + (newValue)
		        if($TI.guiComposerServer.widgetsBeingUpdatedList[widgetId+"."+propertyName] == null)
		        {
		          $TI.guiComposerServer.widgetsBeingUpdatedList[widgetId+"."+propertyName] = false;
		        }
		        
		        if( $TI.guiComposerServer.widgetsBeingUpdatedList[widgetId+"."+propertyName] == false)
		        {
			        var messageObject = { requestName: "propertyChange" , widgetId : widgetId , propertyName : propertyName, newValue : newValue  };
			        var messageJson = dojo.toJson(messageObject);
			        $TI.guiComposerServer._send(messageJson);
		        }
		    },
		    _sendInitInfo : function() {
		    	if(!$TI.guiComposerServer.connected) {
		    		return;
		        };
		        try
		        {
		        	  $TI.helper.log("guiComposer.js: sending initial message");
		        	  var docVersion = $TI.helper.getDocumentVersion();
		        	  var libVersion = $TI.helper.getGCLibVersion();
		        	  var docHref = $TI.helper.getHref();
		        	  var messageObject = { 
		        			  requestName: "setInitInfo" , 
		        			  gcLibraryVersion : libVersion,
		        			  documentVersion : docVersion,
		        			  href : docHref
		        	  };
		        	  var messageJson = dojo.toJson(messageObject);
		        	  $TI.guiComposerServer._send(messageJson);
				}
				catch(err)
				{
				   $TI.helper.log("guiComposer.js: error in sendBindings :" + err);
				}
		    },
		    sendBindings : function()
		    {
		          if(!$TI.guiComposerServer.connected)
		          {
		              return;
		          }
		          
		         try
		         {
			         // create a "addWidgetBindings" request and send to webServer
	                var widgetBindingRequest = { requestName : "addWidgetBindings", widgetBindings : $TI.guiComposerServer.widgetBindings};
	                var widgetBindingRequestJson = dojo.toJson(widgetBindingRequest);
	                $TI.helper.log("guiComposer.js: sending bindings" +widgetBindingRequestJson);                
	                $TI.guiComposerServer._send(widgetBindingRequestJson);
			        
	                // cache the binding
	                for (var i = 0; i < $TI.guiComposerServer.widgetBindings.length; ++i) {
	                	var binding = $TI.guiComposerServer.widgetBindings[i];
	                	$TI.guiComposerServer.activeWidgetBindings.push(binding);
	                }
	                
			        // clear the binding array------
			        $TI.guiComposerServer.widgetBindings.length = 0;
		        }
		        catch(err)
		        {
		           $TI.helper.log("guiComposer.js: error in sendBindings :" + err);
		        }
		    },
		    
		    sendAllExecuteOperations : function() {
		          if(!$TI.guiComposerServer.connected)
		          {
		              return;
		          }
		          
		         try
		         {
		             $TI.helper.log("guiComposer.js: sending Execute Opreations" );
		             for( var i = 0; i < $TI.guiComposerServer.executeOperations.length; ++i) {
		            	 var currentOperation = $TI.guiComposerServer.executeOperations[i];
		            	 $TI.guiComposerServer.sendOneExecuteOperation(
		            			currentOperation.operationName, 
		            			currentOperation.arguments, 
		            			currentOperation.callbackFunction, 
		            			currentOperation.operationId
		            	);
		             }
			        // clear the executeOperations array 
		             $TI.guiComposerServer.executeOperations.length = 0;
		        }
		        catch(err)
		        {
		           $TI.helper.log("guiComposer.js: error in Execute Opreations :" + err);
		        }
		    },

		    sendOneExecuteOperation : function( operationName, arguments, callbackFunction, operationId) {
	           if(operationName == null || operationName.length == 0)
	           {
	               return;
	           }
	           
	           if(callbackFunction == null)
	           {	               
	               // one-way operation: no return expected
	               // Note that critical-errors may still be received
	               var messageObject = { requestName: "executeOperation" , operationName : operationName , arguments : arguments};
	               var messageJson = dojo.toJson(messageObject);
	               $TI.guiComposerServer._send(messageJson);
	           }
	           else
	           {
                   // create a globally-unique-requestId that will be used to map back to a (callbackFunction, operationId)
                   $TI.guiComposerServer.operationIdCounter++;
                   var requestId = $TI.guiComposerServer.operationIdCounter.toString();
                   var requestInfo = {callbackFunction : callbackFunction, operationId : operationId };
                   $TI.guiComposerServer.requestIdRegistry[requestId] = requestInfo;
                   var messageObject = { requestName: "executeOperation" , operationName : operationName , arguments : arguments , requestId : requestId };
                   var messageJson = dojo.toJson(messageObject);	                   
                   $TI.guiComposerServer._send(messageJson);
	           }
		    },
		    
	        // Widget proxy is used to support custom widgets (non DOJO widgets)
	        WidgetProxy : function (getFunction,  setFunction, watchFunction)
	        {
	            this.set=setFunction;
	            this.get=getFunction;
	            this.watch=watchFunction;
	        }
        } //guiComposerServer end >>>
    }; //$TI end >>>

	if (window.isMaqetta === undefined) {
	    // if versions don't match show error HTML page. 
		$TI.helper.checkVersion();
	    
	    require(["dojo/ready"], function(ready){
	        ready(function(){
	        	
	            // create/connect the webSocket
	            $TI.guiComposerServer.join();
	
	        	var path = $TI.helper.getPathName();
	        	var length = path.length;
	        	var jsonPath = "";
	        	if( length > 4) {
	        		jsonPath = path.substr(0, length -5) + ".json";
	        	}
	        	if( jsonPath.length > 0) {
	        		$TI.guiComposerServer.addBindingsFromFile(jsonPath);	
	        	}
	        });
	   });    
	};