/**
 * Analog meter.
 */
define([
	"dojo/_base/declare",
	"dojo/_base/lang",
	"./_BaseGauge"
], function(declare, lang, _BaseGauge) {
	return declare("gc.dijit.AnalogMeter", [_BaseGauge], {
		baseClass: "dijit dijitAnalogMeter",
		_meter: null,
		
		height: 0,
		width: 0,
		
		constructor: function(params, srcNodeRef) {
			log("AnalogMeter Constructor");
			
			this.height = this._params.height = params.height = (params.height != undefined) ? Number(params.height) : 300;
			this.width = this._params.width = params.width = (params.width != undefined) ? Number(params.width) : 120;
		},
		
		_createGauge: function(id, params) {
			return new steelseries.Linear(id, params);
		},
		
	});
});