/**
 * Fuel gauge.
 */
define([
	"dojo/_base/declare",
	"dojo/_base/lang",
	"./_BaseGauge"
], function(declare, lang, _BaseGauge) {
	return declare("gc.dijit.FuelGauge", [_BaseGauge], {
		orientation: '', // 'north', 'west'
//		_orientation: steelseries.Orientation.NORTH,
		
		constructor: function(params, srcNodeRef) {
			log('FuelGauge constructor');
					
			this.orientation = (params.orientation != undefined) ? params.orientation : 'north';

			this._params = lang.mixin(this._params, {
				section: null,
			});
			
			if (params.orientation) {
				switch (params.orientation) {
				case 'north':
					this._orientation = steelseries.Orientation.NORTH;
					break;
				case 'south':
					this._orientation = steelseries.Orientation.SOUTH;
					break;
				case 'east':
					this._orientation = steelseries.Orientation.EAST;
					break;
				case 'west':
					this._orientation = steelseries.Orientation.WEST;
					break;
				}
			}
			
			this._params = lang.mixin(this._params, {			
  				orientation: this._orientation,
			});
		},
		
		_createGauge: function(id, params) {
			return new steelseries.RadialVertical(id, params);
		}
	});
});