define([
	"dojo/_base/declare",
	"dojo/_base/lang",
    "./_BaseGraph"
], function(declare, lang, _BaseGraph) {
	return declare("gc.dijit.LineGraph", [_BaseGraph], {
		
		// Attributes
		
		_setSeries0Attr : function(values) {
			this._setSeriesN(values,0);
		},
		_setSeries1Attr : function(values) {
			this._setSeriesN(values,1);
		},
		_setSeries2Attr : function(values) {
			this._setSeriesN(values,2);
		},
		_setSeries3Attr : function(values) {
			this._setSeriesN(values,3);
		},
		_setSeries4Attr : function(values) {
			this._setSeriesN(values,4);
		},
		_setSeries5Attr : function(values) {
			this._setSeriesN(values,5);
		},
		_setSeries6Attr : function(values) {
			this._setSeriesN(values,6);
		},
		_setSeries7Attr : function(values) {
			this._setSeriesN(values,7);
		},
		
		_setSeriesN : function(values, index) {
			if( this._graph) {
				this._set('series'+index, values);
				this._setGraphSeries(values, index);
				if( this.modelBindEnabled) {
					log('LineGraph._setSeriesN('+this.id+').graph.replot()');
					this._graph.replot({resetAxes: true});
				}
			}
		},
	
		constructor: function(params, srcNodeRef) {
			var ii;
			var ss=this._params.series;
			for(ii=0;ii<ss.length;ii++){
				if(!(ss[ii].label))
					ss[ii].label="Series "+ii;
			};
			this.series0 = [0];
			for( var i = 1; i < this._numBuffers; ++i) {
				this["series"+i] = [];
			}
		},
		
		startup: function() {
			this.inherited(arguments);
			
			var seriesAll = new Array();
			for( var i = 0; i < this._numBuffers; ++i) {
				var series = this["series"+i];
	//			if (series.length > 0)
					seriesAll.push(series);
			}
            this._graph = $.jqplot(this.id, seriesAll, this._params);
		},
	});
});