define([
	"dojo/_base/declare",
	"dojo/query",
	"dojo/dom-attr",
	"dijit/form/MultiSelect",
	"./_GCBaseWidget",
	"./libs/tools",
	"dojo/dom-construct"
], function(declare, query, domAttr, MultiSelect, _GCBaseWidget,tools,construct) {
	return declare("gc.dijit.MultiSelect", [MultiSelect, _GCBaseWidget], {
		labels : "item1,item2,item3",
		multiple: false,
		size: 4,
		// for options sort
		sort:"none",
		_setSortAttr:function(s){
			if(s==this.sort)
				return;
			this._set(s);
			tools.set("labels",this.labels);
			
		},
		
		postCreate: function() {
			this.inherited(arguments);
			
			// Get a DOM node reference for the root of our widget
			var domNode = this.domNode;

			domNode.setAttribute("size", this.size);
			if (!this.multiple)
				domNode.removeAttribute("multiple");
		},
		
		_setLabelsAttr : function(labels) {
			this._set('labels', labels);
			//remove old data
			this.domNode.length=0;
			var data=tools.parseLabels(labels);
			tools.sortOptions(this,data);
			for(var i=0;i<data.length;i++){
				var opt=construct.create("option",{"value":data[i].value,"innerHTML":data[i].label});
				this.domNode.appendChild(opt);
			}
		},		
	});
});