define([
	"dojo/_base/declare",
	"dijit/form/NumberSpinner",
	"./_GCBaseWidget",
	"dojo/number"
], function(declare, NumberSpinner, _GCBaseWidget,number) {
	return declare("gc.dijit.NumberSpinner", [NumberSpinner, _GCBaseWidget], {
		min: "",
		max: "",
		_setMinAttr:function(min)
		{
			var nmin=number.parse(min);
			if(isNaN(nmin)||nmin>=this.constraints.max)
			{
				min="";
			}
			else
				this.constraints.min=nmin;
			this._set("min",min);
				
		},
		_setMaxAttr:function(max)
		{
			var nmax=number.parse(max);
			if(isNaN(nmax)||nmax<=this.constraints.min)
			{
				max="";
			}
			else
				this.constraints.max=nmax;
			this._set("max",max);
		},
		_isValidSubset:function()
		{
			return false;
		},
		_setValueAttr:function(val)
		{
			var nmax=this.constraints.max;
			var nmin=this.constraints.min;
			if(val>nmax)
				val=nmax;
			if(val<nmin)
				val=nmin;
			arguments[0]=val;
			this.inherited(arguments);
		}
	});
});