define([
    "dojo/_base/declare", 
	"dojo/dom-construct", 
	"dojo/parser", 
	"dojo/ready",
    "dijit/_WidgetBase",
	"dijit/form/RadioButton",
	"./_GCBaseWidget",
	"dijit/_Container",
	"./libs/tools",
	"dojo/on",
	"dojo/_base/lang"

    ], function(declare, domConstruct, parser, ready,_WidgetBase, RadioButton, _GCBaseWidget,_Container,tools,on,lang){
        return declare("gc.dijit.RadioButtonGroup", [_WidgetBase, _GCBaseWidget,_Container], {
        	baseClass:"radioButtonGroup",
        	labels:"Option A,Option B,Option C",
        	name:"",
        	selectedIndex:-1,
        	selectedLabel:null,
        	length:0,
        	value:null,
        	options:[],
        	style:"border:1px solid #ccc;borderRadius:4px;display:inline-block;padding:2px;",
        	title:"RadioButtonGroup",
     		_setLabelsAttr : function(labels) {
    			if(!labels)
    				return;
        		this.options=[];
    			this._set('labels', labels);
    			if(!(lang.isArray(labels))){
    				labels=labels.split(",");
    			};
    			var data=tools.parseLabels(labels);
    			if (data.length > 0) 
    			{
//    				tools.sortOptions(this,data);
    				for(var i=0;i<data.length;i++){
    					var di={
    							"label":data[i].label,
    							"value":data[i].value,
    							"id":dijit.getUniqueId("radioButton")
    					};
    					this.options.push(di);
    					
    				}
    				this.length=this.options.length;
    			}
    			this.buildRendering();
    		},
    		_setValuesAttr:function(vs){
    			if(!vs) return;
    			this._set("values",vs);
    			if(!(lang.isArray(vs))){
    				vs=vs.split(",");
    			};
    			for(var i=0;i<vs.length;i++){
    				if(i>=this.length)
    					break;
    				this.options[i].value=vs[i];
    			}
    			this.buildRendering();
   			
    		},
    		createdDomNode:false,
            buildRendering: function() {
                // create the DOM for this widget
				this.inherited(arguments);
				if(!this.createdDomNode){
					this.createdDomNode=true;
	       			this.domNode = domConstruct.create('fieldset', { id: dijit.getUniqueId("fieldset") });
	   				this._legendNode = domConstruct.create("legend", { id: dijit.getUniqueId("legend"),innerHTML:this.title });
	   				this.domNode.style.cssText = "border:1px solid #ccc;border-radius:4px;display:inline-block;padding:2px;";
	   				this.containerNode = domConstruct.create("div", { id: dijit.getUniqueId("div") });
	   				this.domNode.appendChild(this._legendNode);
	   				this.domNode.appendChild(this.containerNode);
				} else
					this.containerNode.innerHTML="";
	        		this.selectedIndex=-1;
	        		this.selectedLabel=null;
	        		this.value=null;
   				var rname=this.name?this.name:this.id;
   				var i=0;
   				for(i=0;i<this.options.length;i++){
   					var rb=domConstruct.create("input",{
   						"type":"radio",
   						"name":rname,
   						"id":this.options[i].id,
   						"value":this.options[i].value,
   						"class":"radioButtonGroupButton",
   					});
					var labelNode = domConstruct.create("label", 
					{ 
						innerHTML: this.options[i].label, 
						"for" : this.options[i].id,
						"class":"radioButtonGroupLabel"
					});
					var that=this;
					on(rb,"click",function(e){
						that._onchange(e.target.id);
					});
					var spaceNode=domConstruct.create("span",{innerHTML:"&nbsp;&nbsp;"});
					var brNode = domConstruct.create("br");
					this.containerNode.appendChild(rb);
					this.containerNode.appendChild(spaceNode);
					this.containerNode.appendChild(labelNode);
					this.containerNode.appendChild(brNode);
   				}
            },
            _onchange:function(buttonId){
            	var sIndex=0;
            	for(var i=0;i<this.options.length;i++){
            		if(buttonId==this.options[i].id){
            			sIndex=i;
            			break;
            		}
            	}
            	this.set("selectedIndex",sIndex);
            },
            _setTitleAttr:function(ti){
            	this._set("title",ti);
            	this._legendNode.innerHTML=ti;
            },
            _setValueAttr:function(v){
            	if(this.value==v)
            		return;
            	var sIndex=0;
            	for(var i=0;i<this.options.length;i++){
            		if(this.options[i].value==v){
            			sIndex=i;
            			break;
            		}
            		
            	}
            	this._set("value",this.options[sIndex].value);
            	this.set("selectedIndex",sIndex);
            },
            _setSelectedIndexAttr:function(sIndex){
            	if(typeof sIndex!="number"){
            		sIndex=parseInt(sIndex);
            	}
            	if(isNaN(sIndex))
            		return;
               	if(sIndex==this.selectedIndex)
            		return;
               	if(sIndex<0||sIndex>=this.options.length)
               		sIndex=0;
            	this._set("selectedIndex",sIndex);
            	this.set("value",this.options[sIndex].value);
            	this.set("selectedLabel",this.options[sIndex].label);
            	dojo.byId(this.options[sIndex].id).checked=true;
           	
            },
            _setSelectedLabelAttr:function(la){
            	if(this.selectedLabel==la)
            		return;
            	var sIndex=0;
            	for(var i=0;i<this.options.length;i++){
            		if(this.options[i].label==la){
            			sIndex=i;
            			break;
            		}
            		
            	}
            	this._set("selectedLabel",this.options[sIndex].label);
            	this.set("selectedIndex",sIndex);
            }
	        });
    });