define([
	"dojo/_base/declare", 
	"dijit/form/Select",
	"./_GCBaseWidget",
	"dojo/dom-style",
	"dojo/_base/lang",
	"dojo/dom-class",
	"dojo/dom-geometry",
	"./libs/tools"
], function(declare, Select, _GCBaseWidget,domStyle,lang,domClass,gemo,tools){
	var accepts=["font","font-family","font-size","color","font-weight","font-style","text-decoration","text-align", "vertical-align","white-space","text-indent","line-height"];
	function isAccept(item)
	{
		var rt=false;
		if(!item)
			return false;
		item=item.trim().toLowerCase();
		for(var i=0;i<accepts.length;i++)
		{
			if(item==accepts[i])
			{
				rt=true;
				break;
			}
			
		}
		return rt;
	};
	function parseCss(css)
	{
		var styles=css.split(";");
		var rt=[];
		for(var i1=0;i1<styles.length;i1++)
		{
			var stName=styles[i1].split(":")[0];
			if(isAccept(stName))
				rt.push(styles[i1]);
		}
		
		return rt.join(";");
	};
	function checkLength(len){
		if(len==null||len==undefined)
			return false;
		var len1=parseInt(len);
		if(len1==0||isNaN(len1))
			return false;
		len=len.toLowerCase();
		if(len.indexOf('px')>=0||len.indexOf('in')
				||len.indexOf('em')||len.indexOf('ex')
				||len.indexOf('cm')||len.indexOf('mm')
				||len.indexOf('pt')||len.indexOf('pc'))
			return true;
		return false;
	}

    return declare("gc.dijit.Select", [Select, _GCBaseWidget], {
		labels : "item1,item2,item3",
		index: 0,
		buttonPosition:"right",
		rotate:"",
		_setRotateAttr:function(deg){
			this.rotate=deg;
			if(this.domNode){
				this.domNode.style.webkitTransform="rotate("+deg+"deg)";
				this.domNode.style.MozTransform="rotate("+deg+"deg)";
			}
			
		},
		_setButtonPositionAttr:function(pos){
			this.buttonPosition=pos;
			 var btNode=this.titleNode;
			 if(btNode){
				 var pn=btNode.parentNode;
				 if((pos=="left"&&(btNode!=pn.firstChild))||
						 (pos!="left"&&(btNode!=pn.lastChild))){
					 pn.appendChild(pn.firstChild);
					 
				 }
			 }
		},		
		postCreate:function()
		{
			//add global style to popup option menu by Peter Cai 
			this.inherited(arguments);
			if(this.style)
			{
				var mapNode = this.dropDown.domNode;
				var css=this.style;
				if(lang.isObject(css)){
//					domStyle.set(mapNode, value);
				}else{
					var cssText=parseCss(css);
					if(mapNode.style.cssText){
						mapNode.style.cssText += "; " + cssText;
					}else{
						mapNode.style.cssText = cssText;
					}
				}
			}
			this.set("buttonPosition",this.buttonPosition);

			// listen for changes to dijit.form.Select, update index property when user makes a selection
			var that = this;
			this.watch("value", function(propertyName, oldValue, newValue){
				console.log("value changed: old: "+oldValue+" new Value: "+newValue);
				this.get("index");
			});
			this.watch("labels", function(propertyName, oldValue, newValue){
				console.log("labels changed: old: "+oldValue+" new Value: "+newValue);
			});
			// set a fixed width for dojo select
			var style1=this.domNode.style;
			if(style1.overflow=="hidden"){
				var width1=style1.width;
				if(checkLength(width1)){
					var container=this.containerNode;
					var inhtml=container.innerHTML;
					container.innerHTML="";
					var widthpx=domStyle.get(this.containerNode.parentNode,"width");
					container.innerHTML=inhtml;
					gemo.setMarginBox(container,{w:widthpx});
					container.style.display="inline-block";
					container.style.overflow="hidden";
					container.style.textAlign="left";
				}
			}
		},
		
		_setLabelsAttr : function(labels) {
			if(!labels)
				return;
			this._set('labels', labels);
			if(!(lang.isArray(labels))){
				labels=labels.split(",");
			};
			var data=tools.parseLabels(labels);
			if (data.length > 0) 
			{
				while(this.options.length>0)
					this.removeOption(0);
				tools.sortOptions(this,data);
//				this.removeOption(this.getOptions());
				for(i=0;i<data.length;i++){
						data[i].label+="";
					this.addOption(data[i]);
					
				}
			}
		},
		/*
		_getLabelsAttr:function(){
			var rt=this.labels;
			if(lang.isArray(rt))
				rt=rt.join();
			return rt;
		},
		*/
		// for options sort
		sort:"none",
		_setSortAttr:function(s){
			if(s==this.sort)
				return;
			this._set(s);
			tools.set("labels",this.labels);
			
		},

		_setIndexAttr : function(index) {
			this._set('index', index);
			var options = this.getOptions();
			//fixed by Peter Cai
			
			if(index<0||index>options.length)
				index=0;
			this.set("value",this.options[index]);
		},
		
		_getIndexAttr:function(){
			var ii=0;
			for(var i=0;i<this.options.length;i++){
				if(this.options[i].selected){
					ii=i;
					break;
				}
			}
			this._set("index",ii);
			return ii;
			
		}
    });
});