/**
 * 
 * Abstract base gauge, client should not instantiate this widget.
 */
define([
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dijit/_WidgetBase",
	"./_GCBaseWidget",
], function(declare, lang, _WidgetBase, _GCBaseWidget) {
	return declare("gc.dijit._BaseGauge", [_WidgetBase, _GCBaseWidget], {
		baseClass: "dijit dijitGauge",
		_gauge: null,
		_params: {},
		
		/* public attributes */
		title: '',
		unit: '',
		lcdVisible: false,
		size: 0,
		backgroundDesign: 'anthracite',
		frameDesign: 'tiltedBlack',
		sectionRatio: [],
		gradientRatio: [],
		labelNumberFormat: 'standard',
		fractionalScaleDecimals: 0,
		minValue: 0,
		maxValue: 0,
		value: 0,
				
		constructor: function(params, srcNodeRef) {
			log("_BaseGauge Constructor");
			
			/* convert text to number */
			this.title = (params.title != undefined) ? params.title : '';
			this.unit = (params.unit != undefined) ? params.unit : '';
			this.lcdVisible = (params.lcdVisible != undefined) ? params.lcdVisible : false;
			this.size = params.size = (params.size != undefined) ? Number(params.size) : 200;
			this.minValue = params.minValue = (params.minValue != undefined) ? Number(params.minValue) : 0;
			this.maxValue = params.maxValue = (params.maxValue != undefined) ? Number(params.maxValue) : 100;
			this.value = params.value = (params.value != undefined) ? Number(params.value) : this.minValue;
			this.value = params.value = (this.value < this.minValue) ? this.minValue : this.value;
			this.fractionalScaleDecimals = params.fractionalScaleDecimals = (params.fractionalScaleDecimals != undefined) ? Number(params.fractionalScaleDecimals) : 1;
			this.sectionRatio = params.sectionRatio = (params.sectionRatio != undefined && params.sectionRatio.length != 0) ? params.sectionRatio : new Array(0, 0.8, 0.95, 1);
			this.gradientRatio = params.gradientRatio = (params.gradientRatio != undefined && params.gradientRatio.length != 0) ? params.gradientRatio : new Array(0.65, 0.80, 0.98);
			
			// calculate the section values
			var total = Math.abs(this.maxValue - this.minValue);
			var first = this.minValue + Math.round(total * this.sectionRatio[0]);
			var second = this.minValue + Math.round(total * this.sectionRatio[1]);
			var third = this.minValue + Math.round(total * this.sectionRatio[2]);
			var forth = this.minValue + Math.round(total * this.sectionRatio[3]);
			
			// calculate the threshold value
			var threshold = this.minValue + Math.round(total * 0.9); 
			
			// parameter mixin
			this._params = lang.mixin({
				titleString: this.title,
				unitString: this.unit,
				lcdVisible: this.lcdVisible,
				size: this.size,
				gaugeType: steelseries.GaugeType.TYPE4,
				foregroundType: steelseries.ForegroundType.TYPE5,
				
				minValue: this.minValue,
				maxValue: this.maxValue,
				value: this.value,
				
				niceScale: false,
				lcdVisible: false,
				thresholdVisible: false,
				threshold: threshold,
				
				// create default gradient
				useValueGradient: true,
				valueGradient: new steelseries.gradientWrapper(this.minValue, this.maxValue,
			        	[0, this.gradientRatio[0], this.gradientRatio[1], this.gradientRatio[2], 1],
			        	[ new steelseries.rgbaColor(0, 200, 0, 1),
			        	  new steelseries.rgbaColor(0, 200, 0, 1),
			        	  new steelseries.rgbaColor(200, 200, 0, 1),
			              new steelseries.rgbaColor(200, 0, 0, 1),
			              new steelseries.rgbaColor(200, 0, 0, 1) ]),
			                 
			    // create default section
			    useSectionColors: true,
			    section: [steelseries.Section(first, second, 'rgba(0, 220, 0, 0.3)'),
		                   steelseries.Section(second, third, 'rgba(220, 220, 0, 0.3)'),
		                   steelseries.Section(third, forth, 'rgba(255, 0, 0, 0.3)') ],
			}, params);
			
			/* override the parameters - convert string to object */
			var _labelNumberFormat = {format: 'standard'};
			if (params.labelNumberFormat) {
				_labelNumberFormat = {format: params.labelNumberFormat};
			}
			var _frameDesign = steelseries.FrameDesign.TILTED_BLACK;
			if (params.frameDesign) {
				_frameDesign = new steelseries.FrameDesignDef(params.frameDesign);
			}
			var _backgroundDesign = steelseries.BackgroundColor.ANTHRACITE;
			if (params.backgroundDesign) {
				switch (params.backgroundDesign) {
				case 'punchedSheet':
					_backgroundDesign = steelseries.BackgroundColor.PUNCHED_SHEET;
					break;
				case 'carbon':
					_backgroundDesign = steelseries.BackgroundColor.CARBON;
					break;
				case 'stainless':
					_backgroundDesign = steelseries.BackgroundColor.STAINLESS;
					break;
				case 'brushedMetal':
					_backgroundDesign = steelseries.BackgroundColor.BRUSHED_METAL;
					break;
				case 'brushedStainless':
					_backgroundDesign = steelseries.BackgroundColor.BRUSHED_STAINLESS;
					break;
				case 'turned':
					_backgroundDesign = steelseries.BackgroundColor.TURNED;
					break;
				case 'darkGray':
					_backgroundDesign = steelseries.BackgroundColor.DARK_GRAY;
					break;
				case 'satinGray':
					_backgroundDesign = steelseries.BackgroundColor.SATIN_GRAY;
					break;
				case 'lightGray':
					_backgroundDesign = steelseries.BackgroundColor.LIGHT_GRAY;
					break;
				case 'white':
					_backgroundDesign = steelseries.BackgroundColor.WHITE;
					break;
				case 'black':
					_backgroundDesign = steelseries.BackgroundColor.BLACK;
					break;
				case 'beige':
					_backgroundDesign = steelseries.BackgroundColor.BEIGE;
					break;
				case 'brown':
					_backgroundDesign = steelseries.BackgroundColor.BROWN;
					break;
				case 'red':
					_backgroundDesign = steelseries.BackgroundColor.RED;
					break;
				case 'green':
					_backgroundDesign = steelseries.BackgroundColor.GREEN;
					break;
				case 'blue':
					_backgroundDesign = steelseries.BackgroundColor.BLUE;
					break;
				case 'anthracite':
					_backgroundDesign = steelseries.BackgroundColor.ANTHRACITE;
					break;
				case 'mud':
					_backgroundDesign = steelseries.BackgroundColor.MUD;
					break;
				}
			}
			this._params = lang.mixin(this._params, {			
				labelNumberFormat: _labelNumberFormat,
				frameDesign: _frameDesign,
				backgroundColor: _backgroundDesign,
			});
		},
				
		startup: function() {
			this.inherited(arguments);
			this._gauge = this._createGauge(this.id, this._params);
			this._gauge.setValue(this.value);
		},
		
		/**
		 * Returns a new gauge object.
		 */
		_createGauge: function(params) {
			log('Sub class needs to return the gauge object');
		},
		
		_setValueAttr: function(value) {
			this._set('value', value);
			if (this._gauge)
				this._gauge.setValueAnimated(value);
		},
	});
});