/**
 * Dijit drag and drop mixin.
 */
define([
	"dojo/_base/declare",
	"dojo/dom-construct", 
	"dojo/dom-geometry",
	"dojo/dom-style",
	"dojo/dom-class",
	"dijit/Tooltip"
], function(declare, domConstruct, domGeom,domStyle,domClass,Tooltip) {
	return declare("gc.dijit._GCBaseWidget", null, {
		_multiStatus : null,
		_statusNode : null,
		visible:true,
		//we need this flag for parent-child binding control
		bindingDisabled:false,
		disabled:false,
		readOnly:false,
		toolTip:"",
		djTooltip:null,
		modelBindEnabled:true,
		_setBindingDisabledAttr:function(bd){
			this._set("bindingDisabled",bd);
			this._setModelBinding();
		},
		/*
		 * binding must be set according to visible, disabled and parent state
		 */
		_setModelBinding:function(){
			var mb=!this.bindingDisabled&&this.visible&&!this.disabled;
			this.set("modelBindEnabled",mb);
			
		},
		_setTooltipAttr:function(tt){
			this._set("tooltip",tt);
			if(!this.djTooltip){
				this.djTooltip=new Tooltip({connectId:[this.domNode]});
			};
			this.djTooltip.set("label",tt);
		},
		_disabledClass:function(){
			if(this.domNode){
			if(this.disabled||this.readOnly){
				domClass.add(this.domNode,"widgetDisabled");
			}else{
				domClass.remove(this.domNode,"widgetDisabled");
			}
			}
		},
		_setDisabledAttr:function(dis){
			this._set("disabled",dis);
			this._disabledClass();
			this._setModelBinding();
		},
		_setReadOnlyAttr:function(ro){
			this._set("readOnly",ro);
			this._disabledClass();
			/*
			if(this.getChildren){
				var childs=this.getChildren();
				for(var i=0;i<childs.length;i++){
					childs[i].set("readOnly",ro);
				}
			}
			*/
		},
		_setModelBindEnabledAttr:function(mbe){
			this._set("modelBindEnabled",mbe);
			if(this.getChildren){
				var childs=this.getChildren();
				for(var i=0;i<childs.length;i++){
					childs[i].set("bindingDisabled",!this.modelBindEnabled);
				}
			}
			
		},
		_setVisibleAttr:function(vis){
			if(vis===null||vis==undefined)
				return;
			this._set("visible",vis);
			var svis="inherit";
			if(!vis)
				svis="hidden";
			domStyle.set(this.domNode,"visibility",svis);
			this._setModelBinding();
		},				
		
		displayStatus : 'ShowIcon', // ShowIcon, Ignore, HideWidget
		constructor: function() {
			// Need to initialize the variables here. Otherwise, they will be shared between instances.
			this._multiStatus = new Array();
			this._statusNode = {};

			if (window.log == undefined) {
				log = function(msg) {
					if (window.$TI_eclipseLog) {
						window.$TI_eclipseLog(msg);
					} else {
						console.log(msg);
					}
				};
			}
			
			log('_GCBaseWidget constructor {' + this.baseClass + '}');
		},
		
		startup: function() {
			this.inherited(arguments);
			// get a DOM node reference for the root of our widget
			var domNode = this.domNode;
			if (domNode.addEventListener) {
				var _self = this;
				dojo.connect(domNode, 'dragover', function(e) {_self._dragover(e);});
				dojo.connect(domNode, 'drop', function(e) {_self._drop(e);});
			}
		},
		
		_dragover: function(/*Event*/ event) {
			// the dragover event needs to be canceled to allow firing the drop event
			if (event.preventDefault) {
				event.preventDefault();
			}
			
			// prevent propagating to parent widget
			if (event.stopPropagation) {
				event.stopPropagation();
			}
		},
		
		_drop: function(/*Event*/ event) {
			var node = event.target;
			var widgetId = null;
			var widgetClass = null;
			
			do {
				widgetId = node.getAttribute("widgetid");
				widgetClass = node.getAttribute("class");
				node = node.parentNode;
			} while (node != null && widgetId == null);
										
			var dropText = null;
			if (window.getCCSBinding) {
				dropText = window.getCCSBinding();
			
			} else { 
				dropText = event.dataTransfer.getData("text/plain");
			}
			
			if (dropText != null) {
//				alert("widgetClass = " + widgetClass + "\n\n" + 
//						  "widgetId = " + widgetId + "\n\n" + 
//						  "dropText = " + dropText);
			}				
			
			// prevent the default action
			if (event.preventDefault) {
				event.preventDefault();
			}
			
			// prevent propagating to parent widget
			if (event.stopPropagation) {
				event.stopPropagation();
			}
		},
		
		_displayStatusAsIcon : function() {
			var message = "";
			var iconType = "warning";
			for (var msg in this._multiStatus) {
				message += this._multiStatus[msg].message + "\n";
				if( this._multiStatus[msg].statusType == "error") {
					iconType = "error"; 
				}
			}
			
			if( this._statusNode.dom) {
				this.domNode.parentElement.removeChild(this._statusNode.dom);
				this._statusNode.dom = null;
			}

			if( message.length > 0) {
				var iconName = iconType == "error" ? "error.png" : "warning.png";
				var iconFolder = "lib/davinci.gc_1_0/WebContent/gc/resources/";
				var geomObj = domGeom.position(this.domNode);
				var zIndex=domStyle.get(this.domNode,"zIndex");
				zIndex=parseInt(zIndex);
				if(isNaN(zIndex))
					zIndex=800;
				else
					zIndex+=10;
				this._statusNode.dom = domConstruct.create('img', 
					{
						src: iconFolder + iconName,
						width : 13, 
						height : 13, 
						title : message, 
						style : "position:absolute;left:" + geomObj.x + "px;top:" + geomObj.y + "px;z-index:"+zIndex+";opacity:0.8;"
					}); 
				this.domNode.parentElement.appendChild(  this._statusNode.dom);
			}
		},
		
		_displayStatusHideWidget : function() {
			var show = this._multiStatus.length > 0;
			if( show) {
				this._setStyleAttr( { visibility : 'visible'});
			}
			else {
				this._setStyleAttr( { visibility : 'hidden'});
			}
		},
		
		setBindStatus : function( propertyName, status) {
			
			if( status != null && status.statusType != 'ok') {
				this._multiStatus[propertyName] = status;
			}
			else {
				delete this._multiStatus[propertyName];
			}

			if( this.displayStatus == 'ShowIcon') {
				this._displayStatusAsIcon();		
			} else if ( this.displayStatus == 'HideWidget') {
				this._displayStatusHideWidget();
			}

// TODO - let the widget control their error icon position.
//			var obj = domGeom.position(this.domNode);
		}
	});
});