define([	
    "dojo/_base/lang",
	"dojo/dom-construct", 

],function(lang,construct){
	this.isPageLog=false;
	var tools={
	aCode:"a".charCodeAt(0),
	zCode:"z".charCodeAt(0),
	Acode:"A".charCodeAt(0),	
	nearUpcase:function(ic){
		if(ic>=this.aCode&&ic<=this.zCode){
			ic=ic-(this.aCode-this.Acode)+0.5;
		}
		return ic;
	},
	compareStr:function(s1,s2) {
		if(typeof s1!="string")
			s1=s1+"";
		if(typeof s2!="string")
			s2=s2+"";
		var rt=0;
		var c1,c2,l1=s1.length,l2=s2.length;
		var sl=l1?l2:l1<l2;
		for(var i=0;i<sl;i++){
			c1=this.nearUpcase(s1.charCodeAt(i));
			c2=this.nearUpcase(s2.charCodeAt(i));
			if(c1==c2)
				continue;
			if(c1>c2)
				rt=1;
			else
				rt=-1;
			break;
		}
		if(rt==0){
			if(l1>l2)
				rt=1;
			else if(l1<l2)
				rt=-1;
		}
		return rt;
	},
	sortOptions:function(select,data){
		var that=this;
		if(select.sort=="ascending"||select.sort=="descending"){
			data.sort(function(a,b){
				return that.compareStr(a.label,b.label);
			});
			if(select.sort=="descending")
				data.reverse();
		};
		
	},
	parseLabels:function(labels){
		if(!(lang.isArray(labels))){
			labels=labels.split(",");
		};
		var data=[];
		for(var i=0;i<labels.length;i++){
			var datai={};
			if(labels[i].split instanceof Function){
				var di=labels[i].split(":");
				datai.value=di[0];
				if(di.length>1)
					datai.label=di[1];
				else
					datai.label=di[0];
				
			}else{
				datai.label=datai.value=labels[i];
			}
				
			data.push(datai);
		};
		return data;
		
	},
	pageLog:function(info){
		if(!this.isPageLog)
			return;
		var lid="logDiv101";
		var logdiv=dojo.byId(lid);
		if(!logdiv){
			logdiv=construct.create("div",{id:lid,style:"position:absolute;left:800px;height:200px;overflow:auto;border:1px red solid;width:300px;"});
			document.body.appendChild(logdiv);
		}
		logdiv.innerHTML+="<br/>"+info;
	}
	};
	return tools;
});