define(function() {
    return {
    	onResourceChanged: function(resource, type) {
    		if (window.$TI_onResourceChanged) {
    			return window.$TI_onResourceChanged(resource, type);

    		} else {
    			console.info('No callback from browser to handle resource change event');
    		}
    	},
    	
    	onWidgetCreated: function(htmlFile, widgetId) {
//    		alert('onWidgetCreated ' + htmlFile + '\n' + widgetId);
    	},
    
    	onWidgetModified: function(htmlFile, widgetId, properties) {
//    		alert('onWidgetModified ' + htmlFile + '\n' + widgetId + '\n' + properties);
    	},
    	
    	onWidgetDestroyed: function(htmlFile, widgetId) {
    		if (window.$TI_onWidgetRemoved) {
    			return window.$TI_onWidgetRemoved(htmlFile, widgetId);
    		
    		} else {
    			console.info('No callback from browser to remove widget bindings for \'' + widgetId + '\'');
    		}
    	},
    	
    	getPropertyBinding: function(htmlFile, widgetId, widgetProperty) {
    		if (window.$TI_getPropertyBinding) {
    			return window.$TI_getPropertyBinding(htmlFile, widgetId, widgetProperty);
    		
    		} else {
    			console.info('No callback from browser to get widget binding for \'' + widgetId + 
						'\' with property \'' + widgetProperty + '\'');
    		}
    		return "";
    	},
    	
    	bindProperty: function(htmlFile, widgetId, widgetType, widgetProperty, binding, datatype) {
    		if (window.$TI_bindProperty) {
    			return window.$TI_bindProperty(htmlFile, widgetId, widgetType, widgetProperty, binding, datatype);
    			
    		} else {
    			console.info('No callback from browser to bind widget for \'' + widgetId + 
    					'\' with property \'' + widgetProperty + '\' and binding \'' + binding + '\'');	
    		}
    	},
    };

});
