define([
	"dojo/_base/declare",
	"./FakeOptionsInput",
	"dojo/i18n!./nls/dijit"
], function(
	declare,
	FakeOptionsInput,
	dijitNls
) {

return declare(FakeOptionsInput, {
	supportsHTML: false,
	helpText: "Enter a label for each CheckBox to be added, one per line.",
	
	constructor : function() {
		//this.helpText = dijitNls.selectInputHelp;
	},

	// These are what we'll create the new widget with (via ModifyCommand)
	//
	// options contain the parsed results of the SmartInput
	getProperties: function(widget, options) {
		var r = {
		    labels: [],
		    values: []
		};

		for (var i=0; i<options.length; i++) {
			r.labels.push( dojox.html.entities.decode(options[i].text) );
			r.values.push( options[i].selected ? true : false );
		}
		
		return r;
	},

	get: function(name) {
		this.inherited(arguments);
	},
	
	set: function(name, value) {
		this.inherited(arguments);
	}

});

});