define(function() {
	var GraphHelper = function() {};

	GraphHelper.prototype = {
		preProcessData: function(data) {
			var style = data.properties.style;
			if (style) {
				var styles = style.split(';');
				for (var i = 0; i < styles.length; ++i) {
					var elm = styles[i].split(':');
					var key = elm[0].trim();
	
					if (key == 'height' && data.properties['height']) {
						styles[i] = 'height: ' + data.properties['height'] + 'px';
					} else if (key == 'width' && data.properties['width']) {
						styles[i]= 'width: ' + data.properties['width'] + 'px';
					}
				}
				
				data.properties.style = '';
				for (var i = 0; i < styles.length; ++i) {
					data.properties.style += styles[i] + ';';
				}
			}
			return data;
		},
	};
	
	return GraphHelper;
});