/*******************************************************************************
 * Copyright (c) ${year} Texas Instruments Incorporated - http://www.ti.com/
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Texas Instruments Incorporated - initial API and implementation
 *
 * Original Author:
 *     Boualem Sekhri.
 *
 *
 * Contributing Authors:
 *
 * About:
 * 		This script requires dojo , jquery
 *******************************************************************************/
	// Add a splash screen
	if (window.isMaqetta === undefined) {
		try {
			document.addEventListener('DOMContentLoaded', function() {
				try {
					var splash = document.createElement('div');
					var body = document.getElementsByTagName('body')[0];
					splash.setAttribute('id', 'splashId');
					splash.style.zIndex = 99999;
					splash.style.backgroundColor = 'white';
					splash.style.width = '100%';
					splash.style.height = '100%';
					splash.style.position = 'absolute';
					body.appendChild(splash);
				} catch (err) {}
			});
		} catch (err) {}
	}

	// Required for the modal dialog that shows critical errors
	require(['dijit/Dialog']);

    // check if websocket is supported
    if (!window.WebSocket && window.MozWebSocket){
        window.WebSocket = window.MozWebSocket;
    }
    if (!window.WebSocket)
    {
        alert("WebSockets are not supported by this browser.\nPlease use Firefox or Chrome!");
	}

	var $TI =
	{	helper :
		{
            getCurrentPage : function()
			{
				var sPath = getPathName();
				var sPage = sPath.substring(sPath.lastIndexOf('/') + 1);
				return sPage;
			},
			getPathName : function()
			{
				if( typeof $GC_original_pathname !== 'undefined') {
					return $GC_original_pathname;
				}
				return window.location.pathname;
			},
			getHref : function() {
				if( typeof $GC_original_href !== 'undefined') {
					return $GC_original_href;
				}
				return window.location.href;
			},
			getClass : function (object) 
			{
			  return Object.prototype.toString.call(object)
			    .match(/^\[object\s(.*)\]$/)[1];
			},
			
			// Prevents having two message dialogs on top of each other. 
			_modalDialogIsOpened : false,
			// If a HTML page has iframes $last_critical_error binding is fired in both the parent HTML and the 
			// child iframe. We don't want that to result in popping up two dialogs. 
			_modalDialogsEnabled : true,
			
			showDialog:function(title, content) {
				if( !this._modalDialogsEnabled) {
					return;
				}
				if( this._modalDialogIsOpened){ 
					return;
				}
				this._modalDialogIsOpened = true; 
				
				// convert \n breaks to a HTML <br> breaks. 
				var Re = new RegExp("\n","g");
				var reformattedContent = content.replace(Re,"<br>");
				
				this._inside = true;
				var dlg = new dijit.Dialog(
				{
				        title: title,
				        style: "width: 410px;",
				        content: "<table border='0' style='width:100%;'> <tr><td>" + reformattedContent +
				        "<br><br><br> </td></tr> <tr><td style='text-align: center;'>"+
				        "<button id='okBt'>OK</button></td></tr> </table>"

				});
				var that = this;
				dojo.connect(dojo.byId("okBt"),"onclick",null,function(){
					dlg.destroyRecursive();
					that._modalDialogIsOpened = false;
				});
				
				dlg.show();		
				
			},
			showError : function(title, content) {
				this.showDialog( title, '<strong>ERROR : </strong>' + content); 
			},
			showWarning : function(title, content) {
				this.showDialog( title, '<strong>Warning : </strong>' + content); 
			},
			showInformation : function(title, content) {
				this.showDialog( title, '<strong>Information : </strong>' + content); 
			},
			enableDialogs : function( enabled) {
				this._modalDialogsEnabled = enabled; 
			},
			getGCLibVersion : function() {
				return { 
					major : 1, 
// [TI_FIX] DO not remove or modify the following line
					minor : 5, 
					revision : 0,
// [TI_FIX] DO not remove or modify the following line
					path : "davinci.gc_1_5",
// [TI_FIX] DO not remove or modify the following line
					name : "1.5.0"
				};
			},
			getDocumentVersion : function() {
				var head = document.head;
				var attrs = head !== null ? head.attributes : null; 
				var node = attrs !== null ? attrs.item("data-gc-version") : null;
				var version = node !== null ? node.value : null;
				if( version === null) {
					return null;
				}
				var versionName = version; 
				var ret = { name : versionName};
				var parts = version.split(".");
				if( parts.length > 0) {
					var major = parseInt(parts[0]);
					if( !isNaN(major)) {
						ret.major = major;
					}
				}
				if( parts.length > 1) {
					var minor = parseInt(parts[1]);
					if( !isNaN(minor)) {
						ret.minor = minor;
					}
				}
				return ret;
			},
			checkVersion : function() {
				var docVersion = this.getDocumentVersion();
				var libVersion = this.getGCLibVersion();

				if( docVersion === null) {
					window.location  = "lib/"+libVersion.path+"/WebContent/gc/backplane/error_missing_version.html";
					return;
				}
				
				if( libVersion.major !== docVersion.major) {
					window.location  = "lib/"+libVersion.path+"/WebContent/gc/backplane/error_incompatible_version.html";	
					return;
				}
			},
			log : function(msg, filter) {
				// The user can turn on/off these flags from javascript code by calling $TI.helper.log.backplane = false;
				// Their default values will be requested from the .option file of the com.ti.browser plugin. 
				if( filter) {
					var filterOn = this.log[filter]; 
					if( typeof filterOn !== 'undefined') {
						if( !filterOn) {
							return;
						}
					}
					else if( window.$TI_eclipseLogEnabledFor) {
						this.log[filter] = window.$TI_eclipseLogEnabledFor(filter); 
					}
				}
				if (window.$TI_eclipseLog) {
					window.$TI_eclipseLog(msg, filter);
				} else {
					if( filter) {
						console.log(filter + ":" +msg);
					}
					else {
						console.log(msg);
					}
				}
			},
			valuesEqual : function (obj1, obj2){
				return obj1 === obj2; 
			},
			_getDefaultJsonPath : function() {
	        	var path = $TI.helper.getPathName();
	        	var jsonPath = "";
	        	var lastSlash = path.lastIndexOf("/");
	        	var lastDot = path.lastIndexOf(".");
	        	if( lastDot !== -1 && lastDot > lastSlash) {
	        		jsonPath = path.substr(0, lastDot) + ".json";
	        	}
	        	else {
	        		jsonPath = path + ".json";
	        	}
	        	return jsonPath; 
			},
			_isArray : function (value) {
		    	return Object.prototype.toString.call(value) === '[object Array]';
			},		
			_mergeArrays : function (out, options) {
				var args = arguments;
				if( args.length < 3) {
					return;
				}
				var add = function( current) {
					if( current === null) {
						if( options.addNulls) {
							out.push( current);
						}
					}
					else if( typeof current === 'undefined') {
						if( options.addUndefined) {
							out.push( current);
						}
					}
					else {
						out.push( current);
					}
				};
				
				var i,j = 0;
				for( j = 2; j < args.length; ++j) {
					currentArg = args[j];
					if( this._isArray(currentArg)) {
						for( i = 0; i < currentArg.length; ++i) {
							add( currentArg[i]);
						}
					}
					else {
						out.push( currentArg);
					}
				}
			}
		},
    //----------------define guiComposerServer (WebSocket client) -------------
        guiComposerServer : {

            // local options - that are not sent to the backplane. 
            _localOptions : [
	            'inPreProcessingFunction',
                'outPreProcessingFunction',
                'setValueWhenEqual'
            ],
        	
        	// callback functions supported in the JSON file.  
            _supportedFunctions : [
            	'inPreProcessingFunction',
                'outPreProcessingFunction'
            ],
             
            // binding properties that are part of the JSON binding object.
            _supportedBindngProperties : [
                'widgetId',
                'propertyName',
                'serverBindName',
                'options'
            ],
             
            // models that are local (do not exist on the backplane, unless requested by the backplane.)
            // use regular expressions to parse local bind names and split widget id from widget property name. 
            _localModels : { 
                widget: /^\s*widget\.([\w\$\.]+)\.([\w\$]+)\s*$/,
                prop: /^\s*(prop)\.([\w\$\.]+)\s*$/ 
            },

            connected : false,
            widgetsBeingUpdatedList : {},
            _groupUpdateList : [],
            executeOperations : new Array(),
            operationIdCounter : 0,
            requestIdRegistry : {},
            dropUpdateWidgets : new Array(),
            defaultBindingsSent : null,
            _bindingsAddedListeners : {}, 
            
            join : function() 
            {
            	if( this._ws)
            		return;
            	var pathname = $TI.helper.getPathName();
                var socketURL = $TI.helper.getHref().replace('http://', 'ws://').replace('https://', 'wss://');
                if(pathname !== '/') {
                	socketURL = socketURL.replace(pathname,'/ws/');
                }
                var pos = socketURL.indexOf('#');
                if (pos > 0) {
                	socketURL = socketURL.substring(0, pos);
                }

                this._ws = new WebSocket(socketURL, 'gui_composer');
                this._ws.onopen = this._onopen;
                this._ws.onmessage = this._onmessage;
                this._ws.onclose = this._onclose;
            },
            _onopen : function() 
            {
                $TI.guiComposerServer.connected = true;
                $TI.helper.log('Socket _onopen','backplane');
                $TI.guiComposerServer._sendInitInfo();
                $TI.guiComposerServer.sendBindings();
                $TI.guiComposerServer.sendAllExecuteOperations();
                $TI.helper.log('defaultBindingsSent','backplane');
                $TI.guiComposerServer.defaultBindingsSent = true;
            },
            _send : function(message) {
                if (this._ws){
                    this._ws.send(message);
                }
                else{
                    $TI.helper.log('ERROR: _send called after WebSocket is closed!','backplane');
                }
            },
            _onmessage : function(event) 
            {
                if (event.data)
                {
                    // create object from the json request
                    var requestObject = dojo.fromJson(event.data);
                    var requestName = requestObject.requestName;
                    
                    if(requestName === "ping") {
                        var pingReplyMessage = { requestName : "pingReply"};
                        var pingReplyMessageJson = dojo.toJson(pingReplyMessage);
                        $TI.guiComposerServer._send(pingReplyMessageJson);
                    }
                    else if(requestName === "propertyChange" || requestName === "propertyStatusChange") {
                    	$TI.guiComposerServer._onPropertyChange(requestObject);
                    }
                    else if(requestName === "groupRequest" ) {
                    	$TI.guiComposerServer._onGroupRequest(requestObject);
                    }
                    else if(requestName === "operationCompleted") {
                        var requestId = requestObject.requestId;
                        var result = requestObject.result;
                        var requestInfo = $TI.guiComposerServer.requestIdRegistry[requestId];
                        
                        if(requestInfo !== null) {
                            delete $TI.guiComposerServer.requestIdRegistry[requestId];
                            var operationId = requestInfo.operationId;
                            var callbackFunction = requestInfo.callbackFunction;
                            if(callbackFunction) {
                                try {
                                    callbackFunction(result, operationId );
                                }
                                catch(err) {
                                	$TI.helper.log('ERROR: Exception in user callback:'+err,'backplane');
                                }
                            }
                        }
                    }
                    else if( requestName === "connectWidget") {
                    	$TI.guiComposerServer._onConnectWidget(requestObject);
                    }
                    else {
                    	$TI.helper.log('ERROR: unknown requestName = ' + requestName,'backplane');
                    }
                }
            },
            _onclose : function(event) {
                this._ws = null;
                $TI.helper.log('Socket _onclose','backplane');
                $TI.guiComposerServer.connected = false;
            },
            
            _onPropertyChange : function( requestObject) {
            	var that = $TI.guiComposerServer;
                var requestName = requestObject.requestName;
                var widgetId = requestObject.widgetId;
                var propertyName = requestObject.propertyName;
                var newValue = requestObject.newValue;
                var timeSend = requestObject.timeSent;
                var setValueWhenEqual = requestObject.setValueWhenEqual; 
                var timeDelay = 0;
                var currentTime = null;
                if( timeSend) {
                   	currentTime = new Date().getTime();
                	timeDelay = currentTime - timeSend; 
                	if( timeDelay < 0) {
                		timeDelay = 0;
                	}
                }

            	$TI.helper.log( '_onmessage:'+ requestName + ', widget_id=' + widgetId + ', propertyName=' + propertyName +
            		', value='+ newValue + 'current delay=' + timeDelay, 'backplane');
            	
                if(widgetId === "backplane" && 
                	( propertyName === "value:backplane.$last_critical_error" || 
                	  propertyName === "backplane.$last_critical_error"))  {
                	var errorMessage = newValue;
                	if( errorMessage !== null && errorMessage.length !== 0){
                		$TI.helper.showError("Critical Error", errorMessage);
                	} 
                	return; 
            	}    

                var bind = that._bindings.getBind(widgetId, propertyName);
                if( bind && bind.inPreProcessingFunction) {
                   // we don't want errors in the inPreProcessingFunction function to cause script execution to stop.
                    try {
                		newValue = bind.inPreProcessingFunction(newValue);	
                	}
                	catch(err) {
                    	$TI.helper.log('ERROR: User preprocessing function error threw an exception:' + err,'backplane');
                	}
                }
                
                // set the property of the widget to the newValue;
                var widget = that._getWidgetAndAdd(widgetId);
                if(widget)
                {
                	if( requestName === "propertyChange") {
                		
                		var skipNextUpdate = false;
                		
                        if( timeSend) {
                        	if( that.dropUpdateWidgets[widgetId] && that.dropUpdateWidgets[widgetId][propertyName]) {
                       			var dropUpdate = that.dropUpdateWidgets[widgetId][propertyName].dropUpdate;
                       			if( typeof dropUpdate !== 'undefined') {
                           			var forceUpdate = that.dropUpdateWidgets[widgetId][propertyName].forceUpdate;
                           			var lastUpdate = that.dropUpdateWidgets[widgetId][propertyName].lastUpdate;
                           			
                           			// make sure we drop an update only if we the widget has been update at least once, otherwise don't skip. 
                           			if( typeof lastUpdate !== 'undefined') {
                           				
                           				// if the delay is too big, drop an update.  
                           				if( timeDelay > dropUpdate) {
                           					
                           					// if we don't care about force update , drop the update.
                           					if( typeof forceUpdate === 'undefined') {
                           						$TI.helper.log( 'DROPPED UPDATE( id=' + widgetId + ' current delay=' + timeDelay, 'backplane');
                           						skipNextUpdate = true;
                           					}
                           					
                           					// but if we haven't updated the widget for a long time, don't skip.
                           					if( !skipNextUpdate && (currentTime - lastUpdate  < forceUpdate)) {
                           						$TI.helper.log( 'DROPPED UPDATE( id='+widgetId+' current delay=' + timeDelay + 
                           							' accumulated delay=' + (currentTime - lastUpdate), 'backplane');
                           						skipNextUpdate = true;
                           					}

                           					if( !skipNextUpdate) {
                           						// too much time without update - do not skip.
                           						$TI.helper.log( 'FORCED UPDATE( id=' + widgetId +' current delay=' + timeDelay + 
                           							' accumulated delay=' + (currentTime - lastUpdate), 'backplane');
                           					}
                           				}
                          			}                           				
                           			
                           			// save the time of last update.
                           			if( !skipNextUpdate && (typeof forceUpdate !== 'undefined')) {
                           				that.dropUpdateWidgets[widgetId][propertyName].lastUpdate = currentTime;
                           			}
                       			}
                       		}
                        }

                        if( skipNextUpdate) {
                        	if( typeof widget.skipNextUpdate !== 'undefined') {
                        		$TI.helper.log( 'WIDGET SKIP UPDATE ( id=' + widgetId + ' current delay=' + timeDelay, 'backplane');
                        		widget.skipNextUpdate();
                        	}
                        	else {
                        		return;
                        	}
                        }
                        
                        //check if this is a new value
                        var currentValue = widget.get(propertyName);
        				var bind = that._bindings.getBind( widgetId, propertyName); 
                        var forceSet = bind && ( bind.setValueWhenEqual || setValueWhenEqual);  
                        if(forceSet || (newValue !== "null" && currentValue !== newValue)){
                        	that.widgetsBeingUpdatedList[widgetId+"."+propertyName] = newValue;
                        	if( widget._isGCProperty) {
                        		widget.set(propertyName, newValue, undefined, setValueWhenEqual);
                        	}
                        	else {
                        		widget.set(propertyName, newValue);
                        	}
                            that.widgetsBeingUpdatedList[widgetId+"."+propertyName] = undefined;                                
                        }
                	}
                	else if( requestName === "propertyStatusChange") {
                        if(widget.setBindStatus) {
                        	var status = {
                        		statusType : requestObject.statusType,
                        		message : requestObject.message
                        	}; 
                        	widget.setBindStatus( propertyName, status);
                        }
                	}
                }
                else {
                	$TI.helper.log('ERROR: widget not found. widgetId = ' + widgetId, 'backplane');
                }
            },
          
            _onConnectWidget : function( requestObject) {
            	$TI.helper.log('_onConnectWidget ' + requestObject,'backplane');
            	var that = $TI.guiComposerServer;
            	var w = that._getWidgetAndAdd( requestObject.widgetId, false);
            	var value =  w ? w.get( requestObject.propertyName) : null;
            	var bind = that._bindings.getBind(requestObject.widgetId, requestObject.propertyName);
            	if (!bind) {
                	var options = { 
                    		connectResponse : true,
                    		dataType : "String",
                    		value: value
                    	}; 
                	that.addBinding( requestObject.widgetId, requestObject.propertyName, null, options);
            	} else {
            		bind.existsOnServer = true;
            		if (value !== null) {
            			that._sendPropertyChange(requestObject.widgetId, requestObject.propertyName, value);
            		}
            	}
            },
            
            _onGroupRequest : function( requestObject) {
            	var that = $TI.guiComposerServer; 
            	var requests = requestObject.requests;
            	var i = 0;
            	var length = requests.length;
            	var currentObject;
            	var newObject;
            	$TI.helper.log('group request, length = '+length, 'backplane');
            	
            	that._groupUpdateList = [];
            	// when properties are changed in groups, we buffer all changes of 
            	// any properties until we set the last one and send back to the backplane 
            	// only these are are left different from the backplane request.
            	for( i = 0; i < length; ++i) {
            		currentObject = requests[i];
            		if( currentObject.requestName === 'propertyChange') {
            			newObject = { 
	            			widgetId : currentObject.widgetId,
	            			propertyName : currentObject.propertyName,
	            			backplaneValue : currentObject.newValue,
	            			newValue : currentObject.newValue
	            		};
	            		that._groupUpdateList.push( newObject);
            		}
            	}
            	
            	for( i = 0; i < length; ++i) {
            		currentObject = requests[i];
            		if( currentObject.requestName === 'propertyChange') {
            			that._onPropertyChange( currentObject);
            		}
            	}

            	length = that._groupUpdateList.length;
            	for( i = 0; i < length; ++i) {
            		currentObject = that._groupUpdateList[i];
                    if( currentObject.newValue !== currentObject.backplaneValue) {
                    	_sendPropertyChange(currentObject.widgetId, currentObject.propertyName, currentObject.newValue);
                    }
            	}
            	that._groupUpdateList = [];
            },
            
            // API 
            setModelValue : function( modelBind, value, dataType) {
            	if( !(modelBind)) {
            		$TI.helper.log('ERROR: setModelValue(' + modelBind + ')', 'backplane');
            		return;
            	}
                var bind = new this._Bind();
                bind.serverBindName = modelBind;
                bind.options = {};
                bind.options.defaultValue = value;
                bind.options.dataType = dataType;
                bind.toSendToServer = true;
                bind.setModelValue = true;
                this._bindings.add( bind);
                this.sendBindings();
            },

            // API 
            addBinding : function(widgetId, propertyName, serverBindName, options) {
            	
            	if( !widgetId || !propertyName) {
            		$TI.helper.log('ERROR: addBinding('+widgetId+','+propertyName+')', 'backplane');
            		return;
            	}
                var widget = this._getWidgetAndAdd(widgetId, true);
                if( !widget) {
                    $TI.helper.log('ERROR: addBinding(). There is no widget with id = ' + widgetId, 'backplane');
                }
                var bind = new this._Bind();
                bind.widgetId = widgetId;
                bind.widget = widget;
                bind.propertyName = propertyName;
                bind.serverBindName = serverBindName;
                bind.toSendToServer = true;
                
                var local = false;
                if( bind.serverBindName !== null && bind.serverBindName != undefined) {
                	// local binding start with wodget or prop and don't have special symbols.
                	local = this._isLocalBindName( bind.serverBindName);
                }
                else {
                	// there are two cases in which serverBindName can be omitted:
                	// 1. to additinally speicify settings fo local bind in the JSON file like callbacks.
                	// 2. in responce from the backplane to repicate widget bind due to expression.
                	local = !( options && options.connectResponse);
                }
                
                if( local) {
            		delete bind.toSendToServer;
            		bind.local = true;
            		bind.registeredLocal = false;
                }
                
                if( widget) {
                	bind.register();
                }

                if( options) {
	                for( var i=0; i < this._localOptions.length; ++i) {
	               		var f = this._localOptions[i];
	               		if( options[f]) {
		               		bind[f] = options[f];
		               		delete options[f];
	               		}
	               	}
                }
                
                // add to the map of slow widgets if needed.
                if( options !== null && ( options.dropUpdate || options.forceUpdate)) {
                	if( typeof this.dropUpdateWidgets[widgetId] === 'undefined') {
                		this.dropUpdateWidgets[widgetId] = new Array();
                	}
                	if( typeof this.dropUpdateWidgets[widgetId][propertyName] === 'undefined') {
                		this.dropUpdateWidgets[widgetId][propertyName] = {}; 
                	}
                	if( options.dropUpdate) {
                		this.dropUpdateWidgets[widgetId][propertyName].dropUpdate = options.dropUpdate;
                		delete options.dropUpdate; // do not send to the server.
                	}
                	if( options.forceUpdate) {
                		this.dropUpdateWidgets[widgetId][propertyName].forceUpdate = options.forceUpdate;
                		delete options.forceUpdate; // do not send to the server.
                	}
                }

                bind.options = options;

                // make sure we send the disabled state to the backplane.
                if( bind.options && !bind.local && !bind.initialModelBindEnabled) {
                	bind.options.disabled = true;
                }
                
                this._bindings.add( bind);
                this.sendBindings();
                this._connectLocalBindings();
            },

            synchronizeWithDojo : function() {
            	for( var i = 0; i < this._bindings._array.length; ++i) {
            		var bind = this._bindings._array[i];
            		var wrapper = this._widgets[bind.widgetId];
            		if( wrapper.isDojo) {
            			
            			var dojoWidget = dijit.byId(bind.widgetId);
        				var widgetExistNow = typeof dojoWidget !== 'undefined';
        				var widgetExistBefore = bind.widget != null && bind.widget != undefined;
        				
        				if( widgetExistNow && !widgetExistBefore) {
        					wrapper.widget = dojoWidget;
        					bind.widget = dojoWidget;  
        					bind.register();
        					if (bind.existsOnServer) {
        						this.enableBinding(true, bind.widgetId, bind.propertyName, true);
        					}
        					else if( bind.local) {
        						this._localBindings.add(bind);
        					}
        				}
        				else if( !widgetExistNow && widgetExistBefore) {
        					if (bind.existsOnServer) {
            					this.enableBinding(false, bind.widgetId, bind.propertyName, true);
        					}
        					else if( bind.local) {
        						this._localBindings.remove(bind);
        					}
        					bind.widget = null;
        					wrapper.widget = null;
        				}
            		}
            	}
            },
            
            _isLocalBindName : function( serverBindName) {
            	var models = this._localModels;
	            for( var localModel in models) {
	            	if( models.hasOwnProperty(localModel) && models[localModel].test(serverBindName)) {
	            		return true;
	            	}
	            }
	            return false;
            },
            
            enableBinding : function(enable, widgetId, propertyName, syncValue) {
            	var data = { widgetId: widgetId, propertyName : propertyName};
            	if( syncValue) {
            		data.options = { syncValue : true};
            	}
            	this.enableBindings( enable, [ data]);
            },
            
            
            
            enableBindings : function(enable, widgetBindings) {
            	var enableBool = enable ? true : false;
           		var request = { requestName : "enableWidgetBindings", enable : enableBool, widgetBindings : widgetBindings };
                var requestJson = dojo.toJson(request);
           		$TI.guiComposerServer._send(requestJson);
            },
            
            addBindingsFromFile :  function (bindingDefinitionFile) {
	            if(!bindingDefinitionFile) {
                    return;
                }
	            // create/connect the webSocket
            	this.join();
	            var that = this;
 	            // -------------load json widget binding information
                dojo.xhrGet(
                {
                    url: bindingDefinitionFile,
                    handleAs: "json",
                    sync : true ,
                    
                    _createParameterSwapFunction : function ( f ) {
                    	return function( propName, oldValue, newValue) { 
                    		f( propName, newValue, oldValue);
                    	};
                    },
                    
                    load: function(data) {
                        for(var prop in data.widgetBindings){
                            var wb = data.widgetBindings[prop];
                            var i = 0;

                        	try {
	                            // Evaluates the functions specified in the JSON file. 
	                            // AddBinding expects function objects instead the function name.
	                            for( i=0; i < that._supportedFunctions.length; ++i) {
	                        		var f = that._supportedFunctions[i];
	                           		if(wb.options[f]) {
	                           			wb.options[f] = eval(wb.options[f]);
	                           		}
	                            }
	
	                            // add prop specific listener functions 
	                            if( wb.widgetId === 'prop' && that._widgets['prop'] && that._widgets['prop'].widget) {
	                            	var w = that._widgets['prop'].widget;
                            		var propChanged = wb.options['onPropertyChanged'];
	                   				if( propChanged) {
	                   					w.watch( wb.propertyName, this._createParameterSwapFunction( eval(propChanged)));
	                   				}
	                   				var statusChanged = wb.options['onBindStatusChanged'];
	                   				if( statusChanged) {
	                   					w.watch( wb.propertyName + '$bind_status', this._createParameterSwapFunction( eval(statusChanged)));
	                   				}
	                            }
                        	}
                           	catch(err) {
                               	$TI.helper.showError('JSON File Error', 'File:'+bindingDefinitionFile+'\n' +err);
                           	}
                            
                            // Binding records with no wigetId are used to initialize backplane bindings.  
                            if( !(wb.widgetId) && wb.serverBindName && wb.options && (typeof wb.options.defaultValue !== 'undefined' )) {
                                $TI.guiComposerServer.setModelValue( wb.serverBindName, wb.options.defaultValue, wb.options.dataType);
                            }
                            else {
                            	$TI.guiComposerServer.addBinding(wb.widgetId, wb.propertyName, wb.serverBindName, wb.options);
                            }
                        }
                        $TI.guiComposerServer._notifyBindingsAddedListeners(bindingDefinitionFile);
                    },
                    error: function(err) {
                        $TI.helper.log('ERROR: Excetion while loading binding definitions file:' + 
                        	bindingDefinitionFile + '\n' + err, 'backplane');
                        // since we guiComposer.js tries to automatically load the corresponding JSON file 
                        // we don't want these failures to popup a error message
                        // only systaxt error will popup for now to help finding JSON sintax error easier.
                        if( err.toString().indexOf('SyntaxError') !== -1) {
                        	$TI.helper.showError('JSON File Error', 'File:'+bindingDefinitionFile+'\n' +err);
                        }
                    },
                });
	        },
	        
	        // execute an action on the server
	        // options syntax: { arguments :  argsValue, widgetId : widgetIdValue,
	        //                   propertyName : propertyNameValue, requestId : requestIdValue}
	        // Some or all of the options may be null
	        executeAsynchOperation : function(operationName, arguments, callbackFunction, operationId) {
	        	var newOperaton = {
	        		operationName : operationName, 
	        		arguments : arguments, 
	        		callbackFunction: callbackFunction, 
	        		operationId : operationId
		        };
	        	$TI.guiComposerServer.executeOperations.push(newOperaton);
	        	$TI.guiComposerServer.sendAllExecuteOperations();
	        },
	        
			// API - registers widget proxies  
	        registerWidget : function(widget, widgetId) {
	        	if( !this._widgets[widgetId]) {
	        		this._addWidget( widget, widgetId, false);
	        	} else {
	        		$TI.helper.log('ERROR: registerWidget id ='+ widgetId +' already exist.','backplane');
	        	}
	        },
	        
	        // API - replace prop widget
	        replacePropObject : function( widget, localBindNameRegEx) {
	        	var prev = this._widgets['prop'];
        		this._addWidget( widget, 'prop', false);
        		if (localBindNameRegEx) {
        			this._localModels.prop = localBindNameRegEx;
        		}
        			
        		return prev; 
	        },

	        _addWidget : function( widget, widgetId, isDojo) {
	        	var w = new this._GCWidget();
	        	w.widget = widget;
	        	w.widgetId = widgetId; 
	        	w.isDojo = isDojo;
	        	this._widgets[widgetId] = w;   
	        },
	        
        	// check first if it is in the list, then at dojo's list. 
	        // for dynamically enabled plugins we still want to add it, even the dojo widget does not exits. 
	        _getWidgetAndAdd : function( widgetId, addAnyway) {
	        	var gcw = this._widgets[widgetId]; 
	        	if( gcw) {
	        		return gcw.widget; 
	        	} 
                var w = dijit.byId(widgetId);
                if( w) {
                	this._addWidget( w, widgetId, true);
                }
                else if( addAnyway){
                	this._addWidget( null, widgetId, true);
                }
                return w;
	        },
	        
	        _getWidgetDoNotAdd : function( widgetId) {
	        	var gcw = this._widgets[widgetId]; 
	        	if( gcw) {
	        		return gcw.widget; 
	        	} 
                return dijit.byId(widgetId);
	        },
	        
            // main listener for property change in all widgets
		    // sends change to ws server.
		    widgetChangeListener : function (widgetId, propertyName, newValue) {
		    	var that = $TI.guiComposerServer;
		    	
		    	// pass the value through the post processing function, if needed.  
                var bind = that._bindings.getBind(widgetId, propertyName);
                var groupIndex;
                var i;
                var currentObject;
                
                // don't send the server if we already nkow that it is not registered there.
                if( bind && !bind.existsOnServer) {
                	return;
                }
                
                if( bind && bind.outPreProcessingFunction) {
                   // we don't want errors in the outPreProcessingFunction function to cause script execution to stop.
                    try {
                		newValue = bind.outPreProcessingFunction(newValue);	
                	}
                	catch(err) {
                    	$TI.helper.log('ERROR: Execption thrown inside outPreProcessingFunctionfunction.' + err, 'backplane');
                	}
                }
                
                // if a property is part of group update, rememeber the new 
                groupIndex = -1;
                for( i = 0; i < that._groupUpdateList.length; ++i) {
                	currentObject = that._groupUpdateList[i];
                	if( widgetId === currentObject.widgetId && propertyName === currentObject.propertyName) {
                		groupIndex = i;
                		break;
                	}
                }
                if( groupIndex != -1) {
                	that._groupUpdateList[groupIndex].newValue = newValue;
                }
                else {
                	that._sendPropertyChange(widgetId, propertyName, newValue);
                }
		    },
		    
		    _sendPropertyChange : function( widgetId, propertyName, newValue) {
		    	var that = $TI.guiComposerServer;
		    	var messageObject;
		    	var messageJson;
		        if( that.widgetsBeingUpdatedList[widgetId+"."+propertyName] !== newValue) {
			        messageObject = { requestName: "propertyChange" , widgetId : widgetId , propertyName : propertyName, newValue : newValue  };
			        messageJson = dojo.toJson(messageObject);
			        $TI.helper.log('_send mesasge: widgetId=' + widgetId + ' propertyName=' + propertyName + ' newValue='+ newValue,'backplane');			        
			        that._send(messageJson);
		        }
		    },
		    
		    _sendInitInfo : function() {
		    	if(!$TI.guiComposerServer.connected) {
		    		return;
		        };
		        try
		        {
		        	  $TI.helper.log('_send initial message','backplane');
		        	  var docVersion = $TI.helper.getDocumentVersion();
		        	  var libVersion = $TI.helper.getGCLibVersion();
		        	  var docHref = $TI.helper.getHref();
		        	  var messageObject = { 
		        			  requestName: "setInitInfo" , 
		        			  gcLibraryVersion : libVersion,
		        			  documentVersion : docVersion,
		        			  href : docHref
		        	  };
		        	  var messageJson = dojo.toJson(messageObject);
		        	  $TI.guiComposerServer._send(messageJson);
				}
				catch(err)
				{
				   $TI.helper.log('ERROR: Exception thown inside sendBindings:' + err, 'backplane');
				}
		    },
		    sendBindings : function() {
		    	if(!$TI.guiComposerServer.connected) {
		    		return;
		        }
		    	try {
	                var widgetBindingRequest = { 
	                	requestName : "addWidgetBindings", 
	                	widgetBindings : this._bindings.getBindingsToSend()
	                };
	                var widgetBindingRequestJson = dojo.toJson(widgetBindingRequest);
	                $TI.helper.log('sending bindings:' +widgetBindingRequestJson,'backplane');                
	                $TI.guiComposerServer._send(widgetBindingRequestJson);
	                this._bindings.markAsExistsOnServer();
		        }
		        catch(err) {
		           $TI.helper.log('ERROR: Exception whrown inside sendBindings :' + err, 'backplane');
		        }
		    },
		    
		    sendAllExecuteOperations : function() {
		    	if(!$TI.guiComposerServer.connected) {
	            	return;
		        }
		        try {
		             $TI.helper.log('sending Execute Opreations','backplane');
		             for( var i = 0; i < $TI.guiComposerServer.executeOperations.length; ++i) {
		            	 var currentOperation = $TI.guiComposerServer.executeOperations[i];
		            	 $TI.guiComposerServer.sendOneExecuteOperation(
		            			currentOperation.operationName, 
		            			currentOperation.arguments, 
		            			currentOperation.callbackFunction, 
		            			currentOperation.operationId
		            	);
		             }
			        // clear the executeOperations array 
		             $TI.guiComposerServer.executeOperations.length = 0;
		        }
		        catch(err) {
		           $TI.helper.log('ERROR: Exception thrown in Execute Opreations :' + err,'backplane');
		        }
		    },

		    sendOneExecuteOperation : function( operationName, arguments, callbackFunction, operationId) {
	           if(operationName === null || operationName.length === 0)
	           {
	               return;
	           }
	           
	           if(callbackFunction === null)
	           {	               
	               // one-way operation: no return expected
	               // Note that critical-errors may still be received
	               var messageObject = { requestName: "executeOperation" , operationName : operationName , arguments : arguments};
	               var messageJson = dojo.toJson(messageObject);
	               $TI.guiComposerServer._send(messageJson);
	           }
	           else
	           {
                   // create a globally-unique-requestId that will be used to map back to a (callbackFunction, operationId)
                   $TI.guiComposerServer.operationIdCounter++;
                   var requestId = $TI.guiComposerServer.operationIdCounter.toString();
                   var requestInfo = {callbackFunction : callbackFunction, operationId : operationId };
                   $TI.guiComposerServer.requestIdRegistry[requestId] = requestInfo;
                   var messageObject = { requestName: "executeOperation" , operationName : operationName , arguments : arguments , requestId : requestId };
                   var messageJson = dojo.toJson(messageObject);	                   
                   $TI.guiComposerServer._send(messageJson);
	           }
		    },
		    
	    	// all widgets ( dojo and non-dojo ) are inside this map.
	    	_widgets : {
	    		toString : function() {
	    			var ret = '';
	    			var first = true;
	    			for(var propertyName in this) {
	    				if( propertyName !== 'toString') {
	    					if( !first) {
	    						ret += ',';
	    					}
	    					first = false;
	    					ret += propertyName + '=' + this[propertyName].toString();
	    				}
    				}	    	
	    			return ret;
	    		}
	    	},
	    	
	    	_GCWidget : function () {
	    		
				// properties:
				// 		String widgetId;
	    		// 		
				//    	boolean isDojo; // we soport custom non dojo widget, created by the API registerWidget. 
				//      Object ( get, set, watch ) proxy;
	    		
	    		this.toString = function() {
	    			return this.widgetId;
	    		};
	    	},
	    	
	    	// all bindings. 
	    	_bindings : {
	    		_array : new Array(),
	    		
	    		add : function( bind) {
	    			this._array.push( bind);
	    		},
	    		
	    		getBind : function( widgetId, propertyName) {
	    			for( var i = 0; i < this._array.length; ++i) {
	    				if( $TI.helper.valuesEqual(widgetId, this._array[i].widgetId) &&
	    					$TI.helper.valuesEqual(propertyName,this._array[i].propertyName))  {
	    					return this._array[i];
	    				} 
	    			}
	    			return null;
	    		},
	    		
	    		getBindingsToSend : function() {
	    			var ret = Array();     
	    			for( var i = 0; i < this._array.length; ++i) {
	    				var bind = this._array[i]; 
	    				if( bind.toSendToServer) {
	    	                var b = {}; 
	    	                for( var j=0; j < $TI.guiComposerServer._supportedBindngProperties.length; ++j) {
	    	                	var p = $TI.guiComposerServer._supportedBindngProperties[j];
	    	                	if( bind[p]) {
	    	                		b[p] = bind[p];
	    	                	}
	    	                }
	    	                ret.push(b);
	    				}
	    			}
	    			return ret; 
	    		},

	    		markAsExistsOnServer : function() {
	    			
	    			// remove set model value binds only   
	    			this._array = this._array.filter(function(bind) {
	    				return typeof bind.setModelValue === 'undefined';
	    			});
	    			
	    			// mark the remainning as sent to the server.
	    			for( var i = 0; i < this._array.length; ++i) {
	    				var bind = this._array[i]; 
	    				if( bind.toSendToServer) {
	    					bind.existsOnServer = true;
	    					delete bind.toSendToServer;
	    				}
	    			}
	    		},
	    	},
	    	
	    	_Bind : function () {
	    		
				// properties:
	    		// 		String widgetId
	    		//		String propertyName
	    		//      object widget 		{ get,set,watch } 
	    		// 		function inPreprocessingFunction
	    		// 		function outPreprocessingFunction
	    		// 		String serverBindName
	    		// 		boolean toSendToServer
	    		//		boolean existsOnServer
	    		//		boolean setModelValue
	    		// 		boolean registeredLocal
	    		// 		boolean setValueWhenEqual
	    		// 		function watchListener
	    		// 		boolean initialModelBindEnabled
	    		
	    		this.toString = function() {
	    			return this.widget + '.'+this.propertyName;
	    		};
	    		
	    		this.register = function() {
	    			var that = this;
	                //add a watch function
	                var listener = function(propertyName, oldValue, newValue) {
	                    $TI.guiComposerServer.widgetChangeListener( that.widgetId, that.propertyName, newValue);
	                };
	                $TI.helper.log('Adding watch to:' + this.widgetId + ':' + this.propertyName,'backplane');
	                this.watchListener = this.widget.watch( this.propertyName, listener);

	                // support for automatic model bind disabled when the widget is hidden or disabled.
	                if (!this.local)
	                {
		                var modelBindEnabledListener = function(p, oldValue, newValue) {
		                	$TI.helper.log('OnModelBindEnabledChanged( id=' + that.widgetId + ', value= ' + newValue,'backplane');
	    					$TI.guiComposerServer.enableBinding(newValue, that.widgetId, null);
		                };
		                
		                // set the intial value
		                this.widget.watch("modelBindEnabled", modelBindEnabledListener);
		                this.initialModelBindEnabled = this.widget.get( "modelBindEnabled");
		                if(( typeof this.initialModelBindEnabled === "undefined") || (this.initialModelBindEnabled === null)) {
		                	this.initialModelBindEnabled = true;
		                }
		                $TI.helper.log('Initial ModelBindEnabled = ' + this.initialModelBindEnabled + ' for id=' + this.widgetId,'backplane');
	    			}
	    		};
	    	},

	    	_localBindings : {
	    		
	    		_list : [], 
	    		
	    		add : function( bind) {
	    			var that = $TI.guiComposerServer;
	    			var wwc = this._getClinetBind( bind);
	    			var wws = this._getServerBind( bind);
	    			if( !wwc || !wws) {
                    	$TI.helper.log('ERROR: _localBindings.add - invalid widget description.','backplane');
                    	return;
	    			}
	    			var wc = that._getWidgetAndAdd(wwc.widgetId);
	    			var ws = that._getWidgetAndAdd(wws.widgetId);
	    			if( !wc || !ws) {
                    	$TI.helper.log('ERROR: _localBindings.add - no sunch widget.','backplane');
                    	return;
	    			}
	    			var pc = wwc.proprtyName;
	    			var ps = wws.propertyName;
	    			
	                var lc = function(propertyName, oldValue, newValue) {
	                	// if the widget has been removed due to synchronizeWithDojo()
	                	ws = that._getWidgetAndAdd(wws.widgetId);
	                	if( !ws) {
	                		return;
	                	}
	                	var currentValue = ws.get( ps);
	                	if( !$TI.helper.valuesEqual( newValue, currentValue)) {
	                		ws.set( ps, newValue);
	                	};
	                };
	                wc.watch(pc, lc);

	                var ls = function(propertyName, oldValue, newValue) {
	                	// if the widget has been removed due to synchronizeWithDojo()
	                	wc = that._getWidgetAndAdd(wwc.widgetId);
	                	if( !wc) {
	                		return;
	                	}
                        var forceSet = bind && bind.setValueWhenEqual;  
	                	var currentValue = wc.get( pc);
	                	if( forceSet || !$TI.helper.valuesEqual( newValue, currentValue)) {
	                		wc.set( pc, newValue);
	                	};
	                };
	                ws.watch(ps, ls);

	                // add to the list so we can unsubscribe when the widget is destroyed.
	                this._list.push( { 
	                	widgetClient : wc,
	                	propoertyClient : pc, 
	                	listenerClient : lc,
	                	widgetServer : ws,
	                	propoertyServer : ps, 
	                	listenerServer : ls
	                });
	                
	                bind.registeredLocal = true;
	    			
	    			// set the initial binding value: serverBind -> widgetBind
	    			var initValue = ws.get(ps);
	    			wc.set(pc, initValue);
	    		},

	    		// calls unwatch and removes the entry from the list 
	    		remove : function( bind) {
	    			var that = $TI.guiComposerServer;
	    			var wwc = this._getClinetBind( bind);
	    			var wws = this._getServerBind( bind);
	    			var wc = that._getWidgetDoNotAdd(wwc.widgetId);
	    			var ws = that._getWidgetDoNotAdd(wws.widgetId);
	    			var pc = wwc.proprtyName;
	    			var ps = wws.propertyName;
	    			var i = 0;
	    			var current;
	    			for( i = 0; i < this._list.length; ++i) {
	    				current = this._list[i];
	    				if( current.widgetClient == wc &&
	    					current.propoertyClient == pc && 
	    					current.widgetServer == ws &&
	    					current.propoertyServer == ps ) {
	    					if( typeof wc.unwatch === "function") {
	    						wc.unwatch( pc, current.listenerClient);
	    					}
	    					if( typeof ws.unwatch === "function") {
	    						ws.unwatch( ps, current.listenerServer);
	    					}
	    					this._list.splice(i, 1);
	    					break;
	    				} 
	    			}
	    		},

	    		_getClinetBind : function( bind) {
	    			return {
	    				widgetId : bind.widgetId, 
	    				proprtyName : bind.propertyName
	    			};
	    		},
	    		
	    		_getServerBind : function( bind) {
	    			var name = bind.serverBindName;
	    			if( name) {
	    				var models = $TI.guiComposerServer._localModels;
	    				for( var model in models)
	    				{
	    					if (models.hasOwnProperty(model))
	    					{
	    						var result = models[model].exec(name);
	    						if (result != null && result.length > 2)
	    						{
	    							return { 
	    								widgetId : result[1], 
	    								propertyName : result[2]	
	    							};
	    						}
	    					}
	    				}
	    			}
	    			return null;
	    		},
	    	},

		    _connectLocalBindings : function() {
    			for( var i = 0; i < this._bindings._array.length; ++i) {
    				var bind = this._bindings._array[i];
    				// some properties are just declared in the JSON file - they don't have serverBindName.
    				// that is why we need the check bind.serverBindName.
    				if( bind.local && !(bind.registeredLocal) && bind.serverBindName) {
    			    	this._localBindings.add(bind);
    				}
    			}
		    },
		    
		    addBindingsAddedListener : function( callback, fileName) {
		    	if( typeof fileName === 'undefined')
		    		fileName = $TI.helper._getDefaultJsonPath();
		    	if( typeof this._bindingsAddedListeners[fileName] === 'undefined')
		    		this._bindingsAddedListeners[fileName] = new Array();
		    	this._bindingsAddedListeners[fileName].push( callback);
		    },
		    
		    _notifyBindingsAddedListeners : function ( fileName) {
		    	if( typeof this._bindingsAddedListeners[fileName] === 'undefined')
		    		return;
		    	var arr = this._bindingsAddedListeners[fileName];
		    	for (var i=0; i < arr.length; i++) 
		    		arr[i]();
		    }
        }, //guiComposerServer end >>>

        // API 
        GUIVars : {
    		getValue : function( propertyName, widgetID) {
    			var widget = this._getWidget(propertyName, widgetID, 'getValue');
    			if( typeof widget !== 'undefined') {
    				return widget.get(propertyName);
    			}
    			else {
    				return undefined;
    			}
    		},
    		setValue : function( propertyName, value, widgetID) {
    			var widget = this._getWidget(propertyName, widgetID, 'setValue');
    			if( typeof widget !== 'undefined') {
    				widget.set(propertyName, value);
    			}
    		},
			getStatus : function( propertyName, widgetID) {
    			var widget = this._getWidget(propertyName, widgetID, 'getStatus');
    			if( typeof widget !== 'undefined') {
    				if( widget.getBindStatus !== 'undefined') {
    					return widget.getBindStatus(propertyName, status);
    				}
    			}	
    			return null;
			},
			setStatus : function( propertyName, status, widgetID) {
    			var widget = this._getWidget(propertyName, widgetID, 'setStatus');
    			if( typeof widget !== 'undefined' && widget.setBindStatus !== 'undefined') {
    				widget.setBindStatus(propertyName, status);
    			}
			},
			onSet : function( propertyName, listener, widgetID) {
    			var widget = this._getWidget(propertyName, widgetID, 'onSet');
    			if( typeof widget !== 'undefined') {
    				widget.watch( propertyName, listener);
    			}
			},
			_getWidget : function( propertyName, widgetID, functionName) {
    			var widget = undefined;
    			if (typeof widgetID !== 'undefined') {
    				widget = dijit.byId(widgetID);
    			}
    			else { 
    				widget = $TI.guiComposerServer._widgets['prop'].widget;
    			}
    			return widget;
			}
        }
    }; //$TI end >>>

	// put the 'prop' widnget in the registry to handle all browser prop objects. 
	$TI.guiComposerServer.registerWidget( {
		
		_listeners : {},
		_listeners_progress : {},
		_isGCProperty : true, 
		
		get: function(property) {
			var ret = this[property];
			$TI.helper.log('prop.get('+property+')='+ret,'backplane');
			return ret;
		},
		
		set: function(property, value, exception, setValueWhenEqual) {
			$TI.helper.log('prop.set('+property+','+value+')','backplane');
			
			var that = $TI.guiComposerServer;
			var oldValue = this[property];
			var bind = that._bindings.getBind( 'prop', property); 
			var forceSet = bind && ( bind.setValueWhenEqual || setValueWhenEqual);
			if( forceSet || !$TI.helper.valuesEqual(oldValue,value)) {
				this[property] = value;
				var listeners = this._listeners[property]; 
				if( typeof listeners !== 'undefined') {
					
					// the following code supports rentrant calls on the same propery.  When rentrant calls on the same property are
					// detected, we need only to notify listeners that have already been called of further changes.  Listeners that
					// have not yet been notified will be notified of the new value once when this function returns to the parent caller and 
					// continues notifying the remaining listeners using the new value and the previous oldValue preserved on the call stack.
					var listener_progress = this._listeners_progress[property];
					if (listener_progress === undefined) {
						// first time called, setup structures for keeping track of progress.
						listener_progress = { count : 0 };
						this._listeners_progress[property] = listener_progress;
					}
					
					var saved_listeners_progress_count = listener_progress.count;   // save notification progress for the current level of nesting
					try {
						var count = saved_listeners_progress_count;   // reentrant case: only notify listeners that have already been notified.
						if ( count === 0) {
							count = listeners.length;   // non-reentrant case, notify all the listeners.
						}
						
						// start listener progress for current level of nesting (used to keep track of where we are as well as a flag to detect rentrancy).
						listener_progress.count = 1;   // reset the notification progress for the next level of nesting
						
						for(var i=0; i < count; i++) {
							// always recheck that the value hasn't changed to stop the rentrancy cycles that may occur.
							// also, reentrancy may be used to revert values, so listeners not notified previously need not be notified at all.
							listeners[i](property, oldValue, value);  // this call may trigger reentrant calls on the same property.
							listener_progress.count++;
							
							value = this[property];
							if( forceSet || $TI.helper.valuesEqual(oldValue,value)) {
								// value has been reverted back to the original value through reentrancy, so skip the remaining notifications
								// including the binding.
								break;
							}
						}
					}
					catch( err) {
						// error during onChangedNotification
						try {
							this.set(property, oldValue, err);  // restore the original value, and pass allong the error message too, so listeners know we are reverting.
						}
						catch( revertErr) {
							$TI.helper.log('ERROR: nested ERROR in onPropertyChanged while recovering from: ' + err,'backplane');
						}
						throw err;  // let nested reentrant calls clean up themselves.  Note that if the same propery was changed numerous times, it will also be reverted numerous times.
					}
					finally {
						listener_progress.count = saved_listeners_progress_count;  // restore the notification progress for the previous level of nesting
					}
				}
			}
		},

		watch: function(property, listener) {
			$TI.helper.log('prop.watch('+property+')','backplane');
			if( typeof this._listeners[property] === 'undefined'){
				this._listeners[property] = new Array();
			}
			this._listeners[property].push( listener);
		},
		
		unwatch : function( property, listener) {
			var arr = this._listeners[property];
			if( typeof arr !== 'undefined'){
				var index = arr.indexOf(listener);
				if (index > -1) {
					arr.splice(index, 1);
				}
			}
		},
		
		getBindStatus : function (property) {
			return this.get(property + '$bind_status');
		},
		
		setBindStatus : function (property, status) {
			this.set( property + '$bind_status', status);
		},
		
		watchBindStatus : function(property, listener) {
			this.watch( property + '$bind_status', listener);
		} 
		
    }, 'prop');
	
	if (window.isMaqetta === undefined) {
	    // if versions don't match show error HTML page. 
		$TI.helper.checkVersion();
	    
	    require(["dojo/ready"], function(ready){
	        ready(function(){
	            // create/connect the webSocket
	            $TI.guiComposerServer.join();
	        	var jsonPath = $TI.helper._getDefaultJsonPath();
        		$TI.guiComposerServer.addBindingsFromFile(jsonPath);
        		
        		// add splash binding - remove the splash screen when the splash widget binding returns
        		var splashProxy = {
        			get: function(property) {return null;},
        			set: function(property, value) {
                		try {
                			var splash = document.getElementById('splashId');
                			splash.style.display = 'none';
                		} catch (err) {}
        			},
        			watch: function(property, listener) {},
        		};
        		$TI.guiComposerServer.registerWidget(splashProxy, 'splashId');
        		$TI.guiComposerServer.addBinding('splashId', 'value', 'true', null);
	        });
	   });    
	};

	/**
	 * Collection of pulic functions. 
	 */
	var TI = {
			
		/**
		 * Executes DSS script. 
		 * 
		 * @param functionName 
		 * @param parameters passed to the DSS Script function
		 */
		DSS : function ( functionName) {
			var callbackFunc = null;
		
			var onCompleted = function ( result, requstId) {
				if( result && result.status && result.status.type === "ERROR" ) {
					$TI.helper.showError('DSS script error', result.status.message);
				
				} else if (result && callbackFunc) {
					callbackFunc(result.result);
				}
			}; 
			var args = Array.prototype.slice.call(arguments);
			args.shift();
			
			if (args.length > 1 && (typeof args[args.length-1] === "function")) {
				callbackFunc = args.pop();
			}
			
			var appPath = $TI.helper.getPathName();
			var params = {
				appPath : appPath,
				func : functionName,
				params : args
			};
			$TI.guiComposerServer.executeAsynchOperation('pm.$execute', params, onCompleted, 0);
		},
		
		/**
		 * An object that performs file operations(read, write, browse).
		 * 
		 * The object unifies the client-server upload/download functionality with operations over the local file system.
		 * The object detects if the code is running from an embedded browser or from a standalone browser. 
		 * In the case of an embedded browser a local file system access is performed. 
		 * If a standalone browser the files are uploaded to and downloaded from the server. 
		 * Passing the 'options' object can alter that behavior - a local browser can switch to  
		 * accessing sever uploaded files instead of the local file system files.
		 *
		 * All operations are asynchronous and require a callback to signal completion of the operation. 
		 * In the callback an error object will be passed if the requested operation failed.
		 * The error object will be 'undefined' if the file operation succeeded.
		 * 
		 * errorInfo - An object that contains the error encountered during the operation. 
		 * 		 If it is 'undefined' the operation has succeeded. 
		 * 			errorInfo.id - id of the error. Possible errors are:
		 *				local_file_operation_not_allowed
		 *				operation_cancelled_by_user
		 *				file_not_found
		 *				invalid_remote_path_name
		 * 			Make sure the code that uses errorInfo.id can handle new values.  
		 * 		errorInfo.message - detailed message.
		 * 
		 * options - alters the behavior of the operations. 
		 * 		options.clientLocation : 'auto', 'remote' or 'local' - allows client running in an 
		 * 			embedded browser to be as the remote case - keeping the file in the server and to use upload 
		 * 			and download operation instead of working on the local file system. 
		 * 			If remote client sets clientLocation to 'local' options the server will fail the operation.
		 * 
		 * fileInfo 
		 * 		An object that encapsulates the information needed for local or remote file system access.
		 * 		Different functions use different properties of these object:  
		 * 			fileInfo.localFile - the name of the file in the local file system. Used in the remote case. 
		 * 			fileInfo.serverFile - the name of the file on the server's file system. Used in the remote case.
		 * 			fileInfo.localPath - the full path of the file in the local file system. Used in the local case. 
		 */
		File : {
	
			/**
			 * Let the user select a file from the local file system and returns its content and location.
			 * 
			 * If options.clientLocation is 'remote', or options.clientLocation is 'auto' and the call is requested 
			 * by a remote client the file is uploaded to the server first.
			 * 
			 * The file is closed before the callback is called.
			 * 
			 * @param fileInfo - In the local case fileInfo.localPath specifies the location in the file
			 * 		system where the browse button will open. In the remote case this parameter is ignored.
			 * @param options - See options of File object for details.  
			 * @param callback - a callback function that receives the data read from the file. 
			 * 			callback : function ( data , fileInfo, errorInfo) 
			 * 				data - string containing the file content.
			 * 				fileInfo  
			 * 					In the local case fileInfo.localPath points to the file in the local file system the user has selected.
			 * 					In the remote case fileInfo.localFile contains the name of the file the user has 
			 * 					selected and fileInfo.serverFile contains the server's file name.      
			 * 				errorInfo - see errorInfo of File object.  
			 */
			browseAndLoad : function( fileInfo, options, callback) {
				if( this._isEmbeddedClient( options)) {
					this._localBrowseAndLoad( fileInfo, callback);
				}
				else {
					this._serverBrowseAndLoad( fileInfo, callback);
				}
			},
			
			/**
			 * Lets the user select the file where the data will be saved.
			 * In the embedded browser case the user is prompted with a browse dialog to select the file in which
			 * the data will be saved to. In the remote case the file is created on the server and then  
			 * uploaded to the client's machine.
			 *    
			 * @param data - data to be saved.
			 * @param fileInfo- In the local case fileInfo.localPath specifies the folder in which the browse 
			 * 				dialog will open and filename selected by the user.  
			 * 				In the remote case fileInfo.localFile will be used to create the server file.       
			 * @param options - see options description in File.
			 * @param callback
			 * 				callback : function ( fileInfo, errorInfo) 	
			 *					fileInfo - In the local case fileInfo.localPath will point to the file selected by the user. 
			 *		 				In the remote case the fileInfo.localFile will be the one specified by the user and
			 * 					fileInfo.serverFile will contain the name of the server file.
			 * 					errorInfo - see errorInfo of File object.  
			 */
			browseAndSave : function( data, fileInfo, options, callback) {
				if( this._isEmbeddedClient( options)) {
					this._localBrowseAndSave( data, fileInfo, callback);
				}
				else {
					this._serverBrowseAndSave( data, fileInfo, callback);
				}
			},

			/**
			 * Saves data to the file specified by fileInfo.  
			 * It the local case fileInfo.localPath is used. In the remote case fileInfo.serverFile is used.
			 *  
			 * @param data - data to be saved.
			 * @param fileInfo - It the local case fileInfo.localPath is used. In the remote case fileInfo.serverFile is used.
			 * @parma append - if true, data will be added to the end of the file, isntead at the beginning.  
			 * @param options- see options description in File.
			 * 				append : true - to add to the end of the file instead of the beginning. 
			 * 				addCRBefore : true - if CR should be inserted before data. 
			 * 				addCRAfter : true - if CR should be inserted after data.
			 * @param callback 
			 * 		callback : function ( errorInfo) 	
			 * 			errorInfo - see errorInfo of File object.  
			 */
			save : function( data, fileInfo, options, callback) {
				if( this._isEmbeddedClient( options)) {
					this._write( fileInfo.localPath, data, options, callback);
				}
				else {
					this._write( fileInfo.serverFile, data, options, callback);
				}
			},
			
			/**
			 * Returns the content of the specified file.
			 * 
			 * The file is closed before the callback is called.
			 * 
			 * @param fileInfo - In the local case the content of the fileInfo.localPath is used, 
			 * 		otherwise the content of fileInfo.serverFile is used. 
			 * @param options - See options of File object for details.  
			 * @param callback - a callback function that receives the data read from the file. 
			 * 			callback : function ( data , fileInfo, errorInfo) 
			 * 				data - string containing the file content.
			 * 				fileInfo
			 * 					- the original fileInfo the user has paased. 
			 * 					- it is preseved so the same callback can be used for both load and browseAndLoad.   
			 * 				errorInfo - see errorInfo of File object.  
			 */
			load : function( fileInfo, options, callback) {
				var local = this._isEmbeddedClient( options);
				var path = local ? fileInfo.localPath : fileInfo.serverFile;
				var onComplete = function( data, errorInfo) {
					callback( data, fileInfo, errorInfo);
				};
				this._read( path, local, onComplete);
			},

			/**
			 * Converts the data that is to be written to, or read from the target, to the format specified. 
			 * This allows the same object to be stored in different data formats.
			 * For example: Comma Separated Value, JSON, etc.
			 * This member has two function: 
			 *		objectToString - converts data to the string that will be written to the file.
			 *		stringToObject - converts the string read from the file to the object that will be returned 
			 *			to the read() callback.
			 *   
			 * The default implementation of this member does not provide any conversion.
			 * It simply reads and writes the provided string.   
			 */
			dataConverter : { 
				objectToString : function ( obj) {
					if( typeof obj === 'undefined' || obj === null) {
						return "";
					}
					return obj.toString();
				},
				stringToObject : function( str) {
					return str;
				}
			},
			
			/**
			 * Lets the user select a folder from the local file system.  
			 * The operation will fail if called from a remove client. 
			 * 
			 * @param fileInfo - It the local case fileInfo.localPath is the intiial selection in the dialog.   
			 * @param options - See options of File object for details.
			 * 			additinal optional parameters:
			 * 				title - the title of the dialog
			 * 				message - a message describing why the dialog is opened  
			 * @param callback - a callback function that receives the data read from the file. 
			 * 			callback : function ( data , fileInfo, errorInfo) 
			 * 				fileInfo - In the local case fileInfo.localPath points to the folder the user has selected. 
			 * 				errorInfo - see errorInfo of File object.  
			 */
			browseFolder : function( fileInfo, options, callback) {
				var params = {
					path : fileInfo.localPath
				};
				var onCompleted = null;
				if( typeof callback === 'function') {
					onCompleted = function ( result, requstId) {
						var errorInfo = undefined;
						var fileInfoRet = undefined;
						if( result && result.status && result.status.type === "ERROR" ) {
							errorInfo = result.status;
						}
						else if( !result || !result.result) {
							errorInfo = { message :'Unknown server error!'};
							callback( undefined, errorInfo);
							return;
						}
						else if( result && result.result){
							fileInfoRet = {
								localPath : result.result.localPath
							};
						}
						callback( fileInfoRet, errorInfo);
					};
				}
				
				var optionalParams = ['title','message'];
				for( var i = 0; i < optionalParams.length; ++i) {
					if( options && options[ optionalParams[i]]) {
						params[optionalParams[i]] = options[ optionalParams[i]];
					}
				}
				
				var bindingName = 'streams.$local_browse_folder'; 
				$TI.guiComposerServer.executeAsynchOperation( bindingName, params, onCompleted, 0);
			},
			
			/**
			 * List the files contained in the path of the local file system.  
			 * The operation will fail if called from a remove client. 
			 * 
			 * @param fileInfo - It the local case fileInfo.localPath is the path the info is requested for.     
			 * @param options - an object with optinal parameter - not used.  
			 * @param callback - a callback function that receives the list of files. 
			 * 			callback : function ( result, errorInfo)
			 * 				result.files - an arrays with elements for each file in the specified path.
			 * 					each object has properites: 
			 * 						name - String - the name of the file. 
			 * 						isFile - boolean - true of the element is file, false if it is a folder.
			 * 						fullPath - String - the full path of the file.  
			 * 				errorInfo - see errorInfo of File object.  
			 */
			listFiles : function( fileInfo, options, callback) {
				var params = {
					path : fileInfo.localPath
				};
				var onCompleted = null;
				if( typeof callback === 'function') {
					onCompleted = function ( result, requstId) {
						var errorInfo = undefined;
						var clientResult = undefined;
						if( result && result.status && result.status.type === "ERROR" ) {
							errorInfo = result.status;
						}
						else if( !result || !result.result) {
							errorInfo = { message :'Unknown server error!'};
							callback( undefined, errorInfo);
							return;
						}
						else if( result && result.result){
							clientResult = result.result;
						}
						callback( clientResult, errorInfo);
					};
				}
				var bindingName = 'streams.$local_list_files'; 
				$TI.guiComposerServer.executeAsynchOperation( bindingName, params, onCompleted, 0);
			},
			
			_localBrowseAndSave : function( data, fileInfo, callback) {
				var onCompleted = function ( result, requstId) {
					var errorInfo = undefined;
					var fileInfoRet = {};
					if( result && result.status && result.status.type === 'ERROR' ) {
						errorInfo =  result.status;
					};
					if( result && result.result) {
						fileInfoRet.localPath = result.result.localPath;
					};
					callback( fileInfoRet, errorInfo);
				};
				var convertedData = this.dataConverter.objectToString(data);
				var params = {
					data : convertedData
				};
				if( typeof fileInfo !== 'undefined' &&
					typeof fileInfo.localPath === 'string'&&
					fileInfo.localPath.length > 0) {
					params.localPath = fileInfo.localPath;  
				}
				$TI.guiComposerServer.executeAsynchOperation( 'streams.$local_browse_and_save', params, onCompleted, 0);
			},

			_localBrowseAndLoad : function( fileInfo, callback) {
				var onCompleted = function ( result, requstId) {
					var errorInfo = undefined;
					if( result && result.status && result.status.type === 'ERROR' ) {
						errorInfo =  result.status;
						callback( undefined, undefined, errorInfo);
						return;
					};
					if( !result || !result.result) {
						errorInfo = { message :'Unknown server error!'};
						callback( undefined, undefined, errorInfo);
						return;
					};
					var fileInfoRet = {
						localPath : result.result.localPath
					};
					callback( result.result.data, fileInfoRet, errorInfo);
				};
				var params = {};
				if( typeof fileInfo !== 'undefined' &&
					typeof fileInfo.localPath === 'string'&&
					fileInfo.localPath.length > 0) {
					params.localPath = fileInfo.localPath;  
				}
				$TI.guiComposerServer.executeAsynchOperation( 'streams.$local_browse_and_load', params, onCompleted, 0);
			},
			
			_serverBrowseAndSave : function( data, fileInfo, callback) {
				var that = this;
				var callbackFileNew = function ( result, requstId) {
					var errorInfo = undefined;
					if( result && result.status && result.status.type === 'ERROR' ) {
						errorInfo =  result.status;
						callback( undefined, errorInfo);
						return;
					};
					if( !result || !result.result) {
						errorInfo = { message :'Server error!'};
						callback( undefined, errorInfo);
						return;
					};
					var fileInfoRet = {
						serverFile : result.result.serverFile,
						localFile : result.result.localFile
					};
					var callbackWrite = function ( errorInfo) {
						if( errorInfo) {
							callback( undefined, errorInfo);
							return;
						};
						that._downalod( fileInfoRet);
						callback( fileInfoRet, undefined);
					};
					var options = {
						clientLocation : 'remote'
					};
					that._write(fileInfoRet.serverFile, data, options, callbackWrite);
				};
				var params = {
				};
				if( fileInfo && fileInfo.localFile) {
					params.localFile = fileInfo.localFile;  
				}
				$TI.guiComposerServer.executeAsynchOperation( 'streams.$remote_file_new', params, callbackFileNew, 0);
			},
			
			_serverBrowseAndLoad : function( fileInfo, callback) {
				var that = this;
				var browseAndUploadCallback = function( serverFile, localFile, error) {
					var fileInfoRet = {
						localFile : localFile,
						serverFile : serverFile
					};
					if( error) {
						var errorInfo = {
							message : error,
							id : "upload_error"  
						}; 
						callback( undefined, fileInfoRet, errorInfo);
						return;
					}
					that._read( fileInfoRet.serverFile, false, function( data, error) {
						callback( data, fileInfoRet, error);
					});
				};
				this._browseAndUpload( browseAndUploadCallback);
			},
			
			_browseAndUpload : function(callback) {
				
				function _setAttr( element, name, value) {
					atr = document.createAttribute( name);
					atr.nodeValue = value;
					element.setAttributeNode(atr);
				};

				// create the form with the input.
			    var input = document.createElement("input");
				_setAttr( input, "type", "file");
				_setAttr( input, "name", "userfile1");
			    var form = document.createElement("form");
				_setAttr( form, "action","fileupload");
				_setAttr( form, "method","post");
				_setAttr( form, "enctype","multipart/form-data");
				_setAttr( form, "style","display:none");

				// simualte click on the browse buton.
			    form.appendChild(input);
				document.body.appendChild(form);
				var fileName = undefined;
				var onCompletedCalled = false;
					
				input.onchange = function (){
					// make sure we don't call the callback twice.
					if( onCompletedCalled) {
						return;
					}
					onCompletedCalled = true;
					if( input.files.length > 0){
						fileName = input.files[0].name;
					}
					if( !fileName) {
						document.body.removeChild( form);
						callback( undefined, undefined, "The user cancelled the operation!");
						return;
					}
					
					// upload the file to the server.
					var formData = new FormData(form);
					var oReq = new XMLHttpRequest();
					oReq.open("POST", "fileupload", true);
					oReq.onload = function( e) { 
						if (oReq.readyState==4 && oReq.status==200){
							// parse the upaload result and return the server name or error.
							var serverName = undefined;
							var error = undefined;
							var res = oReq.responseText;
							if( res.indexOf('name=') == 0){
								serverName = res.substring(5);
							}
							if( res.indexOf('error=') == 0){
								error = res.substring(6);
							}
							document.body.removeChild(form);

							callback( serverName, fileName, error);
						}
					};
					oReq.send(formData);	
				};
				input.click();
				
				// in 5 seconds if onchanged is not called we tell the client the user has selected the cancel button.
				setTimeout( function() {
					// make sure we don't call the callback twice.
					if( onCompletedCalled) {
						return;
					}
					onCompletedCalled = true;
					document.body.removeChild(form);
					callback( undefined, undefined, "The user cancelled the operation!");
				}, 5000);
			},
			
			_downalod : function( fileInfo) {
			   var a = document.createElement("a");
			   a.download = fileInfo.localFile;
			   a.href = "/gc/download_area/temporary_files/" + fileInfo.serverFile;
			   a.click();
			   delete a;
			},
			
			_read : function( path, local, callback) {
				var that = this;
				var onCompleted = function ( result, requstId) {
					var convertedData = that.dataConverter.stringToObject(result.result);
					var error = undefined;
					if( result && result.status && result.status.type === "ERROR" ) {
						error =  result.status;
					}
					callback( convertedData, error);
				};
				var params = {
					path : path
				};
				var fn = local ? 'streams.$local_file_read' : 'streams.$remote_file_read'; 
				$TI.guiComposerServer.executeAsynchOperation( fn, params, onCompleted, 0);
			},
			
			_write : function( path, data, options, callback) {
				var convertedData = this.dataConverter.objectToString( data); 
				var params = {
					path : path,
					data : convertedData
				};
				var optionalParams = [ 'append','addCRBefore','addCRAfter'];
				for( var i = 0; i < optionalParams.length; ++i) {
					if( options && options[ optionalParams[i]]) {
						params[optionalParams[i]] = true;
					}
				}
				var onCompleted = null;
				if( typeof callback === 'function') {
					onCompleted = function ( result, requstId) {
						var error = undefined;
						if( result && result.status && result.status.type === "ERROR" ) {
							error = result.status;
						}
						callback( error);
					};
				}
				var bindingName = this._isEmbeddedClient( options) ? 'streams.$local_file_write' : 'streams.$remote_file_write'; 
				$TI.guiComposerServer.executeAsynchOperation( bindingName, params, onCompleted, 0);
			},
	
			_isEmbeddedClient : function( options) {
				var local = navigator && navigator.userAgent && navigator.userAgent.indexOf("TIBrowser") != -1;
				if( typeof options !== 'undefined' && typeof options.clientLocation !== 'undefined') {
					var loc = options.clientLocation;
					if( loc == 'auto') {
						return local;
					}
					else if( loc == 'local') {
						return true;
					}
					else if( loc == 'remote') {
						return false;
					}
				}
				return local; 
			}
		},

		/**
		 * Instantiated objects from this prototype will allow the user to store data 
		 * in files as a Coma Separated Value (CVS) formats.
		 * 
		 * Only objects instantiated with new operator can be used: var file = new TI.CVSFile();
		 * 
		 * Passed arrays to the write() or append() functions will be written as 
		 * value1, value2, ..., valueN line to the file. 
		 * If values are strings they will be escaped with quotes. 
		 * 
		 * If the data read from the file contains un-escaped commas, an array will be returned in the data 
		 * parameter of the read() callback.
		 */
		CSVFile : function (){
			this.dataConverter = {
				objectToString : function ( obj) {
					if( $TI.helper._isArray(obj)) {
						var s = '';
						var i = 0;
						var line = '';
						
						// support for two dimentional arrays
						if( obj.length > 0 && $TI.helper._isArray(obj[0])) {
							for( i = 0; i < obj.length; ++i) {
								line = this.objectToString( obj[i]);
								s += line;
								if( i < obj.length - 1) {
									s += "\n";
								}
							}
							return s;
						}
						
						for( i = 0; i < obj.length; ++i) {
							if( i > 0) {
								s += ",";
							}
							s += this._toCSV(obj[i].toString());
						}
						return s; 
					}
					else {
						if( typeof obj !== 'undefined' && obj !== null) {
							return this._toCSV(obj.toString());
						}
						else {
							return '';
						}
					}
				},
				stringToObject : function( str) {
					throw "Implementation in progress....";
				},
				_toCSV : function( text) {
					var ret = text;
					// if a string cotains " or , we escape it with " at the beginning and end.
					// each " is escapted with another ".
					var hasQuotes = text.indexOf( '"') != -1;
					var hasComa = text.indexOf(',') != -1;
					if( !hasQuotes && !hasComa) {
						return text;
					}
					var parts = text.split("\"");
					if( parts.length > 1) {
						ret = "";
						for( var i = 0; i < parts.length; ++i) {
							if( i > 0) {
								ret += "\"\"";
							}
							ret += parts[i];
						}
					}
					return "\"" + ret + "\"";
				}
			};
		},
		
		/**
		 * Instantiated objects from this prototype will allow the user to store data 
		 * in files as JSON object.
		 * 
		 * Only objects instantiated with new operator can be used: var file = new TI.JSONFile();
		 * 
		 * Objects passed to write() or append() functions will be converted first to 
		 * their JSON representations and then written to the file. 
		 * 
		 * The data read from the file is be expected to be a JSON string that will be returned 
		 * as a javascript object to the client in the read() callback.
		 */
		JSONFile : function () {
			this.dataConverter = {
				objectToString : function ( obj) {
					return obj;
				},
				stringToObject : function( str) {
					return str;
				}
			};
		}
	};
	
	TI.CSVFile.prototype = TI.File;
	TI.JSONFile.prototype = TI.File;
