define([
	"dojo/_base/declare",
	"dijit/Dialog",
	"dijit/_Widget",
	"dijit/form/TextBox",
	"gc/dijit/ComboBox",
	"dijit/_TemplatedMixin",
	"dijit/_WidgetsInTemplateMixin"
], function(declare, Dialog, _Widget, TextBox, ComboBox, _TemplatedMixin, _WidgetsInTemplateMixin) {
	return declare("gc.dijit.BindingDialog", [Dialog], {
		id: 'ti_binding_dialog',
		baseClass: "dijitBindingDialog",
		declaredClass: 'BindingDialog',
		
		target: null,
		pageInfo: null,
		
		targetProperty: null,
		inTemplate: null,
		outTemplate: null,
		
        constructor: function(params) {
        	// if dialog is closed with x-button it is not destroyed, only hidden
        	// destroy it here to prevent dijit registry exception
        	if (dijit.byId('ti_binding_dialog')) {
				var dlg = dijit.byId('ti_binding_dialog');
				dlg.destroy();
        	}
        	
        	this.inTemplate = '';
        	this.outTemplate = '';
        	
        	if (params && params.target) {
        		this.target = params.target;
        	} else {
        		this.target = cW;
        	}

        	if (params && params.pageInfo) {
        		this.pageInfo = params.pageInfo;
        	}
        	
        	var self = this
        	  , contentWidget = new (declare([_Widget, _TemplatedMixin, _WidgetsInTemplateMixin], {
	    		templateString:   '<div>'
					+ '<label style="display: inline-block; width: 18em; text-align: right;">Format:</label> <div style="width: 20em;" data-dojo-type="dijit/form/TextBox" data-dojo-attach-point="tbFmt" data-dojo-attach-event="onKeyUp:_checkKeys,onClick:_select" data-ti-info="dataFormat"></div>'
					+ '<img src="/maqetta/app/davinci/img/help_25.png" width="16" height="16" style="float: right; margin-right: 1em; margin-top: 2px;" onclick="(function(el) { var descNode = el.parentElement.getElementsByClassName(\'ti-desc\')[0]; descNode.innerHTML = localView.help[\'dataFormat\']; })(this);" /><br/>'
					+ '<label style="display: inline-block; width: 18em; text-align: right;">Pre Processing Function:</label> <div style="width: 20em;" data-dojo-type="gc/dijit/ComboBox" data-dojo-attach-point="cbIn" data-dojo-attach-event="onKeyUp:_checkKeys,onClick:_select" data-ti-info="inPreProcessingFunction"></div>'
					+ '<img src="/maqetta/app/davinci/img/help_25.png" width="16" height="16" style="float: right; margin-right: 1em; margin-top: 2px;" onclick="(function(el) { var descNode = el.parentElement.getElementsByClassName(\'ti-desc\')[0]; descNode.innerHTML = localView.help[\'inPreProcessingFunction\']; })(this);" /><br/>'
					+ '<label style="display: inline-block; width: 18em; text-align: right;">Post Processing Function:</label> <div style="width: 20em;" data-dojo-type="gc/dijit/ComboBox" data-dojo-attach-point="cbOut" data-dojo-attach-event="onKeyUp:_checkKeys,onClick:_select" data-ti-info="outPreProcessingFunction"></div>'
					+ '<img src="/maqetta/app/davinci/img/help_25.png" width="16" height="16" style="float: right; margin-right: 1em; margin-top: 2px;" onclick="(function(el) { var descNode = el.parentElement.getElementsByClassName(\'ti-desc\')[0]; descNode.innerHTML = localView.help[\'outPreProcessingFunction\']; })(this);" /><br/>'
					+ '<p class="ti-desc" style="color: #aaa;"></p>'
					+ '<div class="dijitDialogPaneActionBar">'
					+   '<button dojoType="dijit.form.Button" type="button" data-dojo-attach-point="btnEdit" data-dojo-attach-event="onClick:_edit" style="float:left;">Edit</button>'
					+ 	'<button dojoType="dijit.form.Button" type="submit" data-dojo-attach-point="btnOk" data-dojo-attach-event="onClick:_ok">OK</button>'
					+ 	'<button dojoType="dijit.form.Button" type="button" data-dojo-attach-point="btnCancel" data-dojo-attach-event="onClick:_cancel">Cancel</button>'
	        		+ '</div>'
					+ '</div>'
				,
	
				// attach points
				cbIn: null,			// comboboxes
				cbOut: null,
				tbFmt: null,		// textboxes
				btnOk: null, 		// buttons
				btnCancel: null,

				startup: function() {
					this.inherited(arguments);
					
					if (window.localView) {				
						this.setWidgetValues();
					} else {
						console.warn("LocalView is not globally available, can't assign function list to ComboBoxes");
					}
				},
				
		    	setWidgetValues: function() {
		    		// setup combobox options
		    		if (window.localView) {
						if (localView.appfns.length < 1) {
							localView.loadFunctionsFromFile();
						}
						
						var fns = [];
						[].forEach.call(localView.appfns, function(fnObj) {
							fns.push(fnObj.name);
						});
		    			
		    			this.cbIn._setLabelsAttr(fns);
		    			this.cbOut._setLabelsAttr(fns);
		    			
		    			var Workbench = window.davinci.Workbench
		    			  , appJsonSrc = $TI_getBindingJsonString(Workbench.getProject() + '/app.html')
		    			  , bindings = JSON.parse(appJsonSrc).widgetBindings
		    			;
		    			  
		    			if (bindings.length < 1) {
		    				console.warn('invalid bindings object:', bindings);
		    				bindings = [];
		    			}

		    			var dlgSelf = this;
		    			[].forEach.call(bindings, function(binding) {
		    				var widgetId       = binding.widgetId
		    				  , propertyName   = binding.propertyName
		    				  , serverBindName = binding.serverBindName
		    				  , local          = binding.local || true
		    				  , options		   = binding.options
		    				;

		    				if (widgetId != 'prop') { // Real Widget
		    					if (widgetId == self.target.label && propertyName == self.pageInfo.target) {
									if (options.inPreProcessingFunction && options.inPreProcessingFunction != '') {
										dlgSelf.cbIn.set('displayedValue', options.inPreProcessingFunction);
										
										// hack: we need to generate a srcTemplate regardless of whether an inPreProcessingFunction was previously specified
				    					var propData;
				    					for (property in localView.availProps.widget) {
				    						var p = localView.availProps.widget[property];
				    						if ('inPreProcessingFunction' == p.jsonName) {
				    							propData = p;
				    						}
				    					}
				    					dlgSelf.ownerDialog.inSrcTemplate = "\n" + propData.codeSnippet; // hack: keep a copy of the src template in case user does not use default fn name
										// /hack
				    					
									} else {
				    					var propData;
				    					for (property in localView.availProps.widget) {
				    						var p = localView.availProps.widget[property];
				    						if ('inPreProcessingFunction' == p.jsonName) {
				    							propData = p;
				    						}
				    					}

										var defaultFnName = propData.newName.replace(/<text1>/g, widgetId.replace(/^[a-z]/, function(char) { return char.toUpperCase(); }));
										//dlgSelf.cbIn.set('displayedValue', defaultFnName); //sge
										
										var inTmpl = "\n" + propData.codeSnippet.replace(/<text1>/g, defaultFnName);
										dlgSelf.ownerDialog.inSrcTemplate = "\n" + propData.codeSnippet; // hack: keep a copy of the src template in case user does not use default fn name
										dlgSelf.ownerDialog.inTemplate = inTmpl;
									}
									
									if (options.outPreProcessingFunction && options.outPreProcessingFunction != '') {
										dlgSelf.cbOut.set('displayedValue', options.outPreProcessingFunction);
										
										// hack: we need to generate a srcTemplate regardless of whether an outPreProcessingFunction was previously specified
				    					var propData;
				    					for (property in localView.availProps.widget) {
				    						var p = localView.availProps.widget[property];
				    						if ('outPreProcessingFunction' == p.jsonName) {
				    							propData = p;
				    						}
				    					}
				    					dlgSelf.ownerDialog.outSrcTemplate = "\n" + propData.codeSnippet; // hack: keep a copy of the src template in case user does not use default fn name
										// /hack
				    					
									} else {
				    					var propData;
				    					for (property in localView.availProps.widget) {
				    						var p = localView.availProps.widget[property];
				    						if ('outPreProcessingFunction' == p.jsonName) {
				    							propData = p;
				    						}
				    					}

										var defaultFnName = propData.newName.replace(/<text1>/g, widgetId.replace(/^[a-z]/, function(char) { return char.toUpperCase(); }));
										//dlgSelf.cbOut.set('displayedValue', defaultFnName); //sge

										var outTmpl = "\n" + propData.codeSnippet.replace(/<text1>/g, defaultFnName);
										dlgSelf.ownerDialog.outSrcTemplate = "\n" + propData.codeSnippet; // hack: keep a copy of the src template in case user does not use default fn name
										dlgSelf.ownerDialog.outTemplate = outTmpl;
									}
									
									if (options.dataFormat) {
										dlgSelf.tbFmt.set('value', options.dataFormat);
									}
		    					}
		    				}
		    			});
		    			
		    			
		    		} else {
		    			console.warn('localView is not available, unable to populate function combo boxes');
		    		}
		    	},
		    	
			    _checkKeys: function(evt) {
			    	if (evt.which == 13) {
			    		this._ok();
			    	}
			    },
			    
			    _select: function(evt) {
			    	this.targetProperty = evt.target.dataset.tiInfo;
			    	
			    	if (this.targetProperty == 'dataFormat') {
			    		// disable edit button
			    	} else {
			    		// enable edit button
			    	}
			    },
			    
			    _edit: function(evt, silent) {
					var fnName = false;
					silent = silent || false;
					
					if (this.targetProperty == 'inPreProcessingFunction') {
						fnName = this.cbIn.get('value');
						
						//localView.fnTemplate = this.ownerDialog.inTemplate; // not using default fn names
						localView.fnTemplate = this.ownerDialog.inSrcTemplate.replace(/<text1>/g, fnName);
						
					} else if (this.targetProperty == 'outPreProcessingFunction') {
						fnName = this.cbOut.get('value');
						
						//localView.fnTemplate = this.ownerDialog.outTemplate; // not using default fn names
						localView.fnTemplate = this.ownerDialog.outSrcTemplate.replace(/<text1>/g, fnName);
					}
					
					if (fnName) {
						localView.editFn(fnName, silent);
					}
			    },
		    	
		    	_ok: function() {
		    		var library = localView.library
		    		  , runtime = localView.runtime
		    		  , metadata = localView.metadata
		    		  , bid = self.target.label
		    		  , bprop = self.pageInfo.target
		    		  , opts = {
		    				serverBindName: document.querySelector('#' + self.pageInfo.id).value
		    			}
		    		;
		    		
	    			var Workbench = window.davinci.Workbench
	    			  , appJsonSrc = $TI_getBindingJsonString(Workbench.getProject() + '/app.html')
	    			  , bindings = JSON.parse(appJsonSrc).widgetBindings
	    			;
	    			  
	    			if (bindings.length < 1) {
	    				bindings = [];
	    			}
	    			
	    			var dlgSelf = this;
	    			[].forEach.call(bindings, function(binding) {
	    				var widgetId       = binding.widgetId
	    				  , propertyName   = binding.propertyName
	    				  , serverBindName = binding.serverBindName
	    				  , local          = binding.local || true
	    				  , options		   = binding.options
	    				;
	    				
	    				if (widgetId != 'prop') { // Real Widget
	    					if (widgetId == self.target.label && propertyName == bprop) {
	    						for (var p in options) {
	    							opts[p] = options[p];
	    						}
	    					}
	    				}
	    			});
		    		
	    			var userInPPFunc   = this.cbIn.get('value')
	    			  , foundInPPFunc  = false
	    			  , userOutPPFunc  = this.cbOut.get('value')
	    			  , foundOutPPFunc = false
	    			;

	    			// see if localView already knows about the specified function(s)
	    			for (var i=0; i<localView.appfns.length; i++) {
	    				if (localView.appfns[i].name == userInPPFunc) {
	    					foundInPPFunc = true;
	    				}

	    				if (localView.appfns[i].name == userOutPPFunc) {
	    					foundOutPPFunc = true;
	    				}
	    			}
	    			
	    			// hack: create functions if they don't already exist
	    			if (! foundInPPFunc) {
		    			var oldTarget = this.targetProperty;
		    			this.targetProperty = 'inPreProcessingFunction';
		    			this._edit(null, true); // silently add function to js file if function doesn't already exist
		    			oldTarget = null;
		    			foundInPPFunc = true; // localView.editFn will forceReload known functions, so this will be true by the time it returns
	    			}
	    			
	    			if (! foundOutPPFunc) {
		    			var oldTarget = this.targetProperty;
		    			this.targetProperty = 'outPreProcessingFunction';
		    			this._edit(null, true);
		    			this.targetProperty = oldTarget;
		    			oldTarget = null;
		    			foundOutPPFunc = true;
	    			}
	    			// /hack
	    			
	    			// allow user to enter blank function names (to delete the references in app.json)
	    			if (!foundInPPFunc && userInPPFunc == '') { foundInPPFunc = true; }
	    			if (!foundOutPPFunc && userOutPPFunc == '') { foundOutPPFunc = true; }
	    			
	    			// set values
		    		if (foundInPPFunc) {
		    			opts.inPreProcessingFunction = userInPPFunc;
		    		}
		    		
		    		if (foundOutPPFunc) {
		    			opts.outPreProcessingFunction = userOutPPFunc;
		    		}
		    		
	    			opts.dataFormat = this.tbFmt.get('value');

	    			// delete keys if necessary
	    			if (opts.inPreProcessingFunction == '') { delete opts.inPreProcessingFunction; }
	    			if (opts.outPreProcessingFunction == '') { delete opts.outPreProcessingFunction; }
	    			if (opts.dataFormat == '') { delete opts.dataFormat; }

	    			// store
					if (library) {
						var ve = runtime.currentEditor.visualEditor;
						var data = new Array(ve.fileName, bid, '', bprop, JSON.stringify(opts));
						metadata.invokeCallback(library, 'bindProperty', data);

					} else {
						console.warn('no access to gc library, save aborted!');
					}			    				

					this.ownerDialog.inSrcTemplate = '';
					this.ownerDialog.outSrcTemplate = '';
		    		this.ownerDialog.destroy();
		    	},
		    	
		    	_cancel: function() {
					this.ownerDialog.inSrcTemplate = '';
					this.ownerDialog.outSrcTemplate = '';
		    		this.ownerDialog.destroy();
		    	}		
        	}));
        	
        	contentWidget.ownerDialog = this; 
        	contentWidget.startup();
        	this.content = contentWidget;
        }
	});
});