define([
    "dojo/_base/declare", 
	"dojo/dom-construct", 
	"dojo/parser", 
	"dojo/ready",
    "dijit/_WidgetBase",
	"dijit/form/RadioButton",
	"./_GCBaseWidget",
	"dijit/_Container",
	"./libs/tools",
	"dojo/on",
	"dojo/_base/lang"

    ], function(declare, domConstruct, parser, ready,_WidgetBase, RadioButton, _GCBaseWidget,_Container,tools,on,lang){
        return declare("gc.dijit.CheckBoxGroup", [_WidgetBase, _GCBaseWidget,_Container], {
        	baseClass:"checkBoxGroup",
        	labels:"Option A,Option B,Option C",
        	values:[0,0,0],
        	name:"",
        	selectedIndex:-1,
        	selectedLabel:null,
        	length:0,
        	value:null,
        	options:[],
        	style:"border:1px solid #ccc;borderRadius:4px;display:inline-block;padding:2px;",
        	title:"CheckBoxGroup",
     		_setLabelsAttr : function(labels) {
    			if(!labels)
    				return;
        		this.options=[];
        		this.values=[];
    			this._set('labels', labels);
    			if(!(lang.isArray(labels))&&labels.split){
    				labels=labels.split(",");
    			};
 //   			var data=tools.parseLabels(labels,false);
    			if (labels.length > 0) 
    			{
//    				tools.sortOptions(this,data);
    				for(var i=0;i<labels.length;i++){
    					var di={
    							"label":labels[i],
    							"id":dijit.getUniqueId("checkbox")
    					};
    					this.options.push(di);
    					this.values.push(0);
    					
    				}
    				this.length=this.options.length;
    			}
    			this.buildRendering();
    		},
    		_setValuesAttr:function(vs){
    			if(!vs) return;
    			var nvalues=this.values.slice(0);
    			if(!(lang.isArray(vs))&&vs.split){
    				vs=vs.split(",");
    			};
    			for(var i=0;i<vs.length;i++){
    				if(i>=nvalues.length)
    					break;
    				var vi=parseInt(vs[i]);
    				if(isNaN(vi))
    					vi=0;
    				nvalues[i]=vi?1:0;
     			}
    			
    			this._set("values",nvalues);
    			for(var i=0;i<this.options.length;i++){
    				var cbNode=dojo.byId(this.options[i].id);
    				if(cbNode)
    				cbNode.checked=this.values[i]?true:false;
    			}
   			
    		},
    		createdDomNode:false,
            buildRendering: function() {
                // create the DOM for this widget
				this.inherited(arguments);
				if(!this.createdDomNode){
					this.createdDomNode=true;
	       			this.domNode = domConstruct.create('fieldset', { id: dijit.getUniqueId("fieldset") });
	   				this._legendNode = domConstruct.create("legend", { id: dijit.getUniqueId("legend"),innerHTML:this.title });
	   				this.domNode.style.cssText = "border:1px solid #ccc;border-radius:4px;display:inline-block;padding:2px;";
	   				this.containerNode = domConstruct.create("div", { id: dijit.getUniqueId("div") });
	   				this.domNode.appendChild(this._legendNode);
	   				this.domNode.appendChild(this.containerNode);
				} else
					this.containerNode.innerHTML="";
	        		this.selectedIndex=-1;
	        		this.selectedLabel=null;
	        		this.value=null;
   				var rname=this.name?this.name:this.id;
   				var i=0;
   				for(i=0;i<this.options.length;i++){
   					var rb=domConstruct.create("input",{
   						"type":"checkbox",
   						"name":rname,
   						"id":this.options[i].id,
   						"checked":this.values[i]?true:false,
   						"class":"checkBoxGruopButton",
   					});
					var labelNode = domConstruct.create("label", 
					{ 
						innerHTML: this.options[i].label, 
						"for" : this.options[i].id,
						"class":"checkBoxGroupLabel"
					});
					var that=this;
					on(rb,"click",function(e){
						that._onchange(e.target.id,e.target.checked);
					});
					var spaceNode=domConstruct.create("span",{innerHTML:"&nbsp;&nbsp;"});
					var brNode = domConstruct.create("br");
					this.containerNode.appendChild(rb);
					this.containerNode.appendChild(spaceNode);
					this.containerNode.appendChild(labelNode);
					this.containerNode.appendChild(brNode);
   				}
            },
            _onchange:function(buttonId,checked){
            	var sIndex=-1;
            	for(var i=0;i<this.options.length;i++){
            		if(buttonId==this.options[i].id){
            			sIndex=i;
            			break;
            		}
            	}
           		if(sIndex>=0&&this.values[sIndex]!=checked){
            			
            			var nvalues=this.values.slice(0);
            			nvalues[sIndex]=checked?1:0;
            			this._set("values",nvalues);
            		}
           	},
            _setTitleAttr:function(ti){
           	this._set("title",ti);
            	this._legendNode.innerHTML=ti;
            },
            postCreate:function(){
            	this.inherited(arguments);
            	this.watch("labels",function(attr,ov,nv){
            		this.log(attr + " IS CHANGED FROM "+ov+" TO "+nv);
            	});
            	this.watch("values",function(attr,ov,nv){
        			this.log("checkboxgroup:setvalues ----------------------");
            		this.log(attr + " IS CHANGED FROM "+ov+" TO "+nv);
            	});
            }
   		
	        });
    });