define([
	"dojo/_base/declare",
	"dijit/_Widget",
	"./_GCBaseWidget",
	"dojo/store/Memory",
	"dojo/store/Observable",
	"dijit/tree/ObjectStoreModel",
	"gc/dijit/TextBox",
	"dijit/Tree"
], function(declare, _Widget, _GCBaseWidget, Memory, Observable, ObjectStoreModel, TextBox, Tree) {
	return declare("gc.dijit.JsonTree", [_Widget, _GCBaseWidget], {
		baseClass: "dijitJsonTree",
		label: "",
		disabled: false,
		
		domId: null,
		
		store: null,
		model: null,
		tree: null,
		
		ownerView: null,
		
		// attach points
		tiMetaName: null,
		tiMetaKey: null,
		tiMetaValue: null,
		
        constructor: function(params) {
        	//this.log('constructing a JsonTree with params:', params);
        	
        	if (params && params.ownerView) {
        		this.ownerView = params.ownerView;
        	}
        	
        	this.domId = (typeof params == 'string') ? params
        											 : ('domId' in params) ? params.domId
        													 			 : ''
        	;
        	var data = [];
        	if ('treedata' in params) {
        		data = params.treedata;
        		
        	} else {
        		// TODO: parse json data into treedata format
        	}
        	
        	if (typeof window.jsontree == 'undefined') {
        		window.jsontree = this;
        	}
        	
        	this.store = new Memory({
        		data: data, /* see http://dojotoolkit.org/reference-guide/1.8/dijit/Tree.html sample for "treedata" format */
        		getChildren: function(object){
        			return this.query({parent: object.id});
        		}
            });
        	
        	this.store = Observable(this.store);
        	
        	this.model = new ObjectStoreModel({
                store: this.store
              , query: {id: 'root'} //FIXME: hardcoded root node id
        	  , mayHaveChildren: function(obj) {
        		  return 'children' in obj && obj.children;
        	  }
            });
        	
        	// to listen for widget selection changes (ie, visual widgets)
        	//dojo.subscribe("/davinci/ui/widgetSelected", dojo.hitch(this, this.updateView));
        },
        
        postCreate: function() {
			this.inherited(arguments);
			
			this.tree = new Tree({
				model: this.model
			  , showRoot: false
			  , autoExpand: true
			  , getIconClass: function(item, opened) {
				  	return item.children ? 'ti-meta-tree-icon' : 'dijitLeaf';
			  	}
			});
        },

		startup: function() {
			this.inherited(arguments);
			//this.log('in JsonTree.startup: this:', this, ', tiMetaKey:', this.tiMetaKey, ', tiMetaValue:', this.tiMetaValue);

			this.tree.placeAt(dojo.byId(this.domId));
			
			//FIXME: sets the tree's click handler to run in the context of metaView, see onClick()
			var self = this
			  , count = 0
			  , connectClickHandler = function() {
					//this.log('connectClickHandler:');
					if (metaView.tiMetaKey == null || metaView.tiMetaValue == null) {
						this.log('  attach points NOT OK, aborting. tiMetaKey:', metaView.tiMetaKey, ', tiMetaValue:', metaView.tiMetaValue);
						return;
					}
					
					//this.log('  setting onClick handler');
					metaView.tree.tree.onClick = function() {
		  				metaView.tree.onClick.apply(metaView, arguments);
					};				
				}
			;
		
			if (this.tiMetaKey != null) {
				connectClickHandler();
				
			} else {
				var deferConnectClickHandler = function() {
					if (++count < 20) {
						if (metaView.tiMetaKey == null) {
							setTimeout(deferConnectClickHandler, 500);
							
						} else {
							connectClickHandler();
						}

					} else {
						this.log('deferClickHandler: attach points NOT OK, giving up.  Run: "metaView.tree.tree.onClick = function() { metaView.tree.onClick.call(metaView, arguments); };" manually');
					}
				}
				
				setTimeout(deferConnectClickHandler, 500);
			}
			
			this.tree.startup();
		},
		
		addItem: function(item) {
			this.store.add(item);
		},
		
		removeItem: function(id) {
			this.store.remove(id);
		},
		
		//FIXME: This runs with metaView as the context (see startup()), use ownerView instead
		onClick: function(item, node) {
			if (item.children) {
				// not an editable item

				// expand or collapse node if it's the currently selected virtual widget
				if (item.name == this.tiMetaName.get('value')) {
					if (node.isExpanded) {
						this.tree.tree._collapseNode(node);
					} else {
						this.tree.tree._expandNode(node);
					}
				}
				
				// update UI based on selected virtual widget
				this.disconnectOnChange(); // remove onChange handler from tiMetaValue textbox
			
				this.tiMetaName.setValue('');
				this.tiMetaKey.setValue('');
				this.tiMetaValue.setValue('');
				this.btnTiMetaEdit._setDisabledAttr(true);
			
				this.tiMetaName.setValue(item.wid);
				this.btnTiMetaDel._setDisabledAttr(false);
			
				this.connectOnChange(); // re-attach onChange handler from tiMetaValue textbox
				
			} else {
				// editable item
				
				// update UI based on selected virtual widget
				this.editingItem = item;
				
				this.disconnectOnChange(); // remove onChange handler from tiMetaValue textbox
	
				this.tiMetaName.setValue('');
				this.tiMetaKey.setValue('');
				this.tiMetaValue.setValue('');
				this.btnTiMetaEdit._setDisabledAttr(true);
	
				if (item && item.children) {
					this.tiMetaValue._setDisabledAttr(true);
					return;
				}
	
				this.tiMetaName.setValue(item.wid);
				this.tiMetaKey.setValue(item.name);
				this.tiMetaValue.setValue(item.value);
				this.tiMetaValue._setDisabledAttr(false);
				this.btnTiMetaDel._setDisabledAttr(false);
	
				if (item.name == 'onPropertyChanged') {
					if (typeof item.value != 'undefined' && item.value != '') {
						this.btnTiMetaEdit._setDisabledAttr(false);
					}
				}
				
				this.connectOnChange(); // re-attach onChange handler from tiMetaValue textbox
			}
		},
		
		destroy: function() {
			this.tree.destroy();
			this.inherited(arguments);
		},
		
/*		
		_setLabelAttr: function(buf) {
			this._set("label", buf);
			html.set(this.domNode, buf);
		},
		
		_getLabelAttr: function() {
			var buf = this.domNode.textContent;
			this._set("label", buf);
			return buf;
		},
*/		
		_simulateClick: function() {
            if (this.domNode) {
            	var evt = document.createEvent("MouseEvents");
            	evt.initEvent("click", true, false);
            	this.domNode.dispatchEvent(evt);
            }
        }
	});
});