define([
    "dojo/_base/declare", 
	"dojo/dom-construct", 
	"dojo/parser", 
	"dojo/ready",
    "dijit/_WidgetBase",
	"dijit/form/RadioButton",
	"./_GCBaseWidget",
	"dijit/_Container",
	"./libs/tools",
	"dojo/on",
	"dojo/_base/lang",
	"./libs/_selectableWidget",
	"dojo/_base/array"
    ], function(declare, domConstruct, parser, ready,_WidgetBase, RadioButton, _GCBaseWidget,_Container,tools,on,lang,_selectableWidget,array){
        return declare("gc.dijit.RadioButtonGroup", [_WidgetBase, _GCBaseWidget,_Container,_selectableWidget], {
        	baseClass:"radioButtonGroup",
        	name:"",
        	index:-1,
        	label:null,
        	length:0,
        	options:[],
        	iType:"radio",
        	style:"border:1px solid #ccc;borderRadius:4px;display:inline-block;padding:2px;",
        	title:"RadioButtonGroup",
            buildRendering: function() {
                // create the DOM for this widget
				this.inherited(arguments);
	       			this.domNode = domConstruct.create('fieldset', { id: dijit.getUniqueId("fieldset") });
	   				this._legendNode = domConstruct.create("legend", { id: dijit.getUniqueId("legend"),innerHTML:this.title });
	   				this.domNode.style.cssText = "border:1px solid #ccc;border-radius:4px;display:inline-block;padding:2px;";
	   				this.containerNode = domConstruct.create("div", { id: dijit.getUniqueId("div") });
	   				this.domNode.appendChild(this._legendNode);
	   				this.domNode.appendChild(this.containerNode);
            },
            startup:function(){
            	console.debug("radio button group startup");
            	this.inherited(arguments);
            },
            postCreate:function(){
            	console.debug("postcreate");
            	this.inherited(arguments);
            	this._loadChildren();
            	this._updateSelection();
            },
            _loadChildren:function(){
            	this.inherited(arguments);
				this.containerNode.innerHTML="";
   				var rname=this.name?this.name:this.id;
   				var i=0;
   				for(i=0;i<this.options.length;i++){
   					var rb=domConstruct.create("input",{
   						"type":this.iType,
   						"name":rname,
   						"id":this.options[i].id,
   						"value":this.options[i].value,
   						"class":"radioButtonGroupButton",
   					});
					var labelNode = domConstruct.create("label", 
					{ 
						innerHTML: this.options[i].label, 
						"for" : this.options[i].id,
						"class":"radioButtonGroupLabel"
					});
					var that=this;
					on(rb,"click",function(e){
						that._onchange(e.target.id);
					});
					var spaceNode=domConstruct.create("span",{innerHTML:"&nbsp;&nbsp;"});
					var brNode = domConstruct.create("br");
					this.containerNode.appendChild(rb);
					this.containerNode.appendChild(spaceNode);
					this.containerNode.appendChild(labelNode);
					this.containerNode.appendChild(brNode);
   				};
            },
            _onchange:function(buttonId){
            	this.clearOptions();
            	for(var i=0;i<this.options.length;i++){
            		if(buttonId==this.options[i].id){
            			this.options[i].selected=true;
            			break;
            		}
            	}
            	this._updateSelection();
            },
            _updateSelection:function(){
            	var i1=-1;
            	var foundValue=false;
            	var vs=[];
            	array.forEach(this.options,function(op,i){
            		if(op.selected){
            			if(!foundValue){
            				i1=i;
            				foundvalue=true;
            			};
            			vs.push(op.value);
            			var node1=dojo.byId(op.id);
            			if(node1)
            				node1.checked=true;
             		};
             	});
            	if(i1!=-1){
                	this._set("index",i1);
                	this._set("label",this.options[i1].label); 
                	if(this.multiple)
                		this._set("value",vs);
                	else
                		this._set("value",vs[0]);
            	}else{
                	this._set("index",i1);
                	this._set("label",""); 
                	if(this.multiple)
                		this._set("value",[]);
                	else
                		this._set("value","");
            		
            	};
            },
            _setTitleAttr:function(ti){
            	this._set("title",ti);
            	this._legendNode.innerHTML=ti;
            },
            _setValueAttr:function(v){
            	this.setOption("value",v);
            },
            _setLabelAttr:function(la){
            	this.setOption("label",la);
             }
	        });
    });