define([
	"dojo/_base/declare",
	"dojo/_base/lang",
    "./_BaseGraph"
], function(declare, lang, _BaseGraph) {
	return declare("gc.dijit.ScalarLineGraph", [_BaseGraph], {
		
		// Attributes
		updateTrigger : null, 
		bufferLength : 50,
		_buffers : null,
		valueSetted:{},
		_skipNextUpdate : false,
		
		constructor: function(params, srcNodeRef) {
			this.log("ScalarLineGraph.constructor");
			this.bufferLength = (params.bufferLength != undefined) ? Number(params.bufferLength) : 50;
		},
		
		
		_shiftLeft : function( index, newValue) {
			
			if( index >= this._numBuffers || index < 0) {
				this.log( "ScalarLineGraph supports only "+this._numBuffers + " buffers.");
				return;
			}

			var current = this._buffers[index];
			if( current.length == 0 || current.length == 1) {
				current = new Array(this.bufferLength);
				this._buffers[index] = current; 
			}
			
			current[ this.bufferLength-1] = newValue;
			current.shift();
		},

		_onUpdate : function() {
			if (this._graph) {
				if( this.modelBindEnabled) {
					for( var i = 0; i < this._numBuffers; ++i) {
						var member = "value"+i; 
						if( this.valueSetted[member]) {
							this._shiftLeft( i, this[member]);
							this._setGraphSeries(this._buffers[i], i);
						}
					}
					
					if( this._skipNextUpdate) {
						this.log('ScalarLineGraph._skipNextUpdate == true');
						this._skipNextUpdate = false;
					}
					else {
						this._graph.replot({resetAxes: (this.resetAxesOption === 'on')});
						this.log('ScalarLineGraph._onUpdate('+this.id+').graph.replot()');
					}
				}
			}
		},
		
		constructor: function(params, srcNodeRef) {
			var ii;
			var ss=this._params.series;
			for(ii=0;ii<ss.length;ii++){
				if(!(ss[ii].label))
					ss[ii].label="Value "+ii;
			};
			this.value0 = 0;
			this._buffers = new Array();
			this._buffers[0] = [0]; 
			for( var i = 1; i < this._numBuffers; ++i) {
				this._buffers[i] = [];
			}
		},
		
		startup: function() {
            this.inherited(arguments);
			this.domNode.removeAttribute("title");
            this.seriesColor();
            var id = this.domNode.getAttribute("id");
     /*       for (var i = this._buffers.length-1; i >= 0; --i) {
            	if (this._buffers[i].length <= 0)
            		this._buffers.splice(i, i);
            }*/
            this._graph = $.jqplot(id, this._buffers, this._params);
        },
   
        _set: function(option, value) {
        	this.inherited(arguments);
        	this.valueSetted[option]=true;
        },
   
		_setUpdateTriggerAttr: function(value) {
			this._set('UpdateTrigger', value);
			this._onUpdate();
		},
		
		skipNextUpdate : function() {
			this.log('ScalarLineGraph.skipNextUpdate()');
			this._skipNextUpdate = true;
		},
		
		_getExportData : function() {
			var currentData;
			var allData = new Array();
			if( !this._buffers || !this._buffers.length) {
				return allData;
			}
			var i = 0;
			for( i = 0; i < this._buffers.length; ++i) {
				var data = this._buffers[i];
				if( data && data.length) {
					var name = this['seriesName' + i];
					if( !name) {
						name = 'Series '+i;
					}
					currentData = [];
					$TI.helper._mergeArrays( currentData, {}, name);
					$TI.helper._mergeArrays( currentData, {}, data);
					allData.push( currentData);
				}
			}
			return allData;
		}
	});
});