define([
	"dojo/_base/declare", 
	"dijit/form/Select",
	"./_GCBaseWidget",
	"dojo/dom-style",
	"dojo/_base/lang",
	"dojo/dom-class",
	"dojo/dom-geometry",
	"./libs/tools",
	"dojo/dom-construct",
	"dojo/query",
	"./libs/_selectableWidget"
], function(declare, Select, _GCBaseWidget,domStyle,lang,domClass,gemo,tools,con,query,sw){
	var accepts=["font","font-family","font-size","color","font-weight","font-style","text-decoration","text-align", "vertical-align","white-space","text-indent","line-height"];
	function isAccept(item)
	{
		var rt=false;
		if(!item)
			return false;
		item=item.trim().toLowerCase();
		for(var i=0;i<accepts.length;i++)
		{
			if(item==accepts[i])
			{
				rt=true;
				break;
			}
			
		}
		return rt;
	};
	function parseCss(css)
	{
		var styles=css.split(";");
		var rt=[];
		for(var i1=0;i1<styles.length;i1++)
		{
			var stName=styles[i1].split(":")[0];
			if(isAccept(stName))
				rt.push(styles[i1]);
		}
		
		return rt.join(";");
	};
	function checkLength(len){
		if(len==null||len==undefined)
			return false;
		var len1=parseInt(len);
		if(len1==0||isNaN(len1))
			return false;
		len=len.toLowerCase();
		if(len.indexOf('px')>=0||len.indexOf('in')
				||len.indexOf('em')||len.indexOf('ex')
				||len.indexOf('cm')||len.indexOf('mm')
				||len.indexOf('pt')||len.indexOf('pc'))
			return true;
		return false;
	}

    return declare("gc.dijit.Select", [Select, _GCBaseWidget,sw], {
		labels : "item1,item2,item3",
		index: 0,
		buttonPosition:"right",
		rotate:"",
		rotateStyle:function(){
			var deg=this.rotate;
			if(!this.domNode)
				return;
			var box1=gemo.getMarginBox(this.domNode);
			var dt=(box1.w-box1.h)/2;
			var dt1=0;
			if(deg==90)
				dt1=dt; else
			if(deg==270)
					dt1=-dt;
			var translate="translate("+dt1+"px,"+dt1+"px)";
			this.domNode.style.webkitTransform="rotate("+deg+"deg) "+translate;
			this.domNode.style.MozTransform="rotate("+deg+"deg)" +translate;
			
		},
		_setRotateAttr:function(deg){
			deg=parseInt(deg);
			if(isNaN(deg))
				return;
			this.rotate=deg;
			this.rotateStyle();
		},
		_setButtonPositionAttr:function(pos){
			this.buttonPosition=pos;
			 var btNode=this.titleNode;
			 var td1=this.containerNode.parentNode;
			 if(btNode){
				 var pn=btNode.parentNode;
				 if((pos=="left"&&(btNode!=pn.firstChild))||
						 (pos!="left"&&(btNode!=pn.lastChild))){
					 pn.appendChild(pn.firstChild);
					 
				 };
				 if(pos=="left"){
					 domClass.add(td1,"leftbutton");
				 }else{
					 domClass.remove(td1,"leftbutton");
				 }
					 
				 
			 }
		},	
		_getMenuItemForOption:function(){
			var item=this.inherited(arguments);
			var box1=gemo.getMarginBox(this.titleNode);
			var td1=con.create("td",{"class":"select_bt_td"});
			td1.style.width=box1.w+"px";
			if(this.buttonPosition=="left")
				item.domNode.insertBefore(td1,item.domNode.firstChild);
			else
				item.domNode.appendChild(td1);
			return item;
			
		},
		postCreate:function()
		{
			//add global style to popup option menu by Peter Cai 
			this.inherited(arguments);
			domClass.add(this.dropDown.domNode,"tiselect");
			domClass.add(this.domNode,"tiselect");
			domClass.remove(this.domNode,"dijitRightArrowButton dijitUpArrowButton dijitLeftArrowButton dijitDownArrowButton");
			if(this.style)
			{
				var mapNode = this.dropDown.domNode;
				var css=this.style;
				if(lang.isObject(css)){
//					domStyle.set(mapNode, value);
				}else{
					var cssText=parseCss(css);
					if(mapNode.style.cssText){
						mapNode.style.cssText += "; " + cssText;
					}else{
						mapNode.style.cssText = cssText;
					}
				}
			};
			this.set("buttonPosition",this.buttonPosition);
			// set a fixed width for dojo select
			var style1=this.domNode.style;
			if(style1.overflow=="hidden"){
				var width1=style1.width;
				if(checkLength(width1)){
					var container=this.containerNode;
					var inhtml=container.innerHTML;
					container.innerHTML="";
					var widthpx=domStyle.get(this.containerNode.parentNode,"width");
					container.innerHTML=inhtml;
					gemo.setMarginBox(container,{w:widthpx});
					container.style.display="inline-block";
					container.style.overflow="hidden";
					container.style.textAlign="inherit";
				}
			}
			var that=this;
			this.watch("value",function(){
				console.debug("value changed");
			});
		},
		startup:function(){
			this.inherited(arguments);
			this.rotateStyle();
			
		},
		_fillContent:function(){
			this.inherited(arguments);

		},
//		settingValue:false,
		_setValueAttr:function(v){
	//		this.settingValue=true;
			this.log("set value: "+v);
			if((typeof v=="object")&&("value" in v))
				v=v.value;
			this.setOption("value",v);
//			this.settingValue=false;
		},
		_updateSelection:function(){
			this.inherited(arguments);
			var ii;
			for (ii=0;ii<this.options.length;ii++){
				if(this.options[ii].selected){
						this._set("index",this.options[ii].index);
						this._set("value",this.options[ii].value);
						this._setDisplay(this.options[ii].label);
						this.rotateStyle();
						break;
					};
				};
		},
		resize:function(){
			this.set("rotate",this.rotate);
		}
		
    });
});