define([
	"dojo/_base/declare",
	"dijit/layout/TabContainer",
	"dojo/_base/lang", // lang.getObject
	"./_GCBaseWidget"
], function(declare, TabContainer,lang, _GCBaseWidget,TabController) {
	return declare("gc.dijit.TabContainer", [TabContainer, _GCBaseWidget], {
		index: 0,
		
		constructor: function(params, srcNodeRef) {
		},		
		
		_setModelBindEnabledAttr:function(mbe){
			this._set("modelBindEnabled",mbe);
			if(this.getChildren){
				var childs=this.getChildren();
				if( this.selectedChildWidget) {
					this.selectedChildWidget.set("bindingDisabled",!mbe);
				}
				for(var i=0;i<childs.length;i++){
					if(childs[i] != this.selectedChildWidget){
						childs[i].set("bindingDisabled",true);
					}
				}
			};
		},
		
		startup:function(){
			var _this = this;
			this.inherited(arguments);
			this._setModelBinding();
			this.watch("selectedChildWidget",function(){
				this._setModelBinding();
				_this._set('index', _this._getIndexAttr());
			});
		},
		
		_setIndexAttr: function(index) {
			var children = this.getChildren();
			if (index >= 0 && index < children.length) {
				this.selectChild(children[index]);
			}
		},
		
		_getIndexAttr: function() {
			var children = this.getChildren();
			for (var i = 0; i < children.length; ++i) {
				if (this.selectedChildWidget === children[i])
					return i;
			}
			return -1;
		},		
	});
});