/**
 * 
 * Abstract base gauge, client should not instantiate this widget.
 */
define([
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dijit/_WidgetBase",
	"./_GCBaseWidget",
	"dojo/dom-style",

], function(declare, lang, _WidgetBase, _GCBaseWidget,domStyle) {
	return declare("gc.dijit._BaseGauge", [_WidgetBase, _GCBaseWidget], {
		baseClass: "dijit dijitGauge",
		_gauge: null,
		_params: {},
		_regenerating: false,
		
		/* public attributes */
		title: '',
		unit: '',
		lcdVisible: false,
		size: 0,
		backgroundDesign: 'brushedStainless',
		frameDesign: 'glossyMetal',
		labelNumberFormat: 'standard',
		fractionalScaleDecimals: 0,
		minValue: 0,
		maxValue: 0,
		value: 0,
		thresholdValue: 0,
		dt:2,
		getNumber:function(nv,default1){
			var rt=parseInt(nv);
			if(isNaN(rt))
				rt=default1;
			return rt;
		},
				
		constructor: function(params, srcNodeRef) {
			this.log("_BaseGauge Constructor");
			
			/* convert text to number */
			this.title = (params.title != undefined) ? params.title : '';
			this.unit = (params.unit != undefined) ? params.unit : '';
			this.lcdVisible = (params.lcdVisible != undefined) ? params.lcdVisible : false;
			this.size = params.size =this.getNumber(params.size,200);
			this.minValue = params.minValue = (params.minValue != undefined) ? Number(params.minValue) : 0;
			this.maxValue = params.maxValue = (params.maxValue != undefined) ? Number(params.maxValue) : 100;
			this.value = params.value = (params.value != undefined) ? Number(params.value) : this.minValue;
			this.value = params.value = (this.value < this.minValue) ? this.minValue : this.value;
			this.thresholdValue = (params.thresholdValue == undefined) ? this.maxValue : Number(params.thresholdValue);
			this.fractionalScaleDecimals = params.fractionalScaleDecimals = (params.fractionalScaleDecimals != undefined) ? Number(params.fractionalScaleDecimals) : 1;
			
			// calculate the threshold value
			var threshold = this.thresholdValue;
			if (threshold < this.minValue) threshold = this.minValue;
			else if (threshold > this.maxValue) threshold = this.maxValue;
			
			// parameter mixin
			this._params = lang.mixin({
				titleString: this.title,
				unitString: this.unit,
				lcdVisible: this.lcdVisible,
				lcdColor: steelseries.LcdColor.BLUE2,
				size: this.size,
				gaugeType: steelseries.GaugeType.TYPE4,
				foregroundType: steelseries.ForegroundType.TYPE5,
				
				minValue: this.minValue,
				maxValue: this.maxValue,
				value: this.value,
				
				niceScale: false,
				lcdVisible: false,
				thresholdVisible: false,
				threshold: threshold,
				valueColor: steelseries.ColorDef.BLUE,
			}, params);
			
			/* override the parameters - convert string to object */
			var _labelNumberFormat = {format: 'standard'};
			if (params.labelNumberFormat) {
				_labelNumberFormat = {format: params.labelNumberFormat};
			}
			var _frameDesign = steelseries.FrameDesign.GLOSSY_METAL;
			if (params.frameDesign) {
				_frameDesign = new steelseries.FrameDesignDef(params.frameDesign);
			}
			var _backgroundDesign = steelseries.BackgroundColor.BRUSHED_STAINLESS;
			if (params.backgroundDesign) {
				switch (params.backgroundDesign) {
				case 'punchedSheet':
					_backgroundDesign = steelseries.BackgroundColor.PUNCHED_SHEET;
					break;
				case 'carbon':
					_backgroundDesign = steelseries.BackgroundColor.CARBON;
					break;
				case 'stainless':
					_backgroundDesign = steelseries.BackgroundColor.STAINLESS;
					break;
				case 'brushedMetal':
					_backgroundDesign = steelseries.BackgroundColor.BRUSHED_METAL;
					break;
				case 'brushedStainless':
					_backgroundDesign = steelseries.BackgroundColor.BRUSHED_STAINLESS;
					break;
				case 'turned':
					_backgroundDesign = steelseries.BackgroundColor.TURNED;
					break;
				case 'darkGray':
					_backgroundDesign = steelseries.BackgroundColor.DARK_GRAY;
					break;
				case 'satinGray':
					_backgroundDesign = steelseries.BackgroundColor.SATIN_GRAY;
					break;
				case 'lightGray':
					_backgroundDesign = steelseries.BackgroundColor.LIGHT_GRAY;
					break;
				case 'white':
					_backgroundDesign = steelseries.BackgroundColor.WHITE;
					break;
				case 'black':
					_backgroundDesign = steelseries.BackgroundColor.BLACK;
					break;
				case 'beige':
					_backgroundDesign = steelseries.BackgroundColor.BEIGE;
					break;
				case 'brown':
					_backgroundDesign = steelseries.BackgroundColor.BROWN;
					break;
				case 'red':
					_backgroundDesign = steelseries.BackgroundColor.RED;
					break;
				case 'green':
					_backgroundDesign = steelseries.BackgroundColor.GREEN;
					break;
				case 'blue':
					_backgroundDesign = steelseries.BackgroundColor.BLUE;
					break;
				case 'anthracite':
					_backgroundDesign = steelseries.BackgroundColor.ANTHRACITE;
					break;
				case 'mud':
					_backgroundDesign = steelseries.BackgroundColor.MUD;
					break;
				}
			}
			this._params = lang.mixin(this._params, {			
				labelNumberFormat: _labelNumberFormat,
				frameDesign: _frameDesign,
				backgroundColor: _backgroundDesign,
			});
		},
		buildRendering:function(){
			this.inherited(arguments);
			this.domNode.width=this.size;
			this.domNode.height=this.size;
		},		
		startup: function() {
			this.inherited(arguments);
			this._initSize();
			this._gauge = this._createGauge(this.id, this._params);
			this._gauge.setValue(this.value);
			this.domNode.removeAttribute("title");
		},
		
		/**
		 * Returns a new gauge object.
		 */
		_createGauge: function(params) {
			this.log('Sub class needs to return the gauge object');
		},
		
		_setValueAttr: function(value) {
			this._set('value', value);
			if (this._gauge)
				this._gauge.setValueAnimated(value);
		},
		_setStyleAttr:function(s){
			this.inherited(arguments);
			var s1=this._calSize();
			if(this._started&&s1){
				this._gauge = this._createGauge(this.id, this._params);
				this.domNode.style.width=this.domNode.style.height=this.size+"px";
				this._set("style",this.domNode.style.cssText);
				if(this.domNode._dvWidget){
					this.domNode._dvWidget._srcElement.setAttribute("style",this.style);
					this.domNode._maqDeltas = undefined;	
					}
				this._gauge.setValue(this.value);
				this.domNode.removeAttribute("title");
			}
		},
		_calSize:function(){
			var w1=0,h1=0,s1=0;
			h1 = domStyle.get(this.domNode,"height");
			w1= domStyle.get(this.domNode,"width");
			var dh=Math.abs(this.size-h1);
			var dw=Math.abs(this.size-w1);
			if(dh<this.dt&&dw<this.dt)
				return 0;
			if(dh>=this.dt&&dw<this.dt)
				s1=h1;
			else if(dh<this.dt&&dw>=this.dt)
				s1=w1;
			else {
				s1=(w1<h1)?w1:h1;
			}
			s1=Math.round(s1);
			if(s1>0) {
				this.set("size",s1);
				this._params.size=s1;
			}
			if(this.size<=0) {
				this.size=1;
				this._params.size=1;
			}
			return s1;
		},
		resize:function(){
			this._setStyleAttr(this.style);
		},
		_initSize:function(){
			if(!this.domNode)
				return;
			this._calSize();
			this.domNode.width=this.size;
			this.domNode.height=this.szie;
			this.domNode.style.width=this.size+"px";
			this.domNode.style.height=this.size+"px";
		},
		
		set: function(prop, val) {
			this.inherited(arguments);
			
			if (prop == 'minValue' || prop == 'maxValue') {
				this.regenerate();
			}
		},
		
		regenerate: function() {	
			if (this._params.minValue != this.minValue) {
				this._params.minValue = this.minValue;
			}

			if (this._params.maxValue != this.maxValue) {
				this._params.maxValue = this.maxValue;
			}

			if (this._regenerating)
				return;
			this._regenerating = true;
				
			// IMPORTANT NOTE:
			// 
			// since blinking using setInterval for every 1000ms, we need to wait for the first setInterval
			// to kick in first to avoid flickering. Also, we need to kill the timer using the destroy
			// function to avoid multiple timer fighting to update the gauge.
			var self = this;
			setTimeout(function() {
				if (self._gauge && self._gauge.destroy) {
					self._gauge.destroy();
				}
				delete self._gauge;
				self._gauge = null;			 
			 
				self._initSize();
				self._gauge = self._createGauge(self.id, self._params);
				self._gauge.setValue(self.value);
				self.domNode.removeAttribute("title");
				
				self._regenerating = false;
			}, 2000);
		}
		
	});
});