/**
 * Dijit drag and drop mixin.
 */
define([
	"dojo/_base/declare",
	"dojo/dom-construct", 
	"dojo/dom-geometry",
	"dojo/dom-style",
	"dojo/dom-class",
	"dijit/Menu",
	"dijit/MenuItem",
	"./Tooltip",
	"./libs/tools"
], function(declare, domConstruct, domGeom, domStyle, domClass, Menu, MenuItem, Tooltip, tools) {
	return declare("gc.dijit._GCBaseWidget", null, {
		_multiStatus : null,
		_statusNode : null,
		visible:true,
		//we need this flag for parent-child binding control
		bindingDisabled:false,
		disabled:false,
		readOnly:false,
		toolTip:"",
		djTooltip:null,
		modelBindEnabled:true,
		_clazz: "",
		
		_setBindingDisabledAttr:function(bd){
			this._set("bindingDisabled",bd);
			this._setModelBinding();
		},
		/*
		 * binding must be set according to visible, disabled and parent state
		 */
		_setModelBinding:function(){
			var mb=!this.bindingDisabled&&this.visible&&!this.disabled;
			this.set("modelBindEnabled",mb);
			
		},
		_setTooltipAttr:function(tt){
			this._set("tooltip",tt);
			if(!this.djTooltip){
				this.djTooltip=new Tooltip({connectId:[this.domNode]});
			};
			this.djTooltip.set("label",tt);
		},
		_isMaqetta:function(){
			var topWin=window;
			try{
			while(true){
				if((topWin.parent)&&topWin.parent!=topWin)
					{
					topWin=topWin.parent;
					tools.pageLog(topWin);
					}
				else
					break;
			}
			if( topWin.davinci&& topWin.davinci.ve)
				return true;
			} catch(e){
//				tools.pageLog(e+"--"+e.name+"::"+e.arguments);
			}
			return false;

		},
		_setMaqettaVis:function(){
			if(!this._isMaqetta()||!this.domNode)
				return;
			var class1="widgetDisabled1";
			if(this.disabled||this.readOnly||!this.visible){
				domClass.add(this.domNode,class1);
			}else{
				domClass.remove(this.domNode,class1);
			}
			
		},
		_setChildrenTabIndex: function(domNode, index) {
			var tabIndex = domNode.getAttribute("tabIndex");
			var oldTabIndex = domNode.getAttribute("oldTabIndex");
			
			if (index && tabIndex) {
				/* remember the very first tab index */
				if (!oldTabIndex) {
					domNode.setAttribute("oldTabIndex", tabIndex);
				}
				
				domNode.setAttribute("tabIndex", index);
			
			} else if (!index && oldTabIndex) {
				domNode.setAttribute("tabIndex", oldTabIndex);
				domNode.removeAttribute("oldTabIndex");
			}			
						
			var children = domNode.children;
			if (children) {
				for (var i = 0; i < children.length; ++i) {
					this._setChildrenTabIndex(children[i], index);
				}
			}
		},
		_disabledClass:function(){
			var disClass="widgetDisabled";
			if(this._isMaqetta())
				this._setMaqettaVis();
			else {
				if(this.domNode){
					if(this.disabled||this.readOnly){
						domClass.add(this.domNode,disClass);
						this._setChildrenTabIndex(this.domNode, -1);
					}else{
						domClass.remove(this.domNode,disClass);
						this._setChildrenTabIndex(this.domNode);
					}
				}
			}
		},
		_setClassAttr: function(clazz) {
			if (this.domNode) {
				if (clazz !== undefined && clazz !== null) {
					var tmp = clazz.trim();
					domClass.remove(this.domNode, this._clazz);
					if (tmp.length > 0) {
						domClass.add(this.domNode, tmp);
					}
					this._clazz = clazz;
				}
			}
		},
		_getClassAttr: function() {
			return this._clazz;
		},
		_setDisabledAttr:function(dis){
			this._set("disabled",dis);
			this._disabledClass();
			this._setModelBinding();
		},
		_setReadOnlyAttr:function(ro){
			this._set("readOnly",ro);
			this._disabledClass();
			/*
			if(this.getChildren){
				var childs=this.getChildren();
				for(var i=0;i<childs.length;i++){
					childs[i].set("readOnly",ro);
				}
			}
			*/
		},
		_setModelBindEnabledAttr:function(mbe){
			this._set("modelBindEnabled",mbe);
			if(this.getChildren){
				var childs=this.getChildren();
				for(var i=0;i<childs.length;i++){
					childs[i].set("bindingDisabled",!this.modelBindEnabled);
				}
			}
			
		},
		
		_setVisibleAttr:function(vis){
			if(vis===null||vis==undefined)
				return;
			this._set("visible",vis);
			if(this._isMaqetta())
				this._setMaqettaVis();
			else {
				if( vis) {
					domClass.remove(this.domNode,'dijitHidden');
					if( this._statusNode.dom) {
						domClass.remove(this._statusNode.dom,'dijitHidden');
					}
				}
				else {
					domClass.add(this.domNode,'dijitHidden');
					if( this._statusNode.dom) {
						domClass.add(this._statusNode.dom,'dijitHidden');
					}
				}
			}
			this._setModelBinding();
		},				
		
		displayStatus : 'ShowIcon', // ShowIcon, Ignore, HideWidget
		constructor: function(params, srcNodeRef) {
			this.log('_GCBaseWidget constructor {' + this.baseClass + '}');
			this._multiStatus = new Array();
			this._statusNode = {};
			if( !this._isMaqetta()) {
				this._createMenu(params.id, params.menu);
			}
		},
		
		log : function( message, filter) {
			if( !filter) {
				filter = 'widget';
			}
			if( window.$TI && window.$TI.helper && window.$TI.helper.log ) {
				window.$TI.helper.log( message, filter);
			}  
			else {
				console.log(filter + ":" +message);
			}
		},
		
		_createMenu: function(widgetId, menu) {
			
			var derivedMenuItems = this._getMenuItems();
			if(!(( menu && menu.length) || (derivedMenuItems && derivedMenuItems.length))) {
				return;
			}
			
			var i = 0;
			var item = null;
			var menuWidget = new Menu({
				targetNodeIds: [widgetId]
			});

			// give a chance of the derived class to insert the menu items first.
			if( derivedMenuItems && derivedMenuItems.length) { 
				for( i = 0; i < derivedMenuItems.length; ++i) {
					item = new MenuItem( derivedMenuItems[i]);
					menuWidget.addChild( item);
				}
			}
			
			if ( menu && menu.length > 0) { 
				var that = this;
				var items = menu.split(",");
				for (i in items) {
					var pair = items[i].split(":");
					menuWidget.addChild(new MenuItem({
						label: pair[0],
						onClick: function(event) {
							try {
								window.eval(pair[1]);
							} catch (err) {
								that.log(err);
							}
						}
					}));				
				}
			}
		},
		startup: function() {
			this.inherited(arguments);
			// get a DOM node reference for the root of our widget
//			var domNode = this.domNode;
//			if (domNode.addEventListener) {
//				var _self = this;
//				dojo.connect(domNode, 'dragover', function(e) {_self._dragover(e);});
//				dojo.connect(domNode, 'drop', function(e) {_self._drop(e);});
//			}
		},

//		_dragover: function(/*Event*/ event) {
//			// the dragover event needs to be canceled to allow firing the drop event
//			if (event.preventDefault) {
//				event.preventDefault();
//			}
//			
//			// prevent propagating to parent widget
//			if (event.stopPropagation) {
//				event.stopPropagation();
//			}
//		},
//		
//		_drop: function(/*Event*/ event) {
//			var node = event.target;
//			var widgetId = null;
////			var widgetClass = null;
//			
//			do {
//				widgetId = node.getAttribute("widgetid");
//				widgetClass = node.getAttribute("class");
//				node = node.parentNode;
//			} while (node != null && widgetId == null);
//										
//			var dropText = null;
//			if (window.getCCSBinding) {
//				dropText = window.getCCSBinding();
//			
//			} else { 
//				dropText = event.dataTransfer.getData("text/plain");
//			}
//			
//			if (dropText != null) {
////				alert("widgetClass = " + widgetClass + "\n\n" + 
////						  "widgetId = " + widgetId + "\n\n" + 
////						  "dropText = " + dropText);
//			}				
//			
//			// prevent the default action
//			if (event.preventDefault) {
//				event.preventDefault();
//			}
//			
//			// prevent propagating to parent widget
//			if (event.stopPropagation) {
//				event.stopPropagation();
//			}
//		},
		
		_displayStatusAsIcon : function() {
			var message  = ""
			  , iconType = "warning"
			;
			  
			for (var msg in this._multiStatus) {
				message += this._multiStatus[msg].message + "\n";
				
				if (this._multiStatus[msg].statusType == "error") {
					iconType = "error"; 
				}
			}
			
			if (this._statusNode.dom) {
				this._statusNode.dom.parentNode.removeChild(this._statusNode.dom);
				this._statusNode.dom = null;
			}

			if (message.length > 0) {
				var iconName   = iconType == "error" ? "error.png" : "warning.png"
// [TI_FIX] DO not remove or modify the following line
				  , iconFolder = "lib/davinci.gc_1_5/WebContent/gc/resources/"
				  , geomObj    = { x:0, y:0, w:0, h:0 }
				;
				
				if (this.domNode.style.position == 'absolute') {
					// absolute-positioned elements
					var geomSrc = window.getComputedStyle(this.domNode);
					geomObj.x = parseInt(geomSrc.left) || 0;
					geomObj.y = parseInt(geomSrc.top) || 0;
					
				} else {
					// flow-positioned elements
					var targetNode = this.domNode;
					geomObj = domGeom.position(targetNode);
					
					// remove container offsets
					while (targetNode && targetNode.tagName && targetNode.tagName.toLowerCase() != 'body') {
						var styleSrc = window.getComputedStyle(targetNode)
						  , x = parseInt(styleSrc.left)
						  , y = parseInt(styleSrc.top)
						;
						
						geomObj.x -= isNaN(x) ? 0 : x;
						geomObj.y -= isNaN(y) ? 0 : y;
						
						targetNode = targetNode.parentNode;
					}
				}

				var zIndex = parseInt( domStyle.get(this.domNode, "zIndex") );

				// ensure indicator zIndex > widget zIndex (800)
				if(isNaN(zIndex)) {
					zIndex = 8000;
					
				} else {
					zIndex += 10;
				}

				var statusGeomObj = this._getStatusGeom();
				this._statusNode.dom = domConstruct.create('img', {
					src: iconFolder + iconName,
					width : statusGeomObj.w || 11, 
					height : statusGeomObj.h || 11, 
					title : message,
					id : "status_error_" + this.id,  // used for GSS testing
					style : "position:absolute;left:" + (geomObj.x + statusGeomObj.xoffset) + "px;top:" + 
							(geomObj.y + statusGeomObj.yoffset) + "px;z-index:"+zIndex+";opacity:0.8;"
				});
				if( !this.get("visible")) {
					domClass.add(this._statusNode.dom,'dijitHidden');
				}
				
				// append indicator to the same container as the widget
				this.domNode.parentNode.appendChild(this._statusNode.dom);
			}
		},
		
		/* sub-class can override this method to return a new status geom object */
		_getStatusGeom: function() {
			return {xoffset: 0, yoffset: 0, w: 0, h: 0}; 			
		},
		
		_displayStatusHideWidget : function() {
			var show = this._multiStatus.length > 0;
			if( show) {
				this._setStyleAttr( { visibility : 'visible'});
			}
			else {
				this._setStyleAttr( { visibility : 'hidden'});
			}
		},
		
		setBindStatus : function( propertyName, status) {
			
			if( status != null && status.statusType != 'ok') {
				this._multiStatus[propertyName] = status;
			}
			else {
				delete this._multiStatus[propertyName];
			}

			if( this.displayStatus == 'ShowIcon') {
				this._displayStatusAsIcon();		
			} else if ( this.displayStatus == 'HideWidget') {
				this._displayStatusHideWidget();
			}

// TODO - let the widget control their error icon position.
//			var obj = domGeom.position(this.domNode);
		},
		
		/**
		 * The derived widget returns array of objects that have label and onClick properties, i.e.:
		 * return [
		 *  	{ label : "ABC" , onClick : function (event) { // do something }},
		 *  	{ label : "XYZ" , onClick : function (event) { // do something else }},
		 *  ];
		 */
		_getMenuItems : function() {
			return [];
		},
		
		_getExportMenuItems : function() {
			var that = this;
			return [{ 
			    	 label : "Export",
			    	 onClick: function(event) {
						try {
							that._onExport();
						} catch (err) {
							that.log(err);
						}
			    	 }
			     }
			];
		},
		
		_onExport : function() {
			if( !$TI || !TI || !TI.CSVFile) {
				return;
			}
			var allData = this._getExportData();
			if( !allData || !allData.length){
				return;
			}  
			var callback = function( fileInfo, errorInfo) {
				if( errorInfo && ( errorInfo.id !== 'operation_cancelled_by_user')) {
					$TI.helper.showError( "Export failed !", errorInfo.message);
					that.log(errorInfo.message);
				} 
			};
			var options = 'auto';
			var FI = undefined;
			new TI.CSVFile().browseAndSave( allData, FI, options, callback);
		},
		
		/**
		 * The derived class provides the data to be exported here. 
		 * At this callback the it is already checked that the global variables TI and $TI are defined.
		 * The derived class returns an object, an array or a two dimensional array.  
		 */
		_getExportData : function() {
			return [];
		}
	});
});
