define([	
    "dojo/_base/lang",
	"dojo/dom-construct", 
	"dojo/_base/array",
	"dojo/on",
	"dojo/dom",
	"dojo/json"

],function(lang,construct,array,on,dom,json){
	this.isPageLog=false;
	var tools = {
		compareStr:function(s1,s2){
			return s1.localeCompare(s2);
		},
		sortOptions:function(select,data){
			var that=this;
			if(select.sort=="ascending"||select.sort=="descending"){
				data.sort(function(a,b){
					return that.compareStr(a.label,b.label);
				});
				if(select.sort=="descending")
					data.reverse();
			} else {
				for (var i = 0; i < data.length; ++i) {
					if (!("index" in data[i])) {
						return;
					}
				}				
				data.sort(function(a,b){
					return a.index-b.index;
				});
			};
			
		},
		parseLabels:function(labels){
			if(!(lang.isArray(labels))&&labels.split){
				labels=labels.split(",");
			};
			var data=[];
			for(var i=0;i<labels.length;i++){
				var datai={};
				if(labels[i].split instanceof Function){
					var di=labels[i].split(":");
					datai.value=di[0];
					if(di.length>1)
						datai.label=di[1];
					else
						datai.label=di[0];
					
				}else{
					datai.label=datai.value=labels[i];
				}
					
				data.push(datai);
			};
			return data;
			
		},
		createLogWin:function(wid){
			var logtemp="<table border='0' cellspacing='0' style='width: 100%;;height: 100%;resize:both;overflow:auto;'>"+
			"<tr><td><div id='"+wid+"' style='height: 100%;overflow: auto;resize:none;'></div></td></tr>"+
			"<tr><td style='height: 30px;text-align: left;'><button id='clearBt'>Clear</button>&nbsp;&nbsp;<button id='selectBt'>Select All</button></td></tr></table>";
			var logWin=construct.create("div",{id:"logDiv100",style:"position:absolute;z-index:9999;background-color:white;left:800px;height:200px;overflow:auto;border:1px red solid;width:300px;resize:both",
				innerHTML:logtemp});
			document.body.appendChild(logWin);
			on(dom.byId("clearBt"),"click",function(){
				dom.byId(wid).innerHTML="";
			});
			var that=this
			on(dom.byId("selectBt"),"click",function(){
				that.fnSelect(wid);
			});
		},
		fnDeSelect:function () {
			if (document.selection) document.selection.empty(); 
			else if (window.getSelection)
		            window.getSelection().removeAllRanges();
		},
	
		fnSelect:function (objId) {
			this.fnDeSelect();
			if (document.selection) {
			var range = document.body.createTextRange();
			        range.moveToElementText(document.getElementById(objId));
			range.select();
			}
			else if (window.getSelection) {
			var range = document.createRange();
			range.selectNode(document.getElementById(objId));
			window.getSelection().addRange(range);
			}
		},
		
		pageLog:function(info){
			if(!this.isPageLog)
				return;
			var lid="logDiv101";
			var logdiv=dom.byId(lid);
			if(!logdiv){
				this.createLogWin(lid);
			}
			logdiv=dom.byId(lid);
			logdiv.innerHTML+="<br/>"+info;
		},
		getTopIds:function(){
			var childs=document.body.childNodes;
			var ids=[];
			for(var i=0;i<childs.length;i++){
				if(childs[i].nodeType==1){
					var id1=childs[i].id;
					if(dijit.byId(id1)){
						ids.push(id1);
					}
				}
			}
			return ids;
			
		},
		isSpace:function(s){
			if(s===null||s===undefined)
				return true;
			s=s+"";
			return !(/\S/.test(s));
		},
		filterCss:function(css){
			function isAccept(item)
			{
				if(!item)
					return false;
				return array.some(css.acceptNames,function(name){
					if(lang.isString(name))
						return (name==item);
					else //RegExp
						return name.test(item);
				});
			};
			function parseCss()
			{
				css.accept=[];
				css.refuse=[];
				var aStyles=[];
				var ss=css.text.split(";");
				array.forEach(ss,function(s){
					var colPos=s.indexOf(":");
					if(colPos<0)
						return;
					var sname=s.substring(0,colPos);
					var svalue=s.substring(colPos+1);
						aStyles.push({name:sname.toLowerCase().trim(),value:svalue.trim()});
				});
				array.forEach(aStyles,function(s){
					var sText=s.name+":"+s.value;
					if(isAccept(s.name))
						css.accept.push(sText);
					else
						css.refuse.push(sText);
				});
			};
			parseCss();
			return css;
	
		},
		isArray:function(o) {
			//because instanceof cross frame isssue, we can't use dojo isArray
			  return Object.prototype.toString.call(o) === '[object Array]';
			},
		getCallers:function(){
			var maxLoop=20;
			var callers=[];
			var num=0;
			var ce=arguments.callee.caller;
			while(ce){
				var name=ce.name?ce.name:ce.nom;
				callers.push(name);
				try{
				ce=ce.caller;
				} catch(e){
					break;
				}
				num++;
				if(num>maxLoop)
					break;
			};
			return callers;
		},
		setCssText:function(node,css){
			if(node.style.cssText){
				node.style.cssText += "; " + css;
			}else{
				node.style.cssText = css;
			}
			
		},
		setBrowserStyle:function (node,sn,sv){
			//for firefox
			node.style["-moz-"+sn]=sv;
			//chrome
			node.style["-webkit-"+sn]=sv;
		},
		buttonStyle:function (bt,s){
			if(!bt.titleNode||!bt.domNode)
				return;
			var css={text:s,
					acceptNames:["position","top","left","z-index","width"]};
			this.filterCss(css);
			this.setCssText(bt.domNode,css.accept.join(";"));
			this.setCssText(bt.titleNode, css.refuse.join(";"));
			bt._set("style", s);
			//twist vertical align
			var va=bt.titleNode.style.verticalAlign;
			va=va.toLowerCase().trim();
			if(va=="top")
				va="start";
			else if(va=="bottom")
				va="end";
			else
				va="";//default;
			this.setBrowserStyle(bt.titleNode,"box-align",va);
			//text-algin
			var la=bt.titleNode.style.textAlign;
			la=la.toLowerCase().trim();
			if(la=="left")
				la="start";
			else if(la=="right")
				la="end";
			else
				la="";//default;
			this.setBrowserStyle(bt.titleNode,"box-pack",la);		
		}
	};
	return tools;
});