/*******************************************************************************
 * Copyright (c) 2013 Texas Instruments Incorporated - http://www.ti.com/
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Texas Instruments Incorporated - initial API and implementation
 *
 * Original Author:
 * 		Dobrin Alexiev
 *
 * Contributing Authors:
 *
 * About:
 * 		Common functionality between templates. 
 *******************************************************************************/

function _parseGCAppParameters() {
	var searchString = document.location.search;
	searchString = searchString.substring(1);
	var nvPairs = searchString.split('&');
	var expectedVars = [ 'original_href', 'original_pathname', 'app_location_href'];
	var i, j;
	var nvPair;
	var name;
	var value;
	
	for( j = 0; j < expectedVars.length; ++j) {
		for (i = 0; i < nvPairs.length; i++){
	    	nvPair = nvPairs[i].split("=");
	    	name = nvPair[0];
	    	value = nvPair[1];
	    	if( name === expectedVars[j]) {
	    		this['$GC_' + expectedVars[j]] = value; 
	    	}
		}
	}
	for( j = 0; j < expectedVars.length; ++j) {
		if( typeof this['$GC_' + expectedVars[j]] === "undefined") {
			console.log( 'ERROR : ' + expectedVars[j] + ' is not passed as parameter to this app.');
		}
	}
}

_parseGCAppParameters();

function _afterAllPropertiesChanged( bindings, dataType, widgetId, callback) {
	var props = {};
	var proxy = {
		get: function(property) { return null;},
		set: function(property, value) {
			props[ property] = true;
			var hasunset = false;
			for( var p in props) {
				if( props.hasOwnProperty(p)) {
					if( !props[p]) {
						hasunset = true;
						break;
					}
				}
			}
			if( !hasunset) {
				callback( property, value);
			}
		},
		watch: function(property, listener) {},
	};
	$TI.guiComposerServer.registerWidget( proxy, widgetId);
	for( var i = 0; i < bindings.length; ++i) {
		var propName = "prop"+i;
		props[propName] = false;
		$TI.guiComposerServer.addBinding( widgetId, propName, bindings[i], {dataType: dataType[i]});
	}
}

function _afterAnyPropertyChanged( bindings, dataType, widgetId, callback) {
	var props = {};
	var proxy = {
		get: function(property) { return null;},
		set: function(property, value) {
			if( props[property] !== value) {
				props[property] = value;
				for( var p in props) {
					if( props.hasOwnProperty(p)) {
						if( props[p] == null) {
							return;
						}
					}
				}
				callback( property, value);
			}
		},
		watch: function(property, listener) {},
	};
	$TI.guiComposerServer.registerWidget( proxy, widgetId);
	for( var i = 0; i < bindings.length; ++i) {
		var propName = "prop"+i;
		props[propName] = null;
		$TI.guiComposerServer.addBinding( widgetId, propName, bindings[i], {dataType: dataType[i]});
	}
}

