define([
   	"dojo/_base/declare",
   	"dojo/_base/connect",
   	"dojo/dom",
   	"dojo/_base/lang",
   	"dojo/dom-construct",
	"davinci/ve/input/SmartInput",
	"davinci/model/Path",
	"davinci/ve/widget",
	"davinci/ve/commands/ModifyCommand",
	"dijit/Dialog",
	"dijit/form/Button",
    "dijit/Tree",
    "dojo/text!./templates/selectsrc.txt",
    "dojo/i18n!dijit/nls/common",
	"dojo/i18n!./nls/html",
	"dijit/tree/dndSource"
], function(
	declare,
	con,
	dom,
	lang,
	construct,
	SmartInput,
	Path,
	Widget,
	ModifyCommand,
	Dialog,
	Button,
	Tree,
	templateString,
	commonNls,
	htmlNls,
	dndSource
) {
return declare(SmartInput, {
	// Added this so we can re-use this class for elements that do not support an
	// "alt" attribute (such as AUDIO, EMBED, and VIDEO)
	supportsAltText: true,
	show: function(widgetId) {
		this._widget = Widget.byId(widgetId);
		if (!this._inline) {
			this._inline = new Dialog({
				title : htmlNls.selectfiles,
				content:templateString
			});

			//Set-up file selection tree
			var treeParms= {  
				id: "htmlSrcAttributeInputSelectionTree",
				style: "height:100%;margin-bottom:12px;;overflow:auto;border:1px gray solid;",
				model: system.resource,
				filters: "new system.resource.FileTypeFilter(parms.fileTypes || '*');", //See #1725
		    };
			var tree = new Tree(treeParms).placeAt("srcTree");
			var selectedSource=dojo.byId("selectedSource");
			var images=this._widget._srcElement.getAttribute('images');
			//initialize list
			if(images&&images.length)
			{
				images=images.split(",");
				for(var i=0;i<images.length;i++){
					var option1=document.createElement("option");
					option1.text=images[i];
					selectedSource.appendChild(option1);
				}		
				
			}
			//init add button
			var addBt=dojo.byId("addBt");
			var _self=this;
			addBt.disabled=true;
			function testSelection(selection,sourceSelect){
				var rt=true;
				if("File"!=selection.elementType)
					rt=false;
				else{
					var inputPath = new Path(selection.getPath());
					var filePath = new Path(sourceSelect._widget._edit_context._srcDocument.fileName);
					// ignore the filename to get the correct path to the image
					relativePath = inputPath.relativeTo(filePath, true).toString();
					if(relativePath==="")
						rt=false;
					
				};
				return rt;
				
			};
			function testTreeSelct(){
				var selected=false;
				var i;
				if(tree.selectedItems!=null){
				for	(i=0;i<tree.selectedItems.length;i++){
					selected=testSelection(tree.selectedItems[i],_self);
					if(!selected)
						break;
				}
				}
				return selected;
			}
			dojo.connect(tree,"onClick",null,function(){
				addBt.disabled=!testTreeSelct();
			});
			dojo.connect(addBt,"onclick",null,function(){
				var selects=tree.selectedItems;
				for(var i=0;i<selects.length;i++){
					var inputPath = new Path(selects[i].getPath());
					var filePath = new Path(_self._widget._edit_context._srcDocument.fileName);
					// ignore the filename to get the correct path to the image
					relativePath = inputPath.relativeTo(filePath, true).toString();
					var option1=document.createElement("option");
					option1.text=relativePath;
					selectedSource.appendChild(option1);
					
				}
			});
			//remove ,up, down
			var deleteBt=dojo.byId("deleteBt");
			deleteBt.disabled=true;
			var upBt=dojo.byId("upBt");
			upBt.disabled=true;
			var downBt=dojo.byId("downBt");
			downBt.disabled=true;
			function testSelectButtons()
			{
				var options=selectedSource.options;
				var i=0,num=0;
				for(i=0;i<options.length;i++){
					if(options[i].selected)
						num++;
				};
				var deleteDis=true,upDis=true,downDis=true;
				if(num>0)
					deleteDis=false;
				if(num==1&&options.selectedIndex!=0)
					upDis=false;
				if(num==1&&options.selectedIndex!=options.length-1)
					downDis=false;
				deleteBt.disabled=deleteDis;
				upBt.disabled=upDis;
				downBt.disabled=downDis;
				
			}
			dojo.connect(selectedSource,"onchange",null,function(){
				testSelectButtons();
			});
			dojo.connect(deleteBt,"onclick",null,function(){
				var opts=selectedSource.options;
				var sindex=opts.selectedIndex;
				selectedSource.remove(sindex);
				if(opts.length>0){
					if(sindex<opts.length)
						opts.selectedIndex=sindex;
					else
						opts.selectedIndex=opts.length-1;
					
				}
				testSelectButtons();
			});
			dojo.connect(upBt,"onclick",null,function(){
				var options=selectedSource.options;
				if(options.selectedIndex<=0)
					return;
				selectedSource.insertBefore(options[options.selectedIndex],options[options.selectedIndex-1]);
				testSelectButtons();
			});
			dojo.connect(downBt,"onclick",null,function(){
				var options=selectedSource.options;
				if(options.selectedIndex<options.length-2){
					selectedSource.insertBefore(options[options.selectedIndex],options[options.selectedIndex+2]);
				} else if(options.selectedIndex==options.length-2){
					selectedSource.appendChild(options[options.selectedIndex]);
				}
				testSelectButtons();
			});


			//Cancel and OK button
			var cancelBt=dom.byId("cancelBt");
			var okBt=dom.byId("okBt");
			dojo.connect(cancelBt,"onclick",this,function(){
				this._inline.destroyRecursive();
				delete this._inline;
				this._inline=null;
				
			});
			con.connect(okBt,"onclick",null,function(){
				var imgs=[];
				var i;
				var options=selectedSource.options;
				for(i=0;i<options.length;i++)
				{
					imgs.push(options[i].label);
				}
				//Clean -up
				_self._inline.destroyRecursive();
		    	delete _self._inline;
		    	_self.updateWidget(imgs.join());
			});
		//Set up cancel handler
		var onCancelFileSelection = function(e) {
			this._inline.destroyRecursive();
			delete this._inline;
		};
		this._connection.push(dojo.connect(this._inline, "onCancel", this,
			onCancelFileSelection));
		}

		this._inline.show();

	},
	hide: function(cancel) {
		if (this._inline) {
			
			//Destroy dialog and widgets
			this._inline.destroyRecursive();
			delete this._inline;
		}
		this.inherited(arguments);
	},
	updateWidget: function(images) {
		var values = {};
		values.images = images;
		var context = this._widget.getContext();
		var command = new ModifyCommand(this._widget, values, null, context);
		this._widget._edit_context.getCommandStack().execute(command);
		this._widget = command.newWidget;
		// get the focus on the current node
		this._widget._edit_context._focuses[0]._selectedWidget = this._widget; 
		// redraw the box around the
		context.select(this._widget, null, false); 
	}

});
});