// [TI_FIX: selcomb] <<FILE>>
// Notes:  Developer should set the displayed message by specifying .confirmText in the constructor or with .setText() before showing the dialog
//         Optional: set numButtons to 3 for Yes/No/Cancel (default is 2 buttons)
//					 set .onHide as a callback to fire when the dialog is closed (ie to check .confirmState)
//					 set okButtonText and/or cancelButtonText in the constructor (ie to use Yes/No instead of OK/Cancel) 

define(["dojo/_base/declare",
        "dijit/_Templated",
        "dijit/_Widget",
        "dojo/i18n!davinci/ui/nls/ui",
        "dojo/i18n!dijit/nls/common",
        "dojo/text!./templates/ConfirmDialog.html",
        "dijit/form/Button",
        
],function(declare, _Templated, _Widget, uiNLS, commonNLS, templateString){
	return declare("davinci.ui.ConfirmDialog",   [_Widget, _Templated], {
		numButtons : 2,
		confirmText : "Please confirm this action",
		confirmState: false,
		altState: false,

		cancelButtonText : "Cancel",
		cancelCallBack : function(){
			if (typeof this.onHide == 'function') this.onHide();
		},
		
		okButtonText : "OK",
		okCallBack : function(){
			this.confirmState = true;
			this.altState = false;
			if (typeof this.onHide == 'function') this.onHide();
		},
		
		altButtonText : "OK",
		altCallBack : function(){
			this.confirmState = true;
			this.altState = true;
			if (typeof this.onHide == 'function') this.onHide();
		},
		
		templateString: templateString,
		widgetsInTemplate: true,
		_okButton : null,
		_altButton : null,
		_cancelButton : null,
		_confirmText : null,
		okButton : function(){this.okCallBack();this.onClose();},
		altButton : function(){this.altCallBack();this.onClose();},
		cancelButton : function(){this.cancelCallBack();this.onClose();},
		onClose:function(){},
		
		startup: function() {
			if (this.numButtons = 3) this._altButton.domNode.style.display = 'inline-block';
		},

		_setConfirmTextAttr : function(value){
			this._confirmText.innerHTML = value;
		},
		
		_setCancelCallBackAttr : function(value){
			this.cancelCallBack = value;
		},
		
		_setOkCallBackAttr : function(value){
			this.okCallBack = value;
		},

		_setAltCallBackAttr : function(value){
			this.altCallBack = value;
		},
		
		_setCancelButtonTextAttr : function(value){
			//if no cancel button text, just hide it 
			
			if(value==null || value==""){
				dojo.addClass(this._cancelButton.domNode, "dijitHidden");
			}else{
				dojo.removeClass(this._cancelButton.domNode, "dijitHidden");
			}
			
			dojo.attr(this._cancelButton,'label',  value);
		},
		
		_setOkButtonTextAttr : function(value){
			dojo.attr(this._okButton, 'label', value);
		},
		
		_setAltButtonTextAttr : function(value){
			dojo.attr(this._altButton, 'label', value);
		},
		
		setText: function(text) {
			this._setConfirmTextAttr(text);
		}
	});
});