// [TI_FIX: selcomb] <<FILE>> Note: Variant of Download.js that removes library information from download package

define(["dojo/_base/declare",
        "dijit/_Templated",
        "dijit/_Widget",
        "davinci/library",
        "system/resource",
        "davinci/Runtime",
        "davinci/Workbench",
        "davinci/ve/RebaseDownload",
        "dojo/i18n!./nls/ui",
        "dojo/i18n!dijit/nls/common",
        "dojo/text!./templates/download.html",
        "davinci/Theme",
        "dijit/form/Button"

],function(declare, _Templated, _Widget,  Library, Resource,  Runtime, Workbench, RebaseDownload, uiNLS, commonNLS, templateString, Theme){
	return declare("davinci.ui.Download",   [_Widget, _Templated], {
		templateString: templateString,
		widgetsInTemplate: true,
		
		postMixInProperties: function() {
			var langObj = uiNLS;
			var dijitLangObj = commonNLS;
			dojo.mixin(this, langObj);
			dojo.mixin(this, dijitLangObj);
			this.inherited(arguments);
		},
		/* templated attach points, custom input section */
		
		/* check box for rewrite dojo */
		__rewriteDojo : null,
		__rewriteDojoURL : null,
		__fileName : null,
		_selectionDiv : null,
		_okButton : null,
		_tableDiv : null,
	
		buildRendering : function(){
			var langObj = uiNLS;
			this.inherited(arguments);
			
			this._handles = [];
			this._userLibs = [];
			var uiArray = [];
			this.libraries = {};
		},

		_getLibRoot: function(id,version) {},
		_getLibs: function() { return []; },
		
		getRoot: function(){
			if(Workbench.singleProjectMode()){
				return Workbench.getProject();
			}
		},
		
		_getResources: function(){
			var project=Workbench.getProject();
			var folder = Resource.findResource(project);

			/* get all sub files */
		
			var list = [];
			for(var i = 0;i<folder.children.length;i++){
				list.push(folder.children[i].getPath());
			}
			
			return {userFiles: [project], userLibs: []};
		},
		
		_rewriteUrls: function(){
		
			var resources = this._getResources();
				
			//this._pages = Resource.findResource("*.html", true, null, true);

			var pageBuilder = new RebaseDownload([]);
			var allResources = [];

			for(var i=0;i<resources.userFiles.length;i++){
				var resource = Resource.findResource(resources.userFiles[i]);
				if(resource.elementType=="Folder"){
					allResources = Resource.findResource("*.html", true, resource, true);
				}else if(resource.extension=="html"){
					allResources = [resource];
				}

				for(var k=0;k<allResources.length;k++){
					if(Theme.isThemeHTML(allResources[k])) {
						continue;
					}

					var newSource = pageBuilder.rebuildSource(allResources[k].getText(), false);
					allResources[k].setContents(newSource, true);
				}
			}
		},
		
		okButton: function(){
			function makeTimeoutFunction(downloadFiles, fileName, root, libs){
				return function(){
					var files = downloadFiles;
					var fn = fileName;
				
					
					Resource.download(files, fn, root, libs);		
					/*
					for(var i=0;i<pgs.length;i++){
						pgs[i].removeWorkingCopy();
					}
					*/
					
				}
			}
			var fileName = dojo.attr( this.__fileName, "value");
			this._rewriteUrls();
		
			var allFiles = this._getResources();
			var pages = this._noRewrite ? [] : this._pages;
			/* have to close the dialog before the download call starts */
			var actualLibs = [];
			setTimeout(makeTimeoutFunction(allFiles.userFiles, fileName, this.getRoot(), actualLibs), 300);
			this.onClose();
		},
		cancelButton: function(){
			this.cancel = true;
			this.onClose();
		}
	});
});