/// [TI_FIX: selcomb] <<FILE>>

define(["dojo/_base/declare",
    	"dojo/on",
        "dijit/_Templated",
        "dijit/_Widget",
        "davinci/library",
        "system/resource",
        "davinci/Runtime",
        "davinci/Workbench",
        "davinci/ve/RebaseDownload",
        "dojo/i18n!./nls/ui",
        "dojo/i18n!dijit/nls/common",
        "dojo/text!./templates/export.html",
        "davinci/Theme",
        "dijit/form/Button"

],function(declare, on, _Templated, _Widget,  Library, Resource,  Runtime, Workbench, RebaseDownload, uiNLS, commonNLS, templateString, Theme){
	return declare("davinci.ui.ExportProject",   [_Widget, _Templated], {
		templateString: templateString,
		widgetsInTemplate: true,
		keepOpen: false,
		_custom: false,
		
		postMixInProperties: function() {
			var langObj = uiNLS;
			var dijitLangObj = commonNLS;
			dojo.mixin(this, langObj);
			dojo.mixin(this, dijitLangObj);
			this.inherited(arguments);
		},
		/* templated attach points, custom input section */
		_okButton : null,		
		_exportfileButton: null,
		_locationButton: null,
		_programButton: null,
		_locationFile: null,
		_programFile: null,
		_connectionSelect: null,
		_connectionFilter: null,
		_deviceSelect: null,
		_deviceFilter: null,
		
		connectionTypes: [],
		deviceTypes: [],
		defaultConnection: null,
		defaultDevice: null,
		defaultProgram: null,
		defaultLoaded: false,
		
		buildRendering : function(){
			this.inherited(arguments);

			var defaultFilename = 'C:\\' + Workbench.getProject() + '.zip';
			defaultFilename = defaultFilename.replace(/ /g, '_'); // no spaces

			dojo.connect(this._connectionSelect, "onChange", this, 'updateUARTConnections');
			dojo.connect(this._deviceSelect, "onChange", this, 'updateConnections'); // note case sensitive event name
			
			this._connectionSelect.addOption({ value: 0, label: 'Please select an option...', disabled: true });
			this._deviceSelect.addOption({ value: 0, label: 'Please select an option...', disabled: true });

			this.getDebugSessionInfo();
			this.updateDevices();
			this.defaultLoaded = true;
		},
		
		postCreate: function() {
			/* Check if this is a custom project or not */
			var _self = this;
			var projectName = Workbench.getProject();
			on(this._locationFile, 'keyup', this._checkValid.bind(this));
			on(this._programFile, 'keyup', this._checkValid.bind(this));
			Runtime.serverJSONRequest({
				url: "cmd/isCustomProject", 
			    content: {
			    	"project":    projectName 
			    },
			    load: function(responseObject, ioArgs) {
			    	_self._custom = responseObject;
				}, 
			    sync: true
			});
			
			/* hide non-essential element for custom project */
			if (this._custom) {
				var nonEssential = _self.domNode.getElementsByClassName('NonEssential');
	    		for (var i = 0; i < nonEssential.length; ++i) {
	    			nonEssential[i].style.display = 'none';
				}
			}
		},
		
		_checkValid: function() {
			// Disable OK button if not valid, re-enable when valid
			var valid = true;
			
			if (this._locationFile.value == '')       valid = false;
			if (!this._custom) {
				if (this._connectionSelect.get('value') == 0)   valid = false;
				if (this._deviceSelect.get('value') == 0) valid = false;
				if (this._programFile.value == '')        valid = false;
			}
			
			this._okButton.set( 'disabled', !valid);			
		},
		
		getDebugSessionInfo: function() {
			try {
				var a = Runtime.serverJSONRequest({
					url:  "cmd/getDebugSessionInfo",
					content: {},
					sync: true
				});
	
				if(a.connection){
					this.defaultConnection = a.connection;
				}
				if(a.device){
					this.defaultDevice = a.device;
				}
				if(a.program){
					this.defaultProgram = a.program;
				}
				
			} catch(e) {
				console.warn(e.toString());
			}
			
		},
		
		updateConnections: function() {
			var name = Workbench.getProject();
			if (name == "") name = "NEWPROJECT";
			
			var selectedDevice = this._deviceSelect.get('displayedValue');
			if (selectedDevice == 'Please select an option...') return;

			try {
				this._connectionSelect.options = [];
				this._connectionSelect.addOption({ value: 0, label: 'Please select an option...', disabled: true });
	
				var a = Runtime.serverJSONRequest({
					url:  "cmd/getProjectConnections",
					content: {"project": name, "device": selectedDevice},
					sync: true
				});
	
				for (var opt in a.connections) { this._connectionSelect.addOption({value: a.connections[opt], label: a.connections[opt]}); }

			} catch(e) {
				console.warn(e.toString());
			}
			
			if(!this.defaultLoaded && this.defaultConnection) {
				var connection = this._connectionSelect.getOptions(this.defaultConnection);
				if(connection) {
					this._connectionSelect.set('value', this.defaultConnection);
				}
			}

			this.updateUARTConnections(); // Update UART connection widgets
		},
		
		updateDevices: function() {
			var name = Workbench.getProject();
			if (name == "") name = "NEWPROJECT";

			try {
				this._deviceSelect.options = [];
				this._deviceSelect.addOption({ value: 0, label: 'Please select an option...', disabled: true });
	
				var a = Runtime.serverJSONRequest({
					url:     "cmd/getProjectDevices",
					content: {"project": name},
					sync:    true
				});
	
				for (var opt in a.devices) { this._deviceSelect.addOption({value: a.devices[opt], label: a.devices[opt]}); }
				
			} catch(e) {
				console.warn(e.toString());
			}
			
			if(!this.defaultLoaded) {
				if(this.defaultDevice) {
					var device = this._deviceSelect.getOptions(this.defaultDevice);
					if(device) {
						this._deviceSelect.set('value', this.defaultDevice);
					}
				}
			
				if(this.defaultProgram) {
					this._programFile.value = this.defaultProgram;
				}
			}

			this.updateConnections(); // Update connect list
		},
		
		updateUARTConnections: function() {
			var selectedConnection = this._connectionSelect.get('displayedValue');
			if (selectedConnection == 'Please select an option...') return;
			
			/* set UART widget visible */
			var UARTConnElements = document.getElementsByClassName('UARTConnection');
			var visible = selectedConnection === 'UARTConnection';
			for (var i = 0; i < UARTConnElements.length; ++i) {
				UARTConnElements[i].style.display = visible ? '' : 'none';
			}		
			this._checkValid(); // check if we can re-enable the ok button
		},

		
		exportfileButton: function() {
			this._uploader.click();
		},
		
		outfileButton: function() {
			this._ofUploader.click();
		},
		
		okButton: function(){
			var self = this;
			
			// selcomb: NOTE: Maqetta now destroys the dialogs domNode *before* showing the ConfirmDialog...
			//                We still need self so we can access the doExport() method and pass it the data we collect here
			var dlgData = {
				exportfile: 	this._locationFile.value,
				conn: 			this._connectionSelect.get('value'),
				connFilter: 	this._connectionFilter.value,
				dev: 			this._deviceSelect.get('value'),
				comportFilter: 	this._comportFilter.value,
				baudrate:		this._baudrate.value,
				devFilter:  	this._deviceFilter.value,
				outfile: 		this._programFile.value				
			};
			
			// -- Step I, Dirty Files
			var editors = Workbench.editorTabs.getChildren();
    		var dirty = [];
    		
    		editors.forEach(function(ed) {
    			if (ed.isDirty) dirty.push(ed);
    		});

    		if (dirty.length > 0) { // See if the user wants to save files before proceeding
                require(['davinci/ui/ConfirmDialog'],
                		function(ConfirmDialog) {
                			var dlgConfirm = new ConfirmDialog({
                			    confirmText:      "There are unsaved files. Please press one of the following:<ul style='list-style-type: none;'><li><strong>Yes</strong> to save all files and export</li><li><strong>No</strong> to export without saving, or<br/>&nbsp;</li><li><strong>Cancel</strong> to abort export</li></ul>"
                			  , numButtons:       3
                			  , okButtonText:     "Yes"
                			  , altButtonText:    "No"
                			  , cancelButtonText: "Cancel"
                			  , onHide:           function() {
                    				var shouldSave = (this.confirmState && !this.altState);
                    				var shouldExport = (this.confirmState || this.altState);                    				
                        			if (shouldSave) {
                        				var count = dirty.length;
                        				dirty.forEach(function(ed) { 
                        					ed.save(undefined, function() {
	                        					count--;
	                        					if (count <= 0) {
	                                    			self.doExport(dlgData); // selcomb: need to pass this data forward now	                        						
	                        					}
	                        				}); 
                        				});
                        			}
                        			else if(shouldExport) {
                            			self.doExport(dlgData); // selcomb: need to pass this data forward now	                        						
                        			}
                    			}
                			});
                    		Workbench.showModal(dlgConfirm, "Save Files", "width: 370px");
                        }
                );
                
    		} else { // No dirty files -- go to step 2
    			this.doExport(dlgData); // selcomb: need to pass this data forward now
    		}
		},
		
		doExport: function(dlgData) { // selcomb: need to have this data passed in now
			var exportfile 	  = dlgData.exportfile || false
			  , conn       	  = dlgData.conn       || false
			  , connFilter 	  = dlgData.connFilter
			  , comportFilter = dlgData.comportFilter
			  , baudrate	  = dlgData.baudrate
			  , dev        	  = dlgData.dev        || false
			  , devFilter  	  = dlgData.devFilter
			  , outfile	   	  = dlgData.outfile    || false;
			
			var errorMsg = new Error("Not enough data passed to proceed with export"); 
			if (this._custom) {
				if (!exportfile) {
					throw errmrMsg;
					return;
				}
			} else {
				if (!(exportfile && conn && dev && outfile)) {
					throw errorMsg;
					return;
				}
			}
			

			if (!exportfile.match(/\.zip$/i)) exportfile += '.zip';
		
			var projectName = Workbench.getProject();
			var result = Runtime.serverJSONRequest({
			    url:     "cmd/exportProject"
			    , content: {
				    "project":    projectName 
				  , "zipFile":    exportfile
				  , "connection": conn
				  , "connectionFilter": connFilter
				  , "comportFilter": comportFilter
				  , "baudrate": baudrate
				  , "device":     dev
				  , "deviceFilter": devFilter
				  , "program":    outfile
			    }
			  , sync: true
			});

			if (result != 'OK') {
				alert("Error during export:\n\n" + result);
				this.keepOpen = true;
				this.onClose();
				return;
			}

			this.keepOpen = false;
			this.onClose();
		},
		
		locationButton: function() {
			var self = this,
			project = Workbench.getProject();

            Runtime.serverJSONRequest({
                url: "cmd/getSelectedFile",
                handleAs: "text",
                content: {
                       "filterExtensions": "*.zip|*.*",
                       "filterNames": "Application (*.zip)|All Files (*.*)",
                       "filterPath" : self._locationFile.value,
                       "fileName": project + '.zip'
                },
                sync: false,
                load: function(responseObject, ioArgs) {
                	if (responseObject != "" && responseObject.match(".zip$") != ".zip") {
                		responseObject += ".zip";
                	}
                	if(responseObject != "") {
                		self._locationFile.value = responseObject;
                	}
                	//FIXME: check xhr.status for server errors
                	//console.dir(ioArgs);
                	self._checkValid();
                },
          });
		},

		programButton: function() {
			var self = this;
			Runtime.serverJSONRequest({
                url: "cmd/getSelectedFile",
                handleAs: "text",
                content: {
                       "filterExtensions": "*.out|*.*",
                       "filterPath" : self._programFile.value,
                       "filterNames": "Binary (*.out)|All Files (*.*)",
                },
                sync: false,
                load: function(responseObject, ioArgs) {
                	if(responseObject != "") {
                		self._programFile.value = responseObject;
                	}
                	//FIXME: check xhr.status for server errors
                	//console.dir(ioArgs);
                	self._checkValid();
                },
          });
		},

		cancelButton: function(){
			this.cancel = true;
			this.keepOpen = false;
			this.onClose();
		}
	});
});