// [TI_FIX: pchuong] - new file

define(["dojo/_base/declare",
        "dijit/_Templated",
        "dijit/_Widget",
        "davinci/library",
        "system/resource",
        "davinci/workbench/Preferences",
        "davinci/Runtime",
        "davinci/Workbench",
        "dojo/i18n!davinci/ui/nls/ui",
        "dojo/i18n!dijit/nls/common",
        "dojo/text!./templates/ImportProject.html",
        "davinci/ui/widgets/NewFile",
        "dijit/form/Button",
        "dijit/form/RadioButton",
        "dijit/form/TextBox"
        
],function(declare, _Templated, _Widget,  Library, Resource, Preferences,  Runtime, Workbench, uiNLS, commonNLS, templateString, NewFile){
	return dojo.declare("davinci.ui.ImportProject",   [_Widget,_Templated], {
		widgetsInTemplate: true,
		templateString: templateString,
		_okButton: null,

		_locationButton: null,
		_location: null,
		_projectName: null,

		postMixInProperties : function() {
			var langObj = uiNLS;
			var dijitLangObj = commonNLS;
			dojo.mixin(this, langObj);
			dojo.mixin(this, dijitLangObj);
			Resource.listProjects(dojo.hitch(this,this.setProjects));
			this.inherited(arguments);
		},
		
		setProjects : function(projects){
			this._projects = projects;
		},
		
		postCreate : function(){
			this.inherited(arguments);
			dojo.connect(this._location, "onkeyup", this, '_checkValid');
		},
		
		_checkValid : function(){
			var loc = dojo.attr(this._location, "value");
			var valid = true;
			
			if (loc == null) {
				valid = false;
				
			} else {
				var tmp = loc.replace(/^.*[\\\/]/, '');
				this._projectName = tmp.replace('.zip', '');
			}
			
			for (var i=0; i < this._projects.length && valid; i++){
				if (this._projects[i].name == this._projectName) { // key 'name' was missing from this._projects[i] in test  
					valid = false;
					
					// trigger a message
					dojo.byId('__projectExists').style.visibility = 'visible';
				}
			}

			if (this._projectName == "") 
				valid = false;

			if (valid) {
				// make sure we clear any existing project warning
				dojo.byId('__projectExists').style.visibility = 'hidden';
			}

			this._okButton.set( 'disabled', !valid);
		},

		okButton : function(){
			var self = this;

			// [TI_FIX: alee] >> begin (prompt to save dirty files first)			
			// NOTE: Maqetta now destroys the dialogs domNode *before* showing the ConfirmDialog...
			//                We still need self so we can access the doExport() method and pass it the data we collect here
			var dlgData = {
				projectName: 	this._projectName,
				location:		this._location.value
			};

			// -- Step I, Dirty Files
			var editors = Workbench.editorTabs.getChildren();
    		var dirty = [];
    		
    		editors.forEach(function(ed) {
    			if (ed.isDirty) dirty.push(ed);
    		});

    		if (dirty.length > 0) { // See if the user wants to save files before proceeding
                require(['davinci/ui/ConfirmDialog'],
                		function(ConfirmDialog) {
                			var dlgConfirm = new ConfirmDialog({
                			    confirmText:      "There are unsaved files. Please press one of the following:<ul style='list-style-type: none;'><li><strong>Yes</strong> to save all files and export</li><li><strong>No</strong> to export without saving, or<br/>&nbsp;</li><li><strong>Cancel</strong> to abort export</li></ul>"
                			  , numButtons:       3
                			  , okButtonText:     "Yes"
                			  , altButtonText:    "No"
                			  , cancelButtonText: "Cancel"
                			  , onHide:           function() {
                  				var shouldSave = (this.confirmState && !this.altState);
                				var shouldImport = (this.confirmState || this.altState);                    				                  				                  				
                    			if (shouldSave) {
                    				var count = dirty.length;
                    				dirty.forEach(function(ed) { 
                    					ed.save(undefined, function() {
                        					count--;
                        					if (count <= 0) {
                                    			self.doImport(dlgData); // selcomb: need to pass this data forward now	                        						
                        					}
                        				}); 
                    				});
                    			}
                    			else if(shouldImport) {
                        			self.doImport(dlgData); // selcomb: need to pass this data forward now	                        						
                    			}
                			}
                			});
                    		Workbench.showModal(dlgConfirm, "Save Files", "width: 370px");
                        }
                );
                
    		} else { // No dirty files -- go to step 2
    			this.doImport(dlgData); // alee: need to pass this data forward now
    		}
		},
			
    	doImport :function(dlgData) { // alee: need to have this data passed in now
			var projectName	  = dlgData.projectName || false
			  , location	  = dlgData.location       || false;
			
			var errorMsg = new Error("Not enough data passed to proceed with import"); 
			if (!(projectName && location)) {
				throw errorMsg;
				return;
			}
			

			var result = Runtime.serverJSONRequest({
				url: "cmd/importProject",
				handleAs: "text",
				content: {
					project: projectName,
					path: location,
				},
				sync: true,
			});
			if (result == 'OK') {
				Workbench.loadProject(projectName);
			}
			
			this.onClose();
		},
		// [TI_FIX: alee] << end (prompt to save dirty files first)					
		
		locationButton: function() {
			var self = this;

			Runtime.serverJSONRequest({
				url: "cmd/getSelectedFile",
				handleAs: "text",
				content: {
					"filterExtensions": "*.zip|*.*",
                    "filterNames": "Application (*.zip)|All Files (*.*)",
				},
				sync: false,
				load: function(responseObject, ioArgs) {
					self._location.value = responseObject;
					//FIXME: check xhr.status for server errors
					//console.dir(ioArgs);
					self._checkValid();
				},
			});
		},
		
		
		_getValueAttr : function(){
			return this.value;
		},
		
		cancelButton: function(){
			this.cancel = true;
			this.onClose();
		},

		onClose : function(keepOpen){
			return !keepOpen;
		}
	});
});