define(["dojo/_base/declare", 
        "dijit/_Templated", 
        "dijit/_Widget",
        "davinci/Runtime",
        "davinci/Workbench",
		"dojo/i18n!davinci/ui/nls/ui", 
		"dojo/i18n!dijit/nls/common",
		"dojo/text!./templates/InstallProject.html"

], function(declare, _Templated, _Widget, Runtime, Workbench, uiNLS, commonNLS, templateString) {

	return declare("davinci.ui.InstallProject", [ _Widget, _Templated ], {
		widgetsInTemplate : true,
		templateString : templateString,
		_okButton : null,
		_projectName : null,

		postMixInProperties : function() {
			var langObj = uiNLS;
			var dijitLangObj = commonNLS;
			dojo.mixin(this, langObj);
			dojo.mixin(this, dijitLangObj);
			if (!this.invalid)
				this.invalid = {};

			this.inherited(arguments);
		},
		postCreate : function() {
			this.inherited(arguments);
			dojo.connect(this._projectName, "onkeyup", this, '_checkValid');
			if (this.value) {
				this._setValueAttr(this.value);
			}

			if (this.invalid) {
				this._setInvalidAttr(this.invalid);
			}
		},

		_setInvalidAttr : function(values) {
			this.invalid = values;
		},

		_checkValid : function() {

			// make sure the project name is OK.
			var name = dojo.attr(this._projectName, "value");
			var valid = (name != null && name.length > 0);

			for ( var i = 0; i < this.invalid.length && valid; i++) {
				if (this.invalid[i] == name)
					valid = false;
			}
			this._okButton.set('disabled', !valid);
		},

		okButton : function() {
			this.value = dojo.attr(this._projectName, "value");
			
			var projectName = Workbench.getProject();
			
			// [TI_FIX: alee] >> begin (prompt to save dirty files first)			
			// NOTE: Maqetta now destroys the dialogs domNode *before* showing the ConfirmDialog...
			//                We still need self so we can access the doExport() method and pass it the data we collect here
			var self = this;
			var dlgData = {
				projectName: 	projectName,
				name:			this.value
			};

			// -- Step I, Dirty Files
			var editors = Workbench.editorTabs.getChildren();
    		var dirty = [];
    		
    		editors.forEach(function(ed) {
    			if (ed.isDirty) dirty.push(ed);
    		});

    		if (dirty.length > 0) { // See if the user wants to save files before proceeding
                require(['davinci/ui/ConfirmDialog'],
                		function(ConfirmDialog) {
                			var dlgConfirm = new ConfirmDialog({
                			    confirmText:      "There are unsaved files. Please press one of the following:<ul style='list-style-type: none;'><li><strong>Yes</strong> to save all files and export</li><li><strong>No</strong> to export without saving, or<br/>&nbsp;</li><li><strong>Cancel</strong> to abort export</li></ul>"
                			  , numButtons:       3
                			  , okButtonText:     "Yes"
                			  , altButtonText:    "No"
                			  , cancelButtonText: "Cancel"
                			  , onHide:           function() {
                  				var shouldSave = (this.confirmState && !this.altState);
                				var shouldInstall = (this.confirmState || this.altState);                    				                  				
                    			if (shouldSave) {
                    				var count = dirty.length;
                    				dirty.forEach(function(ed) { 
                    					ed.save(undefined, function() {
                        					count--;
                        					if (count <= 0) {
                                    			self.doInstall(dlgData); // selcomb: need to pass this data forward now	                        						
                        					}
                        				}); 
                    				});
                    			}
                    			else if(shouldInstall) {
                        			self.doInstall(dlgData); // selcomb: need to pass this data forward now	                        						
                    			}
                			}
                			});
                    		Workbench.showModal(dlgConfirm, "Save Files", "width: 370px");
                        }
                );
                
    		} else { // No dirty files -- go to step 2
    			this.doInstall(dlgData); // alee: need to pass this data forward now
    		}
		},
			
    	doInstall :function(dlgData) { // alee: need to have this data passed in now
			var projectName	  = dlgData.projectName || false
			  , name	  	  = dlgData.name       || false;
			
			var errorMsg = new Error("Not enough data passed to proceed with import"); 
			if (!(projectName && name)) {
				throw errorMsg;
				return;
			}
			
			var result = Runtime.serverJSONRequest({
				url: "cmd/installProject",
				content: {
					"project": projectName, 
					"name": name
				},
				sync: true
			});
			
			console.log('Install Result:' + result);
			
			if (result != 'OK') {
				alert("Error during install:\n\n" + result);
				//this.close(true);
				return;
			}

			this.onClose();
		},
		// [TI_FIX: alee] << end (prompt to save dirty files first)					

		_getValueAttr : function() {
			return this.value;
		},

		_setValueAttr : function(value) {

			this.value = value;
			if (this._projectName) {
				dojo.attr(this._projectName, "value", this.value);
			}
			this._checkValid();
		},

		cancelButton : function() {
			this.cancel = true;
			this.onClose();
		},

		_getCancelAttr : function(value) {
			return this.cancel;
		},
	});
});
