/* Local virtual widgets view
 * 
 */

define([
	"dojo/_base/declare",
	"../ve/metadata",
	"../Runtime",
	"./ViewLite",
	"dijit/_WidgetBase",
	"../Workbench",
	"dijit/Tooltip",
	"dijit/layout/ContentPane",
	"dojo/store/Memory",
	"dgrid/OnDemandGrid",
	"dgrid/tree",
	"dgrid/Selection",
	"dgrid/Keyboard",
	"dgrid/editor",
	"dgrid/extensions/ColumnResizer",
	"dijit/form/Select",
	"dijit/Dialog",
	"dijit/_Widget",
	"dijit/form/TextBox",
	"dijit/form/ComboBox",
	"dijit/form/Button",
	
	"dijit/_TemplatedMixin",
	"dijit/_WidgetsInTemplateMixin",
	"dojo/i18n!./nls/workbench",
	"dojo/text!./templates/LocalView.html"
], function(declare, Metadata, Runtime, ViewLite, WidgetBase, Workbench, Tooltip, ContentPane, Memory, DGrid, DGridTree, DGridSelection, DGridKeyboard, DGridEditor, DGridColumnResizer, Select, Dialog, _Widget, TextBox, ComboBox, Button, _TemplatedMixin, _WidgetsInTemplateMixin, workbenchStrings, templateStr){

return declare("davinci.ui.localview", [ViewLite, WidgetBase, _TemplatedMixin, _WidgetsInTemplateMixin],{
	debug: true,
	
	templateString: templateStr,
	domContainer: null,
	runtime: null,
	metadata: null,
	library: null,
	
	appjs: '', // (raw app.js file) string
	appfns: [],  // see loadFunctionsFromFile() below
	
	availProps: {
		widget: null,
		prop: null,
		loaded: null
	},
	
	fnTemplate: '',
	
	//FIXME: use jsonName for both virtual & physical widgets
	help: {
		// Virtual
		'Data Type':              ''
	  , 'Server Bind Name':       ''
	  , onPropertyChanged:        ''
	  , onBindStatusChanged:      ''
		  
		// Widgets
	  , dataFormat:               ''
	  , inPreProcessingFunction:  ''
	  , outPreProcessingFunction: ''
	},
	
	oldWorkbenchOnResize: null,
	currentEditor: null,
	
	dgrid: null,
	dataStore: null,
	monitoring: null, // true when monitoring changes to app.js
	
	subscriptions: [], 
	
	// attach points
	
	// methods
	stub: function(name) {
		console.warn("LocalView: " + name + " stub");
	},
	
	constructor: function(params, srcNodeRef) {		
		this.inherited(arguments);
		
		this.monitoring = false;
		
		// setup library access
		this.runtime = Runtime;
		this.metadata = Metadata;
		this.library = this.metadata.getLibraryForType('gc.dijit.Button'); // gc
		
		// get availProps
		if (typeof $TI_getAvailableBindProperties == 'function') {
		
			/* This is a workaround of the chromium browser not returning the properties */
			var numRetries = 10;
			while (numRetries > 0) {
				try {
					this.availProps.widget = JSON.parse($TI_getAvailableBindProperties('widget'));
					this.availProps.prop = JSON.parse($TI_getAvailableBindProperties('prop'));
					this.availProps.loaded = true;
					numRetries = 0;	
				} catch (e) {
					numRetries--;
					var e = new Date().getTime() + 500;
  					while (new Date().getTime() <= e) {}
				}
			}
			
			// get help text
			//  gui vars
			for (property in this.availProps.prop) {
				var p = this.availProps.prop[property];
				this.help[p.displayName] = p.description.replace(/\n/g, "<p class=\"ti-help-text\" />").replace(/\t/g, "&nbsp; &nbsp; ");
			}
			//  widgets
			for (property in this.availProps.widget) {
				var p = this.availProps.widget[property];				
				this.help[p.jsonName] = p.description.replace(/\n/g, "<p class=\"ti-help-text\" />").replace(/\t/g, "&nbsp; &nbsp; ");
			}

		} else {
			console.warn("Using an external browser, getAvailableBindProperties() not supported!");
			this.availProps.loaded = false;
		}

		this.subscribe("/davinci/ui/editorSelected", this.editorChanged.bind(this));
		
		this.loadFunctionsFromFile();
		
		this.currentEditor = {};
		
		window.localView = this;
	},
	
	fixHeight: function() {
		var localContainer = document.querySelector('.ti-local')
		  , gridContainer = document.querySelector('#localGrid')
		  , splitter = dojo.byId('palette-tabcontainer-left-bottom_splitter')
		;
		
		if (! (localContainer && splitter)) return;

		var cH = (parseInt(splitter.style.top) - 5);
		localContainer.style.height = cH + 'px';
		gridContainer.style.height = (cH - 20) + 'px';
		
		if (this.dgrid && 'resize' in this.dgrid && typeof this.dgrid.resize == 'function') {
			this.dgrid.resize();
			
			// sometimes the first record will be display above the headers,
			// calling resize() on the dgrid again (after a few ms) should clear it up.
			var self = this;
			setTimeout(function() { self.dgrid.resize(); }, 50);
		}
	},
/*
	postCreate: function() {
		this.inherited(arguments);
	},
*/
	startup: function() {
		this.inherited(arguments);
		var self = this;
		
		// watch for resize events so we can correct the height of the container and show
		// scrollbars when necessary
		if (this.oldWorkbenchOnResize == null) {
			this.oldWorkbenchOnResize = Workbench.onResize;

			Workbench.onResize = function() {
				if (self.oldWorkbenchOnResize) {
					self.oldWorkbenchOnResize(arguments);
				}

				self.fixHeight.call(self);
				
				// "disable" the delete toolbar item because we may have lost focus on a previously selected row
//FIXME: this won't work here as the resize function is called rather aggressively - even clicking the delprop button will run it thereby disabling the button before executing!
//				dojo.byId('ti-meta-tbbtn-delprop').classList.add('tiTbBtnDisabled');
			};
		}
		
		window.addEventListener('resize', function() {
			self.fixHeight.call(self);
		});
		
		this.fixHeight.call(this);
		
		// analyze app.js
		if (this.appfns.length < 1) {
			this.loadFunctionsFromFile();
		}
		
		// setup tree-grid for virtual widgets
		var columns = [
		    // widget name is not currently editable
			DGridTree({
				field: 'name'
			  , label: 'Name'
			  , collapseOnRefresh: false
			})
			
		  , {
				field: 'property'
			  , label: 'Property'
			}
			
		  , {
			    field: 'value'
			  , label: 'Value'
		  	}
		];

		var Grid = declare([DGrid, DGridSelection, DGridKeyboard, DGridColumnResizer]);
		
		// create array representing virtual widgets, to feed into dgrid
		var rootId = this.getUUID()
		  , virtualWidgets = [
		        { id: rootId, vwidget: false, vprop: false }
		    ]
		  , appJsonSrc = ''
		  , bindings = []
		;
		
		if (typeof $TI_getBindingJsonString == 'function') {
			appJsonSrc = $TI_getBindingJsonString(Workbench.getProject() + '/app.html');
			bindings = JSON.parse(appJsonSrc).widgetBindings;
		}
		
		if (bindings.length < 1) {
			console.warn('invalid bindings object:', bindings);
			bindings = [];
		}

		// setup the datastore representing virtual widget bindings
		[].forEach.call(bindings, function(binding) {
			var widgetId       = binding.widgetId
			  , propertyName   = binding.propertyName
			  , serverBindName = binding.serverBindName
			  , local          = binding.local || true
			  , options		   = binding.options
			;
			
			if (widgetId == 'prop') { // Virtual Widget
				options.onPropertyChanged = options.onPropertyChanged || '';
				options.onBindStatusChanged = options.onBindStatusChanged || '';
				
				var virtualWidgetTreeId = self.getUUID()
				  , sbnId  = self.getUUID()
				  , typeId = self.getUUID()
				  , opcId  = self.getUUID()
				  , obscId = self.getUUID()
				;
				
				virtualWidgets.push({ id: virtualWidgetTreeId, parent: rootId, name: propertyName, vwidget: true, vprop: false });
				virtualWidgets.push({ id: sbnId,  parent: virtualWidgetTreeId, property: 'Server Bind Name',      value: serverBindName, 				vwidget: false, vprop: true });
				virtualWidgets.push({ id: typeId, parent: virtualWidgetTreeId, property: 'Data Type',             value: options.dataType, 				vwidget: false, vprop: true });
				virtualWidgets.push({ id: opcId,  parent: virtualWidgetTreeId, property: 'onPropertyChanged',     value: options.onPropertyChanged, 	vwidget: false, vprop: true });
				virtualWidgets.push({ id: obscId, parent: virtualWidgetTreeId, property: 'onBindStatusChanged', value: options.onBindStatusChanged, vwidget: false, vprop: true });
			}
		});
		
		this.dataStore = new Memory({
		    data: virtualWidgets
		    
		  , getChildren: function(parent) {
		        var store = this		        
		          , children = []
		        ;
		        
		        for (var i in store.data) {
		        	var child = store.data[i];
		        	if (child.parent == parent.id) children.push(child);
		        }
		        
		        return children;
		    }
		
		  , mayHaveChildren: function(parent) {
			    return (this.getChildren(parent).length > 0);
		    }
		});
		
		this.dgrid = new Grid({
			store: this.dataStore
		  , query: { vwidget: true }
		  , columns: columns
		}, "localGrid");
		
		this.dgrid.on(".dgrid-header:click", function(evt) {
			// previously selected rows will be de-selected, "disable" toolbar items
			var delBtn = dojo.byId('ti-meta-tbbtn-delprop')
			  , edBtn = dojo.byId('ti-meta-tbbtn-editfn') 
			;
			
			if (! delBtn.classList.contains('tiTbBtnDisabled')) {
				delBtn.classList.add('tiTbBtnDisabled');
			}
			
			if (! edBtn.classList.contains('tiTbBtnDisabled')) {
				edBtn.classList.add('tiTbBtnDisabled');
			}
		});
		
		// dgrid cell click handler
		//   for editable cells (Value column on rows with vprop == true), launch a dialog
		this.dgrid.on(".dgrid-cell:click", function(evt) {
		    var cell = self.dgrid.cell(evt)
		      , colId = parseInt(cell.column.id) || 0
		    ;
		    
		    // "enable" the delete button on the toolbar
		    dojo.byId('ti-meta-tbbtn-delprop').classList.remove('tiTbBtnDisabled');
		    
		    // "disable" the edit button (re-enable below if selected row is relevant to functions)
		    dojo.byId('ti-meta-tbbtn-editfn').classList.add('tiTbBtnDisabled');
		    		    
		    if (cell && cell.row && cell.row.data && cell.row.data.vprop) {
		    	var dlgDataType = 'string'
		    	  , dlgTitle = 'Edit'
		    	  , currentValue = cell.element.textContent
		    	  , parentId = cell.row.data.parent
		    	  , parentObj = self.dataStore.query({id: parentId })[0]
		    	  , widgetId = cell.row.data.id
		    	  , widgetObj = self.dataStore.query({id: widgetId })[0]
		    	  , widgetProp = (widgetObj && widgetObj.property) || ''
		    	  , widgetName = (parentObj && parentObj.name) || ''

				  , propMap = { //FIXME: pull from this.availProps
						'Server Bind Name': 'serverBindName'
					  , 'Data Type': 'dataType'
					  , 'onPropertyChanged': 'onPropertyChanged'
					  , 'onBindStatusChanged': 'onBindStatusChanged'
					}
		    	  ;

				if (widgetName == '') {
					throw new Error("Invalid virtual widget");
					return;
				}
				
				if (widgetProp == 'onPropertyChanged' || widgetProp == 'onBindStatusChanged') {
					dojo.byId('ti-meta-tbbtn-editfn').classList.remove('tiTbBtnDisabled');
				}
				
				// don't handle clicks on the first column
				if (colId < 2) {
					return;
				}
				
				dlgTitle = 'Edit: ' + widgetName + "::" + widgetProp;
				
				var propData;
				for (property in self.availProps.prop) {
					var p = self.availProps.prop[property];
					if (widgetProp == p.displayName) {
						propData = p;
					}
				}

				dlgDataType = propData.editType || 'text';
					
	    		self.launchDialog(dlgTitle, widgetProp, dlgDataType, currentValue, function(newValue, oldValue) {
	    			if (newValue != oldValue) {
		    			if (widgetObj) {
		    				// update store
		    				widgetObj.value = newValue;
		    				self.dgrid.refresh();
		    				
		    				// rebuild a binding object to update app.json with
							var bid = 'prop'
							  , bprop = widgetName
							  , srcNodes = self.dataStore.query({parent: parentId})
							  , opts = {}
							  , sbn = ''
							;
							
							[].forEach.call(srcNodes, function(srcNode) {
									opts[propMap[srcNode.property]] = srcNode.value;
							});
							
							for (var p in opts) {
								if (typeof opts[p] == 'string' && opts[p] == '') {
									delete opts[p];
								}
							}

							if (self.library) {
								var ve = self.runtime.currentEditor.visualEditor;
								var data = new Array(ve.fileName, bid, sbn, bprop, JSON.stringify(opts));
								self.metadata.invokeCallback(self.library, 'bindProperty', data);

							} else {
								console.warn('no access to gc library, save aborted!');
							}			    				
		    			} else {
		    				console.warn("Unable to get cell data to update!");
		    			}
	    			}
	    		});
	    		
		    } else {
				// "disable" toolbar items
				var delBtn = dojo.byId('ti-meta-tbbtn-delprop')
				  , edBtn = dojo.byId('ti-meta-tbbtn-editfn') 
				;
				
				// don't "disable" the delete button if selected row is root node of a virtual widget
				if (! (cell && cell.row && cell.row.data)) {
					if (! delBtn.classList.contains('tiTbBtnDisabled')) {
						delBtn.classList.add('tiTbBtnDisabled');
					}
				}
				
				if (! edBtn.classList.contains('tiTbBtnDisabled')) {
					edBtn.classList.add('tiTbBtnDisabled');
				}
		    }
		});
		
		// start monitoring app.js for changes
		this.monitorJS();
	},
	
	monitorJS: function() {
		// NOTE: loadProject() in Workbench.js will call unmonitorJS() if necessary before changing projects 
		if (typeof $TI_registerFileMonitor == 'function') {
			var jsFile = davinci.Workbench.getProject() + "/app.js";
			$TI_registerFileMonitor(jsFile, "localView.loadFunctionsFromFile");
			this.monitoring = true;
		}
	},
	
	unmonitorJS: function() {
		if (typeof $TI_unregisterFileMonitor == 'function') {
			var jsFile = davinci.Workbench.getProject() + "/app.js";
			$TI_registerFileMonitor(jsFile);
			this.monitoring = false;
		}		
	},

	editorChanged: function(changeEvent) {
		var editor = changeEvent.editor;
	
		if (this.currentEditor) {
			if (this.currentEditor == editor) {
				return;
			}
		}
		
		this.currentEditor = editor;
		
//		var operation = (this.currentEditor.editorId == 'davinci.ve.HTMLPageEditor') ? 'showView' : 'hideView';
		var operation = 'hideView';
		Workbench[operation]('davinci.ui.localview');

		// remove any previous subscriptions and re-subscribe
		// FIXME: we shouldn't need to re-subscribe, but if we don't then the LocalView tab will not
		//         hide correctly after first occurrence.
		dojo.forEach(this.subscriptions, dojo.unsubscribe);
		delete this.subscriptions;
		this.subscriptions = [];
		this.subscribe("/davinci/ui/editorSelected", this.editorChanged.bind(this));
	},
	
	// Load app.js as a document, parse and return an array
	loadFunctionsFromFile: function(forceReload) {
		if (Workbench.getProject() == '' || Workbench.getProject() == 'undefined') {
			return;
		}
		
		if (forceReload) {
			this.appjs = '';
			this.appfns = [];
		}
		
		if (this.appjs == '') {
			var self = this
			  , projectName = Workbench.getProject()
			  , url = "/maqetta/user/maqettaUser/ws/workspace/" + projectName + "/app.js"
			;
			
			dojo.xhr('GET', {
				sync: true
				
			  , url: url
			  
			  , load: function() {
				  	var buf = arguments[0];
				  	
					self.appjs = buf;
					
					var fnList = []
					  , lines = buf.split("\n")
					  , ln = 0
					  , signatures = [
					      /^\s*function\s*([a-zA-Z0-9_]+)\s*\(([a-zA-Z0-9_\,\s]*)/
						, /^\s*window\.([a-zA-Z0-9_]+)\s*=\s*function\s*\(([a-zA-Z0-9_\,\s]*)/
					  ]
					;
					
					[].forEach.call(signatures, function(regex) {
						ln = 0;
						[].forEach.call(lines, function(line) {
							ln++;
							if (regex.test(line)) {
								var fnSig  = regex.exec(line)[0]
								  , fnName = regex.exec(line)[1]
								  , fnArgs = regex.exec(line)[2]
								  , fnBody = self.getFunctionBody(fnSig, fnArgs)
								  //, fnLine = self.findLineNumber(fnSig)
								  , fnLine = ln
								;

								fnList.push({ name: fnName, body: fnBody, args: fnArgs, sig: fnSig, line: fnLine });
							}
						});
					});
					
					var sortUnique = function(a) {
							// first sort by line number, desc
							a = a.sort(function(a,b) {
								return a.line < b.line;
							});
						
							// then sort by name, asc
							a = a.sort(function (a,b) {
								return a.name > b.name;
							});
							
							var result = [];
							result.push(a[0]);
							
							for (var i = 1; i < a.length; i++) {
						        if (a[i-1].name !== a[i].name) {
						            result.push(a[i]);
						        }
						    }
							
						    return result;
						}
					  , sortedFns = sortUnique(fnList)
					  , fnCounter = 0
					;

					[].forEach.call(sortedFns, function(fn) {
						self.appfns.push({id: ++fnCounter, name: fn.name, args: fn.args, fn: fn.body, line: fn.line});
					});
				}
			
			  , error: function() {
				  console.log('An error occurred while retrieving app.js:', arguments);
			  }
			});
		}
		
		return this.appfns;
	},
	
	getFunctionBody: function(fnSig, fnArgs) {
		var sig      = fnSig.replace(/\n/, '').replace(/\r/, '')
		  , startPos = this.appjs.indexOf(sig)
		  , result   = null
		;
		
		if (startPos >= 0) {
			var src = this.appjs
			  , scopeCount = 0
			  , pos = startPos
			  , nextChar = src.charAt(pos)
			  , scanToStartScope = function(i) {
					while (nextChar != '{') {
						i++;
						nextChar = src.charAt(i);
					};
					
					return i;
				}
			  , scanToEndScope = function(i) {
				  	var found = false
				  	  , buf = ''
				  	;
				  	
				  	while ((! found) && i < src.length) {
				  		i++;
				  		nextChar = src.charAt(i);
				  		buf += nextChar;
				  		
				  		switch (nextChar) {
				  			case '{':
				  				scopeCount++;
				  				break;
				  				
				  			case '}':
				  				if (scopeCount == 0) {
				  					found = true;
				  				} else {
				  					scopeCount--;
				  				}
				  				break;
				  				
				  			default:
				  		}
				  	}
				  	
				  	return {pos: i, buf: buf};
			  	}
			;
			
			var scopePos = scanToStartScope(pos)
			  , scope    = scanToEndScope(scopePos)
			;
			
			//result = src.substr(startPos, (scopePos - startPos) + 1) + scope.buf; // full, includes signature and open/close braces
			result = scope.buf.replace(/(\r\n)+$/, '').replace(/\n+$/, '').replace(/}$/, '');
			
			var preface = ''
			  , args = fnArgs.split(/,/)
			;
			for (var i=0; i<args.length; i++) {
				var arg = args[i].replace(/^\s+/, '').replace(/\s+$/, '');
				
				preface += "var " + arg + " = arguments[" + i + "];\n";
			}
			result = preface + result;
			
		} else {
			console.warn("LocalView: getFunctionBody: can't find the function body for function signature:", sig);
		}
		
		return result;
	},

	getUUID: function() {
		// RFC4122 v4
		return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
			var r = Math.random() * 16 | 0,
			    v = (c == 'x') ? r
			    		       : (r & 0x3 | 0x8)
			;
			
			return v.toString(16);
		});
	},	
	
	// edit a function in CCS
	editFn: function(targetFn, silent) {
		var self = this
		  , lineNum = -1
		;
		
		targetFn = targetFn || '';
		silent = silent || false;

		if (targetFn == '') {
			if ('dgrid' in this) {
				// scan dgrid selection
				var selectedId = Object.keys(this.dgrid.selection)[0]
				  , selectedObj = this.dataStore.query({id: selectedId})[0]
				  , parentId
				  , parentObj
				;
				
				if (selectedObj && selectedObj.parent) {
					parentId = selectedObj.parent;
					parentObj = this.dataStore.query({id: parentId })[0];
					
				} else {
					console.warn("Can't determine virtualWidget to edit");
					return;
				}

				switch(selectedObj.property) {
					case 'onPropertyChanged':
					case 'onBindStatusChanged':
						targetFn = selectedObj.value;
						break;
						
					default:
						targetFn = '';
				}
			}
		}
		
		[].forEach.call(this.appfns, function(fn) {
			if (fn.name == targetFn) {
				lineNum = fn.line;
			}
		});
		
		var jsFilename = davinci.Workbench.getProject() + "/app.js";
		if (lineNum == -1 && typeof targetFn == 'string' && targetFn != '') {

			var jsFuncDef = (this.fnTemplate && this.fnTemplate != '') ? this.fnTemplate : "\nfunction " + targetFn + "() {\n\n}\n";
			
//FIXME: prevent empty funcdefs
if (jsFuncDef == "\nfunction " + targetFn + "() {\n\n}\n") { return; }
	
			if (typeof $TI_appendToFile == 'function') {
				$TI_appendToFile(jsFilename, jsFuncDef);
			}
			
			this.fnTemplate = '';

			// wait for the function to be appended, reload our function information, then try again.
			// note: need to set forceReload when we call loadFunctionsFromFile so we get the proper line number
			//       for the newly created function
			setTimeout(function() {
				self.loadFunctionsFromFile(true);
				
				setTimeout(function() {
					self.editFn.call(self, targetFn, silent);
				}, 250);
			}, 750);
			return;
		}
		
		// don't open editor if silent argument was provided
		if (typeof $TI_openJSEditor == 'function' && !silent) {
			$TI_openJSEditor(jsFilename, lineNum);
		}
		//FIXME: add support for maqetta editor if we're using an external browser?
	},
	
	launchDialog: function(title, propertyName, type, oldValue, cb) {
		var userInputWidget = '';

		var propData;
		for (property in this.availProps.prop) {
			var p = this.availProps.prop[property];
			if (propertyName == p.displayName) {
				propData = p;
			}
		}

		var ucFirstWidgetName = title.replace(/^Edit: /, '').replace(/::.*$/, '').replace(/^[a-z]/, function(char) { return char.toUpperCase(); });
		var defaultFnName = ('newName' in propData) ? propData.newName.replace(/<text1>/g, ucFirstWidgetName) : '';

		switch(type) {
		case 'list':
			var types = propData.listItems;

			// [TI_FIX: alee] >> begin (SDSCM00047762 )						
			this.fnSrcTemplate = '';
			// [TI_FIX: alee] << end (SDSCM00047762 )			
			userInputWidget = '<select data-dojo-type="dijit/form/Select" data-dojo-attach-point="userin" style="width: 200px;">';
			[].forEach.call(types, function(type) {
				var selected = (oldValue == type) ? ' selected="selected"' : '';
				userInputWidget += '<option value="' + type + '"' + selected + '>' + type + '</option>';
			});
			userInputWidget += '</select>';
			break;
			

		case 'function':
			// hack: keep a copy of the original function template
			//       so we can rewrite it if user types in a new function name and does not use the default
			this.fnSrcTemplate = "\n" + propData.codeSnippet + "\n";
			
			userInputWidget = '<select data-dojo-type="dijit/form/ComboBox" data-dojo-attach-point="userin" data-dojo-attach-event="onKeyUp:_checkKeys"  style="width: 200px;">';
			var selected = '', tmpUserInputWidget = '', added = {};
			
			// Add known functions to select
			[].forEach.call(this.appfns, function(fn) {
				selected = (oldValue == fn.name) ? ' selected="selected"' : '';
				tmpUserInputWidget += '<option value="' + fn.name + '"' + selected + '>' + fn.name + '</option>';
				added[fn.name] = true;
			});

			// Use defaultFnName if nothing selected and no oldValue
			if (selected == '') {
				if (oldValue == '') {
					if (added[defaultFnName]) {
						//console.log('defaultFnName "' + defaultFnName + '" already in function list -A');
					} else {
						userInputWidget += '<option value="' + defaultFnName + '" >' + defaultFnName + '</option>';
						added[defaultFnName] = true;
					}
					this.fnTemplate = "\n" + propData.codeSnippet.replace(/<text1>/g, defaultFnName) + "\n";
			
				// otherwise, if oldValue is not empty use that instead
				} else {
					if (added[oldValue]) {
						//console.log('defaultFnName "' + defaultFnName + '" already in function list -B');
					} else {
						userInputWidget += '<option value="' + oldValue + '" >' + oldValue + '</option>';
						added[oldValue] = true;
					}
					this.fnTemplate = "\n" + propData.codeSnippet.replace(/<text1>/g, oldValue) + "\n";
				}
			}
			
			userInputWidget += tmpUserInputWidget + '</select>';
			break;
			
		case 'text':
		default:
			// [TI_FIX: alee] >> begin (SDSCM00047762 )						
			this.fnSrcTemplate = '';
			// [TI_FIX: alee] << end (SDSCM00047762 )			
			userInputWidget = '<input value="' + oldValue + '" data-dojo-attach-event="onKeyUp:_checkKeys" style="width: 20em;" data-dojo-type="dijit/form/TextBox" data-dojo-attach-point="userin" />';
		}

		var self = this;
		
		var editBtnTmpl = (type == 'function') ? '<button dojoType="dijit.form.Button" type="button" data-dojo-attach-point="btnEdit" data-dojo-attach-event="onClick:_edit" style="float:left;">Edit</button>' : ''
		  , contentWidget = new (declare([_Widget, _TemplatedMixin, _WidgetsInTemplateMixin], {
			templateString:   '<div style="margin: -10px; padding: 0px;">'
				+ '<div style="padding: 5px; padding-left: 10px;">'
				+ '<p><span style="display: inline-block; width: 18em; text-align: right;">' + propertyName + ':</span>&nbsp;' + userInputWidget
				+ '<img src="/maqetta/app/davinci/img/help_25.png" width="16" height="16" style="float: right; margin-right: 1em; margin-top: 2px;" onclick="(function(el) { var descNode = el.parentElement.parentElement.getElementsByClassName(\'ti-desc\')[0]; descNode.innerHTML = localView.help[\'' + propertyName + '\'] || \'NOT_SET\'; })(this);" /></p>'
				//+ '<div class="ti-desc" style="margin: 0px; margin-left: 10px; margin-right: 10px; padding: 0px; color: #aaa;">' + self.help[propertyName] + '</div>'
				+ '<div class="ti-desc" style="margin: 0px; margin-left: 10px; margin-right: 10px; padding: 0px; color: #aaa;"></div>'
				+ '</div>'
				+ '<div class="dijitDialogPaneActionBar" style="margin: 0px; padding: 0px; padding-left: 5px; padding-right: 5px; padding-top: 2px; padding-bottom: 2px;">'
				+   editBtnTmpl
				+ 	'<button dojoType="dijit.form.Button" type="submit" data-dojo-attach-point="btnOk" data-dojo-attach-event="onClick:_ok">OK</button>'
				+ 	'<button dojoType="dijit.form.Button" type="button" data-dojo-attach-point="btnCancel" data-dojo-attach-event="onClick:_cancel">Cancel</button> &nbsp;&nbsp;'
				+ '</div>'
				+ '</div>',

			// attach points
			userin: null,		// generated input widget
			btnOk: null, 		// buttons
			btnCancel: null,
			btnEdit: null,
/*			
		    postCreate: function() {
				this.inherited(arguments);
		    },
*/

		    startup: function() {
		    	this.inherited(arguments);
		    	this.userin.set('style', {width: '20em'});
		    },

		    _checkKeys: function(evt) {
		    	if (evt.which == 13) {
		    		this._ok();
		    	}
		    },
		    
			_ok: function() {
				// update the js file if user entered a function name
				var newValue = this.userin.get('value');
				if (newValue != '') {
					var view = this.ownerDialog.ownerView
					  , found = false
					;
					
					[].forEach.call(view.appfns, function(fn) {
						if (fn.name == newValue) {
							found == true;
						}
					});
					
					if (! found) {
						// update template
						view.fnTemplate = view.fnSrcTemplate.replace(/<text1>/g, newValue);
						view.editFn(newValue, true); // silent
					}
				}

				if (cb && typeof cb == 'function') {
					cb(newValue, oldValue);
					
				} else {
					console.warn('dialog closed with "OK" but no callback provided');
				}
				
				this.ownerDialog.ownerView.fnSrcTemplate = '';
				this.ownerDialog.destroy();
			},
			
			_cancel: function() {
				this.ownerDialog.ownerView.fnSrcTemplate = '';
				this.ownerDialog.destroy();
			},
			
			_edit: function() {
				var newValue = this.userin.get('value');
				this.ownerDialog.ownerView.editFn(newValue, false); // not silent (open the editor)
				
				// _ok now silently adds missing functions so if we call it here to close the dialog and fire the callback, we'll get a second copy of the generated function
				//this._ok();
				
				// simulate calling _ok() instead...
				if (cb && typeof cb == 'function') {
					cb(newValue, oldValue);
					
				} else {
					console.warn('dialog closed with "OK" but no callback provided');
				}
				
				this.ownerDialog.ownerView.fnSrcTemplate = '';
				this.ownerDialog.destroy();
			}
		}));
		
		contentWidget.startup();
		
		var editPropDialog = new Dialog({
			title: title
		  , content: contentWidget
		  , style: 'width: 515px;'
		});
		
		// add a reference to the containing dialog so we can destroy it from contentWidget's button handlers
		editPropDialog.content.ownerDialog = editPropDialog;
		editPropDialog.ownerView = this;
		
		editPropDialog.startup();
		editPropDialog.show();
	},
	
	newVirtual: function() {
		if (typeof $TI_getBindingJsonString != 'function') {
			return;
		}
		
		var contentWidget = new (declare([_Widget, _TemplatedMixin, _WidgetsInTemplateMixin], {
			templateString:   '<div style="margin: -10px; padding: 0px;">'
				+ '<div style="padding: 5px; padding-left: 10px;">'
				+ '<label style="display: inline-block; width: 14em; text-align: right;">Name:</label> <div data-dojo-type="dijit/form/TextBox" data-dojo-attach-point="tbName" data-dojo-attach-event="onKeyUp:_checkKeys" style="width: 14em;"></div>'
				+ '<br/></div>'
				+ '<div data-dojo-type="dijit/form/TextBox" data-dojo-attach-point="tbError" style="width:68%; margin-left: 17%; visibility: hidden; background-color: transparent; color: #c00 !important; border: 0px solid #000;" value="Name already in use, please try another"></div>'
				+ '<div class="dijitDialogPaneActionBar" style="margin: 0px; padding: 0px; padding-left: 5px; padding-right: 5px; padding-top: 2px; padding-bottom: 2px;">'
				+ 	'<button dojoType="dijit.form.Button" type="submit" data-dojo-attach-point="btnOk" data-dojo-attach-event="onClick:_ok">OK</button>'
				+ 	'<button dojoType="dijit.form.Button" type="button" data-dojo-attach-point="btnCancel" data-dojo-attach-event="onClick:_cancel">Cancel</button> &nbsp;&nbsp;'
				+ '</div>'
				+ '</div>',
		
			// attach points
			tbName: null,		// textboxes
			tbError: null,
			btnOk: null, 		// buttons
			btnCancel: null,
			
		    postCreate: function() {
				this.inherited(arguments);
		    },
		    
		    _checkKeys: function(evt) {
		    	if (evt.which == 13) {
		    		this._ok();
		    	}
		    },
		
			_ok: function() {
				var propName = this.tbName.get('value') || '';
				
				if (propName && propName != '') {
					  var htmlFile = davinci.Workbench.getProject() + "/app.html"
					    , bindings = JSON.parse($TI_getBindingJsonString(htmlFile)).widgetBindings
					    , valid = true;
					;
					
					for (var i=0; i<bindings.length; i++) {
						if (bindings[i].propertyName == propName) {
							valid = false;
						}
					}
					
					if (! valid) {
						this.tbError.domNode.style.visibility = 'visible';
						
						var self = this;
						setTimeout(function() {
							self.tbName.set('value', '');
							self.tbName.focus();
							self.tbError.domNode.style.visibility = 'hidden';
						}, 3000);
						
						return false;
						
					} else {
						// create an app.json entry for the new virtual widget
						var widgetId = 'prop'
						  , widgetProperty = propName
						  , opts = {
								dataType: 'String'
							}
						;
						
						var view = this.ownerDialog.ownerView;
						
						if (view.library) {
							var ve = view.runtime.currentEditor.visualEditor;
							var data = new Array(ve.fileName, widgetId, '', propName, JSON.stringify(opts)); // '' was widgetType
							view.metadata.invokeCallback(view.library, 'bindProperty', data);
							
							// add to tree
							var rootId = view.dataStore.data[0].id
							  , virtualWidgetTreeId = view.getUUID()
							  , sbnId  = view.getUUID()
							  , typeId = view.getUUID()
							  , opcId  = view.getUUID()
							  , obscId = view.getUUID()
							;
							
							view.dataStore.add({ id: virtualWidgetTreeId, parent: rootId, name: propName, vwidget: true, vprop: false });
							view.dataStore.add({ id: sbnId,  parent: virtualWidgetTreeId, property: 'Server Bind Name',      value: '', 				vwidget: false, vprop: true });
							view.dataStore.add({ id: typeId, parent: virtualWidgetTreeId, property: 'Data Type',             value: opts.dataType,		vwidget: false, vprop: true });
							view.dataStore.add({ id: opcId,  parent: virtualWidgetTreeId, property: 'onPropertyChanged',      value: '', 				vwidget: false, vprop: true });
							view.dataStore.add({ id: obscId, parent: virtualWidgetTreeId, property: 'onBindStatusChanged', value: '', 				vwidget: false, vprop: true });
							
							view.dgrid.refresh();
							
						} else {
							console.warn('no access to gc library, save aborted!');
						}
					}
					
				} else {
					console.log('No name, cancelling virtual widget creation');
				}
				
				this.ownerDialog.destroy();
			},
			
			_cancel: function() {
				this.ownerDialog.destroy();
			}		
		}));
		
		contentWidget.startup();
		
		var newVirtualDialog = new Dialog({
			title: 'New Virtual Widget'
		  , content: contentWidget
		  , style: 'width: 360px;'
		});
		
		// add a reference to the containing dialog so we can destroy it from contentWidget's button handlers
		newVirtualDialog.content.ownerDialog = newVirtualDialog;
		newVirtualDialog.ownerView = this;
		
		newVirtualDialog.startup();
		newVirtualDialog.show();
	},
	
	delVirtual: function() {
		if (typeof $TI_getBindingJsonString != 'function') {
			return;
		}

		var selectedId = Object.keys(this.dgrid.selection)[0]
		  , selectedObj = this.dataStore.query({id: selectedId})[0]
		  , parentId
		  , parentObj
		;
		
		if (selectedObj && selectedObj.parent) {
			parentId = selectedObj.parent;
			parentObj = this.dataStore.query({id: parentId })[0];
			
		} else {
			console.warn("Can't determine virtualWidget to edit");
			return;
		}

		var selectedVirtual = (selectedObj.name && selectedObj.name != '') ? selectedObj : parentObj;

		var contentWidget = new (declare([_Widget, _TemplatedMixin, _WidgetsInTemplateMixin], {
			templateString:   '<div style="margin: -10px; padding: 0px;">'
				+ '<div style="padding: 5px; padding-left: 10px;">'
				+ '<p>Are you sure you want to delete "' + selectedVirtual.name + '"?</p>'
				+ '<br/></div>'
				+ '<div class="dijitDialogPaneActionBar" style="margin: 0px; padding: 0px; padding-left: 5px; padding-right: 5px; padding-top: 2px; padding-bottom: 2px;">'
				+ 	'<button dojoType="dijit.form.Button" type="submit" data-dojo-attach-point="btnOk" data-dojo-attach-event="onClick:_ok">OK</button>'
				+ 	'<button dojoType="dijit.form.Button" type="button" data-dojo-attach-point="btnCancel" data-dojo-attach-event="onClick:_cancel">Cancel</button> &nbsp;&nbsp;'
				+ '</div>'
				+ '</div>',
		
			// attach points
			btnOk: null, 		// buttons
			btnCancel: null,
			
		    postCreate: function() {
				this.inherited(arguments);
		    },
		
			_ok: function() {
				var htmlFile = davinci.Workbench.getProject() + "/app.html"
				  , bindings = JSON.parse($TI_getBindingJsonString(htmlFile)).widgetBindings
				;

				var optsJson = {};
				for (var i=0; i<bindings.length; i++) {
					if (bindings[i].propertyName == selectedVirtual.name) {
						optsJson = bindings[i];
					}
				}

				$TI_unbindProperty(htmlFile, 'prop', '', selectedVirtual.name, JSON.stringify(optsJson.options));
				
				var view = this.ownerDialog.ownerView
				  , children = view.dataStore.getChildren(selectedVirtual.id)
				;
				
				[].forEach.call(children, function(child) {
					view.dataStore.remove(child.id);
				});
				
				view.dataStore.remove(selectedVirtual.id);
				
				this.ownerDialog.ownerView.dgrid.refresh();
				this.ownerDialog.destroy();
			},
			
			_cancel: function() {
				this.ownerDialog.destroy();
			}		
		}));
		
		contentWidget.startup();
		
		var delVirtualDialog = new Dialog({
			title: 'Delete Virtual Widget'
		  , content: contentWidget
		  , style: 'width: 360px;'
		});
		
		// add a reference to the containing dialog so we can destroy it from contentWidget's button handlers
		delVirtualDialog.content.ownerDialog = delVirtualDialog;
		delVirtualDialog.ownerView = this;
		
		delVirtualDialog.startup();
		delVirtualDialog.show();
	}
	
});
});
