/**
 * Analog meter.
 */
define([
	"dojo/_base/declare",
	"dojo/_base/lang",
	"./_BaseGauge",
	"dojo/dom-style",
], function(declare, lang, _BaseGauge,domStyle) {
	return declare("gc.dijit.AnalogMeter", [_BaseGauge], {
		baseClass: "dijit dijitAnalogMeter",
		_meter: null,
		
		height: 0,
		width: 0,
		constructor: function(params, srcNodeRef) {
			log("AnalogMeter Constructor");
			
			this.height = this._params.height = params.height = (params.height != undefined) ? Number(params.height) : 300;
			this.width = this._params.width = params.width = (params.width != undefined) ? Number(params.width) : 120;
		},
		
		_createGauge: function(id, params) {
			return new steelseries.Linear(id, params);
		},
		_setStyleAttr:function(s){
			this._set("style",s);
			var dstyle=this.domNode.style;
			if(dstyle.cssText)
				dstyle.cssText+=s;
			else
				dstyle.cssText=s;
			var s1=this._calSize();
			if(this._started&&s1>0){
				this._gauge = this._createGauge(this.id, this._params);
				this._gauge.setValue(this.value);
				this.domNode.removeAttribute("title");
			}
		},
		_calSize:function(){
			var w1=0,h1=0;
			h1 = domStyle.get(this.domNode,"height");
			h1=Math.round(h1/10)*10;
			if(h1>0){
				this.height=this._params.height=h1;
			};
			w1 = domStyle.get(this.domNode,"width");
			w1=Math.round(w1/10)*10;
			if(w1>0){
				this.width=this._params.width=w1;
			};
			return h1+w1;
		},
		_initSize:function(){
			if(!this.domNode)
				return;
			this.domNode.width=this.width;
			this.domNode.height=this.height;
			this._calSize();
			this.domNode.width=this.width;
			this.domNode.height=this.height;
			this.domNode.style.width=this.width+"px";
			this.domNode.style.height=this.height+"px";
		}
	});
});