define([
	"dojo/_base/declare", 
	"dijit/form/ComboBox",
	"./_GCBaseWidget",
	"dojo/dom-style",
	"dojo/_base/lang",
	"dojo/dom-class",
	"dojo/dom-geometry",
	"./libs/tools"
], function(declare, ComboBox, _GCBaseWidget,domStyle,lang,domClass,gemo,tools){
	var accepts=["font","font-family","font-size","color","font-weight","font-style","text-decoration","text-align", "vertical-align","white-space","text-indent","line-height"];
	function isAccept(item)
	{
		var rt=false;
		if(!item)
			return false;
		item=item.trim().toLowerCase();
		for(var i=0;i<accepts.length;i++)
		{
			if(item==accepts[i])
			{
				rt=true;
				break;
			}
			
		}
		return rt;
	};
	function parseCss(css)
	{
		var styles=css.split(";");
		var rt=[];
		for(var i1=0;i1<styles.length;i1++)
		{
			var stName=styles[i1].split(":")[0];
			if(isAccept(stName))
				rt.push(styles[i1]);
		}
		
		return rt.join(";");
	};
	function checkLength(len){
		if(len==null||len==undefined)
			return false;
		var len1=parseInt(len);
		if(len1==0||isNaN(len1))
			return false;
		len=len.toLowerCase();
		if(len.indexOf('px')>=0||len.indexOf('in')
				||len.indexOf('em')||len.indexOf('ex')
				||len.indexOf('cm')||len.indexOf('mm')
				||len.indexOf('pt')||len.indexOf('pc'))
			return true;
		return false;
	}

    return declare("gc.dijit.ComboBox", [ComboBox, _GCBaseWidget], {
		labels :"item1,item2,item3",
		index: 0,
		buttonPosition:"right",
		rotate:"",
		_setRotateAttr:function(deg){
			this.rotate=deg;
			if(this.domNode){
				this.domNode.style.webkitTransform="rotate("+deg+"deg)";
				this.domNode.style.MozTransform="rotate("+deg+"deg)";
			}
			
		},
		_setButtonPositionAttr:function(pos){
			this.buttonPosition=pos;
			 var btNode=this.titleNode;
			 if(btNode){
				 var pn=btNode.parentNode;
				 if((pos=="left"&&(btNode!=pn.firstChild))||
						 (pos!="left"&&(btNode!=pn.lastChild))){
					 pn.appendChild(pn.firstChild);
					 
				 }
			 }
		},	
		openDropDown:function(){
			this.inherited(arguments);
			if(this.style)
			{
				var mapNode = this.dropDown.domNode;
				var css=this.style;
				if(lang.isObject(css)){
//					domStyle.set(mapNode, value);
				}else{
					var cssText=parseCss(css);
					if(mapNode.style.cssText){
						mapNode.style.cssText += "; " + cssText;
					}else{
						mapNode.style.cssText = cssText;
					}
				}
			}
			// set a fixed width for dojo select
			var style1=this.domNode.style;
			if(style1.overflow=="hidden"){
				var width1=style1.width;
				if(checkLength(width1)){
					var container=this.containerNode;
					var inhtml=container.innerHTML;
					container.innerHTML="";
					var widthpx=domStyle.get(this.containerNode.parentNode,"width");
					container.innerHTML=inhtml;
					gemo.setMarginBox(container,{w:widthpx});
					container.style.display="inline-block";
					container.style.overflow="hidden";
					container.style.textAlign="left";
				}
			}
		},
		postCreate:function()
		{
			//add global style to popup option menu by Peter Cai 
			this.inherited(arguments);
			this.set("buttonPosition",this.buttonPosition);

			// listen for changes to dijit.form.Select, update index property when user makes a selection
			var that = this;
			/*
			this.watch("value", function(propertyName, oldValue, newValue){
				var options = that.getOptions();
				for (var i=0; i<options.length; i++) {
					if (options[i].value == newValue) {
						this.set("index", i);
					}
				}
			});
			*/
		},
		
		_setLabelsAttr : function(labels) {
			if(!labels)
				return;
			this._set("labels",labels);
			var data=tools.parseLabels(labels);
			tools.sortOptions(this,data);
			var sdata=[];
			for(var i=0;i<data.length;i++){
				var idata={name:data[i].label,"id":i};
				sdata.push(idata);
			}
			this.store.data=sdata;
	//		this.set("value","");
		},
		/*
		_getLabelsAttr:function(){
			var rt=this.labels;
			if(lang.isArray(rt))
				rt=rt.join();
			return rt;
		},
		*/
		// for options sort
		sort:"none",
		_setSortAttr:function(s){
			if(s==this.sort)
				return;
			this._set("sort",s);
			this.set("labels",this.labels);
			
		}

		
    });
});