define([
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojox/timing",
    "./_BaseGraph"
], function(declare, lang, timing, _BaseGraph) {
	return declare("gc.dijit.LineGraph", [_BaseGraph], {

		// members
		delayedRefresh : 0,
		
		// Attributes
		
		_setSeries0Attr : function(values) {
			this._setSeriesN(values,0);
		},
		_setSeries1Attr : function(values) {
			this._setSeriesN(values,1);
		},
		_setSeries2Attr : function(values) {
			this._setSeriesN(values,2);
		},
		_setSeries3Attr : function(values) {
			this._setSeriesN(values,3);
		},
		_setSeries4Attr : function(values) {
			this._setSeriesN(values,4);
		},
		_setSeries5Attr : function(values) {
			this._setSeriesN(values,5);
		},
		_setSeries6Attr : function(values) {
			this._setSeriesN(values,6);
		},
		_setSeries7Attr : function(values) {
			this._setSeriesN(values,7);
		},
		
		_setSeriesN : function(values, index) {
			if( this._graph) {
				this._set('series'+index, values);
				this._setGraphSeries(values, index);
				this._requstReplot();
			}
		},
		
		constructor: function(params, srcNodeRef) {
			var ii;
			var ss=this._params.series;
			for(ii=0;ii<ss.length;ii++){
				if(!(ss[ii].label))
					ss[ii].label="Series "+ii;
			};
			this.series0 = [0];
			for( var i = 1; i < this._numBuffers; ++i) {
				this["series"+i] = [];
			}
			
			this.delayedRefresh = (params.delayedRefresh != undefined) ? params.delayedRefresh : 0;
			if( this.delayedRefresh && this.delayedRefresh > 0) {
				this._timer = new timing.Timer(this.delayedRefresh);
				this._timer.onTick = this._onTick;
				this._timer._gc_widget = this;
			}
		},
		
		startup: function() {
			this.inherited(arguments);
			this.domNode.removeAttribute("title");
			this.seriesColor();
			var seriesAll = new Array();
			for( var i = 0; i < this._numBuffers; ++i) {
				var series = this["series"+i];
				seriesAll.push(series);
			}
            this._graph = $.jqplot(this.id, seriesAll, this._params);
		},

		_requstReplot : function() {
			if( this._timer) {
				if( this._timer.isRunning) {
					this._replotNeeded = true;
				}
				else {
					this._replot();
					this._replotNeeded = false;
					this._timer.start();
				}
			}
			else {
				this._replot();
			}
		},
		
		_replot : function() {
			if( this.modelBindEnabled) {
				this._graph.replot({resetAxes: this.resetAxes});
			}
		},

		_onTick : function() {
			// 'this' pointer is pointing to the timer object in this callback. 
			var that = this._gc_widget;
			if( that._replotNeeded) {
				that._replotNeeded = false;
				that._replot();
			} else {
				that._timer.stop();
			}
		}
	});
});