define([
	"dojo/_base/declare",
	"dojo/query",
	"dojo/dom-attr",
	"dijit/form/MultiSelect",
	"./_GCBaseWidget",
	"./libs/tools",
	"dojo/dom-construct"
], function(declare, query, domAttr, MultiSelect, _GCBaseWidget,tools,construct) {
	return declare("gc.dijit.MultiSelect", [MultiSelect, _GCBaseWidget], {
		labels : "item1,item2,item3",
		size: 4,
		// for options sort
		sort:"none",
		_setSortAttr:function(s){
			if(s==this.sort)
				return;
			this._set("sort",s);
			this.set("labels",this.labels);
		},
		constructor:function(p){
			console.debug("gc.dijit.MultiSelect");
		},
		postCreate: function() {
			this.inherited(arguments);
			
			// Get a DOM node reference for the root of our widget
			var domNode = this.domNode;

			domNode.setAttribute("size", this.size);
			if (!this.multiple)
				domNode.removeAttribute("multiple");
			//watch for binding
			this.watch("value",function(attr,ov,nv){
				this.set("index",this.domNode.selectedIndex);
				this.setValue0();
			});
		},
		
		_setLabelsAttr : function(labels) {
			this._set('labels', labels);
			//remove old data
			this.domNode.length=0;
			var data=tools.parseLabels(labels);
			tools.sortOptions(this,data);
			for(var i=0;i<data.length;i++){
				var opt=construct.create("option",{"value":data[i].value,"innerHTML":data[i].label});
				this.domNode.appendChild(opt);
			}
		},	
		_setIndexAttr:function(index){
			var i1=parseInt(index);
			if(isNaN(i1))
				return;
			if(i1>=this.domNode.length||i1<0)
				return;
			if(this.index==i1)
				return;
			var v0=this.domNode.options[i1].value;
			this._set("index",i1);
			this.set("value",[v0]);
			
			
		},
		setValue0:function(){
			var dn=this.domNode;
			var v0;
			if(dn.selectedIndex>=0&&dn.selectedIndex<dn.length)
			 v0=dn.options[dn.selectedIndex].value;
			else
				v0=null;			
			this._set("value0",v0);
		},
		//for single value mapping
		_setValue0Attr:function(v){
			var vs=[];
			vs.push(v);
			this.set("value",vs);
			this.setValue0();
		}
	});
});