define([
	"dojo/_base/declare",
	"dojo/dom-class"
], function(declare, domClass) {
	var obj= declare("gc.dijit._Disabled", null, {
		disabled:false,
		readOnly:false,
		_disabledClass:function(){
			if(this.domNode){
			if(this.disabled||this.readOnly){
				domClass.add(this.domNode,"widgetDisabled");
			}else{
				domClass.remove(this.domNode,"widgetDisabled");
			}
			}
		},
		_setDisabledAttr:function(dis){
			this.disabled=dis;
			this._disabledClass();
			if(this.getChildren){
				var childs=this.getChildren();
				for(var i=0;i<childs.length;i++){
					childs[i].set("disabled",dis);
				}
			}
		},
		_setReadOnlyAttr:function(ro){
			this.readOnly=ro;
			this._disabledClass();
			if(this.getChildren){
				var childs=this.getChildren();
				for(var i=0;i<childs.length;i++){
					childs[i].set("readOnly",ro);
				}
			}
		}
	});
	return obj;
});